# Copyright 1996-97 Erick Branderhorst, GPL'ed, see COPYING.
AC_DEFUN(eb_USE_WORD_LIST,
  [AC_MSG_CHECKING([whether word list $1 is requested])
    dnl Default is disabled $1
    AC_ARG_ENABLE($1,
      [  --enable-$1  use word list $1],
      USE_$1=$enableval;WORDS_LIST="$1 $2", USE_$1=no)
    AC_MSG_RESULT($USE_$1)
    AC_SUBST(USE_$1)
])

AC_DEFUN(eb_USE_WORD_LIST_APPENDIX,
  [AC_MSG_CHECKING([whether appendix word list $1 is requested])
    dnl Default is disabled appendix word lists
    AC_ARG_ENABLE($1,
      [  --enable-$1  use appendix word list],
      USE_$1=$enableval;USE_WLA="$USE_WLA $1", USE_$1=no)
    WLA="$WLA $1"
    AC_MSG_RESULT($USE_$1)
    AC_SUBST(USE_$1)
])

## ----------------------------------------- ##
## Find ispell and where to put .hash files  ##
## ----------------------------------------- ##
AC_DEFUN(AM_PATH_HASHDIR,
 [AC_PATH_PROG(ISPELL, ispell)
  if test "$ISPELL" != "no"; then
    AC_MSG_CHECKING([where .hash files should go])
    dnl Set default value
    hashdir="\$(datadir)/ispell"
    if test "x$prefix" = "xNONE"; then
      if test -d $ac_default_prefix/share/ispell; then
	hashdir="\$(prefix)/share/ispell"
      else
	if test -d $ac_default_prefix/lib/ispell; then
	  hashdir="\$(prefix)/lib/ispell"
	fi
      fi
    else
      if test -d $prefix/share/ispell; then
	hashdir="\$(prefix)/share/ispell"
      else
	if test -d $prefix/lib/ispell; then
	  hashdir="\$(prefix)/lib/ispell"
	fi
      fi
    fi
    AC_MSG_RESULT($hashdir)
    AC_MSG_CHECKING([where dictionary files should go])
    dnl Set default value
    dictdir="\$(datadir)/dict"
    if test "x$prefix" = "xNONE"; then
      if test -d $ac_default_prefix/share/dict; then
	dictdir="\$(prefix)/share/dict"
      else
	if test -d $ac_default_prefix/lib/dict; then
	  dictdir="\$(prefix)/lib/dict"
	else
          if test -d $ac_default_prefix/dict; then
	    dictdir="\$(prefix)/dict"
          fi
	fi
      fi
    else
      if test -d $prefix/share/dict; then
	dictdir="\$(prefix)/share/dict"
      else
	if test -d $prefix/lib/dict; then
	  dictdir="\$(prefix)/lib/dict"
        else
          if test -d $prefix/dict; then
            dictdir="\$(prefix)/dict"
          fi
	fi
      fi
    fi
    AC_MSG_RESULT($dictdir)
  fi
  AC_SUBST(hashdir)
  AC_SUBST(dictdir)])

## ----------------------------------------- ##
## Find ispell and where to put .hash files  ##
## ----------------------------------------- ##
AC_DEFUN(eb_WITH_BUILDICT,
[AC_MSG_CHECKING([whether buildict should be used])
AC_ARG_WITH(buildict,
[  --with-buildict         use buildict instead of buildhash],
[if test "$withval" = yes; then
  USE_BUILDICT=yes
  AC_SUBST(USE_BUILDICT)
  AC_MSG_RESULT(yes)
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])
])


