/* $Id: dict.c,v 2.1 1998/09/19 03:31:24 sgifford Exp $ */

/* Interface to dict. */

/*
    Copyright (C) 1998  Scott Gifford

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    If you have any questions, comments, or compliments, feel free to contact
    me at <sgifford@tir.com>.
*/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <strings.h>
#include <gtk/gtk.h>
#include <stdio.h>

#include "dict.h"
#include "utils.h"

char *dictprog=DICTPROG;

#define BUF_CHUNK 1024
#define READPIPE  0
#define WRITEPIPE 1
DEFINITIONLIST *dict_lookup(WORD *word)
{
  int filedes[2];
  FILE *dict_out;
  char buf[BUF_CHUNK];
  char *def;
  int deflen,defmax;
  DEFINITION *definition;
  DEFINITION **defdef;
  DEFINITIONLIST *deflist=NULL;
  int childstat;
  
  if (pipe(filedes) < 0)
    return NULL;
  
  /* Welcome to UNIX. */
  if (!fork())
  {
    /* Child */
    close(filedes[READPIPE]);
    dup2(filedes[WRITEPIPE],STDOUT_FILENO);
    execlp(dictprog,dictprog,word,NULL);
    fprintf(stderr,"ERROR: Couldn't exec %s %s\n",dictprog,(char *)word);
    exit(100);
  }
  else
  {
    /* Parent */
    close(filedes[WRITEPIPE]);
    dict_out=fdopen(filedes[READPIPE],"r");
    deflen=1;
    defmax=1024;
    def=safe_malloc(1024);
    def[0]='\0';
    
    while (fgets(buf,1023,dict_out))
    {
      while ((strlen(buf)+deflen+1) > defmax)
      {
        def=safe_realloc(def,defmax+BUF_CHUNK);
        defmax+=BUF_CHUNK;
      }
      strcat(def,buf);
      deflen+=strlen(buf);
    }
    fclose(dict_out);
    wait(&childstat);
    if (!WIFEXITED(childstat) || (WEXITSTATUS(childstat) != 0))
    {
      char why[1024];

      sprintf(why,"god only knows why");
      if (WIFEXITED(childstat))
      {
        if (WEXITSTATUS(childstat) == 100)
          sprintf(why,"couldn't exec %s %s",dictprog,(char *)word);
        else
          sprintf(why,"dict returned %d",WEXITSTATUS(childstat));
      }
      else if (WIFSIGNALED(childstat))
      {
        sprintf(why,"terminated by signal %d",WTERMSIG(childstat));
      }
      g_warning("dict exited abnormally: %s\nMore information may be on STDOUT/STDERR\n",why);
      exit(-1);
    }
    else
    {
      definition=safe_malloc(sizeof(DEFINITION));
      definition->text=def;
      defdef=safe_malloc(sizeof(DEFINITION *));
      *defdef=definition;
      deflist=safe_malloc(sizeof(DEFINITIONLIST));
      deflist->defs=defdef;
      deflist->num=1;
    }
  }
  return deflist;
}

void free_deflist(DEFINITIONLIST *deflist)
{
  int i;

  if (!deflist)
    return;

  for(i=0;i<deflist->num;i++)
  {
    free_def(deflist->defs[i]);
  }
  free(deflist);
}

void free_def(DEFINITION *def)
{
  if (!def)
    return;

  free_if_used(def->text);
  free(def);
}
  
