/*
  Prints various types of info taken from an rdbtable body.

  Author: Carlo Strozzi <carlos@linux.it>
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define MAX_ARG_LENGTH  512
#define EMPTY			""

void show_help( char *my_name)
{
    printf("
        NoSQL operator: %s

Usage:  %s [options]

Options:
    -h    Print this help info.
    -H F  Write table header to file 'F'. Warning: %s does
          not do any locking on that file, so make sure you pick a
          unique name for it. A safe bet is suffixing the name with
          your shell process-id ($$), as usual. If the file already
		  exists, ${my_name} prints an error message and exits.
    -t X  Type of information requested. 'X' can be one of:

          n : Print only the No. data rows in the input table.

Prints various pieces of data, extracted from the body of an rdbtable.
Default is to print the whole table body to STDOUT.

This operator reads an rdbtable from STDIN and prints the requested info
to STDOUT.


'$Id: nsq-body.c,v 1.1 1998/05/29 20:43:01 carlos Exp $'

            ----------------------
NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.
This program comes with ABSOLUTELY NO WARRANTY; for details
refer to the GNU General Public License.

You should have received a copy of the GNU General Public License
along with this program;  if not, write to the Free Software
Foundation, Inc., 59 Temple Place Suite 330, Boston, MA 02111-1307
USA.
            ----------------------\n",my_name,my_name,my_name,"\\");
}

int main( int  argc, char *argv[] ) {
  
  /* For getopt() */
  extern char* optarg;
  extern int optind;

  /* for the rest of the program. */
  register int
	a_loop;
  char
	*my_name=argv[0],
	cmd_buf[MAX_COMMAND_LENGTH],
	hdr_file[MAX_ARG_LENGTH],
	info_type;

  int no_hdr=0, debug=0, count_only=0;

  while ((a_loop = getopt(argc, argv, "xhH:t:")) != EOF) {
    switch (a_loop) {
      case 'h':
        show_help(my_name);
        exit(0);
        break;
      case 'x': 
        debug=1;
        break;
      case 'H': 
        snprintf(hdr_file,MAX_ARG_LENGTH,"%s", optarg);
        break;
      case 't':
		info_type=optarg[0];
        break;
      default:
        show_help(my_name);
        exit(1);
    }
  }

  switch (info_type) {
    case 'n':
	  count_only=1;
      break;
  }

  snprintf(cmd_buf,MAX_COMMAND_LENGTH,"#
#
BEGIN { NULL=\"\"; FS=\"\\t\"; OFS=FS;}
# Table comments.
r==0 && $0 ~ /^ *#/ {
  if( \"%s\" != NULL ) print > \"%s\"
  next
}
# Column names.
r==0 { 
  if( \"%s\" != NULL ) print > \"%s\"
  r++; next;
}
# Column definitions.
r == 1 { NR=0;
  if( \"%s\" != NULL ) print > \"%s\"
  r++; next;
}
%d == 0 { print }
END { if(%d) print NR
}",hdr_file, hdr_file, hdr_file, hdr_file, hdr_file,
hdr_file, count_only, count_only);

  if( debug )
	fprintf (stderr, "Generated AWK program:
	  ----------\n%s\n----------\n",cmd_buf);

  execlp(AWK,"awk",cmd_buf,NULL);
  exit(0);
}

