/*
  Prints various types of info taken from an rdbtable header.

  Author: Carlo Strozzi <carlos@linux.it>
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define EMPTY			""

void show_help( char *my_name)
{
    printf("
        NoSQL operator: %s

Usage:  %s [options]

Options:
    -w    Fields are printed on one sigle horizontal line.
          Default is to print them one per line of output.
    -h    Print this help info.
    -b    Escape blank spaces in column descriptions by changing them
          into the ASCII sequence \"&#32;\", to make sure each field is one
          single token to the shell.
    -n    Strip header comments from output.
    -t X  Type of information requested. 'X' can be one of:

          c : Print column names.
          C : Print column names in a format suitable for nsq-fcol.
              (implies '-w').
          D : Print the whole column definition line.
          d : Print column documentation fields only.
          l : Print field lengths only.
          n : Print only the No. of columns in the input table.
          t : Print field types only.

Prints various pieces of data, extracted from the table header lines.
Default is to print the whole table header to STDOUT.

This operator reads an rdbtable from STDIN and prints the requested info
to STDOUT.


'$Id: nsq-header.c,v 1.1 1998/05/29 20:43:01 carlos Exp $'

            ----------------------
NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.
This program comes with ABSOLUTELY NO WARRANTY; for details
refer to the GNU General Public License.

You should have received a copy of the GNU General Public License
along with this program;  if not, write to the Free Software
Foundation, Inc., 59 Temple Place Suite 330, Boston, MA 02111-1307
USA.
            ----------------------\n", my_name, my_name, "\\");
}

int main( int  argc, char *argv[] ) {
  
  /* For getopt() */
  extern char* optarg;
  extern int optind;

  /* for the rest of the program. */
  register int
	a_loop;
  char
	*my_name=argv[0],
	cmd_buf[MAX_COMMAND_LENGTH],
	info_type='c';

  int no_hdr=0, debug=0, esc_blanks=0, one_line=0,
	doc_only=0, lengths_only=0, count_only=0, c_names=0,
	types_only=0, no_cmts=0, fcol=0;

  while ((a_loop = getopt(argc, argv, "xwhbnt:")) != EOF) {
    switch (a_loop) {
      case 'h':
        show_help(my_name);
        exit(0);
        break;
      case 'n': 
        no_cmts=1;
        break;
      case 'x': 
        debug=1;
        break;
      case 'b': 
        esc_blanks=1;
        break;
      case 'w': 
        one_line=1;
        no_hdr=1;
        break;
      case 't':
		no_hdr=1;
		info_type=optarg[0];
        break;
      default:
        show_help(my_name);
        exit(1);
    }
  }

  switch (info_type) {
    case 'D':
      break;
    case 'd': 
	  doc_only=1;
      break;
    case 'l': 
	  lengths_only=1;
      break;
    case 'n': 
	  count_only=1;
	  c_names=1;
      break;
    case 't': 
	  types_only=1;
      break;
    case 'c': 
	  c_names=1;
      break;
    case 'C': 
	  c_names=1;
	  fcol=1;
      break;
  }

  snprintf(cmd_buf,MAX_COMMAND_LENGTH,"#
#
BEGIN { NULL=\"\"; FS=\"\\t\"; OFS=FS;
  if(%d && !%d) OFS=\"\\n\"
}
# Table comments.
r==0 && $0 ~ /^ *#/ {
  if(!%d && !%d)
	print
    next
}
# Column names.
r==0 {
  if(!%d) print
  else if(%d) {
	if(%d) print split($0,a)
    else {
      if(!%d) out_rec=$0
	  else {
		c=1
		out_rec=\"$P[\\042\" $c
		while( ++c <= NF ) out_rec=out_rec \"\\042],$P[\\042\" $c
		out_rec=out_rec \"\\042]\"
	  }
	  if(!%d) gsub(FS,\"\\n\",out_rec)
	  print out_rec
	}
    exit
  }
  r++; next;
}
# Column definitions.
r == 1 {
  if(!%d) {print;exit;}
  else {
    split($0,c_defs )
	c=0
    while(c_defs[++c] != NULL) {
	  a1 = substr(c_defs[c],1,index(c_defs[c],\" \"))
	  if( a1 == NULL) {
		a1 = c_defs[c]
		# Documentation fields should not be empty anyway,
		# otherwise \"set - ...\" from the shell will not
		# set the corresponding positional parameters.
		a2 = \":\"
	  }
	  else a2 = substr(c_defs[c],index(c_defs[c],\" \"))
	  if(%d) {
	    gsub(/[^0-9]+/,NULL,a1)
	    out_rec = out_rec OFS a1
	  }
	  else if(%d) {
        sub(/[0-9]+ */,NULL,a1)
        gsub(/[<> ]/,NULL,a1)
	    if(a1==NULL) a1=\"S\"
        out_rec = out_rec OFS a1
      }
      else if(%d) {
	    sub(/^ */,NULL,a2)
		if(%d) gsub(\" \",\"\\&#032;\",a2)
	    out_rec = out_rec OFS a2
	  }
	  # Default is the whole definition line.
      else out_rec = out_rec OFS c_defs[c]
    }
    sub(/^[\\t\\n]/,NULL,out_rec)
    print out_rec
    exit
  }
}",no_hdr,one_line,no_cmts,no_hdr,no_hdr,c_names,count_only,
fcol,one_line,no_hdr,lengths_only,types_only,doc_only,esc_blanks);

  if( debug )
	fprintf (stderr, "Generated AWK program:
	  ----------\n%s\n----------\n",cmd_buf);

  execlp(AWK,"awk",cmd_buf,NULL);
  exit(0);
}

