/*
 * $Id: dic_head.c,v 1.3 1992/09/22 04:53:04 proj Exp $
 */
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/*	Version 4.0
 */
#include <stdio.h>
#include "commonhd.h"
#include "jslib.h"
#include "jh.h"
#include "jdata.h"

extern int create_file_header(), output_header_jt(), input_file_header(),
  input_header_jt(), input_header_hjt();

int
output_header(ofpter, jtp, fhp)
FILE *ofpter;
struct JT *jtp;
struct wnn_file_head *fhp;
{
    create_file_header(ofpter, WNN_FT_DICT_FILE, fhp->file_passwd);
    output_header_jt(ofpter, jtp);
    return(0);
}

int
input_header(ifpter,  jtp, fhp)
FILE *ifpter;
struct JT *jtp;
struct file_head *fhp;
{

    if(input_file_header(ifpter, fhp) == -1 ||
       input_header_jt(ifpter, jtp) == -1){
	fprintf(stderr, "Not a Wnn file\n");
      return(-1);
  }
  return(0);
}

int
input_hindo_header(ifpter, hjtp, fhp)
FILE *ifpter;
struct wnn_file_head *fhp;
struct HJT *hjtp;
{
    if(input_file_header(ifpter, fhp) == -1 || 
       input_header_hjt(ifpter, hjtp) == -1){
	return(-1);
    }
    return(0);
}
