#ifndef ___APPLET__H___
#  define ___APPLET__H___

#include "types.h"

/* structure to hold one parmater from <param name="aname" value="avalue">   */
typedef struct applet_param
{
 char *name;             /* the parameter name                               */
 char *value;            /* its value                                        */
 } APPLETParam;


/* structure to hold one applet
 * <applet codebase="http://path/" code="app.class" alt="display text"
 * width=100 height=200 align="center" vspace=20 hspace=20 name="instance">
 * <param name="username" value="fred">
 * <param name="address" value="nowhere USA">
 * HTML to ignore if we have java... or display if no alt= above!
 * </applet>
 */

/* I'm not sure about the 2 <param ...> statements.  I've not seen a multiple
 * param applet yet!  Maybe the name= and value= can be used again without
 * the opening <param... each time?????
 */

typedef struct applet_instance
{
 char *instance_name;    /* this applets "instance" name...                  */
 Doc *doc;               /* document that owns the applet                    */
 char *codebase;         /* value of the codebase=  s/b path of applet code  */
 char *code;             /* name of the applet class relative to codebase    */
 char *alt;              /* specifed text to display for browsers that       */
                         /* understand <applet> but don't have JAVA          */
 unsigned int width;     /* initial width in pixels                          */
 unsigned int height;
 unsigned int vspace;    /* pixels above & below window for spacing          */
 unsigned int hspace;
 char *align;            /* type of alignment                                */
 unsigned int nparams;   /* number of parameters                             */
 APPLETParam **params;   /* array of parameter pointers (realloc on adds)    */
 char *ignoretext;       /* pointer to text that may have to be displayed    */
} APPLET;


/* Routines for applet construction and destruction
 */
APPLET *NewApplet(void);
APPLETParam *_NewAppletParam(APPLET *applet, char *nam, char *val);
int AddAppletParam(APPLET *applet, char *name, char *val);
void DumpApplet(APPLET *applet);

void FreeApplet(APPLET *applet);
void _FreeAppletParam(APPLETParam *);

#endif	/* ___APPLET_H___ */





