#ifndef ___ARENA_DISPLAY_H___
#  define ___ARENA_DISPLAY_H___


#include "types.h"
#include "display_types.h"


/*
 * Global variables. :(
 */

extern Window DocDispWin;
extern GC     DocDispGC;

extern int font;

extern long buf_height;
extern int  buf_width;

extern long lineHeight;

extern char *targetptr;    /* for toggling view between HTML/TEXT views */
extern char *targetId;     /* for locating named Id during ParseHTML() */
extern long  IdOffset;     /* offset for targetId */
extern long  ViewOffset;   /* for toggling between HTML/TEXT views */

extern char* buffer;       /* the start of the document buffer */

extern int  hdrlen;        /* offset to start of data from top of buffer*/


/*
 * Functions.
 */

void NewBuffer(Doc* d);

Bool DocDispInit(Window parent_win);
void SetColour(GC gc, int colour_text_ix, int colour_background_ix);
void SetFont(GC gc, int fontIndex);

void DisplaySizeChanged(Doc* doc, Bool all);

void MoveXDisplay(Doc* doc,  int indent);
void MoveYDisplay(Doc* doc, long offset);

void MoveLeftLine(Doc* doc);
void MoveRightLine(Doc* doc);
void MoveLeftPage(Doc* doc);
void MoveRightPage(Doc* doc);

void MoveToYpage(Doc* doc, long offset);
void MoveUpLine(Doc* doc);
void MoveDownLine(Doc* doc);
void MoveUpPage(Doc* doc);
void MoveDownPage(Doc* doc);

void MoveToStart(Doc* doc);
void MoveToEnd(Doc* doc);

void SlideXDisplay(Doc* doc, int slider, int scrollExtent);
void SlideYDisplay(Doc* doc, int slider, int scrollExtent);

Bool VisibleViewRectangle(ViewRectangle view, ViewRectangle area,
			  ViewRectangle* visibleArea);

ViewWindow GetDefaultDocViewWindow(void);

Bool UpdateDocDispWinGeometry(void);

ViewRectangle GetDocViewWinGeometry(void);
   XRectangle GetDocDispWinGeometry(void);
 unsigned int GetDocDispWinWidth(void);
 unsigned int GetDocDispWinHeight(void);

Bool ViewDocArea(Doc* doc,
		 GC theGC, ViewWindow view_window,
		 ViewRectangle document_view_area_to_display);

Bool DisplayDocArea(Doc* doc, XRectangle area_to_display);

Bool DisplayDoc(Doc* doc, Bool reparsing);
void DisplayAll(Doc* doc, Bool reparsing);

void FindString(Doc* doc, char* pattern);
void ResetFindStringPos(void);

void ToggleView(Doc* doc);


#endif	/* ifndef ___ARENA_DISPLAY_H___ */
