#ifndef ___ARENA_EDITOR_I_H___
#  define ___ARENA_EDITOR_I_H___

/*
 * Header file for editor.c (for internal use). Publics are in "editor.h".
 */


#include "defs.h"

#include "HTList.h"


/* from phb */

#define EDIT_CHARACTER_TYPE_NORMAL       0x0
#define EDIT_CHARACTER_TYPE_PARA_BREAK   0x1
#define EDIT_CHARACTER_TYPE_WORD_BREAK   0x2

#define EXTRA_LENGTH 40

/* ------ */


typedef int edit_pixels;
#if 0	/* QingLong.01-02-97 */
typedef int edit_characters;
#endif


typedef enum
{
 edit_cursor_movement_relative,
 edit_cursor_movement_absolute
} edit_cursor_movement;


typedef enum
{
 edit_cursor_unit_pixel,
 edit_cursor_unit_character,
 edit_cursor_unit_word,
 edit_cursor_unit_paragraph,
 edit_cursor_unit_page
} edit_cursor_unit;


typedef struct s_edit_buffer
{
    HTList 	*paras;
    int		width;
    Bool	auto_break;
    int		break_table_size;
    char 	*break_table;
    Bool	soft_break;
} EditBuffer;


typedef struct s_edit_paragraph 
{
    char	*buffer;
    int		buffer_used;
    int		buffer_size;
    int		width;
    int		height;

    HTList 	*lines;
} EditParagraph;


typedef struct s_edit_line
{
    int		index;
    int		pixel_width;
    int		pixel_height;
} EditLine;


typedef struct s_edit_view 
{
    int		width;
    int		height;

    int		(*display_line)();
    int		(*display_cursor)();
    int		(*display_scroll)();

    EditBuffer	*main_buffer;
    EditBuffer	*cut_section_buffer;
    EditBuffer	*cut_line_buffer;
    EditBuffer	*cut_word_buffer;
    EditBuffer	*cut_character_buffer;

    int		cursor_row;
    int		cursor_column;
    int		cursor_x;
    int		cursor_y;
} EditView;




#endif	/* ifndef ___ARENA_EDITOR_I_H___ */
