#ifndef ___ARENA_PARSEHTML_H___
#  define ___ARENA_PARSEHTML_H___


#include "arena.h"
#include "defs.h"
#include "types.h"
#include "image_types.h"

/*
 * alignment codes
 */
#define ALIGN_TOP       0
#define ALIGN_MIDDLE    1
#define ALIGN_BOTTOM    2
#define ALIGN_LEFT      3
#define ALIGN_CENTER    4
#define ALIGN_RIGHT     5
#define ALIGN_JUSTIFY   6
#define ALIGN_NOTE      7      /* used only for text flow mechanism */
#define ALIGN_BLEEDLEFT 8
#define ALIGN_BLEEDRIGHT 9


/*
 * Entity classes
 */
#define EN_UNKNOWN         0
#define EN_TEXT         (1 << 0)
#define EN_BLOCK        (1 << 1)
#define EN_LIST         (1 << 2)
#define EL_DEFLIST      (1 << 3)
#define EN_HEADER       (1 << 4)
#define EN_SETUP        (1 << 5)
#define EN_MAIN         (1 << 6)
#define EN_TABLE        (1 << 7)

/*
 * The HTML token codes
 */
#define ENTITY          -4
#define WHITESPACE      -3     /* the specific char */
#define PCDATA          -2     /* the specific char */
#define ENDDATA         -1

#define ENDTAG          (1<<7) /*  ORed with TAG code */
#define IsTag(tag)      (tag >= 0)

#define UNKNOWN         0
#define TAG_ANCHOR      1       /* EN_TEXT */
#define TAG_BOLD        2       /* EN_TEXT */
#define TAG_DL          3       /* EN_LIST */
#define TAG_DT          4       /* EN_DEFLIST */
#define TAG_DD          5       /* EN_DEFLIST */
#define TAG_H1          6       /* EN_HEADER */
#define TAG_H2          7       /* EN_HEADER */
#define TAG_H3          8       /* EN_HEADER */
#define TAG_H4          9       /* EN_HEADER */
#define TAG_H5          10      /* EN_HEADER */
#define TAG_H6          11      /* EN_HEADER */
#define TAG_ITALIC      12      /* EN_TEXT */
#define TAG_IMG         13      /* EN_TEXT */
#define TAG_LI          14      /* EN_LIST */
#define TAG_OL          15      /* EN_LIST */
#define TAG_P           16      /* EN_BLOCK */
#define TAG_TITLE       17      /* EN_SETUP */
#define TAG_UNDERLINE   18      /* EN_TEXT */
#define TAG_UL          19      /* EN_LIST */
#define TAG_HEAD        20      /* EN_SETUP */
#define TAG_BODY        21      /* EN_MAIN */
#define TAG_HR          22      /* EN_BLOCK */
#define TAG_ADDRESS     23      /* EN_BLOCK */
#define TAG_BR          24      /* EN_TEXT */
#define TAG_STRIKE      25      /* EN_TEXT */
#define TAG_PRE         26      /* EN_BLOCK */
#define TAG_CITE        27      /* EN_TEXT */
#define TAG_CODE        28      /* EN_TEXT */
#define TAG_TT          29      /* EN_TEXT */
#define TAG_EM          30      /* EN_TEXT */
#define TAG_STRONG      31      /* EN_TEXT */
#define TAG_KBD         32      /* EN_TEXT */
#define TAG_SAMP        33      /* EN_TEXT */
#define TAG_DFN         34      /* EN_TEXT */
#define TAG_Q           35      /* EN_TEXT */
#define TAG_QUOTE       36      /* EN_BLOCK */
#define TAG_ISINDEX     37      /* EN_SETUP */
#define TAG_FIG         38      /* EN_BLOCK */
#define TAG_INPUT       39      /* EN_TEXT */
#define TAG_SELECT      40      /* EN_TEXT */
#define TAG_OPTION      41      /* EN_TEXT */
#define TAG_TEXTAREA    42      /* EN_TEXT */
#define TAG_TABLE       43      /* EN_BLOCK */
#define TAG_TR          44      /* EN_TABLE */
#define TAG_TH          45      /* EN_TABLE */
#define TAG_TD          46      /* EN_TABLE */
#define TAG_CAPTION     47      /* EN_BLOCK */
#define TAG_ADDED       48      /* EN_TEXT */
#define TAG_REMOVED     49      /* EN_TEXT */
#define TAG_MATH        50      /* EN_TEXT */
#define TAG_MARGIN      51      /* EN_TEXT */
#define TAG_ABSTRACT    52      /* EN_BLOCK */
#define TAG_BLOCKQUOTE  53      /* EN_BLOCK */
#define TAG_VAR         54      /* EN_TEXT */
#define TAG_BASE        55      /* EN_SETUP */
#define TAG_SUP         56      /* EN_TEXT */
#define TAG_SUB         57      /* EN_TEXT */
#define TAG_SMALL       58      /* EN_TEXT */
#define TAG_NOTE        59      /* EN_BLOCK */
#define TAG_ALT         60      /* EN_BLOCK */
#define TAG_STYLE       61      /* EN_SETUP */ /* howcome 26/2/95 */
#define TAG_LINK	62	/* EN_SETUP */ /* howcome 25/4/95 */
#define TAG_OVERLINE    63      /* MATH */
#define TAG_HTML_SOURCE	64	/* 1/7/95: HTML source display, for use with style sheets */
/* #define TAG_ALL		65 */	/* howcome 7/3/95: for use in style.c */
#define TAG_HTML	65	/* howcome 27/8/85: for use in style.c */
#define TAG_LAST        66	/* howcome 21/8/95: to know the size of element array */
#define TAG_FORM        67      /* --Spif 10/10/95: forms (needed to build form structure) */
#define TAG_CENTER      68      /* rhw 2-April-1997 */
#define TAG_ISINDEX_DE  69      /* EN_TEXT */ /* One field text Entry */
#define TAG_APPLET      70      /* EN_TEXT */

/*
   The paint stream consists of a sequence of overlapping frames:

       a) TextLines which contain elements appearing on a single line
          e.g. STRING, LITERAL, RULE, BULLET, IMAGE. The TextLine
          is large enough to contain all objects on the line. TextLines
          never overlap except when they occur in different frames.

       b) Frames which contain TextLines and other Frames
          (used for figures, tables and sidebars)

   Frames are designed for efficient painting and scrolling,
   regardless of the length of a document. The frames are strictly
   ordered with respect to increasing pixel offset from the top of
   the document. Objects with the same offset are sorted with
   respect to increasing indent.

   This property is vital to the scrolling and painting
   mechanism. The ordering may be broken for elements within LINEs,
   for which a left to right ordering following that in the HTML
   source simplifies the Find menu action.

   FRAMEs are broken into BEGIN and END frame objects. The END frame
   objects are positioned in the sequence according the offset at
   which the frames end. This is needed to safely terminate search
   for objects which intersect the top of the window, when scrolling
   back through the document.
*/

#define TEXTLINE    11   /* frame containing elements on a line */
#define BEGIN_FRAME 12   /* begining of a frame */
#define END_FRAME   13   /* end of a frame */


#ifdef STYLE_COLOUR
#  define STYLE_COLOUR_NUM_LEN   1
# else
#  define STYLE_COLOUR_NUM_LEN   0
#endif

#ifdef STYLE_COLOUR_BORDER
#  define STYLE_COLOUR_BORDER_NUM_LEN   1
# else
#  define STYLE_COLOUR_BORDER_NUM_LEN   0
#endif

#ifdef STYLE_BACKGROUND
#  define STYLE_BACKGROUND_POINTER_LEN   ARENA_VOID_POINTER_SIZE
# else
#  define STYLE_BACKGROUND_POINTER_LEN   0
#endif


#define ARENA_PAINTSTREAM_TAG_LEN   1

        /* number of bytes in TEXTLINE header */
#define  TXTLINLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_LONG_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE)

        /* number of bytes in start of frame marker */
#define FRAMESTLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_LONG_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_LONG_INT_SIZE + 1 + 1 + STYLE_COLOUR_BORDER_NUM_LEN + STYLE_BACKGROUND_POINTER_LEN + ARENA_INT_SIZE)

        /* number of bytes in end of frame marker */
#define FRAMENDLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_INT_SIZE)


#define EMPH_NORMAL      0
#define EMPH_UNDERLINE  (1 << 1)
#define EMPH_STRIKE     (1 << 2)
#define EMPH_HIGHLIGHT  (1 << 3)

#define EMPH_OVERLINE   (1 << 4)
#define EMPH_OVERLARR	(1 << 5)
#define EMPH_OVERRARR	(1 << 6)
#define EMPH_OVERTILDE	(1 << 7)
#define EMPH_OVERHAT	(1 << 8)
#define EMPH_OVERDOT    (1 << 9)
#define EMPH_OVERDDOT   (1 << 10)

#define EMPH_UNDERLARR	(1 << 11)
#define EMPH_UNDERRARR	(1 << 12)
#define EMPH_UNDERTILDE	(1 << 13)
#define EMPH_UNDERHAT	(1 << 14)

#define EMPH_ROOTLINE	(1 << 15)
/* --Spif */
#define EMPH_INPUT      0x50 /* many crashes.. so ANCHOR || 0x40 ... ;) --Spif */

/* Note that PRE_TEXT is passed to display code with tag *not* emph */

#define EMPH_ANCHOR     0x10
#define ISMAP           0x80
#define PRE_TEXT        0x80     /* implies preformatted text */
#define GROOVE          0x80     /* draw horizontal rule as 3d groove */
#define HLINE           0x40     /* width instead of right coord */


/* Elements which can appear in a TEXTLINE. Must be non-zero */

#define STRING	1	/* tag name for string values */
#define BULLET	2	/* tag name for bullet */
#define RULE	3	/* horizontal rule */
#define SEQTEXT	4	/* explicit text, e.g. "i)" */
#define IMAGE	5	/* a pixmap (character-like) */
#define INPUT	6	/* text input field */
#define LINE	7	/* staalesc: line */


#define BULLET_WIDTH   10 /* 6 */     /* size of bullet graphic */

#define ArenaFonts(font) Fonts[(((0 < (font)) && ((font) < FONTS)) ? (font) : 0)]

#define CHWIDTH(font)    XTextWidth(ArenaFonts(font), " ", 1)
#define SPACING(font)    (2 + font->max_bounds.ascent + font->max_bounds.descent)
#define BASELINE(font)   (1 + font->max_bounds.ascent)
#define STRIKELINE(font) (font->max_bounds.ascent - font->max_bounds.descent + 1)
#define LINETHICKNESS(font) (1 + font->ascent / 10)

#define ASCENT(font)     (1 + (((0 <= (font)) && ((font) < FONTS)) ? Fonts[font]->max_bounds.ascent : 0))

#define DESCENT(font)    (1 + (((0 <= (font)) && ((font) < FONTS)) ? Fonts[font]->max_bounds.descent : 0))

#define WIDTH(font, str, len) XTextWidth(ArenaFonts(font), str, len)



#define   RULEFLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + STYLE_COLOUR_NUM_LEN + STYLE_BACKGROUND_POINTER_LEN)

#define   LINEFLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + STYLE_COLOUR_NUM_LEN + STYLE_BACKGROUND_POINTER_LEN)

#define BULLETFLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_INT_SIZE + ARENA_INT_SIZE + 1 + 1 + STYLE_COLOUR_NUM_LEN + STYLE_BACKGROUND_POINTER_LEN)

#define STRINGFLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_INT_SIZE + 1 + STYLE_COLOUR_NUM_LEN + STYLE_BACKGROUND_POINTER_LEN + 1 + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_VOID_POINTER_SIZE + ARENA_VOID_POINTER_SIZE)

#define  INPUTFLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_VOID_POINTER_SIZE + STYLE_BACKGROUND_POINTER_LEN)

#define  IMAGEFLEN   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_INT_SIZE + ARENA_X_PIXMAP_SIZE + ARENA_X_PIXMAP_SIZE + ARENA_VOID_POINTER_SIZE + STYLE_BACKGROUND_POINTER_LEN)

#define SEQTEXTFLEN(len)   (ARENA_PAINTSTREAM_TAG_LEN + ARENA_INT_SIZE + 1 + STYLE_COLOUR_NUM_LEN + STYLE_BACKGROUND_POINTER_LEN + ARENA_INT_SIZE + ARENA_INT_SIZE + 1 + len)


/*
 * Global variables. :(
 */
extern int ParseHTMLerror;
extern Bool DocIsIndex;
extern Bool prepass;         /* true during table prepass */
extern Bool damn_table;      /* to debug table formatter */
extern int Here;
extern char *bufptr, *lastbufptr;
extern char *StartOfLine;    /* in HTML document */
extern Byte* TopObject;      /* first visible object in window */
extern Byte* paint;          /* holds the sequence of paint commands */
extern int paintStartLine;   /* where line starts in the paint stream */
extern int preformatted;
extern long PixOffset;       /* extern current offset from start of document */


/*
 * Functions.
 */

extern void SwallowAttributes(void);
extern int TextWidth(int font, char *str, int len, int *up, int *down);

extern char* FindEndComment(char *ptr);

void FontSize(int font, int *ascent, int *descent);

extern Byte* PaintStreamCurrentPosition(void);

extern void SetBeginFrameHeight(Frame* frame);
extern void SetBeginFrameParameters(Frame* frame);
extern unsigned int PrintBeginFrame(Frame *frame);
extern void PrintEndFrame(Frame *parent, Frame *frame);
extern void PrintFrameSize(Frame *frame);

void PrintRule(Frame *frame, int type, int left, int right, int dy);
void PrintLine(Frame *frame, int left, int right, int top, int bottom);

void PutText(Frame *frame, unsigned int emph, int font, char *s, int len,
	     int x, int y);

long ParseHTML(int *width, Bool style_parse);
char *ParseAttribute(int *len);
char *ParseValue(int *len);

void ParseFormAttrs(FormSubmitMethod* method, char **action, int *alen);

long ParseImage(Doc *doc, int *width);

void ParseImageAttrs(char **href, int *hreflen, int *align, int *ismap,
		     int *width, int *height);

void ParseAnchorAttrs(char **href, int *hreflen, char **name, int *namelen,
		      char **class_p, int *class_len_p);

void ParseInputAttrs(int* type, char** name, int* nlen,
		     char** value, int* vlen, int* maxlength, int* size,
		     int* flags, Image** image);


#endif /* ifndef ___ARENA_PARSEHTML_H___ */
