/*                                      W3C Sample Code Library libwww Private Net Definition
                                  PRIVATE NET DEFINITION
                                             
 */
/*
**      (c) COPYRIGHT MIT 1995.
**      Please first read the full copyright statement in the file COPYRIGH.
*/
/*

   This is the private definition of the Net Class. Please look in the public Net Class
   for more documentation
   
   This module is implemented by HTNet.c, and it is a part of the W3C Sample Code Library.
   
 */
#ifndef HTNETMAN_H
#define HTNETMAN_H
#include "HTNet.h"
#include "HTDNS.h"
#include "HTEvent.h"
#include "HTProt.h"
/*

   The HTNet object is the core of the request queue management. This object contains
   information about the socket descriptor, the input read buffer etc. required to
   identify and service a request.
   
 */
struct _HTNet {
    int                 hash;                                  /* Hash value */

    /* Link to other objects */
    HTRequest *         request;                   /* Link to request object */
    HTHost *            host;          /* What we know about the remote host */
    HTProtocol *        protocol;                /* Protocol to this request */
    HTTransport *       transport;             /* Transport for this request */
    int                 session;

    /* For progress notifications */
    long                bytesRead;                          /* Bytes in body */
    long                headerLength;                /* Bytes read in header */
    long                bytesWritten;            /* Bytes written to network */

#if 0
    int                 retry;               /* Counting attempts to connect */
    int                 home;                    /* Current home if multiple */
#endif

    time_t              connecttime;             /* Used on multihomed hosts */
    BOOL                preemptive;  /* Eff result from Request and Protocol */

    HTEvent             event;
    HTStream *          readStream;    /* host's input stream puts data here */

    /* User specific stuff */
    void *              context;                /* Protocol Specific context */

    /* Eric's sleezoid cheat - should go to extra pipeline object */
    HTEventType         registeredFor;
};

extern SOCKET HTNet_socket(HTNet * me);

#define HTNet_setBytesRead(me,l)        ((me) ? (me->bytesRead=(l)) : -1)
#define HTNet_setBytesWritten(me,l)     ((me) ? (me->bytesWritten=(l)) :-1)
#define HTNet_setHeaderLength(me,l)     ((me) ? (me->headerLength=(l)) :-1)

#define HTNet_bytesRead(me)             ((me) ? (me)->bytesRead : -1)
#define HTNet_bytesWritten(me)          ((me) ? (me)->bytesWritten : -1)
#define HTNet_headerLength(me)          ((me) ? (me)->headerLength : -1)

#define HTNet_addBytesRead(me,l)        ((me) ? (me->bytesRead+=(l)) : -1)
#define HTNet_addBytesWritten(me,l)     ((me) ? (me->bytesWritten+=(l)) : -1)
#define HTNet_addHeaderLength(me,l)     ((me) ? (me->headerLength+=(l)) : -1)

extern BOOL HTNet_setEventParam(HTNet * net, void * eventParam);
extern void* HTNet_eventParam(HTNet * net);
extern BOOL HTNet_setEventCallback(HTNet * net, HTEventCallback * cbf);
extern HTEventCallback * HTNet_eventCallback(HTNet * net);
extern BOOL HTNet_setEventPriority(HTNet * net, HTPriority priority);
extern HTPriority HTNet_eventPriority(HTNet * net);
/*

 */
#endif /* HTNETMAN_H */
/*

   
   ___________________________________
   
                          @(#) $Id: HTNetMan.html,v 2.21 1997/02/16 18:42:45 frystyk Exp $
                                                                                          
   */
