/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import netscape.plugin.composer.Composer;
import netscape.plugin.composer.ComposerDocument;
import netscape.plugin.composer.Plugin;
import netscape.plugin.composer.PluginManager;

class PluginRunner
implements Runnable {
    private Plugin plugin;
    private ComposerDocument document;
    private PluginManager manager;

    public PluginRunner(Plugin plugin, ComposerDocument document, PluginManager manager) {
        this.plugin = plugin;
        this.document = document;
        this.manager = manager;
    }

    public void run() {
        Composer composer = this.document.getComposer();
        try {
            boolean result = this.plugin.perform(this.document);
            this.manager.pluginFinished(composer, result ? 2 : 1, null);
            return;
        }
        catch (ThreadDeath threadDeath) {
            System.err.println("Composer plugin " + this.plugin + " was killed.");
            return;
        }
        catch (Throwable t) {
            System.err.println("Composer plugin " + this.plugin + " threw this exception:");
            t.printStackTrace();
            this.manager.pluginFinished(composer, 0, t.toString());
            return;
        }
    }
}

