/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

class FooStringBuffer {
    private char[] value;
    private int count;

    public FooStringBuffer() {
        this(16);
    }

    public FooStringBuffer(int length) {
        this.value = new char[length];
    }

    public FooStringBuffer(char[] chars, int offset, int length) {
        this.value = new char[length];
        System.arraycopy(chars, offset, this.value, 0, length);
        this.count = length;
    }

    public FooStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        int maxCapacity = this.value.length;
        if (minimumCapacity > maxCapacity) {
            int newCapacity = (maxCapacity + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.ensureCapacity(newLength);
        if (this.count < newLength) {
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = newLength;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin >= this.count) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public FooStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public FooStringBuffer append(String str) {
        if (str == null) {
            str = String.valueOf(str);
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public FooStringBuffer append(char[] str) {
        int len = str.length;
        this.ensureCapacity(this.count + len);
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public FooStringBuffer append(char[] str, int offset, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public FooStringBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public FooStringBuffer append(char c) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public FooStringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public FooStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public FooStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public FooStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public FooStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public FooStringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public FooStringBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        this.ensureCapacity(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count += len;
        return this;
    }

    public FooStringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public FooStringBuffer insert(int offset, char c) {
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        ++this.count;
        return this;
    }

    public FooStringBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public FooStringBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public FooStringBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public FooStringBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public FooStringBuffer reverse() {
        int n = this.count - 1;
        int j = n - 1 >> 1;
        while (j >= 0) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
            --j;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }
}

