/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Border;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class BezelBorder
extends Border {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    public static final int GROOVED = 2;
    public static final int RAISED_BUTTON = 3;
    public static final int LOWERED_BUTTON = 4;
    static final int RAISED_SCROLL_BUTTON = 5;
    static final int LOWERED_SCROLL_BUTTON = 6;
    private static Border raisedBezel;
    private static Border loweredBezel;
    private static Border groovedBezel;
    private static Border raisedButtonBezel;
    private static Border loweredButtonBezel;
    private static Border raisedScrollButtonBezel;
    private static Border loweredScrollButtonBezel;
    private int bezelType;
    private Color baseColor;
    private Color lighterColor;
    private Color darkerColor;
    static final String bezelTypeField = "bezelType";
    static final String baseColorField = "baseColor";
    static final String lighterColorField = "lighterColor";
    static final String darkerColorField = "darkerColor";
    private static Class bezelBorderClass;
    static final Color gray218;
    static final Color gray165;
    static final Color gray143;

    public static Border raisedBezel() {
        if (raisedBezel == null) {
            raisedBezel = new BezelBorder(0, Color.lightGray, Color.white, Color.gray);
        }
        return raisedBezel;
    }

    public static Border loweredBezel() {
        if (loweredBezel == null) {
            loweredBezel = new BezelBorder(1, Color.lightGray, Color.white, Color.gray);
        }
        return loweredBezel;
    }

    public static Border groovedBezel() {
        if (groovedBezel == null) {
            groovedBezel = new BezelBorder(2, Color.lightGray, Color.white, Color.gray);
        }
        return groovedBezel;
    }

    public static Border raisedButtonBezel() {
        if (raisedButtonBezel == null) {
            raisedButtonBezel = new BezelBorder(3, Color.lightGray, Color.white, Color.gray);
        }
        return raisedButtonBezel;
    }

    public static Border loweredButtonBezel() {
        if (loweredButtonBezel == null) {
            loweredButtonBezel = new BezelBorder(4, Color.lightGray, Color.white, Color.gray);
        }
        return loweredButtonBezel;
    }

    static Border raisedScrollButtonBezel() {
        if (raisedScrollButtonBezel == null) {
            raisedScrollButtonBezel = new BezelBorder(5);
        }
        return raisedScrollButtonBezel;
    }

    static Border loweredScrollButtonBezel() {
        if (loweredScrollButtonBezel == null) {
            loweredScrollButtonBezel = new BezelBorder(6);
        }
        return loweredScrollButtonBezel;
    }

    public BezelBorder() {
    }

    public BezelBorder(int type) {
        this(type, Color.lightGray, Color.white, Color.gray);
    }

    public BezelBorder(int type, Color baseColor) {
        this();
        this.bezelType = type;
        this.baseColor = baseColor;
        this.lighterColor = baseColor.lighterColor();
        this.darkerColor = baseColor.darkerColor();
    }

    public BezelBorder(int type, Color baseColor, Color lighterColor, Color darkerColor) {
        this();
        this.bezelType = type;
        this.baseColor = baseColor;
        this.lighterColor = lighterColor;
        this.darkerColor = darkerColor;
    }

    public int leftMargin() {
        if (this.bezelType == 4) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int rightMargin() {
        if (this.bezelType == 3) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int topMargin() {
        if (this.bezelType == 4) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int bottomMargin() {
        if (this.bezelType == 3) {
            return 3;
        }
        if (this.bezelType == 5 || this.bezelType == 6) {
            return 1;
        }
        return 2;
    }

    public int type() {
        return this.bezelType;
    }

    public void drawInRect(Graphics g, int x, int y, int width, int height) {
        switch (this.bezelType) {
            case 0: {
                BezelBorder.drawBezel(g, x, y, width, height, this.baseColor, this.lighterColor, this.darkerColor, Color.darkGray, true);
                return;
            }
            case 1: {
                BezelBorder.drawBezel(g, x, y, width, height, this.baseColor, this.lighterColor, this.darkerColor, Color.darkGray, false);
                return;
            }
            case 2: {
                BezelBorder.drawGroovedBezel(g, x, y, width, height, this.lighterColor, this.darkerColor);
                return;
            }
            case 3: {
                BezelBorder.drawRaisedButtonBezel(g, x, y, width, height);
                return;
            }
            case 4: {
                BezelBorder.drawLoweredButtonBezel(g, x, y, width, height);
                return;
            }
            case 5: {
                BezelBorder.drawRaisedScrollButtonBezel(g, x, y, width, height);
                return;
            }
            case 6: {
                BezelBorder.drawLoweredScrollButtonBezel(g, x, y, width, height);
                return;
            }
        }
        throw new InconsistencyException("Invalid bezelType: " + this.bezelType);
    }

    private static Class bezelBorderClass() {
        if (bezelBorderClass == null) {
            bezelBorderClass = BezelBorder.loweredBezel().getClass();
        }
        return bezelBorderClass;
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.BezelBorder", 1);
        info.addField(bezelTypeField, (byte)8);
        info.addField(baseColorField, (byte)18);
        info.addField(lighterColorField, (byte)18);
        info.addField(darkerColorField, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeInt(bezelTypeField, this.bezelType);
        encoder.encodeObject(baseColorField, this.baseColor);
        encoder.encodeObject(lighterColorField, this.lighterColor);
        encoder.encodeObject(darkerColorField, this.darkerColor);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.bezelType = decoder.decodeInt(bezelTypeField);
        this.baseColor = (Color)decoder.decodeObject(baseColorField);
        this.lighterColor = (Color)decoder.decodeObject(lighterColorField);
        this.darkerColor = (Color)decoder.decodeObject(darkerColorField);
        if (this.getClass() != BezelBorder.bezelBorderClass()) {
            return;
        }
        if (this.baseColor == Color.lightGray && this.lighterColor == Color.white && this.darkerColor == Color.gray) {
            switch (this.bezelType) {
                case 0: {
                    decoder.replaceObject(BezelBorder.raisedBezel());
                    return;
                }
                case 1: {
                    decoder.replaceObject(BezelBorder.loweredBezel());
                    return;
                }
                case 2: {
                    decoder.replaceObject(BezelBorder.groovedBezel());
                    return;
                }
                case 3: {
                    decoder.replaceObject(BezelBorder.raisedButtonBezel());
                    return;
                }
                case 4: {
                    decoder.replaceObject(BezelBorder.loweredButtonBezel());
                    return;
                }
                case 5: {
                    decoder.replaceObject(BezelBorder.raisedScrollButtonBezel());
                    return;
                }
                case 6: {
                    decoder.replaceObject(BezelBorder.loweredScrollButtonBezel());
                    return;
                }
            }
        }
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
    }

    public static void drawBezel(Graphics g, int x, int y, int width, int height, Color baseColor, Color lighterColor, Color darkerColor, Color blackColor, boolean raised) {
        Color innerSE;
        Color innerNW;
        Color outerSE;
        Color outerNW;
        if (width == 0 || height == 0) {
            return;
        }
        if (raised) {
            outerNW = baseColor;
            outerSE = blackColor;
            innerNW = lighterColor;
            innerSE = darkerColor;
        } else {
            outerNW = darkerColor;
            outerSE = lighterColor;
            innerNW = blackColor;
            innerSE = baseColor;
        }
        g.setColor(outerNW);
        g.fillRect(x, y, width - 1, 1);
        g.fillRect(x, y + 1, 1, height - 1);
        g.setColor(outerSE);
        g.fillRect(x, y + height - 1, width, 1);
        g.fillRect(x + width - 1, y, 1, height);
        g.setColor(innerNW);
        g.fillRect(++x, ++y, (width -= 2) - 1, 1);
        g.fillRect(x, y + 1, 1, (height -= 2) - 1);
        g.setColor(innerSE);
        g.fillRect(x, y + height - 1, width, 1);
        g.fillRect(x + width - 1, y, 1, height);
    }

    public static void drawGroovedBezel(Graphics g, int x, int y, int width, int height, Color lighterColor, Color darkerColor) {
        if (width == 0 || height == 0) {
            return;
        }
        g.setColor(lighterColor);
        g.drawRect(x + 1, y + 1, width - 1, height - 1);
        g.drawPoint(x + width - 1, y);
        g.drawPoint(x, y + height - 1);
        g.setColor(darkerColor);
        g.drawRect(x, y, width - 1, height - 1);
    }

    public static void drawRaisedButtonBezel(Graphics g, int x, int y, int width, int height) {
        int maxX = x + width;
        int maxY = y + height;
        g.setColor(Color.white);
        g.drawPoint(x + 1, y + 1);
        g.setColor(Color.gray231);
        g.drawLine(x, y, x, maxY - 4);
        g.drawLine(x + 1, y, maxX - 3, y);
        g.setColor(Color.lightGray);
        g.drawLine(x, maxY - 3, x, maxY - 2);
        g.drawLine(x + 1, y + 2, x + 1, maxY - 3);
        g.drawLine(x + 2, y + 1, maxX - 3, y + 1);
        g.drawLine(x + 2, maxY - 3, maxX - 4, maxY - 3);
        g.drawLine(maxX - 3, y + 2, maxX - 3, maxY - 4);
        g.drawPoint(maxX - 2, y);
        g.setColor(Color.gray153);
        g.drawLine(x + 1, maxY - 2, maxX - 3, maxY - 2);
        g.drawLine(maxX - 2, y + 1, maxX - 2, maxY - 3);
        g.drawPoint(maxX - 3, maxY - 3);
        g.drawPoint(maxX - 1, y);
        g.drawPoint(x, maxY - 1);
        g.setColor(Color.gray102);
        g.drawLine(x + 1, maxY - 1, maxX - 1, maxY - 1);
        g.drawLine(maxX - 1, y + 1, maxX - 1, maxY - 2);
        g.drawPoint(maxX - 2, maxY - 2);
    }

    public static void drawLoweredButtonBezel(Graphics g, int x, int y, int width, int height) {
        int maxX = x + width;
        int maxY = y + height;
        g.setColor(Color.white);
        g.drawPoint(maxX - 2, maxY - 2);
        g.setColor(Color.gray231);
        g.drawLine(x + 2, maxY - 1, maxX - 1, maxY - 1);
        g.drawLine(maxX - 1, y + 3, maxX - 1, maxY - 2);
        g.setColor(Color.lightGray);
        g.drawLine(x + 2, y + 3, x + 2, maxY - 3);
        g.drawLine(x + 3, y + 2, maxX - 2, y + 2);
        g.drawLine(maxX - 2, y + 3, maxX - 2, maxY - 3);
        g.drawLine(x + 2, maxY - 2, maxX - 3, maxY - 2);
        g.drawLine(maxX - 1, y + 1, maxX - 1, y + 2);
        g.drawPoint(x + 1, maxY - 1);
        g.setColor(Color.gray153);
        g.drawLine(x + 1, y + 2, x + 1, maxY - 2);
        g.drawLine(x + 2, y + 1, maxX - 2, y + 1);
        g.drawPoint(x, maxY - 1);
        g.drawPoint(maxX - 1, y);
        g.drawPoint(x + 2, y + 2);
        g.setColor(Color.gray102);
        g.drawLine(x, y, x, maxY - 2);
        g.drawLine(x + 1, y, maxX - 2, y);
        g.drawPoint(x + 1, y + 1);
    }

    static void drawRaisedScrollButtonBezel(Graphics g, int x, int y, int width, int height) {
        int maxX = x + width;
        int maxY = y + height;
        g.setColor(Color.white);
        g.drawLine(x, y + 1, x, maxY - 3);
        g.drawLine(x + 1, y, maxX - 3, y);
        g.setColor(Color.gray231);
        g.drawPoint(x, y);
        g.drawPoint(x, maxY - 2);
        g.drawPoint(maxX - 2, y);
        g.setColor(Color.gray153);
        g.drawPoint(maxX - 1, y);
        g.drawPoint(maxX - 1, maxY - 1);
        g.drawPoint(x, maxY - 1);
        g.setColor(Color.gray102);
        g.drawLine(maxX - 1, y + 1, maxX - 1, maxY - 2);
        g.drawLine(x + 1, maxY - 1, maxX - 2, maxY - 1);
    }

    static void drawLoweredScrollButtonBezel(Graphics g, int x, int y, int width, int height) {
        int maxX = x + width;
        int maxY = y + height;
        g.setColor(Color.gray153);
        g.drawLine(x, maxY - 1, maxX - 1, maxY - 1);
        g.drawLine(maxX - 1, y, maxX - 1, maxY - 2);
        g.setColor(Color.lightGray);
        g.drawLine(x, y, maxX - 2, y);
        g.drawLine(x, y + 1, x, maxY - 2);
    }

    static {
        gray218 = new Color(218, 218, 218);
        gray165 = new Color(165, 165, 165);
        gray143 = new Color(143, 143, 143);
    }
}

