/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.BitmapObserver;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.SystemImages;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Bitmap
extends Image {
    java.awt.Image awtImage;
    BitmapObserver bitmapObserver;
    Target updateTarget;
    Rect updateRect;
    String name;
    String updateCommand;
    int imageNumber = Bitmap.application().nextBitmapNumber();
    boolean loaded = false;
    boolean valid = true;
    boolean transparent = true;
    boolean loadIncrementally;
    boolean added;
    boolean useStaticTracker = false;
    MediaTracker mediaTracker;
    static final int WIDTH = 0;
    static final int HEIGHT = 1;
    private static Class bitmapClass;
    static final String NAME_KEY = "name";
    static final String UPDATE_TARGET_KEY = "updateTarget";
    static final String UPDATE_COMMAND_KEY = "updateCommand";
    static final String TRANSPARENT_KEY = "transparent";
    static final String LOAD_INCREMENTALLY_KEY = "loadIncrementally";

    public static synchronized Bitmap bitmapNamed(String bitmapName, boolean startLoading, boolean cache) {
        if (bitmapName == null || bitmapName.equals("")) {
            return null;
        }
        Application app = Bitmap.application();
        Bitmap bitmap = (Bitmap)app.bitmapByName.get(bitmapName);
        if (bitmap != null) {
            return bitmap;
        }
        bitmap = Bitmap.systemBitmapNamed(bitmapName);
        if (bitmap != null) {
            if (cache) {
                app.bitmapByName.put(bitmapName, bitmap);
                bitmap.useStaticTracker = true;
            }
            bitmap.name = bitmapName;
            return bitmap;
        }
        URL url = app._appResources.urlForBitmapNamed(bitmapName);
        bitmap = Bitmap.bitmapFromURL(url);
        if (bitmap == null) {
            return null;
        }
        if (cache) {
            app.bitmapByName.put(bitmapName, bitmap);
            bitmap.useStaticTracker = true;
        }
        bitmap.name = bitmapName;
        if (startLoading) {
            bitmap.startLoadingData();
        }
        return bitmap;
    }

    public static Bitmap bitmapNamed(String bitmapName, boolean startLoading) {
        return Bitmap.bitmapNamed(bitmapName, startLoading, true);
    }

    public static Bitmap bitmapNamed(String bitmapName) {
        return Bitmap.bitmapNamed(bitmapName, true, true);
    }

    public static Bitmap bitmapFromURL(URL url) {
        java.awt.Image awtImage = AWTCompatibility.awtApplet().getImage(url);
        if (awtImage == null) {
            return null;
        }
        Bitmap bitmap = new Bitmap(awtImage);
        return bitmap;
    }

    public Graphics createGraphics() {
        return Graphics.newGraphics(this);
    }

    public Bitmap() {
    }

    public Bitmap(int width, int height) {
        this();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid bitmap size: " + width + "x" + height);
        }
        this.awtImage = AWTCompatibility.awtApplet().createImage(width, height);
        this.setLoaded(true);
    }

    Bitmap(java.awt.Image awtImage) {
        this();
        this.awtImage = awtImage;
    }

    public Bitmap(int[] pixels, int width, int height) {
        this(pixels, width, height, 0, width);
    }

    public Bitmap(int[] pixels, int width, int height, int offset, int scanSize) {
        this();
        MemoryImageSource src = new MemoryImageSource(width, height, pixels, offset, scanSize);
        this.awtImage = AWTCompatibility.awtApplet().createImage(src);
        this.setLoaded(true);
    }

    public boolean grabPixels(int[] pixels) {
        return this.grabPixels(pixels, 0, 0, this.width(), this.height(), 0, this.width());
    }

    public boolean grabPixels(int[] pixels, int x, int y, int width, int height, int offset, int scanSize) {
        boolean status;
        java.awt.Image image = AWTCompatibility.awtImageForBitmap(this);
        PixelGrabber grabber = new PixelGrabber(image, x, y, width, height, pixels, offset, scanSize);
        try {
            status = grabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            status = false;
        }
        return status;
    }

    public String name() {
        return this.name;
    }

    BitmapObserver bitmapObserver() {
        if (this.bitmapObserver == null && !this.hasLoadedData()) {
            this.bitmapObserver = this.updateTarget != null ? new BitmapObserver(Bitmap.application(), this) : new BitmapObserver(null, this);
        }
        return this.bitmapObserver;
    }

    int getWidthOrHeight(int dimension) {
        BitmapObserver observer;
        int value = -1;
        boolean done = false;
        if (dimension != 0 && dimension != 1) {
            throw new IllegalArgumentException("Invalid dimension request: " + dimension);
        }
        if (this.hasLoadedData()) {
            if (dimension == 0) {
                return this.awtImage.getWidth(null);
            }
            return this.awtImage.getHeight(null);
        }
        BitmapObserver bitmapObserver = observer = this.bitmapObserver();
        synchronized (bitmapObserver) {
            while (!done) {
                if (dimension == 0) {
                    value = this.awtImage.getWidth(observer);
                    value = this.awtImage.getWidth(observer);
                } else {
                    value = this.awtImage.getHeight(observer);
                    value = this.awtImage.getHeight(observer);
                }
                if (value != -1 || !this.isValid()) break;
                if ((observer.lastInfo & 0x40) != 0 || (observer.lastInfo & 0x80) != 0) {
                    this.valid = false;
                    this.reportWhyInvalid();
                    this.setLoaded(true);
                    continue;
                }
                try {
                    observer.wait();
                }
                catch (InterruptedException interruptedException) {}
                if ((observer.lastInfo & 0x40) == 0 && (observer.lastInfo & 0x80) == 0) continue;
                this.valid = false;
                this.reportWhyInvalid();
                this.setLoaded(true);
            }
        }
        return value;
    }

    public int width() {
        return this.getWidthOrHeight(0);
    }

    public int height() {
        return this.getWidthOrHeight(1);
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void drawAt(Graphics g, int x, int y) {
        g.drawBitmapAt(this, x, y);
    }

    public void drawScaled(Graphics g, int x, int y, int width, int height) {
        g.drawBitmapScaled(this, x, y, width, height);
    }

    public void drawTiled(Graphics g, int x, int y, int width, int height) {
        if (!this.isValid()) {
            System.err.println("Graphics.drawBitmapTiled() - Invalid bitmap: " + this.name());
            return;
        }
        super.drawTiled(g, x, y, width, height);
    }

    boolean createScaledVersion(int newWidth, int newHeight) {
        if (!this.isValid()) {
            return false;
        }
        Application application = Bitmap.application();
        BitmapObserver observer = this.bitmapObserver();
        while (!application.applet.prepareImage(this.awtImage, newWidth, newHeight, observer)) {
            if (this.loadsIncrementally()) {
                return true;
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    boolean createScaledVersion(float scaleX, float scaleY) {
        return this.createScaledVersion((int)(scaleX * (float)this.width()), (int)(scaleY * (float)this.height()));
    }

    void startLoadingData() {
        MediaTracker tracker = this.tracker();
        if (!this.added) {
            tracker.addImage(this.awtImage, this.imageNumber);
            this.added = true;
        }
        tracker.checkID(this.imageNumber, true);
    }

    public void loadData() {
        if (this.loaded) {
            return;
        }
        MediaTracker tracker = this.tracker();
        while (!this.loaded) {
            try {
                this.startLoadingData();
                if (this.loadIncrementally) break;
                tracker.waitForID(this.imageNumber);
                this.setLoaded(true);
            }
            catch (InterruptedException e) {
                System.err.println("Bitmap.loadData() - " + e);
            }
        }
        if (this.valid) {
            boolean bl = this.valid = !tracker.isErrorID(this.imageNumber);
        }
        if (!this.valid) {
            this.reportWhyInvalid();
            this.setLoaded(true);
        }
    }

    void setLoaded(boolean flag) {
        this.loaded = flag;
        this.mediaTracker = null;
        this.bitmapObserver = null;
    }

    public boolean hasLoadedData() {
        return this.loaded;
    }

    public void setLoadsIncrementally(boolean flag) {
        this.loadIncrementally = flag;
    }

    public boolean loadsIncrementally() {
        return this.loadIncrementally;
    }

    public synchronized Rect updateRect() {
        Rect tmpRect;
        if (this.updateRect == null) {
            tmpRect = new Rect();
        } else {
            tmpRect = this.updateRect;
            this.updateRect = null;
        }
        return tmpRect;
    }

    public synchronized void setUpdateTarget(Target aTarget) {
        this.updateTarget = aTarget;
    }

    public synchronized Target updateTarget() {
        return this.updateTarget;
    }

    public synchronized void setUpdateCommand(String command) {
        this.updateCommand = command;
    }

    public synchronized String updateCommand() {
        return this.updateCommand;
    }

    void reportWhyInvalid() {
        String message = "";
        int status = this.tracker().statusID(this.imageNumber, false);
        if ((status & 2) != 0) {
            message = String.valueOf(message) + " ABORTED";
        } else if ((status & 8) != 0) {
            message = String.valueOf(message) + " COMPLETE";
        } else if ((status & 4) != 0) {
            message = String.valueOf(message) + " ERRORED";
        } else if ((status & 1) != 0) {
            message = String.valueOf(message) + " LOADING";
        }
        System.err.println("Invalid bitmap: " + this.name() + message);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void flush() {
        this.awtImage.flush();
    }

    public String toString() {
        if (this.name != null) {
            return "Bitmap(" + this.name + ")";
        }
        return super.toString();
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.Bitmap", 1);
        info.addField(NAME_KEY, (byte)16);
        info.addField(UPDATE_TARGET_KEY, (byte)18);
        info.addField(UPDATE_COMMAND_KEY, (byte)16);
        info.addField(TRANSPARENT_KEY, (byte)0);
        info.addField(LOAD_INCREMENTALLY_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        if (this.name == null) {
            throw new CodingException("encoded Bitmaps must have a name");
        }
        encoder.encodeString(NAME_KEY, this.name);
        encoder.encodeObject(UPDATE_TARGET_KEY, (Codable)((Object)this.updateTarget));
        encoder.encodeString(UPDATE_COMMAND_KEY, this.updateCommand);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeBoolean(LOAD_INCREMENTALLY_KEY, this.loadIncrementally);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.name = decoder.decodeString(NAME_KEY);
        if (this.name == null) {
            throw new CodingException("encoded Bitmaps must have a name");
        }
        this.updateTarget = (Target)decoder.decodeObject(UPDATE_TARGET_KEY);
        this.updateCommand = decoder.decodeString(UPDATE_COMMAND_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        this.loadIncrementally = decoder.decodeBoolean(LOAD_INCREMENTALLY_KEY);
        Bitmap tmp = Bitmap.bitmapNamed(this.name);
        if (tmp == null) {
            throw new CodingException("unable to find bitmap named: " + this.name);
        }
        if (this.getClass() == Bitmap.bitmapClass()) {
            decoder.replaceObject(tmp);
            return;
        }
        this.awtImage = tmp.awtImage;
    }

    private static Class bitmapClass() {
        if (bitmapClass == null) {
            bitmapClass = new Bitmap().getClass();
        }
        return bitmapClass;
    }

    private static Application application() {
        return Application.application();
    }

    private static Bitmap systemBitmapNamed(String name) {
        Bitmap bitmap = null;
        if (name == null) {
            return null;
        }
        if (!name.startsWith("netscape/application/")) {
            return null;
        }
        String systemName = name.substring("netscape/application/".length());
        if (systemName.equals("RedGrad.gif")) {
            bitmap = SystemImages.redGrad();
        } else if (systemName.equals("GreenGrad.gif")) {
            bitmap = SystemImages.greenGrad();
        } else if (systemName.equals("BlueGrad.gif")) {
            bitmap = SystemImages.blueGrad();
        } else if (systemName.equals("CheckMark.gif")) {
            bitmap = SystemImages.checkMark();
        } else if (systemName.equals("CloseButton.gif")) {
            bitmap = SystemImages.closeButton();
        } else if (systemName.equals("CloseButtonActive.gif")) {
            bitmap = SystemImages.closeButtonActive();
        } else if (systemName.equals("ColorScrollKnob.gif")) {
            bitmap = SystemImages.colorScrollKnob();
        } else if (systemName.equals("PopupKnob.gif")) {
            bitmap = SystemImages.popupKnob();
        } else if (systemName.equals("PopupKnobH.gif")) {
            bitmap = SystemImages.popupKnobH();
        } else if (systemName.equals("RadioButtonOff.gif")) {
            bitmap = SystemImages.radioButtonOff();
        } else if (systemName.equals("RadioButtonOn.gif")) {
            bitmap = SystemImages.radioButtonOn();
        } else if (systemName.equals("ResizeLeft.gif")) {
            bitmap = SystemImages.resizeLeft();
        } else if (systemName.equals("ResizeRight.gif")) {
            bitmap = SystemImages.resizeRight();
        } else if (systemName.equals("ScrollDownArrow.gif")) {
            bitmap = SystemImages.scrollDownArrow();
        } else if (systemName.equals("ScrollDownArrowActive.gif")) {
            bitmap = SystemImages.scrollDownArrowActive();
        } else if (systemName.equals("ScrollKnobH.gif")) {
            bitmap = SystemImages.scrollKnobH();
        } else if (systemName.equals("ScrollKnobV.gif")) {
            bitmap = SystemImages.scrollKnobV();
        } else if (systemName.equals("ScrollLeftArrow.gif")) {
            bitmap = SystemImages.scrollLeftArrow();
        } else if (systemName.equals("ScrollLeftArrowActive.gif")) {
            bitmap = SystemImages.scrollLeftArrowActive();
        } else if (systemName.equals("ScrollRightArrow.gif")) {
            bitmap = SystemImages.scrollRightArrow();
        } else if (systemName.equals("ScrollRightArrowActive.gif")) {
            bitmap = SystemImages.scrollRightArrowActive();
        } else if (systemName.equals("ScrollTrayBottom.gif")) {
            bitmap = SystemImages.scrollTrayBottom();
        } else if (systemName.equals("ScrollTrayLeft.gif")) {
            bitmap = SystemImages.scrollTrayLeft();
        } else if (systemName.equals("ScrollTrayRight.gif")) {
            bitmap = SystemImages.scrollTrayRight();
        } else if (systemName.equals("ScrollTrayTop.gif")) {
            bitmap = SystemImages.scrollTrayTop();
        } else if (systemName.equals("ScrollUpArrow.gif")) {
            bitmap = SystemImages.scrollUpArrow();
        } else if (systemName.equals("ScrollUpArrowActive.gif")) {
            bitmap = SystemImages.scrollUpArrowActive();
        } else if (systemName.equals("TitleBarLeft.gif")) {
            bitmap = SystemImages.titleBarLeft();
        } else if (systemName.equals("TitleBarRight.gif")) {
            bitmap = SystemImages.titleBarRight();
        } else if (systemName.equals("alertNotification.gif")) {
            bitmap = SystemImages.alertNotification();
        } else if (systemName.equals("alertQuestion.gif")) {
            bitmap = SystemImages.alertQuestion();
        } else if (systemName.equals("alertWarning.gif")) {
            bitmap = SystemImages.alertWarning();
        } else if (systemName.equals("topLeftArrow.gif")) {
            bitmap = SystemImages.topLeftArrow();
        } else if (systemName.equals("topRightArrow.gif")) {
            bitmap = SystemImages.topRightArrow();
        } else if (systemName.equals("bottomRightArrow.gif")) {
            bitmap = SystemImages.bottomRightArrow();
        } else if (systemName.equals("bottomLeftArrow.gif")) {
            bitmap = SystemImages.bottomLeftArrow();
        }
        return bitmap;
    }

    public Image imageWithName(String name) {
        return Bitmap.bitmapNamed(name);
    }

    synchronized void unionWithUpdateRect(int x, int y, int width, int height) {
        if (this.updateRect == null) {
            this.updateRect = new Rect(x, y, width, height);
            return;
        }
        this.updateRect.unionWith(x, y, width, height);
    }

    private MediaTracker tracker() {
        if (this.mediaTracker == null) {
            this.mediaTracker = this.useStaticTracker ? Application.application().mediaTracker() : new MediaTracker(AWTCompatibility.awtApplet());
        }
        return this.mediaTracker;
    }
}

