/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.ColorChooser;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.DragWell;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class ColorWell
extends DragWell
implements DragDestination,
Target {
    Target target;
    String command;
    int origX;
    int origY;
    static final String TARGET_KEY = "target";
    static final String COMMAND_KEY = "command";
    public static final String SHOW_COLOR_CHOOSER = "showColorChooser";

    public ColorWell() {
        this(0, 0, 0, 0);
    }

    public ColorWell(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ColorWell(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setColor(Color.blue);
        this._setupKeyboard();
    }

    public void setColor(Color aColor) {
        if (aColor != null) {
            this.setData(aColor);
            this.draw();
        }
    }

    public Color color() {
        return (Color)this.data();
    }

    public void setData(Object anObject) {
        if (!(anObject instanceof Color)) {
            throw new InconsistencyException("ColorWells can only contain colors");
        }
        super.setData(anObject);
    }

    public Image image() {
        Bitmap colorBitmap = new Bitmap(12, 12);
        Graphics g = new Graphics(colorBitmap);
        g.setColor(Color.black);
        g.drawRect(0, 0, 12, 12);
        g.setColor((Color)this.data);
        g.fillRect(1, 1, 10, 10);
        g.dispose();
        colorBitmap.setTransparent(false);
        return colorBitmap;
    }

    public void setImage(Image image) {
        throw new InconsistencyException("Can't set image on ColorWell");
    }

    public void setDataType(String dataType) {
        throw new InconsistencyException("Can't set data type on ColorWell");
    }

    public String dataType() {
        return "netscape.application.Color";
    }

    public void setTarget(Target aTarget) {
        this.target = aTarget;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String command() {
        return this.command;
    }

    public void drawView(Graphics g) {
        g.setColor(this.color());
        g.fillRect(this.border.leftMargin(), this.border.topMargin(), this.bounds.width - this.border.widthMargin(), this.bounds.height - this.border.heightMargin());
        this.border.drawInRect(g, 0, 0, this.bounds.width, this.bounds.height);
    }

    public boolean mouseDown(MouseEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        this.origX = event.x;
        this.origY = event.y;
        return true;
    }

    public void mouseDragged(MouseEvent event) {
        if (Math.abs(event.x - this.origX) > 3 || Math.abs(event.y - this.origY) > 3) {
            new DragSession(this, this.image(), event.x - 6, event.y - 6, event.x, event.y, this.dataType(), this.data);
        }
    }

    public void mouseUp(MouseEvent event) {
        ColorChooser colorChooser = this.rootView().colorChooser();
        colorChooser.setColor(this.color());
        this.rootView().showColorChooser();
    }

    public DragDestination acceptsDrag(DragSession session, int x, int y) {
        if ("netscape.application.Color".equals(session.dataType())) {
            return this;
        }
        return null;
    }

    public boolean dragEntered(DragSession session) {
        return true;
    }

    public boolean dragMoved(DragSession session) {
        return true;
    }

    public void dragExited(DragSession session) {
    }

    public boolean dragDropped(DragSession session) {
        if (!this.isEnabled() || session.source() == this) {
            return false;
        }
        Object theItem = session.data();
        if (theItem == null || !(theItem instanceof Color)) {
            return false;
        }
        this.setColor((Color)theItem);
        this.sendCommand();
        return true;
    }

    public void sendCommand() {
        if (this.target != null) {
            this.target.performCommand(this.command, this);
        }
    }

    public void performCommand(String command, Object data) {
        if (SHOW_COLOR_CHOOSER.equals(command) && this.rootView() != null) {
            this.rootView().showColorChooser();
        }
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ColorWell", 1);
        info.addField(TARGET_KEY, (byte)18);
        info.addField(COMMAND_KEY, (byte)16);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(TARGET_KEY, (Codable)((Object)this.target));
        encoder.encodeString(COMMAND_KEY, this.command);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(SHOW_COLOR_CHOOSER, 10, 0);
    }

    public boolean canBecomeSelectedView() {
        return true;
    }
}

