/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.InputStream;
import java.net.URL;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.FontMetrics;
import netscape.application.Image;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Deserializer;
import netscape.util.Encoder;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class Font
implements Codable {
    FontMetrics _metrics;
    String _name;
    URL _url;
    Bitmap _glyphsImage;
    Vector _glyphVector;
    Vector _widthsVector;
    Hashtable _description;
    java.awt.Font _awtFont;
    int _type = 0;
    int _widthsArrayBase;
    int[] _widthsArray;
    static final int INVALID = 0;
    static final int AWT = 1;
    static final int DOWNLOADED = 2;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    static final String FAMILY = "Family";
    static final String STYLE = "Style";
    static final String SIZE = "Size";
    static final String WIDTHS = "Widths";
    static final String DESCRIPTION = "Description";
    static final String GLYPHS = "glyphs.gif";
    static final String NAME_KEY = "name";
    static final String STYLE_KEY = "style";
    static final String SIZE_KEY = "size";
    private static Class fontClass;

    private static Class fontClass() {
        if (fontClass == null) {
            fontClass = new Font().getClass();
        }
        return fontClass;
    }

    public Font() {
    }

    public Font(String name, int style, int size) {
        this();
        this._awtFont = new java.awt.Font(name, style, size);
        this._name = name;
        if (this._awtFont != null) {
            this._type = 1;
        }
    }

    public static Font defaultFont() {
        return Font.fontNamed("Helvetica", 0, 12);
    }

    public static synchronized Font fontNamed(String fontName, int style, int size) {
        if (fontName == null || size == 0) {
            return null;
        }
        String uniqueName = String.valueOf(fontName) + "." + style + "." + size;
        Application app = Application.application();
        Font font = (Font)app.fontByName.get(uniqueName);
        if (font != null) {
            return font;
        }
        font = new Font(fontName, style, size);
        if (!font.isValid()) {
            return null;
        }
        app.fontByName.put(uniqueName, font);
        return font;
    }

    public static Font fontNamed(String aString) {
        int fontStyle;
        String[] fontDef = Font.stringsForString(aString);
        if (fontDef == null || fontDef.length == 0) {
            return null;
        }
        String fontName = fontDef[0];
        if (fontName.equals("Default")) {
            return Font.defaultFont();
        }
        if (fontName.length() == 0) {
            return null;
        }
        if (fontDef.length == 1) {
            Application app = Application.application();
            URL url = app._appResources.urlForFontNamed(fontName);
            return Font.getFontFromURL(url, fontName);
        }
        String fontStyleString = fontDef[1];
        char firstChar = fontStyleString.charAt(0);
        if (firstChar == 'P' || firstChar == 'p') {
            fontStyle = 0;
        } else if (firstChar == 'B' || firstChar == 'b') {
            fontStyle = 1;
        } else if (firstChar == 'I' || firstChar == 'i') {
            fontStyle = 2;
        } else {
            try {
                fontStyle = Integer.parseInt(fontStyleString);
            }
            catch (NumberFormatException numberFormatException) {
                fontStyle = 0;
            }
        }
        int fontSize = Font.parseInt(fontDef[2]);
        if (fontSize < 0) {
            fontSize = 0;
        }
        return Font.fontNamed(fontName, fontStyle, fontSize);
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static String[] stringsForString(String aString) {
        if (aString == null) {
            return null;
        }
        if (aString.indexOf(58) == -1) {
            String[] strings = new String[]{aString};
            return strings;
        }
        int count = aString.length();
        StringBuffer tmpBuffer = new StringBuffer();
        Vector stringVector = new Vector();
        int i = 0;
        while (i < count) {
            if (aString.charAt(i) == ':') {
                stringVector.addElement(tmpBuffer.toString());
                tmpBuffer = new StringBuffer();
            } else {
                tmpBuffer.append(aString.charAt(i));
            }
            ++i;
        }
        stringVector.addElement(tmpBuffer.toString());
        count = stringVector.count();
        String[] strings = new String[count];
        i = 0;
        while (i < count) {
            strings[i] = (String)stringVector.elementAt(i);
            ++i;
        }
        return strings;
    }

    synchronized void nameFont(String fontName, Font font) {
        Application.application().fontByName.put(fontName, font);
    }

    static synchronized Font getFontFromURL(URL absoluteURL, String fontName) {
        Font font;
        Application app = Application.application();
        if (absoluteURL == null) {
            return null;
        }
        if (fontName != null && (font = (Font)app.fontByName.get(fontName)) != null) {
            return font;
        }
        font = new Font(absoluteURL, fontName);
        if (!font.isValid()) {
            return null;
        }
        app.fontByName.put(fontName, font);
        return font;
    }

    Font(URL fontURL, String name) {
        this();
        URL configURL;
        this._url = fontURL;
        this._name = name;
        this._type = 2;
        this._glyphVector = new Vector();
        this._widthsVector = new Vector();
        try {
            configURL = new URL(fontURL, String.valueOf(this._name) + ".font/" + DESCRIPTION);
        }
        catch (Exception e) {
            System.err.println("Font.init() - Trouble creating font description URL " + fontURL + this._name + ".font/" + DESCRIPTION + " : " + e);
            this._type = 0;
            return;
        }
        try {
            InputStream inputStream = configURL.openStream();
            Deserializer deserializer = new Deserializer(inputStream);
            this._description = (Hashtable)deserializer.readObject();
            this._loadWidths();
        }
        catch (Exception e) {
            System.err.println("Font.init() - Trouble retrieving font description URL " + configURL);
            e.printStackTrace(System.err);
            this._type = 0;
            return;
        }
        this._loadGlyphs(fontURL);
    }

    void _loadWidths() {
        if (this._description == null) {
            return;
        }
        Object[] widthsInfo = (Object[])this._description.get(WIDTHS);
        if (widthsInfo == null) {
            System.err.println("Font._loadWidths() - No widths information for " + this._name);
            return;
        }
        this._widthsArrayBase = Font.parseInt((String)widthsInfo[0]);
        int count = widthsInfo.length - 1;
        this._widthsArray = new int[this._widthsArrayBase + count];
        int i = 0;
        while (i < this._widthsArrayBase) {
            this._widthsArray[i] = 0;
            ++i;
        }
        i = 1;
        int index = this._widthsArrayBase;
        while (i < count) {
            this._widthsArray[index] = Font.parseInt((String)widthsInfo[i]);
            ++i;
            ++index;
        }
        if (this._widthsArray[32] == 0) {
            this._widthsArray[32] = 5;
        }
    }

    java.awt.Image croppedImage(int x, int y, int width, int height) {
        java.awt.Image croppedImage = AWTCompatibility.awtApplet().createImage(new FilteredImageSource(this._glyphsImage.awtImage.getSource(), new CropImageFilter(x, y, width, height)));
        return croppedImage;
    }

    void _loadGlyphs(URL fontURL) {
        URL glyphURL;
        try {
            glyphURL = new URL(fontURL, String.valueOf(this._name) + ".font/" + GLYPHS);
        }
        catch (Exception e) {
            System.err.println("Font.init() - Trouble creating font glyph URL " + fontURL + this._name + ".font/" + GLYPHS + " : " + e);
            this._type = 0;
            return;
        }
        this._glyphsImage = Bitmap.bitmapFromURL(glyphURL);
        this._glyphsImage.loadData();
        if (this._glyphsImage == null || !this._glyphsImage.isValid()) {
            System.err.println("Font._loadGlyphs() - Trouble loading glyphs for " + this._name);
            return;
        }
        this._glyphsImage.loadData();
        int i = this._widthsArrayBase;
        int x = 0;
        while (i < this._widthsArray.length) {
            java.awt.Image awtImage = this.croppedImage(x, 0, this._widthsArray[i], this._glyphsImage.height());
            this._glyphVector.addElement(AWTCompatibility.bitmapForAWTImage(awtImage));
            Image newImage = (Image)this._glyphVector.lastElement();
            x += this._widthsArray[i];
            ++i;
        }
    }

    boolean isValid() {
        return this._type != 0;
    }

    boolean wasDownloaded() {
        return this._type == 2;
    }

    public FontMetrics fontMetrics() {
        if (this._metrics == null) {
            this._metrics = new FontMetrics(this);
        }
        return this._metrics;
    }

    public String family() {
        if (this._type == 0) {
            return "";
        }
        if (this._awtFont != null) {
            return this._awtFont.getFamily();
        }
        return (String)this._description.get(FAMILY);
    }

    public String name() {
        if (this._type == 0) {
            return "";
        }
        return this._name;
    }

    public int style() {
        if (this._type == 0) {
            return -1;
        }
        if (this._awtFont != null) {
            return this._awtFont.getStyle();
        }
        return Font.parseInt((String)this._description.get(STYLE));
    }

    public int size() {
        if (this._type == 0) {
            return -1;
        }
        if (this._awtFont != null) {
            return this._awtFont.getSize();
        }
        return Font.parseInt((String)this._description.get(SIZE));
    }

    public boolean isPlain() {
        return this.style() == 0;
    }

    public boolean isBold() {
        return (this.style() & 1) > 0;
    }

    public boolean isItalic() {
        return (this.style() & 2) > 0;
    }

    Vector glyphVector() {
        return this._glyphVector;
    }

    String _stringValueFromDescription(String keyName) {
        if (keyName == null || this._description == null) {
            return "";
        }
        return (String)this._description.get(keyName);
    }

    int _intValueFromDescription(String keyName) {
        if (keyName == null || this._description == null) {
            return 0;
        }
        return Font.parseInt((String)this._description.get(keyName));
    }

    public String toString() {
        if (this._type == 0 || this.wasDownloaded()) {
            return this._name;
        }
        String styleString = this.isBold() ? (this.isItalic() ? "BoldItalic" : "Bold") : (this.isItalic() ? "Italic" : "Plain");
        return String.valueOf(this.family()) + ":" + styleString + ":" + this.size();
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Font", 1);
        info.addField(NAME_KEY, (byte)16);
        info.addField(STYLE_KEY, (byte)8);
        info.addField(SIZE_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeString(NAME_KEY, this.name());
        encoder.encodeInt(STYLE_KEY, this.style());
        encoder.encodeInt(SIZE_KEY, this.size());
    }

    public void decode(Decoder decoder) throws CodingException {
        String name = decoder.decodeString(NAME_KEY);
        int style = decoder.decodeInt(STYLE_KEY);
        int size = decoder.decodeInt(SIZE_KEY);
        Font font = Font.fontNamed(name, style, size);
        if (this.getClass() == Font.fontClass()) {
            decoder.replaceObject(font);
            return;
        }
        this._name = font._name;
        this._type = font._type;
        this._awtFont = font._awtFont;
        this.nameFont(this._name, this);
    }

    public void finishDecoding() throws CodingException {
    }
}

