/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.InternalWindow;
import netscape.application.KeyEvent;
import netscape.application.KeyStroke;
import netscape.application.Menu;
import netscape.application.MenuItem;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class MenuView
extends View {
    Menu menu;
    MenuItem selectedItem;
    public MenuView owner;
    public MenuView child;
    InternalWindow menuWindow;
    int type;
    int itemHeight = 17;
    boolean transparent = false;
    static final String MENU_KEY = "menu";
    static final String OWNER_KEY = "owner";
    static final String CHILD_KEY = "child";
    static final String MENUWINDOW_KEY = "menuWindow";
    static final String MENUITEMHEIGHT_KEY = "itemHeight";
    static final String TYPE_KEY = "type";
    static final String TRANSPARENT_KEY = "transparent";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public MenuView() {
        this(0, 0, 0, 0, null, null);
    }

    public MenuView(Menu aMenu) {
        this(0, 0, 0, 0, aMenu, null);
    }

    public MenuView(int x, int y, int width, int height) {
        this(x, y, width, height, null, null);
    }

    public MenuView(int x, int y, int width, int height, Menu aMenu) {
        this(x, y, width, height, aMenu, null);
    }

    public MenuView(int x, int y, int width, int height, Menu aMenu, MenuView anOwner) {
        super(x, y, width, height);
        this.menu = aMenu != null ? aMenu : new Menu(true);
        this.owner = anOwner;
        this.menuWindow = this.createMenuWindow();
        this.menuWindow.addSubview(this);
        if (this.menu.isTopLevel()) {
            this.type = 0;
            this.setHorizResizeInstruction(2);
        } else {
            this.type = 1;
        }
        this.menu.menuView = this;
    }

    protected InternalWindow createMenuWindow() {
        InternalWindow window = new InternalWindow(0, 0, 0, 0);
        window.setType(0);
        window.setLayer(511);
        window.setCanBecomeMain(false);
        window._contentView.setTransparent(true);
        window.setScrollsToVisible(true);
        return window;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public int type() {
        return this.type;
    }

    public void setMenu(Menu theMenu) {
        this.menu = theMenu;
    }

    public Menu menu() {
        return this.menu;
    }

    public void setOwner(MenuView menuView) {
        this.owner = menuView;
    }

    public MenuView owner() {
        return this.owner;
    }

    public Color backgroundColor() {
        return this.menu.backgroundColor();
    }

    public Border border() {
        return this.menu.border();
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
        this.menuWindow.setTransparent(flag);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setItemHeight(int height) {
        if (height > 0) {
            this.itemHeight = height;
            return;
        }
        this.itemHeight = this.minItemHeight();
    }

    public int itemHeight() {
        if (this.itemHeight > 0) {
            return this.itemHeight;
        }
        this.setItemHeight(this.minItemHeight());
        return this.itemHeight;
    }

    public int minItemHeight() {
        int minHeight = 0;
        int count = this.menu.itemCount();
        int i = 0;
        while (i < count) {
            int height = this.menu.itemAt(i).minHeight();
            if (height > minHeight) {
                minHeight = height;
            }
            ++i;
        }
        return minHeight;
    }

    public int minItemWidth() {
        int maxWidth = 0;
        int i = 0;
        while (i < this.menu.itemCount()) {
            int width = this.menu.itemAt(i).minWidth();
            if (width > maxWidth) {
                maxWidth = width;
            }
            ++i;
        }
        return maxWidth;
    }

    public Size minSize() {
        int height;
        int width;
        int count = this.menu.itemCount();
        if (this.type == 0) {
            width = 0;
            int i = 0;
            while (i < count) {
                MenuItem item = this.menu.itemAt(i);
                width += item.minWidth();
                ++i;
            }
            height = this.itemHeight();
        } else {
            width = this.minItemWidth();
            height = count * this.itemHeight();
        }
        return new Size(width += this.border().widthMargin(), height += this.border().heightMargin());
    }

    public MenuItem itemForPoint(int x, int y) {
        int index = -1;
        int i = 0;
        while (i < this.menu.itemCount()) {
            Rect itemRect = this.rectForItemAt(i);
            if (itemRect.contains(x, y)) {
                index = i;
                break;
            }
            ++i;
        }
        MenuItem item = index >= 0 ? this.menu.itemAt(index) : null;
        return item;
    }

    public int selectedIndex() {
        MenuItem item = this.selectedItem();
        if (item == null) {
            return -1;
        }
        return this.menu.indexOfItem(item);
    }

    public MenuItem selectedItem() {
        return this.selectedItem;
    }

    public void selectItem(MenuItem item) {
        if (!item.isEnabled()) {
            return;
        }
        if (this.selectedItem != item) {
            if (this.selectedItem != null) {
                this.selectedItem.setSelected(false);
                this.addDirtyRect(this.rectForItemAt(this.menu.indexOfItem(this.selectedItem)));
            }
            item.setSelected(true);
            this.selectedItem = item;
            this.addDirtyRect(this.rectForItemAt(this.menu.indexOfItem(item)));
        }
    }

    public void deselectItem() {
        if (this.selectedItem != null) {
            this.selectedItem.setSelected(false);
            this.addDirtyRect(this.rectForItemAt(this.menu.indexOfItem(this.selectedItem)));
            this.selectedItem = null;
        }
    }

    public Rect rectForItemAt(int index) {
        int width;
        int y;
        if (index < 0 || index >= this.menu.itemCount()) {
            return null;
        }
        int x = 0;
        if (this.type == 0) {
            y = 0;
            int i = 0;
            while (i < index) {
                MenuItem item = this.menu.itemAt(i);
                x += item.minWidth();
                ++i;
            }
            width = this.menu.itemAt(index).minWidth();
        } else {
            y = this.itemHeight() * index;
            width = this.bounds.width - this.border().widthMargin();
        }
        Rect itemRect = Rect.newRect(x += this.border().leftMargin(), y += this.border().topMargin(), width, this.itemHeight());
        return itemRect;
    }

    public Rect interiorRect() {
        Rect interiorRect = new Rect(this.border().leftMargin(), this.border().topMargin(), this.bounds.width - this.border().widthMargin(), this.bounds.height - this.border().heightMargin());
        return interiorRect;
    }

    public void drawItemAt(int index) {
        Rect rect = this.rectForItemAt(index);
        this.draw(rect);
    }

    protected MenuView createMenuView(Menu theMenu) {
        return new MenuView(0, 0, 0, 0, theMenu, this);
    }

    MenuView mainOwner() {
        MenuView myOwner = this.owner;
        while (myOwner.owner() != null) {
            myOwner = myOwner.owner();
        }
        return myOwner;
    }

    boolean performCommandForKeyStroke(KeyStroke aKeyStroke, int condition) {
        if (Application.application().activeMenuViews.count() > 0) {
            return false;
        }
        if (this.window() != null && !this.descendsFrom(this.rootView()._mainWindow)) {
            return false;
        }
        if (condition == 2 || condition == 1) {
            KeyEvent event = new KeyEvent(0L, aKeyStroke.key, aKeyStroke.modifiers, true);
            return this.menu.handleCommandKeyEvent(event);
        }
        return false;
    }

    void mouseWillDown(MouseEvent event) {
        RootView firstRootView = Application.application().firstRootView();
        if (firstRootView != this.rootView()) {
            this.hideAll();
            return;
        }
        MouseEvent newEvent = this.rootView().convertEventToView(this, event);
        if (this.containsPoint(newEvent.x, newEvent.y)) {
            return;
        }
        if (this.selectedItem() != null) {
            MenuView myChild = this.child;
            while (myChild != null) {
                Rect rect = new Rect(myChild.bounds);
                myChild.superview().convertRectToView(null, rect, rect);
                if (Rect.contains(rect.x, rect.y, rect.width, rect.height, event.x, event.y)) {
                    return;
                }
                myChild = myChild.child;
            }
        }
        this.hideAll();
    }

    void hideAll() {
        Application.application().removeActiveMenuView(this);
        if (this.child != null) {
            this.child.hide();
        }
        if (this.isVisible()) {
            this.hide();
        }
        this.deselectItem();
    }

    public boolean mouseDown(MouseEvent event) {
        if (this.owner != null) {
            return true;
        }
        MenuItem clickedItem = this.itemForPoint(event.x, event.y);
        if (clickedItem == null || !clickedItem.isEnabled()) {
            if (this.child != null) {
                this.child.hide();
            }
            this.deselectItem();
            return true;
        }
        if (this.selectedItem != null && clickedItem == this.selectedItem) {
            if (this.isVisible()) {
                return true;
            }
            Application.application().removeActiveMenuView(this);
            if (this.child != null) {
                this.child.hide();
                this.child = null;
            }
            this.deselectItem();
            return true;
        }
        this.selectItem(clickedItem);
        if (clickedItem.isEnabled() && clickedItem.hasSubmenu()) {
            MenuView menuView = this.createMenuView(clickedItem.submenu());
            menuView.show(this.rootView(), event);
            this.child = menuView;
        }
        return true;
    }

    public void mouseDragged(MouseEvent event) {
        MenuItem clickedItem = this.itemForPoint(event.x, event.y);
        if (!Rect.contains(0, 0, this.width(), this.height(), event.x, event.y)) {
            clickedItem = null;
            if (this.owner != null && this.child == null || this.owner == null && this.child == null && this.isVisible()) {
                this.deselectItem();
            }
        }
        if (clickedItem != null && !clickedItem.isEnabled()) {
            return;
        }
        MenuView menuView = this.child;
        while (menuView != null && menuView.isVisible()) {
            Rect rect = new Rect(menuView.bounds);
            MouseEvent newEvent = this.convertEventToView(menuView, event);
            if (Rect.contains(rect.x, rect.y, rect.width, rect.height, newEvent.x, newEvent.y)) {
                clickedItem = menuView.itemForPoint(newEvent.x, newEvent.y);
                if (clickedItem != null) {
                    menuView.mouseDragged(newEvent);
                    menuView.autoscroll(newEvent);
                    return;
                }
            } else if (menuView.child == null) {
                if (menuView.selectedItem() == null) {
                    menuView.autoscroll(newEvent);
                }
                menuView.deselectItem();
            }
            menuView = menuView.child;
        }
        if (clickedItem != null && clickedItem != this.selectedItem()) {
            if (this.selectedItem != null && this.selectedItem.hasSubmenu() && this.child != null && this.child.isVisible()) {
                this.child.hide();
                this.child = null;
            }
            this.selectItem(clickedItem);
            if (clickedItem.hasSubmenu()) {
                menuView = this.createMenuView(clickedItem.submenu());
                menuView.show(this.rootView(), event);
                this.child = menuView;
            }
        }
    }

    public void mouseUp(MouseEvent event) {
        MenuView menuView;
        MenuItem clickedItem = null;
        clickedItem = this.itemForPoint(event.x, event.y);
        if (this.owner == null && this.selectedItem == clickedItem) {
            if (this.isVisible() && this.selectedItem != null) {
                Application.application().removeActiveMenuView(this);
                this.hide();
                this.menu.performCommand("", clickedItem);
            } else {
                return;
            }
        }
        if (this.owner == null && clickedItem == null) {
            menuView = this.child;
            while (menuView.child != null) {
                menuView = menuView.child;
            }
            menuView.mouseUp(this.convertEventToView(menuView, event));
        }
        if (this.owner != null && this.selectedItem != null) {
            clickedItem = this.selectedItem;
            Application.application().removeActiveMenuView(this.mainOwner());
            this.hide();
            menuView = this.owner;
            while (menuView.owner() != null) {
                menuView.hide();
                menuView = menuView.owner();
            }
            menuView.hide();
            this.menu.performCommand("", clickedItem);
        }
    }

    public void mouseEntered(MouseEvent event) {
        if (this.owner == null && this.selectedItem != null || this.isVisible()) {
            this.mouseDragged(event);
        }
    }

    public void mouseMoved(MouseEvent event) {
        if (this.owner == null && this.selectedItem != null || this.isVisible()) {
            this.mouseDragged(event);
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.owner == null && this.selectedItem != null || this.isVisible()) {
            this.mouseDragged(event);
        }
    }

    public void drawView(Graphics g) {
        this.border().drawInRect(g, 0, 0, this.width(), this.height());
        int count = this.menu.itemCount();
        int width = 0;
        int i = 0;
        while (i < count) {
            MenuItem item = this.menu.itemAt(i);
            Rect itemRect = this.rectForItemAt(i);
            width += itemRect.width;
            if (g.clipRect().intersects(itemRect)) {
                g.pushState();
                g.setClipRect(itemRect);
                if (!this.isTransparent()) {
                    g.setColor(this.backgroundColor());
                    g.fillRect(itemRect.x, itemRect.y, itemRect.width, itemRect.height);
                }
                boolean flag = this.type != 0;
                item.drawInRect(g, itemRect, flag);
                g.popState();
                Rect.returnRect(itemRect);
            }
            ++i;
        }
        if (width < this.interiorRect().width && this.type == 0 && !this.isTransparent()) {
            g.setColor(this.backgroundColor());
            g.fillRect(this.interiorRect().x + width, this.interiorRect().y, this.interiorRect().width - width, this.interiorRect().height);
        }
    }

    public void show(RootView rootView, MouseEvent event) {
        int y;
        int x;
        Rect itemRect;
        if (this.menu.itemCount() == 0) {
            return;
        }
        int width = this.minItemWidth() + this.border().widthMargin() + 20;
        int height = this.itemHeight() * this.menu.itemCount() + this.border().heightMargin();
        this.sizeTo(width, height);
        Menu theMenu = this.menu.superitem() != null ? this.menu.superitem().supermenu() : this.menu;
        MenuView menuView = this.owner != null ? this.owner : this;
        Rect windowRect = Rect.newRect(0, 0, this.width(), this.height());
        menuView.convertRectToView(null, windowRect, windowRect);
        if (rootView.windowClipView() != null && this.menuWindow.layer() != 511) {
            rootView.convertRectToView(rootView.windowClipView(), windowRect, windowRect);
        }
        if ((itemRect = menuView.rectForItemAt(menuView.selectedIndex())) == null) {
            itemRect = new Rect(0, 0, 0, 0);
        }
        if (theMenu.isTopLevel() && menuView.type == 0) {
            x = windowRect.x + itemRect.x - menuView.border().leftMargin();
            y = windowRect.y + menuView.height();
        } else if (this.menu.isTopLevel() && this.type == 1) {
            x = event.x;
            y = event.y;
        } else {
            x = windowRect.x + itemRect.width + menuView.border().widthMargin() - 3;
            y = windowRect.y + itemRect.maxY() - itemRect.height - menuView.border().topMargin();
        }
        int w = this.width();
        this.menuWindow.setBounds(x, y, this.width(), this.height());
        this.sizeTo(w, this.height());
        Rect.returnRect(windowRect);
        Rect.returnRect(itemRect);
        menuView = this.owner != null ? this.mainOwner() : this;
        Application.application().addActiveMenuView(menuView);
        this.menuWindow.setRootView(rootView);
        this.menuWindow.show();
    }

    public void hide() {
        if (this.menuWindow.isVisible()) {
            this.menuWindow.hide();
        }
        if (this.selectedItem != null && this.selectedItem.hasSubmenu()) {
            this.child.hide();
            this.child = null;
        }
        this.deselectItem();
    }

    public boolean isVisible() {
        return this.menuWindow.isVisible();
    }

    public boolean wantsAutoscrollEvents() {
        return true;
    }

    void autoscroll(MouseEvent event) {
        Rect visibleRect = Rect.newRect();
        this.computeVisibleRect(visibleRect);
        if (!visibleRect.contains(event.x, event.y)) {
            if (event.y < visibleRect.y) {
                Rect tmpRect = Rect.newRect(visibleRect.x, event.y, visibleRect.width, this.itemHeight());
                this.scrollRectToVisible(tmpRect);
                Rect.returnRect(tmpRect);
            } else if (event.y > visibleRect.maxY()) {
                Rect tmpRect = Rect.newRect(visibleRect.x, event.y - this.itemHeight(), visibleRect.width, this.itemHeight());
                this.scrollRectToVisible(tmpRect);
                Rect.returnRect(tmpRect);
            }
        }
        Rect.returnRect(visibleRect);
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.MenuView", 1);
        info.addField(MENU_KEY, (byte)18);
        info.addField(OWNER_KEY, (byte)18);
        info.addField(CHILD_KEY, (byte)18);
        info.addField(MENUWINDOW_KEY, (byte)18);
        info.addField(MENUITEMHEIGHT_KEY, (byte)8);
        info.addField(TYPE_KEY, (byte)8);
        info.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(MENU_KEY, this.menu);
        encoder.encodeObject(OWNER_KEY, this.owner);
        encoder.encodeObject(CHILD_KEY, this.child);
        encoder.encodeObject(MENUWINDOW_KEY, this.menuWindow);
        encoder.encodeInt(MENUITEMHEIGHT_KEY, this.itemHeight);
        encoder.encodeInt(TYPE_KEY, this.type);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.menu = (Menu)decoder.decodeObject(MENU_KEY);
        this.owner = (MenuView)decoder.decodeObject(OWNER_KEY);
        this.child = (MenuView)decoder.decodeObject(CHILD_KEY);
        this.menuWindow = (InternalWindow)decoder.decodeObject(MENUWINDOW_KEY);
        this.itemHeight = decoder.decodeInt(MENUITEMHEIGHT_KEY);
        this.type = decoder.decodeInt(TYPE_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
    }
}

