/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.OutputStream;
import netscape.util.Archive;
import netscape.util.ArchivingStack;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Encoder;
import netscape.util.ExternalCoder;
import netscape.util.IdHashtable;

public class Archiver
implements Encoder {
    Archive archive;
    ArchivingStack stack = new ArchivingStack();
    IdHashtable idHash = new IdHashtable(false);
    Object currentObject;
    ClassTable currentTable;
    int currentId;
    int currentColumnCount;
    int currentRow;
    int currentColumn;

    public Archiver(Archive archive) {
        this.archive = archive;
    }

    public Archive archive() {
        return this.archive;
    }

    public static void writeObject(OutputStream outputStream, Object root) throws IOException, CodingException {
        Archive archive = new Archive();
        Archiver archiver = new Archiver(archive);
        archiver.archiveRootObject(root);
        archive.write(outputStream);
    }

    public void archiveRootObject(Object root) throws CodingException {
        int rootId = this.identifierForObject(root);
        this.archive.addRootIdentifier(rootId);
    }

    private int identifierForObject(Object object) throws CodingException {
        if (object == null) {
            return 0;
        }
        int id = this.idHash.get(object);
        if (id != 0) {
            return id;
        }
        String className = object.getClass().getName();
        ExternalCoder coder = this.archive.externalCoderForName(className);
        ClassTable table = this.archive.classTableForName(className);
        if (table == null) {
            ClassInfo info = new ClassInfo(className);
            if (coder != null) {
                coder.describeClassInfo(object, info);
            } else {
                ((Codable)object).describeClassInfo(info);
            }
            table = new ClassTable(this.archive, info);
            table.setUniqueStrings(true);
            this.archive.addClassTable(table);
        }
        id = table.newIdentifier();
        this.idHash.putKnownAbsent(object, id);
        this.pushArchivingState(object, id);
        if (coder != null) {
            coder.encode(object, this);
        } else {
            ((Codable)object).encode(this);
        }
        this.popArchivingState();
        return id;
    }

    private void pushArchivingState(Object object, int id) {
        this.stack.pushArchiver(this);
        this.currentObject = object;
        this.currentTable = this.archive.classTableForIdentifier(id);
        this.currentId = id;
        this.currentRow = this.archive.rowForIdentifier(id);
        this.currentColumn = -1;
        this.currentColumnCount = this.currentTable.fieldCount;
    }

    private void popArchivingState() {
        this.stack.popArchiver(this);
    }

    private void prepareToArchiveField(String key) throws CodingException {
        int count = this.currentColumnCount;
        String[] fieldNames = this.currentTable.fieldNames;
        int i = this.currentColumn + 1;
        while (i < count) {
            if (key == fieldNames[i]) {
                this.currentColumn = i;
                return;
            }
            ++i;
        }
        this.currentColumn = this.currentTable.columnForField(key);
        if (this.currentColumn < 0) {
            throw new CodingException("Unknown field name: " + key);
        }
    }

    public void encodeBoolean(String key, boolean value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setBooleanAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeBooleanArray(String key, boolean[] value, int offset, int length) throws CodingException {
        boolean[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new boolean[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setBooleanArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeChar(String key, char value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setCharAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeCharArray(String key, char[] value, int offset, int length) throws CodingException {
        char[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new char[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setCharArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeByte(String key, byte value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setByteAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeByteArray(String key, byte[] value, int offset, int length) throws CodingException {
        byte[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new byte[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setByteArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeShort(String key, short value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setShortAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeShortArray(String key, short[] value, int offset, int length) throws CodingException {
        short[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new short[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setShortArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeInt(String key, int value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setIntAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeIntArray(String key, int[] value, int offset, int length) throws CodingException {
        int[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new int[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setIntArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeLong(String key, long value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setLongAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeLongArray(String key, long[] value, int offset, int length) throws CodingException {
        long[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new long[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setLongArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeFloat(String key, float value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setFloatAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeFloatArray(String key, float[] value, int offset, int length) throws CodingException {
        float[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new float[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setFloatArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeDouble(String key, double value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setDoubleAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeDoubleArray(String key, double[] value, int offset, int length) throws CodingException {
        double[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new double[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setDoubleArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeString(String key, String value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setStringAt(this.currentRow, this.currentColumn, value);
    }

    public void encodeStringArray(String key, String[] value, int offset, int length) throws CodingException {
        String[] copy = null;
        this.prepareToArchiveField(key);
        if (value != null) {
            copy = new String[length];
            System.arraycopy(value, offset, copy, 0, length);
        }
        this.currentTable.setStringArrayAt(this.currentRow, this.currentColumn, copy);
    }

    public void encodeObject(String key, Object value) throws CodingException {
        this.prepareToArchiveField(key);
        this.currentTable.setIdentifierAt(this.currentRow, this.currentColumn, this.identifierForObject(value));
    }

    public void encodeObjectArray(String key, Object[] value, int offset, int length) throws CodingException {
        this.prepareToArchiveField(key);
        if (value == null) {
            this.currentTable.setIdentifierArrayAt(this.currentRow, this.currentColumn, null);
            return;
        }
        int[] ids = new int[length];
        int i = offset;
        while (i < length) {
            ids[i] = this.identifierForObject(value[i]);
            ++i;
        }
        this.currentTable.setIdentifierArrayAt(this.currentRow, this.currentColumn, ids);
    }
}

