/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class Serializer
extends FilterOutputStream {
    private static boolean[] unsafeChars;
    private static int SMALL_STRING_LIMIT;
    private final int BUF_LEN = 128;
    private byte[] buf = new byte[128];
    private int bufIndex;

    public Serializer(OutputStream outputStream) {
        super(outputStream);
    }

    private void flushBuffer() throws IOException {
        if (this.bufIndex > 0) {
            this.write(this.buf, 0, this.bufIndex);
            this.bufIndex = 0;
        }
    }

    final void writeOutput(int character) throws IOException {
        if (this.bufIndex >= 128) {
            this.flushBuffer();
        }
        this.buf[this.bufIndex++] = (byte)character;
    }

    private final void serializeHashtable(Hashtable h) throws IOException {
        Enumeration e = h.keys();
        this.writeOutput(123);
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = h.get(key);
            if (key instanceof String) {
                this.serializeString((String)key);
            } else {
                this.serializeObjectInternal(key);
            }
            this.writeOutput(61);
            if (value instanceof String) {
                this.serializeString((String)value);
            } else {
                this.serializeObjectInternal(value);
            }
            this.writeOutput(59);
        }
        this.writeOutput(125);
    }

    private final void serializeArray(Object[] a) throws IOException {
        this.writeOutput(91);
        int i = 0;
        int c = a.length;
        while (i < c) {
            Object o = a[i];
            if (o instanceof String) {
                this.serializeString((String)o);
            } else {
                this.serializeObjectInternal(o);
            }
            if (i < c - 1) {
                this.writeOutput(44);
            }
            ++i;
        }
        this.writeOutput(93);
    }

    private final void serializeVector(Vector v) throws IOException {
        this.writeOutput(40);
        int i = 0;
        int c = v.count();
        while (i < c) {
            Object o = v.elementAt(i);
            if (o instanceof String) {
                this.serializeString((String)o);
            } else {
                this.serializeObjectInternal(o);
            }
            if (i < c - 1) {
                this.writeOutput(44);
            }
            ++i;
        }
        this.writeOutput(41);
    }

    final boolean stringRequiresQuotes(String s) {
        int i = 0;
        int c = s.length();
        while (i < c) {
            char ch = s.charAt(i);
            if (ch >= '\u007f') {
                return true;
            }
            if (unsafeChars[ch]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final boolean stringRequiresQuotes(char[] str) {
        int i = 0;
        int c = str.length;
        while (i < c) {
            char ch = str[i];
            if (ch >= '\u007f') {
                return true;
            }
            if (unsafeChars[ch]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final int fourBitToAscii(int n) {
        if (n < 10) {
            return 48 + n;
        }
        return 65 + (n - 10);
    }

    void serializeString(String s) throws IOException {
        int length;
        boolean shouldUseQuote = false;
        boolean shouldUseArray = true;
        char[] str = null;
        if (s == null || (length = s.length()) == 0) {
            this.writeOutput(34);
            this.writeOutput(34);
            return;
        }
        if (length <= 8) {
            shouldUseArray = false;
        } else {
            shouldUseArray = true;
            str = s.toCharArray();
        }
        shouldUseQuote = length > SMALL_STRING_LIMIT ? true : (shouldUseArray ? this.stringRequiresQuotes(str) : this.stringRequiresQuotes(s));
        if (shouldUseQuote) {
            this.writeOutput(34);
        }
        int i = 0;
        while (i < length) {
            char ch = shouldUseArray ? str[i] : s.charAt(i);
            if (ch < '\u00ff') {
                if (ch >= '#' && ch <= '~' && ch != '\\') {
                    this.writeOutput(ch);
                } else {
                    switch (ch) {
                        case ' ': 
                        case '!': {
                            this.writeOutput(ch);
                            break;
                        }
                        case '\"': {
                            this.writeOutput(92);
                            this.writeOutput(34);
                            break;
                        }
                        case '\t': {
                            this.writeOutput(92);
                            this.writeOutput(116);
                            break;
                        }
                        case '\n': {
                            this.writeOutput(92);
                            this.writeOutput(110);
                            break;
                        }
                        case '\r': {
                            this.writeOutput(92);
                            this.writeOutput(114);
                            break;
                        }
                        case '\\': {
                            this.writeOutput(92);
                            this.writeOutput(92);
                            break;
                        }
                        default: {
                            this.writeOutput(92);
                            this.writeOutput(48 + (ch >> 6));
                            this.writeOutput(48 + (ch >> 3 & 7));
                            this.writeOutput(48 + (ch & 7));
                            break;
                        }
                    }
                }
            } else {
                this.writeOutput(92);
                this.writeOutput(117);
                this.writeOutput(this.fourBitToAscii(ch >> 12));
                this.writeOutput(this.fourBitToAscii(ch >> 8 & 0xF));
                this.writeOutput(this.fourBitToAscii(ch >> 4 & 0xF));
                this.writeOutput(this.fourBitToAscii(ch & 0xF));
            }
            ++i;
        }
        if (shouldUseArray) {
            str = null;
        }
        if (shouldUseQuote) {
            this.writeOutput(34);
        }
    }

    final void serializeNull() throws IOException {
        this.writeOutput(64);
    }

    private final void serializeObjectInternal(Object anObject) throws IOException {
        if (anObject instanceof String) {
            this.serializeString((String)anObject);
            return;
        }
        if (anObject instanceof Hashtable) {
            this.serializeHashtable((Hashtable)anObject);
            return;
        }
        if (anObject instanceof Object[]) {
            this.serializeArray((Object[])anObject);
            return;
        }
        if (anObject instanceof Vector) {
            this.serializeVector((Vector)anObject);
            return;
        }
        if (anObject == null) {
            this.serializeNull();
            return;
        }
        this.serializeString(anObject.toString());
    }

    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    public void writeObject(Object anObject) throws IOException {
        this.serializeObjectInternal(anObject);
    }

    public static String serializeObject(Object anObject) {
        String result = null;
        if (anObject == null) {
            result = null;
        } else {
            ByteArrayOutputStream memory = new ByteArrayOutputStream(256);
            Serializer serializer = new Serializer(memory);
            try {
                serializer.writeObject(anObject);
                serializer.flush();
            }
            catch (IOException iOException) {}
            result = memory.toString();
            try {
                serializer.close();
                ((OutputStream)memory).close();
            }
            catch (IOException iOException) {}
            memory = null;
            Object var3_3 = null;
        }
        return result;
    }

    public static boolean writeObject(OutputStream outputStream, Object anObject) {
        try {
            Serializer serializer = new Serializer(outputStream);
            serializer.writeObject(anObject);
            serializer.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static {
        SMALL_STRING_LIMIT = 40;
        unsafeChars = new boolean[127];
        int i = 0;
        while (i < 32) {
            Serializer.unsafeChars[i] = true;
            ++i;
        }
        Serializer.unsafeChars[32] = true;
        Serializer.unsafeChars[34] = true;
        Serializer.unsafeChars[91] = true;
        Serializer.unsafeChars[93] = true;
        Serializer.unsafeChars[44] = true;
        Serializer.unsafeChars[40] = true;
        Serializer.unsafeChars[41] = true;
        Serializer.unsafeChars[123] = true;
        Serializer.unsafeChars[125] = true;
        Serializer.unsafeChars[61] = true;
        Serializer.unsafeChars[59] = true;
        Serializer.unsafeChars[47] = true;
        Serializer.unsafeChars[64] = true;
        Serializer.unsafeChars[33] = true;
        Serializer.unsafeChars[35] = true;
        Serializer.unsafeChars[36] = true;
        Serializer.unsafeChars[37] = true;
        Serializer.unsafeChars[38] = true;
        Serializer.unsafeChars[39] = true;
        Serializer.unsafeChars[58] = true;
        Serializer.unsafeChars[60] = true;
        Serializer.unsafeChars[62] = true;
        Serializer.unsafeChars[63] = true;
        Serializer.unsafeChars[92] = true;
        Serializer.unsafeChars[94] = true;
        Serializer.unsafeChars[96] = true;
        Serializer.unsafeChars[124] = true;
        Serializer.unsafeChars[126] = true;
    }
}

