/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public abstract class LDAPSchemaElement {
    public static final int unknown = 0;
    public static final int cis = 1;
    public static final int binary = 2;
    public static final int telephone = 3;
    public static final int ces = 4;
    public static final int dn = 5;
    public static final int integer = 6;
    protected static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    protected static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    protected static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    protected static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    protected static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    protected static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";
    protected String oid = "";
    protected String name = "";
    protected String description = "";
    protected String attrName;

    protected LDAPSchemaElement() {
    }

    protected LDAPSchemaElement(String name, String oid, String description) {
        this.name = name;
        this.oid = oid;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getOID() {
        return this.oid;
    }

    public String getDescription() {
        return this.description;
    }

    protected void update(LDAPConnection ld, int op, LDAPAttribute attr) throws LDAPException {
        LDAPAttribute[] attrs = new LDAPAttribute[]{attr};
        this.update(ld, op, attrs);
    }

    protected void update(LDAPConnection ld, int op, LDAPAttribute[] attrs) throws LDAPException {
        LDAPModificationSet mods = new LDAPModificationSet();
        int i = 0;
        while (i < attrs.length) {
            mods.add(op, attrs[i]);
            ++i;
        }
        ld.modify("cn=schema", mods);
    }

    protected void update(LDAPConnection ld, int op, String name) throws LDAPException {
        LDAPAttribute attr = new LDAPAttribute(name, this.getValue());
        this.update(ld, op, attr);
    }

    public void add(LDAPConnection ld) throws LDAPException {
        this.update(ld, 0, this.attrName);
    }

    public void remove(LDAPConnection ld) throws LDAPException {
        this.update(ld, 1, this.attrName);
    }

    public abstract String getValue();
}

