/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */

#pragma once

#include "CButton.h"
#include "UStdBevels.h"
#include "UGraphicGizmos.h"

#ifndef __MENUS__
#include <menus.h>
#endif

// 
//	
//		Class CBevelButton
//	
// 

class LStream;

class CBevelButton : public CButton
{
	public:
		enum	{ class_ID = 'BvBt' };	
		
							CBevelButton(LStream *inStream);
		virtual				~CBevelButton();
						
	protected:

		virtual	void		DrawSelfDisabled(void);		
		virtual void		DrawButtonContent(void);
				
		Int16				mBevel;
		SBevelColorDesc		mUpColors;
		SBevelColorDesc		mDownColors;
};

	

// 
//	
//		Class CBevelButton
//	
// 

class CDeluxeBevelButton : public CBevelButton
{
	public:
		enum	{ class_ID = 'DxBt' };	
		
							CDeluxeBevelButton(LStream *inStream);
	protected:

		virtual void		DrawButtonContent(void);
};

