/* utils.c - Utility functions for redir. */

#ifndef lint
char RCS_utils_c[] =
"$Id: utils.c,v 2.3 1998/08/11 17:37:57 caleishm Exp caleishm $  Produced by Chris Leishman & Trevor Cohn.  Ormond College student IT department, 1998.\n";
#endif /* not lint */


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <ctype.h>
#include "utils.h"

#define  ASCII_SIZE 256
#define  MAXTIMELEN 50
#define  TRUE       1
#define  NOMATCH    -1


/* safemalloc performs all space allocation (using the malloc library
   function) and ensures the space was correctly allocated.
*/
void *safemalloc(size_t size)
{
   void *memPtr;

   if (!(memPtr = malloc(size))) {
      fprintf(stderr, "\nERROR: Insufficient Memory.\n");
      exit(EXIT_FAILURE);
   }

   return memPtr;
}


#ifndef HAVE_STRDUP

/* strdup duplicates a string, allocating the minimum amount of memory
   required to store it.
*/
char *strdup(const char *s)
{
   char *new;

   new = (char *) safemalloc(strlen(s) + 1);
   strcpy(new, s);

   return new;
}

#endif


void flush_to_eol(FILE *stream)
{
	int c;

	do {
		c = fgetc(stream);
		if ((c == EOF) || (c == '\n'))
			return;
	} while(TRUE);
}


/* Boyer-Moore string search (p is pattern, a is the string). */

#ifdef NOSAVESKIP
int search(const char *p, const char *a) 
#else
int search(const char *p, const char *a, int *skip) 
#endif
{
	int M = strlen(p), N = strlen(a), i = M - 1, j = M - 1;
#ifdef NOSAVESKIP
	int *skip = buildskip(p); 
#endif
	int min_pos = 0;

#ifdef DEBUG
	printf("--search called, %s, %s\n", a, p);
#endif

	/* Check for ^ and $ characters */

	if (p[0] == '^') {
		if (M-1 > N)
			return NOMATCH;
		for (i=0; i < M-1; i++)
			if (p[i+1] != a[i])
				return NOMATCH;
		return 0;
	}

	if (p[M-1] == '$') {
		if (M-1 > N)
			return NOMATCH;
		for (i=0; i < M-1; i++)
			if (p[i] != a[i+N-M+1])
				return NOMATCH;
		return N-M+1;
	}

	do {
		if(a[i] == p[j]) {
			if(j == M - 1)		
				min_pos = i + 1;
			i--;		
			j--;
		}
		else {	
			i += skip[(int)a[i]];
			if(i < min_pos)	
				i = min_pos;
			j = M - 1;		
		}
	} while(j >= 0 && i < N);

	if(j < 0) {
#ifdef DEBUG
	printf("--search match found, %d\n", i + 1);
#endif
		return i + 1;
	}

#ifdef DEBUG
	printf("--search match not found\n");
#endif
	return NOMATCH;
}

/* Boyer-Moore skip array builder
*/
int *buildskip(const char *p) {
	int *skip;
	int i, M = strlen(p);

	skip = (int *) safemalloc(ASCII_SIZE * sizeof(int));

	for(i = 0; i < ASCII_SIZE; i++)
		skip[i] = M;

	for(i = 0; i < M; i++)
		skip[(int)p[i]] = M - i - 1;

	return skip;
}


/* Add a line to a log file */

void addlog(char *logfile, int i, ...)
{
	FILE *fp;
	time_t t;
	va_list ap;
	int j;
#if defined LONGDATE || !defined HAVE_STRFTIME
	char *currtime;
#else
	char currtime[MAXTIMELEN];
#endif

	if (logfile == NULL)
		return;

	va_start(ap, i);

	if ((fp = fopen(logfile, "a")) == NULL) {
		fprintf(stderr, "ERROR: Couldn't open file \"%s\"\n", logfile);
		return;
	}

#ifdef DEBUG
	printf("Adding log to %s\n", logfile);
#endif

	time(&t);
#if defined LONGDATE || !defined HAVE_STRFTIME
	currtime = ctime(&t);
	currtime[strlen(currtime)-1] = '\0';
#else
	strftime(currtime, MAXTIMELEN, "%b %d %H:%M:%S", localtime(&t));
#endif

	fprintf(fp, "%s ", currtime);

	for(j = 1; j <= i; j++) {
		fprintf(fp, "%s ", va_arg(ap, char *));
	}

	fprintf(fp, "\n");

	if (fclose(fp) == EOF) {
		fprintf(stderr, "ERROR: Couldn't close file \"%s\"\n", logfile);
		return;
	}
}


char *strlower(char *s, int length) {
	int i;

	for (i = 0; i <= length && s[i] != '\0'; i++)
		s[i] = tolower(s[i]);

	return s;
}

		
