// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1992,93,94
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        light.h
//
// Purpose:     interface to light source
//
// Created:     12 Mar 92   Michael Hofer and Michael Pichler
//
// Changed:      1 Aug 94   Michael Pichler
//
// $Id: light.h,v 1.3 1997/02/25 17:03:58 mpichler Exp $
//
//</file>



#ifndef harmony_scene_light_h
#define harmony_scene_light_h


#include "object3d.h"
#include <ge3d/color.h>



class Light
: public Object3D
{
  public:
    Light (int obj_n, int par = 0, const char* name = 0);

    const char* type () const  { return "lgt"; }

    int readLgtFile (FILE*);
    void print ();
    void dependsOnCamera ();

    void setlight (int);  // to ge3d

    const colorRGB* intensity () const
    { return &intensity_; }
    int positional () const
    { return (int) positional_; }

  private:
    colorRGB intensity_;  // light specifics
    float positional_;  // positional or directional
    int camlgt_;  // relative to camera?
};


inline void Light::dependsOnCamera ()
{
  parent_ = 0;  // do not calculate overall trf-matrix
  camlgt_ = 1;
}


#endif
