// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1992,93,94,95,96,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        themenus.h
//
// Purpose:     interface to scene viewer menus and dialogs
//
// Created:     17 Dec 92   Michael Pichler
//
// Changed:     21 Feb 97   Alexander Nussbaumer (editing)
//
// Changed:     19 Mar 97   Michael Pichler
//
// $Id: themenus.h,v 1.30 1997/04/30 10:40:45 mpichler Exp $
//
//</file>



#ifndef harmony_scene_themenus_h
#define harmony_scene_themenus_h


class SceneWindow;
class SceneMenus;

#include <hyperg/utils/str.h>

#include <ge3d/vectors.h>

#include <InterViews/action.h>
#include <InterViews/telltale.h>
class Patch;

class GEContext;
class HG3dInputHandler;
class LayoutKit;
class Menu;
class MenuItem;
class WidgetKit;
class WFileChooser;
class ColourDialog;
class ApplicationWindow;
class Window;
class FieldBrowser;
class TextBrowser;
class QvPerspectiveCamera;
class QvOrthographicCamera;
class NavigationSettingsDialog;
 // anuss
class InsertObjectDialog;
class TextureDialog;
class MaterialDialog;
class WWWAnchorDialog;
class StructureViewerDialog;
class TransformDialog;
class GridDialog;
class ViewpointDialog;


/*** MenuGroupCallback ***/
// action for calling a member function of SceneMenus with integer argument

typedef void (SceneMenus::*SceneMenuMemberFunction) (int);
// pointer to member function of SceneMenus with int argument

class MenuGroupCallback: public Action
{
  public:
    MenuGroupCallback (SceneMenus*, SceneMenuMemberFunction, int arg);

    virtual void execute ();

  private:
    SceneMenus* sm_;
    SceneMenuMemberFunction fu_;
    int arg_;
};



/*** SceneMenus ***/

class SceneMenus
{
  public:
    SceneMenus (Patch* menupatch, Patch* buttonpatch, SceneWindow* scene,
                GEContext*, HG3dInputHandler*,  // might remove them (known through scene window)
                WidgetKit* kit, const LayoutKit* layout);  // pointers must not be nil
    ~SceneMenus ();

    void updateLanguage ();  // language settings; create menus, buttons, dialogs

    void createMenus ();
    void createButtons ();
    void updateDialogs ();

    TextBrowser* errorBrowser ()        // error browser (nil if not yet created)
    { return errorbrowser_; }
    TextBrowser* errorBrowserInstance ();  // instance of error browser (created if not yet done)

    void selectionChanged ();  // hint that selection changed - enable/disable anchor menu items
    void sceneChanged ();  // hint after loading a scene - enable/disable file menu items
    void sceneCleared ();  // on clearing a scene

    void navigationMode (int);
    void selectionMode (int);
    void setRenderMode (int);
    void renderMode (int);
    void BSPmode (int);
    void toggleStereoMode ();
    void textureMipmapping (int);
    void twosidedPolys (int);
    void doLighting (int);
    void transparencyMode (int);
    void highlightingMode (int);
    void displayMode (int mode, int interactive);
    void newFile (); // anuss: starts with empty scene (for editing)
    void openFile ();
    void saveOriginalScene ();
    void saveCurrentScene ();  // anuss
    void toggleShowAnchors ();
    void quitScene ();                  // quit session and care for saving (anuss)

    // editing (anuss)
    void toggleEditScene ();            // change between viewing and editing mode (anuss)
    void editMode (int);                // set any edit mode (EditMode::ed_*) (anuss)
    void toggleEditMode ();             // toggle edit mode (select or camera) (anuss)
    void toggleEditToolbar ();          // toggle edit toolbar (anuss)
    void toggleConstraints ();
    int continueOnSaveState ();         // ask for saving before modified scene is cleared (anuss)
    void undoManipulation ();
//    void insertFile ();                 // insert file as inline into current scene
//    void insertThisFile (const char* filename);  // insert file as inline into current scene
    void deleteSelectedNode ();
    void cutSelectedNode ();
    void copySelectedNode ();
    void pasteSelectedNode ();

    void resetView ();
    void levelView ();
    void untiltView ();

    void addViewpoint (               // add camera to viewpoint menu
      const char* name, QvPerspectiveCamera*, QvOrthographicCamera*
    );
    void clearViewpoints ();
    void selectViewpoint (int num);  // running from 0
    void prevViewpoint ();  // cyclical
    void nextViewpoint ();  // cyclical

    enum {  // anti aliasing
      aa_lines, aa_polygons, aa_polygons2,
      aa_num
    };
    void toggleAntialiasing (int which);
    int antialiasing (int which) const
    { return (aaliasingstate_ [which]->flags () & TelltaleState::is_chosen); }

    void setCollisionDetection (int flag);

    void applyColours (ColourDialog*);  // callback

    enum {  // space ball flags
      sb_translate, sb_rotate, sb_saf,  // 0..2
      sb_numflags  // 3
    };
    int getSballFlag (int i);           // returns setting of i-th sb. flag
    int toggleSballFlag (int i);        // toggles i-th spaceball flag; returns new value
    void toggleSballMode ();            // toggle navigation mode (flip/walk)

    float sballSensitivity () const;    // return sensitivity of spaceball
    void decreaseSballSensitivity ();
    void increaseSballSensitivity ();
    void resetSballSensitivity ();

  private:
    // submenus
    Menu* filePulldown (WidgetKit&, const LayoutKit&);
    Menu* demoPullright (WidgetKit&, const LayoutKit&);
    Menu* usabilityPullright (WidgetKit&, const LayoutKit&);
    MenuItem* editMenu (WidgetKit&, const LayoutKit&);
    Menu* editPulldown (WidgetKit&, const LayoutKit&);  // anuss
    Menu* viewPulldown (WidgetKit&, const LayoutKit&);
    void selectionItems (Menu*, WidgetKit&, const LayoutKit&, int);
    Menu* navigatePulldown (WidgetKit&, const LayoutKit&);
    void emptyViewpointsPullright (WidgetKit&, const LayoutKit&);  // viewpointsPr_
    Menu* anchorsPulldown (WidgetKit&, const LayoutKit&);
    Menu* displayPulldown (WidgetKit&, const LayoutKit&);
    Menu* anchorsPullright (WidgetKit&, const LayoutKit&);
    Menu* colorPullright (WidgetKit&, const LayoutKit&);
    Menu* documentPulldown (WidgetKit&, const LayoutKit&);
    // Menu* optionsPulldown (WidgetKit&, const LayoutKit&);
    Menu* specialPulldown (WidgetKit&, const LayoutKit&);
    Menu* helpPulldown (WidgetKit&, const LayoutKit&);
    void updateAbout (WidgetKit&, const LayoutKit&);

    // dialogs
    void buildOpenFC ();
//    void buildInsertFC ();  // anuss
    void buildColourDialog ();
    void buildErrorDialog ();
    void buildSpaceballDialog ();

    // bubble help
    Window* bubbleHelpWindow (int i);

    void loadDemo (const char*);  // file name relative to demo path
    void browseDemo (const char*, const point3D& position, const point3D& lookat);
    void saveScene (int format, const char* filemask);  // save as dialog
    void writeScene (int format, const char* filename);  // internal call
    void saveVRMLScene ();
    void saveSDFScene ();
    void saveDepth ();  // will be merged into saveScene
    void documentInfo (int);
    void toggleColourDialog ();
    void colourChanged ();
    void anchorMotionChanged ();
    void velocityControlChanged ();
    void arbitraryRotationChanged ();
    void collisionDetectionChanged ();
    void showAnchorsChanged ();
    void aaliasingChanged ();
    void viewingLightChanged ();
    void stereoModeChanged ();
    void toggleTextureLighting ();
    void toggleTextureTransparency ();
    void toggleNoMaterials ();
    void removeSelection ();
    void printData ();
    void printAll ();
    void cameraInfo ();
    void toggleAbout ();
    void toggleErrorDialog ();
    void closeErrorDialog ();
    void toggleNavigationSettingsDialog ();
    void destroyNavsetdlg ();
    void toggleSpaceballDialog ();
    void closeSpaceballDialog ();
    void movementMode (int);
    void setDisplayMode (int);
    void setInteractiveMode (int);
    void sb_checkbuttons (int);
    void updateSensitivity ();

    // editing (anuss)
    void selectParent ();
    void selectChild ();
    void selectNext (int step);
    void viewSelectedNode ();
    void viewAll ();
    void toggleInsertObjectDialog ();
    void toggleTextureDialog ();
    void toggleWWWAnchorDialog ();
    void toggleMaterialDialog ();
    void toggleStructureViewerDialog ();
    void toggleTransformDialog ();  // abstract dialog
    void toggleGridDialog ();
    void toggleViewpointDialog ();
    void destroyEditDialogs ();

    Patch* menupatch_;
    Menu* menubar_;
    int editmapped_, editIdx_;
    Patch* buttonpatch_;
    SceneWindow* scene_;
    GEContext* gecontext_;
    HG3dInputHandler* inputhand_;
    WidgetKit* kit_;
    const LayoutKit* layout_;
    WFileChooser* openfc_;
//  WFileChooser* savefc_;

    // anuss
//    WFileChooser* insertfc_;
    InsertObjectDialog* insertobjectdialog_;
    TextureDialog* texturedialog_;
    MaterialDialog* materialdialog_;
    StructureViewerDialog* structureviewerdialog_;
    WWWAnchorDialog* wwwanchordialog_;
    TransformDialog* transformdialog_;
    GridDialog* griddialog_;
    ViewpointDialog* viewpointdialog_;

    ColourDialog* coldlg_;
    ApplicationWindow* errorwindow_;
    TextBrowser* errorbrowser_;
    NavigationSettingsDialog* navsetdlg_;
    ApplicationWindow* sballwindow_;

    Menu* viewpointsPr_;
    Menu* viewptsParent_;
    int viewpointsIndex_;
    int selectionIndex_;
    int viewproffset_;
    int curviewpoint_;

    TelltaleState* saveasstate_;
    TelltaleState* exportSDFstate_;
    TelltaleState* exportVRMLstate_;

    TelltaleState* editstate_;          // anuss: edit or viewer mode
    TelltaleState* editmodestate_;      // anuss: selection or camera
    TelltaleState* constraintsstate_;   // wordaxis should be drawn
    TelltaleState* edittoolbarstate_;

  public:
    enum {  // edit dialogs (anuss)
      edlg_insertobj, edlg_anchor, edlg_texture, edlg_material,
      edlg_structure, edlg_transform, edlg_viewpoint, edlg_grid,
      edlg_num
    };
    void editdialogClosed (int which);

  private:
    TelltaleState* editdlgstate_ [edlg_num];

    enum {  // anchors and selection
      sel_sourceanchor, sel_deleteanchor, sel_anchorinfo, sel_activateanchor,
      sel_parent, sel_child, sel_previous, sel_next, sel_removesel, sel_view,
      sel_num
    };
    TelltaleState* selectionstate_ [sel_num];
//     TelltaleState* removeselectionstate_;

    // options
    TelltaleState* anchormotionstate_;
    TelltaleState* velocitycontrolstate_;
    TelltaleState* arbitraryrotstate_;
    TelltaleState* colldetectionstate_;
    TelltaleState* showanchorstate_;

    TelltaleState* wireframe_;
    TelltaleState* hiddenline_;
    TelltaleState* flatshading_;
    TelltaleState* smoothshading_;
    TelltaleState* texturing_;

    TelltaleState* intsame_;
    TelltaleState* intwire_;
    TelltaleState* inthline_;
    TelltaleState* intflat_;
    TelltaleState* intsmooth_;
    TelltaleState* inttexture_;

    TelltaleState* aaliasingstate_ [aa_num];
    TelltaleState* texmipmaponstate_;
    TelltaleState* texmipmapoffstate_;
    TelltaleState* navflipobjstate_;
    TelltaleState* navwalkstate_;
    TelltaleState* navflystate_;
    TelltaleState* navflytostate_;
    TelltaleState* navheadsupstate_;
    TelltaleState* viewlgtstate_;
    TelltaleState* stereostate_;
    TelltaleState* renderzbuf_;
    TelltaleState* renderbsp_;
    RString demopath_;
    RString savefilename_;

    TelltaleState* sbflagstate_ [sb_numflags];
    FieldBrowser* sbsensfieldb_;
    int sbsensitivity2_;

  friend class MenuGroupCallback;
  friend class LoadDemoCallback;
  friend class BrowseDemoCallback;
  friend class SetColourCallback;
  friend class ViewpointCallback;

};  // SceneMenus


inline TextBrowser* SceneMenus::errorBrowserInstance ()
{
  if (!errorbrowser_)  // create instance
    buildErrorDialog ();
  return errorbrowser_;
}


#endif
