#ifndef _MENUS_
#define _MENUS_

#define MAX_FILE_SIZE 4096	/* max chars to read from file for cut */
#define MAXPOPUPS 50

typedef struct MenuItem {
    struct MenuItem *next;	/* next menu item */
    struct MenuItem *prev;	/* prev menu item */
    char *item;			/* the character string displayed on left */
    char *item2;		/* the character string displayed on right */
    char *action;		/* action to be performed */
    short item_num;		/* item number of this menu */
    short x;			/* x coordinate for text (item) */
    short x2;			/* x coordinate for text (item2) */
    short y_offset;		/* y coordinate for item */
    short y_height;		/* y height for item */
    short func;			/* twm built in function */
    long val1;			/* values needed for F_SCROLL */
    long val2;
    long val1_unit;		/* units for val1, val2 */
    long val2_unit;		/* pixels (unit=1) or percent of screen 
				 * (unit = Scr.MyDisplayWidth/Height */
    short state;		/* video state, 0 = normal, 1 = reversed */
    short strlen;		/* strlen(item) */
    short strlen2;		/* strlen(item2) */
    short hotkey;		/* Hot key offset (pete@tecc.co.uk).
				   0 - No hot key
				   +ve - offset to hot key char in item
				   -ve - offset to hot key char in item2
				   (offsets have 1 added, so +1 or -1
				   refer to the *first* character)
				 */
    struct MenuRoot *menu;	/* sub-menu */
} MenuItem;

typedef struct MenuRoot {
    struct MenuItem *first;	/* first item in menu */
    struct MenuItem *last;	/* last item in menu */
    struct MenuRoot *next;	/* next in list of root menus */
    char *name;			/* name of root */
    Window w;			/* the window of the menu */
    short height;		/* height of the menu */
    short width;		/* width of the menu for 1st col */
    short width2;		/* width of the menu for 2nd col */
    short items;		/* number of items in the menu */
    Bool in_use;
#ifndef NO_TEXTURE
    Pixmap titlebg, itembg;	/* background pixmap for title and others */
#endif
} MenuRoot;

typedef struct MouseButton {
    int func;			/* the function number */
    MenuRoot *menu;		/* menu if func is F_POPUP */
    MenuItem *item;		/* action to perform if func != F_POPUP */
    int Button;
    int Context;
    int Modifier;
    int val1;
    int val2;
    long val1_unit;		/* units for val1, val2 */
    long val2_unit;		/* pixels (unit=1) or percent of screen 
				 * (unit = Scr.MyDisplayWidth/Height */
    struct MouseButton *NextButton;
} MouseButton;

typedef struct FuncKey {
    struct FuncKey *next;	/* next in the list of function keys */
    char *name;			/* key name */
    KeyCode keycode;		/* X keycode */
    int cont;			/* context */
    int mods;			/* modifiers */
    int func;			/* function to perform */
    int val1;			/* values needed for F_SCROLL */
    int val2;
    long val1_unit;		/* units for val1, val2 */
    long val2_unit;		/* pixels (unit=1) or percent of screen  */
    MenuRoot *menu;		/* menu if func is F_POPUP */
    char *action;		/* action string (if any) */
} FuncKey;

#define MENU_ERROR -1
#define MENU_NOP 0
#define MENU_DONE 1
#define SUBMENU_DONE 2


/* Types of events for the FUNCTION builtin */
#define MOTION 'm'
#define IMMEDIATE 'i'
#define CLICK 'c'
#define DOUBLE_CLICK 'd'
#define TRIPLE_CLICK 't'
#define ONE_AND_A_HALF_CLICKS 'o'
#define TWO_AND_A_HALF_CLICKS 'h'

extern MenuRoot *ActiveMenu;
extern MenuItem *ActiveItem;

#endif				/* _MENUS_ */
