/*****************************************************************************/
/* Enlightenment - The Window Manager that dares to do what others don't     */
/*****************************************************************************/
/* Copyright (C) 1997 - 1998 Carsten Haitzler (The Rasterman) and            */
/*                           Geoff Harrison (Mandrake)                       */
/*                                                                           */
/* This program and utilites is free software; you can redistribute it       */
/* and/or modify it under the terms of the GNU General Public License as     */
/* published by the Free Software Foundation; either version 2 of the        */
/* License, or (at your option) any later version.                           */
/*                                                                           */
/* This software is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         */
/* General Public License for more details.                                  */
/*                                                                           */
/* You should have received a copy of the GNU Library General Public         */
/* License along with this software; if not, write to the                    */
/* Free Software Foundation, Inc., 59 Temple Place - Suite 330,              */
/* Boston, MA 02111-1307, USA.                                               */
/*****************************************************************************/

#ifndef HAVE_VPRINTF
#error "ERROR: Enlightenemnt needs a system with vprintf() in it's libs."
#error "You may have to upgrade your Operating system, Distribution, base"
#error "system libraries etc. Please see the the instuctions for your"
#error "particular Operating System or Distribution"
#endif
#ifndef HAVE_WAIT3
#error "ERROR: Enlightenemnt needs a system with wait3() in it's libs."
#error "You may have to upgrade your Operating system, Distribution, base"
#error "system libraries etc. Please see the the instuctions for your"
#error "particular Operating System or Distribution"
#endif
#ifndef HAVE_GETCWD
#error "ERROR: Enlightenemnt needs a system with getcwd() in it's libs."
#error "You may have to upgrade your Operating system, Distribution, base"
#error "system libraries etc. Please see the the instuctions for your"
#error "particular Operating System or Distribution"
#endif
#ifndef HAVE_MKDIR
#error "ERROR: Enlightenemnt needs a system with mkdir() in it's libs."
#error "You may have to upgrade your Operating system, Distribution, base"
#error "system libraries etc. Please see the the instuctions for your"
#error "particular Operating System or Distribution"
#endif
#ifdef HAVE_SNPRINTF
#define Esnprintf snprintf
#else
#ifdef HAVE_STDARGS
int
                    Esnprintf(char *str, size_t count, const char *fmt,...);

#else
int
                    Esnprintf(va_alist);

#endif
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/extensions/shape.h>
#include <X11/extensions/XTest.h>
#include <X11/extensions/XShm.h>
#include <Imlib.h>
#include <Fnlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <signal.h>
#include <time.h>
#include <math.h>
#include <pwd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/resource.h>
#ifdef HAVE_LIBESD
#include <esd.h>
#endif

#include "arrange.h"

#define EERR_NONE               0
#define EERR_OUT_OF_MEMORY      1
#define EERR_FILE_NOT_EXIST     2
#define EERR_PERMISSION_DENIED  3
#define EERR_FILING_SYSTEM_FULL 4

#ifndef ENLIGHTENMENT_ROOT
#define ENLIGHTENMENT_ROOT           "/usr/local/enlightenment"
#endif
#define ENLIGHTENMENT_SYSTEM_CONFIG  ENLIGHTENMENT_ROOT"/system_config"
#define ENLIGHTENMENT_SYSTEM_THEMES  ENLIGHTENMENT_ROOT"/themes"
#define ENLIGHTENMENT_SYSTEM_BGS     ENLIGHTENMENT_ROOT"/backgrounds"

#define LIST_FINDBY_NAME        0
#define LIST_FINDBY_ID          1
#define LIST_FINDBY_BOTH        2

#define LIST_TYPE_COUNT         13
#define LIST_TYPE_ANY            0
#define LIST_TYPE_CLIENT         1
#define LIST_TYPE_EWIN           2
#define LIST_TYPE_BORDER         3
#define LIST_TYPE_ICLASS         4
#define LIST_TYPE_ACLASS         5
#define LIST_TYPE_AWAIT_ICLASS   6
#define LIST_TYPE_ACLASS_GLOBAL  7
#define LIST_TYPE_ACLASS_DESK    8
#define LIST_TYPE_TCLASS         9
#define LIST_TYPE_BACKGROUND    10
#define LIST_TYPE_BUTTON        11
#define LIST_TYPE_SCLASS        12
#define LIST_TYPE_BORDERMATCH   13
#define LIST_TYPE_COLORMODIFIER 14

#define BEVEL_NONE              0
#define BEVEL_AMIGA             1
#define BEVEL_MOTIF             2
#define BEVEL_NEXT              3
#define BEVEL_DOUBLE            4
#define BEVEL_WIDEDOUBLE        5
#define BEVEL_THINPOINT         6
#define BEVEL_THICKPOINT        7

#define EWIN_ACTIVE             1
#define EWIN_STICKY             2

#define STATE_NORMAL            0
#define STATE_HILITED           1
#define STATE_CLICKED           2
#define STATE_DISABLED          3

#define FILL_STRETCH            0
#define FILL_TILE               1
#define FILL_INTEGER_TILE       2

#define FLAG_BUTTON             0
#define FLAG_TITLE              1
#define FLAG_MINIICON           2
#define FLAG_FIXED              4
#define FLAG_FIXED_HORIZ        8
#define FLAG_FIXED_VERT         16

#define FOCUS_POINTER           0
#define FOCUS_SLOPPY            1
#define FOCUS_CLICK             2

/* Welcome to actions
 * This file contains all of the action handling definitions
 * Created 02/22/98 by Mandrake (mandrake@mandrake.net)
 */

#define ACTION_NONE                   0
#define ACTION_EXEC                   1
#define ACTION_ALERT                  2
#define ACTION_MOVE	              3
#define ACTION_RESIZE                 4
#define ACTION_RAISE                  5
#define ACTION_LOWER                  6
#define ACTION_EXIT                   7
#define ACTION_CLEANUP                8
#define ACTION_SHOW_MENU              9
#define ACTION_HIDE_MENU              10
#define ACTION_RESIZE_H               11
#define ACTION_RESIZE_V               12
#define ACTION_KILL                   13
#define ACTION_KILL_NASTY             14
#define ACTION_DESKTOP_NEXT           15
#define ACTION_DESKTOP_PREV           16
#define ACTION_DESKTOP_RAISE          17
#define ACTION_DESKTOP_LOWER          18
#define ACTION_DESKTOP_DRAG           19
#define ACTION_STICK                  20
#define ACTION_DESKTOP_INPLACE        21
#define ACTION_DRAG_BUTTON            22
#define ACTION_FOCUSMODE_SET          23
#define ACTION_MOVEMODE_SET           24
#define ACTION_RESIZEMODE_SET         25
#define ACTION_SLIDEMODE_SET          26
#define ACTION_CLEANUPSILDE_SET       27
#define ACTION_MAPSLIDE_SET           28
#define ACTION_SOUND_SET              29
#define ACTION_BUTTONMOVE_RESIST_SET  30
#define ACTION_DESKTOPBG_TIMEOUT_SET  31
#define ACTION_MAPSLIDE_SPEED_SET     32
#define ACTION_CLEANUPSLIDE_SPEED_SET 33
#define ACTION_DRAGDIR_SET            34
#define ACTION_DRAGBAR_ORDER_SET      35
#define ACTION_DRAGBAR_WIDTH_SET      36
#define ACTION_DRAGBAR_LENGTH_SET     37
#define ACTION_DESKSLIDE_SET          38
#define ACTION_DESKSLIDE_SPEED_SET    39
#define ACTION_HIQUALITYBG_SET        40
#define ACTION_PLAYSOUNDCLASS         41
#define ACTION_GOTO_DESK              42
#define ACTION_DESKRAY                43
#define ACTION_AUTOSAVE_SET           44
#define ACTION_HIDESHOW_BUTTON        45
/* false number exluding the above list */
#define ACTION_NUMBEROF               46

#define MODE_NONE         0
#define MODE_MOVE         1
#define MODE_RESIZE       2
#define MODE_RESIZE_H     3
#define MODE_RESIZE_V     4
#define MODE_DESKDRAG     5
#define MODE_BUTTONDRAG   6
#define MODE_DESKRAY      7

#define EVENT_MOUSE_DOWN  0
#define EVENT_MOUSE_UP    1
#define EVENT_MOUSE_ENTER 2
#define EVENT_MOUSE_LEAVE 3
#define EVENT_KEY_DOWN    4
#define EVENT_KEY_UP      5

typedef struct _actiontype
  {
     void               *params;
     struct _actiontype *Next;
     int                 Type;
  }
ActionType;

typedef struct _list
  {
     int                 type;
     char               *name;
     int                 id;
     void               *item;

     struct _list       *next;
  }
List;

typedef struct _client
  {
     char               *name;
     Window              win;
     char               *msg;
     char               *clientname;
     char               *version;
     char               *author;
     char               *email;
     char               *web;
     char               *address;
     char               *info;
     Pixmap              pmap;
  }
Client;

typedef struct _root
  {
     Window              win;
     Visual             *vis;
     int                 depth;
     Colormap            cmap;
     int                 scr;
     int                 w, h;
     Window              focuswin;
  }
Root;

typedef struct _modcurve
  {
     int                 num;
     unsigned char      *px;
     unsigned char      *py;
     unsigned char       map[256];
  }
ModCurve;

typedef struct _colormodifierclass
  {
     char               *name;
     ModCurve            red, green, blue;
  }
ColorModifierClass;

typedef struct _imagestate
  {
     char               *im_file;
     char                unloadable;
     ImlibImage         *im;
     ImlibColor         *transp;
     ImlibBorder        *border;
     int                 pixmapfillstyle;
     ImlibColor          bg, hi, lo, hihi, lolo;
     int                 bevelstyle;
     ColorModifierClass *colmod;
  }
ImageState;

typedef struct _imageclass
  {
     char               *name;
     char                external;
     struct
       {
	  ImageState         *normal;
	  ImageState         *hilited;
	  ImageState         *clicked;
	  ImageState         *disabled;
       }
     norm               , active, sticky, sticky_active;
     ImlibBorder         padding;
     ColorModifierClass *colmod;
  }
ImageClass;

typedef struct _textstate
  {
     char               *fontname;
     FnlibStyle          style;
     FnlibFont          *font;
  }
TextState;

typedef struct _textclass
  {
     char               *name;
     struct
       {
	  TextState          *normal;
	  TextState          *hilited;
	  TextState          *clicked;
	  TextState          *disabled;
       }
     norm               , active, sticky, sticky_active;
  }
TextClass;

typedef struct _action
  {
     char                event;
     char                anymodifier;
     int                 modifiers;
     char                anybutton;
     int                 button;
     char                anykey;
     KeyCode             key;
     ActionType         *action;
  }
Action;

typedef struct _actionclass
  {
     char               *name;
     int                 num;
     Action            **list;
  }
ActionClass;

typedef struct _constraints
  {
     int                 min, max;
  }
Constraints;

typedef struct _winpoint
  {
     int                 originbox;
     struct
       {
	  int                 percent;
	  int                 absolute;
       }
     x                  , y;
  }
WinPoint;

typedef struct _geometry
  {
     Constraints         width, height;
     WinPoint            topleft, bottomright;
  }
Geometry;

typedef struct _winbutton
  {
     char               *name;
     ImageClass         *iclass;
     ActionClass        *aclass;
     int                 width, height;
  }
WinButton;

typedef struct _winbuttons
  {
     int                 num;
     WinButton          *buttons;
  }
WinButtons;

typedef struct _winpart
  {
     Geometry            geom;
     ImageClass         *iclass;
     ActionClass        *aclass;
     TextClass          *tclass;
     struct
       {
	  char                is;
	  char                expandable;
	  char                order;
	  char                orientation;
	  WinButtons          buttons;
       }
     region;
     char                ontop;
     int                 flags;
  }
WinPart;

typedef struct _border
  {
     char               *name;
     ImlibBorder         border;
     int                 num_winparts;
     WinPart            *part;
     char                changes_shape;
  }
Border;

typedef struct _ewinbit
  {
     Window              win;
     int                 x, y, w, h;
     int                 cx, cy, cw, ch;
     int                 state;
     char                expose;
  }
EWinBit;

typedef struct _winclient
  {
     Window              win;
     char               *title;
     int                 x, y, w, h;
     Colormap            cmap;
     Window              icon_win;
     Pixmap              icon_pmap;
     Pixmap              icon_mask;
     char                start_iconified;
     XID                 group;
     char                need_input;
     char                transient;
     char               *class;
     char               *name;
     char               *command;
     char               *machine;
     char               *icon_name;
     char                is_group_leader;
     char                no_resize_h;
     char                no_resize_v;
     char                shaped;
     Constraints         width, height;
     int                 base_w, base_h;
     int                 w_inc, h_inc;
     double              aspect_min, aspect_max;
     char                already_placed;
     char                mwm_decor_border;
     char                mwm_decor_resizeh;
     char                mwm_decor_title;
     char                mwm_decor_menu;
     char                mwm_decor_minimize;
     char                mwm_decor_maximize;
     char                mwm_func_resize;
     char                mwm_func_move;
     char                mwm_func_minimize;
     char                mwm_func_maximize;
     char                mwm_func_close;
     unsigned int        app_state;
  }
WinClient;

typedef struct _ewin
  {
     Window              win;
     int                 x, y, w, h;
     WinClient           client;
     Border             *border;
     EWinBit            *bits;
     int                 flags;
     int                 state;
     int                 desktop;
     int                 group;
     char                sticky;
     char                visible;
     char                iconified;
     char                active;
     char                ontop;
     char                onbottom;
     char                never_use_area;
     Window              parent;
     char                floating;
     char                shapedone;
  }
EWin;

typedef struct _awaiticlass
  {
     Window              client_win;
     int                 ewin_bit;
     ImageClass         *iclass;
  }
AwaitIclass;

typedef struct _bgeometry
  {
     Constraints         width, height;
     int                 xorigin, yorigin;
     int                 xabs, xrel;
     int                 yabs, yrel;
     int                 xsizerel, xsizeabs;
     int                 ysizerel, ysizeabs;
     char                size_from_image;
  }
BGeometry;

typedef struct _strip Strip;
typedef struct _stripjoint Stripjoint;

typedef struct _button
  {
     char               *name;
     BGeometry           geom;
     ImageClass         *iclass;
     ActionClass        *aclass;
     char                ontop;
     int                 flags;
     char                sticky;
     int                 desktop;
     char                visible;

     Window              win;
     int                 x, y, w, h;
     int                 cx, cy, cw, ch;
     int                 state;
     char                expose;
  }
Button;

struct _strip
  {
     char               *name;
     int                 xabs, yabs;
     int                 xrel, yrel;
     char                ontop;
     char                sticky;
     int                 desktop;
     char                orientation;
     char                out;
     int                 justification;
     int                 spacing;

     char               *anchor_name;
     char               *bg_name;
     Button             *anchor;
     Button             *bg;

     int                 num_buttons;
     Button             *button;

     Window              win;
     int                 x, y, w, h;
     int                 cx, cy, cw, ch;
  };

typedef struct _background
  {
     char               *name;
     Pixmap              pmap;
     time_t              last_viewed;
     struct _bg
       {
	  ImlibColor          solid;
	  char               *file;
	  ImlibImage         *im;
	  char                tile;
	  char                keep_aspect;
	  int                 xjust, yjust;
	  int                 xperc, yperc;
       }
     bg;
     struct _top
       {
	  char               *file;
	  ImlibImage         *im;
	  char                keep_aspect;
	  int                 xjust, yjust;
	  int                 xperc, yperc;
       }
     top;
  }
Background;

typedef struct _desk
  {
     char                viewable;
     Window              win;
     int                 x, y;
     Background         *bg;
     int                 num;
     Window             *list;
     Button             *tag;
  }
Desk;

typedef struct _desktops
  {
     int                 current;
     Desk                desk[32];
     int                 dragdir;
     int                 dragbar_width;
     int                 dragbar_ordering;
     int                 dragbar_length;
     char                slidein;
     int                 slidespeed;
     char                hiqualitybg;
  }
Desktops;

typedef struct _sample
  {
     int                 rate;
     int                 format;
     int                 samples;
     short              *data;
     int                 id;
  }
Sample;

typedef struct _soundclass
  {
     char               *name;
     char               *file;
     Sample             *sample;
  }
SoundClass;

typedef struct _bordermatch
  {
     char               *name;
     char               *win_title;
     char               *win_name;
     char               *win_class;
     Constraints         width;
     Constraints         height;
     char                transient;
     char                no_resize_h;
     char                no_resize_v;
     char                shaped;
     char               *border;
  }
BorderMatch;

typedef struct _initconfig
  {
     ImlibColor          bgcolor;
     struct
       {
	  struct
	    {
	       int                 justx, justy;
	       int                 x, y;
	    }
	  location;
	  int                 num;
	  char              **file;
	  ImlibImage        **im;
	  Pixmap             *pmap;
       }
     spinner;
  }
InitConfig;

typedef struct _emode
  {
     int                 mode;
     int                 deskmode;
     EWin               *ewin;
     Button             *button;
     int                 resize_detail;
     int                 win_x, win_y, win_w, win_h;
     int                 start_x, start_y;
     char                noewin;
     int                 focusmode;
     char                click_focus_grabbed;
     EWin               *focuswin;
     EWin               *mouse_over_win;
     int                 px, py, x, y;
     char                firstlast;
     int                 movemode;
     int                 resizemode;
     int                 slidemode;
     char                cleanupslide;
     char                mapslide;
     int                 slidespeedmap;
     int                 slidespeedcleanup;
     char                doingslide;
     int                 server_grabbed;
     int                 desktop_bg_timeout;
     int                 deskdrag;
     char                sound;
     int                 button_move_resistance;
     char                button_move_pending;
     Colormap            current_cmap;
     char                autosave;
  }
EMode;

typedef struct
  {
     char               *string;
     short               definition;
  }
StringType;

void                md(char *s);
int                 exists(char *s);
int                 isfile(char *s);
int                 isdir(char *s);
char              **ls(char *dir, int *num);
void                freestrlist(char **l, int num);
void                rm(char *s);
void                mv(char *s, char *ss);
void                cp(char *s, char *ss);
time_t              moddate(char *s);
int                 filesize(char *s);
void                cd(char *s);
char               *cwd(void);
int                 permissions(char *s);
int                 owner(char *s);
int                 group(char *s);
char               *username(int uid);
char               *homedir(int uid);
char               *usershell(int uid);
char               *duplicate(char *s);
char               *atword(char *s, int num);
char               *atchar(char *s, char c);
void                word(char *s, int num, char *wd);
int                 canread(char *s);
int                 canwrite(char *s);
int                 canexec(char *s);
char               *fileof(char *s);
char               *fullfileof(char *s);
char               *pathtoexec(char *file);
char               *pathtofile(char *file);

void                Alert(char *fmt,...);
void                ShowAlert(char *text);
void                AlertHandleClick(int button);
void                ErrAlert(int erno);

void                EDisplayMemUse();
void                EExit(int code);
void               *Emalloc(int size);
void               *Erealloc(void *ptr, int size);
void                Efree(void *ptr);

void               *FindItem(char *name, int id, int find_by, int type);
void                AddItem(void *item, char *name, int id, int type);
void               *RemoveItem(char *name, int id, int find_by, int type);
void              **ListItemType(int *num, int type);
char              **ListItems(int *num, int type);
void              **ListItemTypeID(int *num, int type, int id);

void                MapUnmap(int start);
void                SetupSignals();
void                SetupX();
void                SetupDirs();
void                SetupEnv();

void                HandleSigHup(int num);
void                HandleSigInt(int num);
void                HandleSigQuit(int num);
void                HandleSigIll(int num);
void                HandleSigAbrt(int num);
void                HandleSigFpe(int num);
void                HandleSigSegv(int num);
void                HandleSigPipe(int num);
void                HandleSigAlrm(int num);
void                HandleSigTerm(int num);
void                HandleSigUsr1(int num);
void                HandleSigUsr2(int num);
void                HandleSigChild(int num);
void                HandleSigTstp(int num);
void                HandleSigBus(int num);
void                HandleXError(Display * d, XErrorEvent * ev);
void                HandleXIOError(Display * d);

void                CommsSetup();
void                CommsFindCommsWindow();
void                CommsSend(Client * c, char *s);
char               *CommsGet(Client ** c, XEvent * ev);
void                CommsBroadcast(char *s);
Client             *MakeClient(Window win);
void                DeleteClient(Client * c);
void                HandleComms(XEvent * ev);
void                DisplayClientInfo(Client * c, int onoff);
void                HideClientInfo();

Window              ECreateWindow(Window parent, int x, int y, int w, int h,
				  int saveunder);
Window              ECreateEventWindow(Window parent, int x, int y, int w,
				       int h);
void                GrabX();
void                UngrabX();
void                SetBG(Window win, Pixmap pmap, int color);
void                GetWinXY(Window win, int *x, int *y);
void                GetWinWH(Window win, unsigned int *w, unsigned int *h);
int                 WinExists(Window win);

void                HandleEvent(XEvent * ev);
void                CheckEvent();
void                WaitEvent();

EWin               *GetEwinPointerInClient();
EWin               *GetEwin();
void                SlideEwinTo(EWin * ewin, int fx, int fy, int tx, int ty,
				int speed);
void                AddToFamily(Window win);
void                HonorIclass(char *s, int id);
void                SyncBorderToEwin(EWin * ewin);
void                RealiseEwinWinpart(EWin * ewin, int i);
int                 DrawEwinWinpart(EWin * ewin, int i);
int                 ChangeEwinWinpart(EWin * ewin, int i);
void                DrawEwin(EWin * ewin);
int                 ChangeEwinWinpartContents(EWin * ewin, int i);
void                CalcEwinWinpart(EWin * ewin, int i);
void                CalcEwinSizes(EWin * ewin);
EWin               *Adopt(Window win);
EWin               *CreateEwin();
void                FreeEwin(EWin * ewin);
BorderMatch        *CreateBorderMatch(char *name, char *border);
int                 MatchEwinBorder(EWin * ewin, BorderMatch * b);
void                SetEwinBorder(EWin * ewin);
void                ResizeEwin(EWin * ewin, int w, int h);
void                MoveEwin(EWin * ewin, int x, int y);
void                MoveResizeEwin(EWin * ewin, int x, int y, int w, int h);
void                FloatEwin(EWin * ewin);
void                FloatEwinAt(EWin * ewin, int x, int y);
void                RestackEwin(EWin * ewin);
void                RaiseEwin(EWin * ewin);
void                LowerEwin(EWin * ewin);
void                ShowEwin(EWin * ewin);
void                HideEwin(EWin * ewin);
Border             *CreateBorder(char *name);
void                AddBorderPart(Border * b, ImageClass * iclass,
				  ActionClass * aclass, TextClass * tclass,
				  char ontop, int flags, char isregion,
				  int wmin, int wmax, int hmin, int hmax,
				  int torigin, int txp, int txa, int typ,
				  int tya, int borigin, int bxp, int bxa,
				  int byp, int bya);

ImageClass         *CreateIclass();
ImageState         *CreateImageState();
void                ImageStatePopulate(ImageState * is);
void                IclassPopulate(ImageClass * iclass);
void                IclassApply(ImageClass * iclass, Window win, int w, int h,
				int active, int state, char expose);

ImlibImage         *ELoadImage(char *file);
ImlibImage         *ELoadImageImlibData(ImlibData * imd, char *file);
void                DrawEwinShape(EWin * ewin, int md, int x, int y, int w,
				  int h, char firstlast);
void                FocusToEWin(EWin * ewin);
void                PropagateShapes(Window win);

void                ICCCM_GetTitle(EWin * ewin);
void                ICCCM_GetColormap(EWin * ewin);
void                ICCCM_Delete(EWin * ewin);
void                ICCCM_Save(EWin * ewin);
void                ICCCM_Iconify(EWin * ewin);
void                ICCCM_DeIconfiy(EWin * ewin);
void                ICCCM_MatchSize(EWin * ewin);
void                ICCCM_Configure(EWin * ewin);
void                ICCCM_Adopt(EWin * ewin, Window win);
void                ICCCM_Focus(EWin * ewin);
void                ICCCM_GetGeoms(EWin * ewin);
void                ICCCM_GetInfo(EWin * ewin);
void                ICCCM_GetHints(EWin * ewin);
void                ICCCM_GetShapeInfo(EWin * ewin);
void                ICCCM_SetIconSizes();

ActionClass        *CreateAclass(char *name);
Action             *CreateAction(char event, char anymod, int mod, int anybut,
				 int but, char anykey, char *key);
void                AddToAction(Action * act, int id, void *params);
void                AddAction(ActionClass * a, Action * act);
void                EventAclass(XEvent * ev, ActionClass * a);
int                 handleAction(ActionType * Action);
int                 spawnMenu(void *params);
int                 hideMenu(void *params);
int                 doNothing(void *params);
int                 execApplication(void *params);
int                 alert(void *params);
int                 doExit(void *params);
int                 doMove(void *params);
int                 doResize(void *params);
int                 doResizeH(void *params);
int                 doResizeV(void *params);
int                 doResizeEnd(void *params);
int                 doMoveEnd(void *params);
int                 doRaise(void *params);
int                 doLower(void *params);
int                 doCleanup(void *params);
int                 doKill(void *params);
int                 doKillNasty(void *params);
int                 doNextDesktop(void *params);
int                 doPrevDesktop(void *params);
int                 doRaiseDesktop(void *params);
int                 doLowerDesktop(void *params);
int                 doDragDesktop(void *params);
int                 doStick(void *params);
int                 doInplaceDesktop(void *params);
int                 doDragButtonStart(void *params);
int                 doDragButtonEnd(void *params);
int                 doGotoDesktop(void *params);
int                 doDeskray(void *params);
int                 doAutosaveSet(void *params);
int                 doHideShowButton(void *params);
int                 initFunctionArray(void);

void                GrabActionKey(Action * a);
void                UnGrabActionKey(Action * a);
void                GrabTheButtons(Window win);
void                GrabThePointer(Window win);
void                UnGrabTheButtons();

void                ShowDesktopControls();
void                ShowDesktopTabs();
void                HideDesktopTabs();
void                MoveToDeskTop(int num);
void                MoveToDeskBottom(int num);
void                SlideWindowTo(Window win, int fx, int fy, int tx, int ty,
				  int speed);
Background         *CreateDesktopBG(char *name, ImlibColor * solid,
				    char *bg, char tile, char keep_aspect,
				    int xjust, int yjust, int xperc, int yperc,
				    char *top, char tkeep_aspect, int txjust,
				    int tyjust, int txperc, int typerc);
void                RefreshCurentDesktop();
void                RefreshDesktop(int num);
void                InitDesktopBgs();
void                InitDesktopControls();
void                SetDesktopBg(int desk, Background * bg);
void                ConformEwinToDesktop(EWin * ewin);
int                 DekstopAt(int x, int y);
void                GotoDesktop(int num);
void                MoveDesktop(int num, int x, int y);
void                RaiseDesktop(int num);
void                LowerDesktop(int num);
void                HideDesktop(int num);
void                ShowDesktop(int num);
void                StackDesktops();
void                UncoverDesktop(int num);
void                MoveEwinToDesktop(EWin * ewin, int num);
void                DesktopAddEwinToBottom(EWin * ewin);
void                DesktopAddEwinToTop(EWin * ewin);
void                DesktopRemoveEwin(EWin * ewin);
void                MoveEwinToDesktopAt(EWin * ewin, int num, int x, int y);
void                FloatEwinAboveDesktops(EWin * ewin);
void                DesktopAccounting();

int                 AddEToFile(char *file);
int                 CreateEFile(char *file);
void                AddE();

TextClass          *CreateTclass();
TextState          *CreateTextState();
void                TclassPopulate(TextClass * tclass);
void                TclassApply(ImageClass * iclass, Window win, int w,
				int h, int active, int state, char expose,
				TextClass * tclass, char *text);

void                HandleFocusWindow(Window win);
void                HandleChildShapeChange(XEvent * ev);
void                HandleMotion(XEvent * ev);
void                HandleDestroy(XEvent * ev);
void                HandleProperty(XEvent * ev);
void                HandleCirculate(XEvent * ev);
void                HandleReparent(XEvent * ev);
void                HandleConfigureRequest(XEvent * ev);
void                HandleResizeRequest(XEvent * ev);
void                HandleUnmap(XEvent * ev);
void                HandleMapRequest(XEvent * ev);
void                HandleExpose(XEvent * ev);
void                HandleMouseDown(XEvent * ev);
void                HandleMouseUp(XEvent * ev);
void                HandleMouseIn(XEvent * ev);
void                HandleMouseOut(XEvent * ev);

void                FocusToEWin(EWin * ewin);
EWin               *FindEwinByBase(Window win);
EWin               *FindEwinByChildren(Window win);
EWin               *FindEwinByDecoration(Window win);
Button             *FindButton(Window win);

void                MWM_GetHints(EWin * ewin);
void                MWM_SetInfo();

Button             *CreateButton(char *name, ImageClass * iclass,
				 ActionClass * aclass, char ontop, int flags,
				 int minw, int maxw, int minh,
				 int maxh, int xo, int yo, int xa, int xr,
				 int ya, int yr, int xsr, int xsa, int ysr,
				 int ysa, char simg, int desk, char sticky);
void                DestroyButton(Button * b);
void                CalcButton(Button * b);
void                ShowButton(Button * b);
void                SimpleShowButton(Button * b);
void                MoveButtonToDesktop(Button * b, int num);
void                HideButton(Button * b);
void                DrawButon(Button * b);
void                MovebuttonToCoord(Button * b, int x, int y);

void                GNOME_GetHints(EWin * ewin);

Sample             *LoadWav(char *file);
void                SoundPlay(Sample * s);
void                DestroySample(Sample * s);
void                DestroySclass(SoundClass * sclass);
SoundClass         *CreateSoundClass(char *name, char *file);
void                ApplySclass(SoundClass * sclass);
void                SoundInit();
void                SoundExit();

int                 isafter(int p, char *s1, char *s2);
int                 matchregexp(char *rx, char *s);

void                DoIn(long milsec, void (*func) (int val, void *data));
void                InitTimerQueue();
void                HandleTimerQueue();
void                HandleTimerEvent();

void                CreateCurve(ModCurve * c);
ColorModifierClass *CreateCMClass(char *name,
				  int rnum, unsigned char *rpx,
				  unsigned char *rpy, int gnum,
				  unsigned char *gpx, unsigned char *gpy,
				  int bnum, unsigned char *bpx,
				  unsigned char *bpy);

int                 testForComment(char *line);
int                 GetNextLine(char *line, FILE * ConfigFile);
StringType         *GenerateStringList(char *file);
void                DestroyStringList(StringType * listToKill);
int                 ReturnStringReference(StringType * StringSet,
					  char *actionString);
void                Config_Text(FILE * ConfigFile);
void                Config_Control(FILE * ConfigFile);
void                Config_Menu(FILE * ConfigFile);
void                BorderPartLoad(FILE * ConfigFile, char type, Border * b);
void                Config_Border(FILE * ConfigFile);
void                Config_Button(FILE * ConfigFile);
void                Config_Desktop(FILE * ConfigFile);
void                Config_Iconbox(FILE * ConfigFile);
void                Config_Sound(FILE * ConfigFile);
void                Config_ActionClass(FILE * ConfigFile);
void                Config_ImageClass(FILE * ConfigFile);
void                Config_ColorModifier(FILE * ConfigFile);
void                Config_BorderMatch(FILE * ConfigFile);
int                 LoadConfigFile(char *file);
int                 LoadStringFiles(void);
char               *ExtractTheme(char *theme);
char               *FindFile(char *file);
char               *FindTheme(char *theme);
int                 LoadEConfig(char *themelocation);
void                DeleteUserControlConfig();
void                SaveUserControlConfig();

extern Display     *disp;
extern ImlibData   *id;
extern ImlibData   *ird;
extern FnlibData   *fd;
extern List         lists;
extern int          event_base_shape;
extern Window       comms_win;
extern Root         root;
extern int          (*(ActionFunctions[ACTION_NUMBEROF])) (void *);
extern EMode        mode;
extern Desktops     desks;
extern Window       grab_window;
extern Window       init_win;
extern InitConfig   init_conf;
extern int          deskorder[32];
extern int          sound_fd;

#define FILEPATH_LEN_MAX 4096
extern char         themepath[FILEPATH_LEN_MAX];
extern char        *command;
extern char         mustdel;

/* This turns on E's internal stack tracking system for  coarse debugging */
/* and being able to trace E for profiling/optimisation purposes (which */
/* believe it or not I'm actually doing) */

/* #define DEBUG 1 */

#ifdef DEBUG
extern int          call_level;
extern int          debug_level;

#endif

#ifdef DEBUG
#define EDBUG(l,x) \
{ \
  int i_call_level; \
  if (l<debug_level) \
    { \
      for(i_call_level=0;i_call_level<call_level;i_call_level++) \
        putchar('-'); \
      printf(" %8x %s\n",(unsigned int)time(NULL),x); \
      fflush(stdout); \
    } \
  call_level++; \
}
#else
#define EDBUG(l,x)  \
;
#endif

#ifdef DEBUG
#define EDBUG_RETURN(x)  \
{ \
/*  int i_call_level; */\
  call_level--; \
/*  for(i_call_level=0;i_call_level<call_level;i_call_level++) */\
/*    putchar('-'); */\
/*  putchar('\n'); */\
  return (x); \
}
#define EDBUG_RETURN_  \
{ \
/*  int i_call_level; */\
  call_level--; \
/*  for(i_call_level=0;i_call_level<call_level;i_call_level++) */\
/*    putchar('-'); */\
/*  putchar('\n'); */\
  return; \
}
#else
#define EDBUG_RETURN(x)  \
{ \
  return (x); \
}
#define EDBUG_RETURN_  \
{ \
  return; \
}
#endif
