
#include "E.h"

void
Alert(char *fmt,...)
{
   char                text[10240];
   va_list             ap;

   EDBUG(7, "Alert");
   va_start(ap, fmt);
#ifdef __USE_GNU
   vsnprintf(text, 10240, fmt, ap);
#else
   vsprintf(text, fmt, ap);
#endif
   va_end(ap);
   ShowAlert(text);
   EDBUG_RETURN_;
}

void
ShowAlert(char *text)
{
   Window              win;
   Display            *dd;
   int                 wid, hih, w, h, i, j, k, mask;
   XGCValues           gcv;
   GC                  gc;
   char                line[1024];
   XEvent              ev;
   XFontStruct        *xfs;
   XCharStruct         xcs;
   Font                font;
   XSetWindowAttributes att;
   double              d;
   char                colorful;
   XColor              xcl;
   Colormap            cmap;
   int                 cols[256];
   int                 cnum, r, g, b, fh, x, y, ww, hh;

   EDBUG(8, "ShowAlert");
   if (!text)
      EDBUG_RETURN_;
   ApplySclass(FindItem("SOUND_ALERT", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   dd = XOpenDisplay(NULL);
   if (!dd)
     {
	fprintf(stderr, text);
	fflush(stderr);
	EDBUG_RETURN_;
     }
   cnum = 0;
   cmap = 0;
   colorful = 0;
   if (DefaultDepth(dd, DefaultScreen(dd)) > 4)
      colorful = 1;
   if (colorful)
     {
	cmap = DefaultColormap(disp, DefaultScreen(dd));
	r = 220;
	g = 220;
	b = 220;
	xcl.red = (r << 8) | r;
	xcl.green = (g << 8) | g;
	xcl.blue = (b << 8) | b;
	XAllocColor(dd, cmap, &xcl);
	cols[cnum++] = xcl.pixel;
	r = 160;
	g = 160;
	b = 160;
	xcl.red = (r << 8) | r;
	xcl.green = (g << 8) | g;
	xcl.blue = (b << 8) | b;
	XAllocColor(dd, cmap, &xcl);
	cols[cnum++] = xcl.pixel;
	r = 100;
	g = 100;
	b = 100;
	xcl.red = (r << 8) | r;
	xcl.green = (g << 8) | g;
	xcl.blue = (b << 8) | b;
	XAllocColor(dd, cmap, &xcl);
	cols[cnum++] = xcl.pixel;
	r = 0;
	g = 0;
	b = 0;
	xcl.red = (r << 8) | r;
	xcl.green = (g << 8) | g;
	xcl.blue = (b << 8) | b;
	XAllocColor(dd, cmap, &xcl);
	cols[cnum++] = xcl.pixel;
	r = 255;
	g = 255;
	b = 255;
	xcl.red = (r << 8) | r;
	xcl.green = (g << 8) | g;
	xcl.blue = (b << 8) | b;
	XAllocColor(dd, cmap, &xcl);
	cols[cnum++] = xcl.pixel;
	r = 255;
	g = 80;
	b = 20;
	xcl.red = (r << 8) | r;
	xcl.green = (g << 8) | g;
	xcl.blue = (b << 8) | b;
	XAllocColor(dd, cmap, &xcl);
	cols[cnum++] = xcl.pixel;
     }
   wid = DisplayWidth(dd, DefaultScreen(dd));
   hih = DisplayHeight(dd, DefaultScreen(dd));
   w = (wid - 600) / 2;
   h = (hih - 440) / 2;
   mask = CWBackPixel | CWBorderPixel | CWOverrideRedirect | CWSaveUnder | CWBackingStore;
   if (colorful)
      att.background_pixel = cols[1];
   else
      att.background_pixel = BlackPixel(dd, DefaultScreen(dd));
   if (colorful)
      att.border_pixel = cols[3];
   else
      att.border_pixel = WhitePixel(dd, DefaultScreen(dd));
   att.backing_store = Always;
   att.save_under = True;
   att.override_redirect = True;
   win = XCreateWindow(dd, DefaultRootWindow(dd), -100, -100, 1, 1, 1,
		       DefaultDepth(dd, DefaultScreen(dd)), InputOutput,
		       DefaultVisual(dd, DefaultScreen(dd)), mask, &att);
   gc = XCreateGC(dd, win, 0, &gcv);
   if (colorful)
      XSetForeground(dd, gc, cols[3]);
   else
      XSetForeground(dd, gc, att.border_pixel);
   fh = 0;
   xfs = XLoadQueryFont(dd, "-*-e-*-*-*-*-17-*-*-*-p-*-*-*");
   if (!xfs)
     {
	xfs = XLoadQueryFont(dd, "fixed");
     }
   font = xfs->fid;
   fh = xfs->ascent + xfs->descent;
   XSetFont(dd, gc, font);
   XSync(dd, False);
   i = rand() % 3;
   XMapWindow(dd, win);
   XSync(dd, False);
   XGrabServer(dd);
   if (i == 0)
     {
	for (d = 0; d < 10; d += 0.4)
	  {
	     x = (wid >> 1) + (int)(((10 - d) * (double)wid) * cos(d) / 40);
	     y = (hih >> 1) + (int)(((10 - d) * (double)wid) * sin(d) / 40);
	     ww = (int)((d) * 600 / 10);
	     hh = (int)((d) * 440 / 10);
	     x -= ww >> 1;
	     y -= hh >> 1;
	     XMoveResizeWindow(dd, win, x, y, ww, hh);
	     if (colorful)
	       {
		  XClearWindow(disp, win);
		  XSetForeground(dd, gc, cols[0]);
		  XDrawLine(dd, win, gc, 0, 0, 0, hh - 2);
		  XDrawLine(dd, win, gc, 0, 0, ww - 2, 0);
		  XSetForeground(dd, gc, cols[2]);
		  XDrawLine(dd, win, gc, 1, hh - 1, 600, hh - 1);
		  XDrawLine(dd, win, gc, ww - 1, 1, ww - 1, 440);
	       }
	     XSync(dd, False);
	  }
     }
   else if (i == 1)
     {
	ww = 600;
	hh = 440;
	XResizeWindow(dd, win, ww, hh);
	for (i = -600; i < (wid - 600) >> 1; i += 20)
	  {
	     x = i;
	     y = (hih - 440) >> 1;
	     XMoveWindow(dd, win, x, y);
	     if (colorful)
	       {
		  XClearWindow(disp, win);
		  XSetForeground(dd, gc, cols[0]);
		  XDrawLine(dd, win, gc, 0, 0, 0, hh - 2);
		  XDrawLine(dd, win, gc, 0, 0, ww - 2, 0);
		  XSetForeground(dd, gc, cols[2]);
		  XDrawLine(dd, win, gc, 1, hh - 1, 600, hh - 1);
		  XDrawLine(dd, win, gc, ww - 1, 1, ww - 1, 440);
	       }
	     XSync(dd, False);
	  }
     }
   else if (i == 2)
     {
	for (i = 0; i < 600; i += 20)
	  {
	     ww = i;
	     hh = (i * 440) / 600;
	     x = (wid - ww) >> 1;
	     y = (hih - hh) >> 1;
	     XMoveResizeWindow(dd, win, x, y, ww, hh);
	     if (colorful)
	       {
		  XClearWindow(disp, win);
		  XSetForeground(dd, gc, cols[0]);
		  XDrawLine(dd, win, gc, 0, 0, 0, hh - 2);
		  XDrawLine(dd, win, gc, 0, 0, ww - 2, 0);
		  XSetForeground(dd, gc, cols[2]);
		  XDrawLine(dd, win, gc, 1, hh - 1, 600, hh - 1);
		  XDrawLine(dd, win, gc, ww - 1, 1, ww - 1, 440);
	       }
	     XSync(dd, False);
	  }
     }
   ww = 600;
   hh = 440;
   x = (wid - 600) >> 1;
   y = (hih - 440) >> 1;
   XMoveResizeWindow(dd, win, x, y, ww, hh);
   XMapWindow(dd, win);
   if (colorful)
     {
	XClearWindow(disp, win);
	XSetForeground(dd, gc, cols[0]);
	XDrawLine(dd, win, gc, 0, 0, 0, hh - 2);
	XDrawLine(dd, win, gc, 0, 0, ww - 2, 0);
	XSetForeground(dd, gc, cols[2]);
	XDrawLine(dd, win, gc, 1, hh - 1, 600, hh - 1);
	XDrawLine(dd, win, gc, ww - 1, 1, ww - 1, 440);
     }
   XUngrabServer(dd);
   XSync(dd, False);
   i = 0;
   j = 0;
   k = 0;
   while (text[i])
     {
	line[j++] = text[i++];
	if (line[j - 1] == '\n')
	  {
	     line[j - 1] = 0;
	     j = 0;
	     if (colorful)
	       {
		  XSetForeground(dd, gc, cols[2]);
		  XDrawString(dd, win, gc, 6 + 1 + 2, 6 + k + fh + 2, line, strlen(line));
		  XDrawString(dd, win, gc, 6 + 2, 6 + k + fh + 1 + 2, line, strlen(line));
		  XDrawString(dd, win, gc, 6 - 1 + 2, 6 + k + fh + 2, line, strlen(line));
		  XDrawString(dd, win, gc, 6 + 2, 6 + k + fh - 1 + 2, line, strlen(line));
		  XSetForeground(dd, gc, cols[3]);
		  XDrawString(dd, win, gc, 6 + 1, 6 + k + fh, line, strlen(line));
		  XDrawString(dd, win, gc, 6, 6 + k + fh + 1, line, strlen(line));
		  XDrawString(dd, win, gc, 6 - 1, 6 + k + fh, line, strlen(line));
		  XDrawString(dd, win, gc, 6, 6 + k + fh - 1, line, strlen(line));
		  XSetForeground(dd, gc, cols[4]);
		  XDrawString(dd, win, gc, 6, 6 + k + fh, line, strlen(line));
	       }
	     else
		XDrawString(dd, win, gc, 6, 6 + k + fh, line, strlen(line));
	     k += fh;
	  }
     }
   XQueryTextExtents(dd, font, "LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62,
		     &w, &i, &j, &xcs);
   h = XTextWidth(xfs, "LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
   w = (600 - h) / 2;
   if (colorful)
     {
	XSetForeground(dd, gc, cols[2]);
	XDrawString(dd, win, gc, w + 1 + 2, 433 - j + 2,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XDrawString(dd, win, gc, w + 2, 433 - j + 1 + 2,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XDrawString(dd, win, gc, w - 1 + 2, 433 - j + 2,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XDrawString(dd, win, gc, w + 2, 433 - j - 1 + 2,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XSetForeground(dd, gc, cols[3]);
	XDrawString(dd, win, gc, w + 1, 433 - j,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XDrawString(dd, win, gc, w, 433 - j + 1,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XDrawString(dd, win, gc, w - 1, 433 - j,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XDrawString(dd, win, gc, w, 433 - j - 1,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XSetForeground(dd, gc, cols[5]);
	XDrawString(dd, win, gc, w, 433 - j,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
	XSetForeground(dd, gc, cols[3]);
	XDrawLine(dd, win, gc, w - 4, 433 - j - i - 4, w + h + 4, 433 - j - i - 4);
	XDrawLine(dd, win, gc, w - 4, 433 - j - i - 4, w - 4, 433 + 4);
	XDrawLine(dd, win, gc, w + h + 4, 433 - j - i - 4, w + h + 4, 433 + 4);
	XDrawLine(dd, win, gc, w - 4, 433 + 4, w + h + 4, 433 + 4);
	XSetForeground(dd, gc, cols[0]);
	XDrawLine(dd, win, gc, w - 3, 433 - j - i - 3, w + h + 3, 433 - j - i - 3);
	XDrawLine(dd, win, gc, w - 3, 433 - j - i - 3, w - 3, 433 + 3);
	XSetForeground(dd, gc, cols[2]);
	XDrawLine(dd, win, gc, w + h + 3, 433 - j - i - 3, w + h + 3, 433 + 3);
	XDrawLine(dd, win, gc, w - 3, 433 + 3, w + h + 3, 433 + 3);
     }
   else
      XDrawString(dd, win, gc, w, 433 - j,
	"LeftButton: OK     MiddleButton: Restart     RightButton: Quit", 62);
   XSync(dd, False);
   XSelectInput(dd, win, ButtonPressMask);
   XGrabPointer(dd, win, True, ButtonPressMask | ButtonReleaseMask, GrabModeAsync,
		GrabModeAsync, None, None, CurrentTime);
   XWindowEvent(dd, win, ButtonPressMask, &ev);
   XUngrabPointer(dd, CurrentTime);
   UnGrabTheButtons(win);
   XDestroyWindow(dd, win);
   AlertHandleClick(ev.xbutton.button);
   XFreeGC(dd, gc);
   XFreeFont(dd, xfs);
   XUnloadFont(dd, font);
   if (cnum > 0)
      XFreeColors(dd, cmap, (unsigned long *)cols, cnum, 0);
   XCloseDisplay(dd);
   EDBUG_RETURN_;
}

void
AlertHandleClick(int button)
{
   EDBUG(9, "AlertHandleClick");
   switch (button)
     {
     case 1:
	break;
     case 2:
	doExit("restart");
	break;
     case 3:
	EExit(1);
	break;
     default:
	break;
     }
   EDBUG_RETURN_;
}

void
ErrAlert(int erno)
{
   EDBUG(7, "ErrAlert");
   switch (erno)
     {
     case EERR_OUT_OF_MEMORY:
	Alert("***  OUT OF MEMORY  ***\n\n"
	      "The system has run out of memory whilst allocating space to\n"
	      "work in. Enlightenemnt can at times briefly allocate large\n"
	      "chunks of RAM as scratch space.\n"
	      "This could be a bad thing. Please make sure that virtual\n"
	      "memory is enabled, and that there is a sufficient amount of\n"
	      "Swap Space (virtual memory). A good rule of thumb is to\n"
	      "double the REAL RAM on the system and have that amount of\n"
	      "Swap Space. A suggested minimum TOTAL of RAM and Swap to\n"
	      "ensure that this does not happen would be 80Mb.\n\n"
	      "You may also wish to run top or ps (ps -auwx or ps -ef) to\n"
	      "ensure that no runaway process is eating up most of your\n"
	      "system's memeory. If this is the case you should kill it.\n\n"
	   "For more assistance please contact your system administrator.\n");
	EExit(1);
	break;
     case 999:
	break;
     default:
	break;
     }
   EDBUG_RETURN_;
}
