#include "E.h"

EWin               *
GetEwinPointerInClient()
{
   EWin               *ewin;
   Window              rt, ch;
   int                 dum;
   int                 d;

   EDBUG(5, "GetEwinPointerInClient");
   d = DekstopAt(mode.x, mode.y) & 0x31;
   XQueryPointer(disp, desks.desk[d].win, &rt, &ch, &dum, &dum, &dum,
		 &dum, (unsigned int *)&dum);
   ewin = FindEwinByBase(ch);
   if (ewin)
     {
	XQueryPointer(disp, ch, &rt, &ch, &dum, &dum, &dum,
		      &dum, (unsigned int *)&dum);
	ewin = FindEwinByChildren(ch);
	if ((ewin) && (ewin->client.win == ch))
	   EDBUG_RETURN(ewin);
     }
   EDBUG_RETURN(NULL);
}

EWin               *
GetEwin()
{
   EDBUG(4, "GetEwin");
   EDBUG_RETURN(mode.ewin);
}

void
SlideEwinTo(EWin * ewin, int fx, int fy, int tx, int ty, int speed)
{
   int                 k, spd, x, y, min;
   struct timeval      timev1, timev2;
   int                 dsec, dusec;
   double              tm;
   char                firstlast;
   Window              winid;

   EDBUG(3, "SlideEwinTo");
   winid = ewin->client.win;
   spd = 16;
   min = 2;
   firstlast = 0;
   mode.doingslide = 1;
   ApplySclass(FindItem("SOUND_WINDOW_SLIDE", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   for (k = 0; k < 1024; k += spd)
     {
	gettimeofday(&timev1, NULL);
	x = ((fx * (1023 - k)) + (tx * k)) >> 10;
	y = ((fy * (1023 - k)) + (ty * k)) >> 10;
	DrawEwinShape(ewin, mode.slidemode, x, y, ewin->client.w, ewin->client.h, firstlast);
	if (firstlast == 0)
	   firstlast = 1;
	CheckEvent();
	if (!FindItem(NULL, winid, LIST_FINDBY_ID, LIST_TYPE_EWIN))
	  {
	     mode.doingslide = 0;
	     ApplySclass(FindItem("SOUND_WINDOW_SLIDE_END", 0,
				  LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
	     EDBUG_RETURN_;
	  }
	XSync(disp, False);
	gettimeofday(&timev2, NULL);
	dsec = timev2.tv_sec - timev1.tv_sec;
	dusec = timev2.tv_usec - timev1.tv_usec;
	if (dusec < 0)
	  {
	     dsec--;
	     dusec += 1000000;
	  }
	tm = (double)dsec + (((double)dusec) / 1000000);
	spd = (int)((double)speed * tm);
	if (spd < min)
	   spd = min;
     }
   DrawEwinShape(ewin, mode.slidemode, x, y, ewin->client.w, ewin->client.h, 2);
   MoveEwin(ewin, tx, ty);
   mode.doingslide = 0;
   ApplySclass(FindItem("SOUND_WINDOW_SLIDE_END", 0,
			LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
   EDBUG_RETURN_;
}

void
AddToFamily(Window win)
{
   EWin               *ewin;
   void              **lst;
   Button            **blst;
   int                 i, j, k, num, speed, fx, fy, x, y;
   char                doslide;
   RectBox            *fixed, *ret, newrect;
   Window              winid;

   EDBUG(3, "AddToFamily");
   ewin = FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
      EDBUG_RETURN_;
   GrabX();
   winid = win;
   speed = mode.slidespeedmap;
   doslide = mode.mapslide;
   ewin = Adopt(win);
   if ((!ewin->client.mwm_decor_title) && (!ewin->client.mwm_decor_border))
      doslide = 0;
   if (ewin->client.start_iconified)
     {
	ewin->iconified = 1;
     }
   x = 0;
   y = 0;
   if (!WinExists(ewin->client.win))
     {
	FreeEwin(ewin);
	UngrabX();
	EDBUG_RETURN_;
     }
   ResizeEwin(ewin, ewin->client.w, ewin->client.h);
   if (ewin->desktop < 0)
      ewin->desktop = desks.current;
   else
      ewin->desktop = ewin->desktop & 0x1f;
   if (!ewin->client.already_placed)
     {
	ewin->client.already_placed = 1;
	lst = ListItemType(&num, LIST_TYPE_EWIN);
	if ((lst) && (num > 0))
	  {
	     fixed = Emalloc(sizeof(RectBox) * num);
	     ret = Emalloc(sizeof(RectBox) * (num + 1));
	     j = 0;
	     for (i = 0; i < num; i++)
	       {
		  if ((lst[i] != ewin) &&
		      (((EWin *) lst[i])->desktop == ewin->desktop))
		    {
		       fixed[j].data = lst[i];
		       fixed[j].x = ((EWin *) lst[i])->x;
		       fixed[j].y = ((EWin *) lst[i])->y;
		       fixed[j].w = ((EWin *) lst[i])->w;
		       fixed[j++].h = ((EWin *) lst[i])->h;
		    }
	       }
	     blst = (Button **) ListItemType(&num, LIST_TYPE_BUTTON);
	     if (blst)
	       {
		  fixed = Erealloc(fixed, sizeof(RectBox) * (num + j));
		  ret = Erealloc(ret, sizeof(RectBox) * ((num + j) + 1));
		  for (i = 0; i < num; i++)
		    {
		       if (((blst[i]->desktop == ewin->desktop) ||
			    ((blst[i]->desktop == 0) && (blst[i]->sticky))) &&
			   (blst[i]->visible))
			 {
			    fixed[j].data = NULL;
			    fixed[j].x = blst[i]->x;
			    fixed[j].y = blst[i]->y;
			    fixed[j].w = blst[i]->w;
			    fixed[j++].h = blst[i]->h;
			 }
		    }
		  Efree(blst);
	       }
	     newrect.data = ewin;
	     newrect.x = 0;
	     newrect.y = 0;
	     newrect.w = ewin->w;
	     newrect.h = ewin->h;
	     ArrangeRects(fixed, j, &newrect, 1, ret, root.w, root.h, ARRANGE_BY_SIZE);
	     for (i = 0; i < j + 1; i++)
	       {
		  if (ret[i].data == ewin)
		    {
		       x = ret[i].x;
		       y = ret[i].y;
		       i = j + 1;
		    }
	       }
	     Efree(lst);
	     Efree(ret);
	     Efree(fixed);
	  }
	else
	  {
	     x = (root.w - ewin->w) >> 1;
	     y = (root.h - ewin->h) >> 1;
	  }
     }
   else
     {
	x = ewin->client.x;
	y = ewin->client.y;
     }
   if (!WinExists(ewin->client.win))
     {
	DesktopRemoveEwin(ewin);
	FreeEwin(ewin);
	UngrabX();
	EDBUG_RETURN_;
     }
   AddItem(ewin, "EWIN", ewin->client.win, LIST_TYPE_EWIN);
   DesktopRemoveEwin(ewin);
   if ((doslide) && (!mode.doingslide))
     {
	MoveEwin(ewin, root.w, root.h);
	k = rand() % 4;
	if (k == 0)
	  {
	     fx = (rand() % (root.w)) - ewin->w;
	     fy = -ewin->h;
	  }
	else if (k == 1)
	  {
	     fx = (rand() % (root.w));
	     fy = root.h;
	  }
	else if (k == 2)
	  {
	     fx = -ewin->w;
	     fy = (rand() % (root.h));
	  }
	else
	  {
	     fx = root.w;
	     fy = (rand() % (root.h)) - ewin->h;
	  }
	if (!WinExists(ewin->client.win))
	  {
	     FreeEwin(ewin);
	     UngrabX();
	     EDBUG_RETURN_;
	  }
	MoveEwinToDesktop(ewin, ewin->desktop);
	RaiseEwin(ewin);
	MoveEwin(ewin, fx, fy);
	ShowEwin(ewin);
	SlideEwinTo(ewin, fx, fy, x, y, speed);
	MoveEwinToDesktopAt(ewin, ewin->desktop, x, y);
     }
   else
     {
	if (!WinExists(ewin->client.win))
	  {
	     FreeEwin(ewin);
	     UngrabX();
	     EDBUG_RETURN_;
	  }
	DesktopRemoveEwin(ewin);
	MoveEwinToDesktopAt(ewin, ewin->desktop, x, y);
     }
   DesktopRemoveEwin(ewin);
   RaiseEwin(ewin);
   if (!WinExists(ewin->client.win))
     {
	FreeEwin((EWin *) RemoveItem(NULL, winid, LIST_FINDBY_ID,
				     LIST_TYPE_EWIN));
	UngrabX();
	EDBUG_RETURN_;
     }
   ICCCM_Configure(ewin);
   UngrabX();
   EDBUG_RETURN_;
}

void
HonorIclass(char *s, int id)
{
   AwaitIclass        *a;
   EWin               *ewin;

   EDBUG(4, "HonorIclass");
   a = RemoveItem(s, 0, LIST_FINDBY_NAME, LIST_TYPE_AWAIT_ICLASS);
   if (!a)
      EDBUG_RETURN_;
   ewin = FindItem(NULL, a->client_win, LIST_FINDBY_ID, LIST_TYPE_EWIN);
   if (ewin)
     {
	if (a->ewin_bit < ewin->border->num_winparts)
	  {
	     if ((ewin->border->part[a->ewin_bit].iclass->external) &&
		 (!ewin->bits[a->ewin_bit].win) && (id))
	       {
		  ewin->bits[a->ewin_bit].win = id;
		  RealiseEwinWinpart(ewin, a->ewin_bit);
		  XMapWindow(disp, id);
		  ewin->shapedone = 0;
		  if (!ewin->shapedone)
		     PropagateShapes(ewin->win);
		  else
		    {
		       if (ewin->border->changes_shape)
			  PropagateShapes(ewin->win);
		    }
		  ewin->shapedone = 1;
	       }
	  }
     }
   Efree(a);
   EDBUG_RETURN_;
}

void
SyncBorderToEwin(EWin * ewin)
{
   Border             *b;
   char                title[10240];
   int                 i;

   EDBUG(4, "SyncBorderToEwin");
   b = ewin->border;
   strncpy(title, ewin->client.title, 10240);
   ICCCM_GetTitle(ewin);
   ICCCM_GetInfo(ewin);
   ICCCM_GetHints(ewin);
   ICCCM_GetShapeInfo(ewin);
   ICCCM_GetGeoms(ewin);
   SetEwinBorder(ewin);
   if (b != ewin->border)
     {
	ICCCM_MatchSize(ewin);
	MoveResizeEwin(ewin, ewin->client.x, ewin->client.y, ewin->client.w,
		       ewin->client.h);
     }
   else if (strcmp(title, ewin->client.title))
     {
	for (i = 0; i < ewin->border->num_winparts; i++)
	  {
	     if (ewin->border->part[i].flags == FLAG_TITLE)
		ChangeEwinWinpartContents(ewin, i);
	  }
     }
   EDBUG_RETURN_;
}

void
RealiseEwinWinpart(EWin * ewin, int i)
{
#if 0
   int                 move = 0, resize = 0;

#endif

   EDBUG(4, "RealiseEwinWinpart");
#if 0
   if ((ewin->bits[i].x != ewin->bits[i].cx) ||
       (ewin->bits[i].y != ewin->bits[i].cy))
      move = 1;
   if ((ewin->bits[i].w != ewin->bits[i].cw) ||
       (ewin->bits[i].h != ewin->bits[i].ch))
      resize = 1;
   if ((move) && (resize))
#endif
      XMoveResizeWindow(disp, ewin->bits[i].win,
			ewin->bits[i].x, ewin->bits[i].y,
			ewin->bits[i].w, ewin->bits[i].h);
#if 0
   else if (move)
      XMoveWindow(disp, ewin->bits[i].win, ewin->bits[i].x, ewin->bits[i].y);
   else if (resize)
      XResizeWindow(disp, ewin->bits[i].win, ewin->bits[i].w, ewin->bits[i].h);
#endif
   EDBUG_RETURN_;
}

int
DrawEwinWinpart(EWin * ewin, int i)
{
   int                 move = 0, resize = 0, active = 0, state = 0, ret = 0;

   EDBUG(4, "DrawEwinWinpart");
   active = ewin->state;
   if ((ewin->bits[i].x != ewin->bits[i].cx) ||
       (ewin->bits[i].y != ewin->bits[i].cy))
      move = 1;
   if ((ewin->bits[i].w != ewin->bits[i].cw) ||
       (ewin->bits[i].h != ewin->bits[i].ch))
      resize = 1;
   if ((resize) || (ewin->bits[i].expose))
     {
	state = ewin->bits[i].state;
	IclassApply(ewin->border->part[i].iclass, ewin->bits[i].win,
		    ewin->bits[i].w, ewin->bits[i].h, ewin->state, state,
		    ewin->bits[i].expose);
	if (ewin->border->part[i].flags == FLAG_TITLE)
	   TclassApply(ewin->border->part[i].iclass, ewin->bits[i].win,
		       ewin->bits[i].w, ewin->bits[i].h, active, ewin->state,
		       ewin->bits[i].expose, ewin->border->part[i].tclass,
		       ewin->client.title);
	ret = 1;
     }
   if ((move) || (resize))
     {
	ret = 1;
	ewin->bits[i].cx = ewin->bits[i].x;
	ewin->bits[i].cy = ewin->bits[i].y;
	ewin->bits[i].cw = ewin->bits[i].w;
	ewin->bits[i].ch = ewin->bits[i].h;
     }
   ewin->bits[i].expose = 0;
   EDBUG_RETURN(ret);
}

int
ChangeEwinWinpart(EWin * ewin, int i)
{
   int                 active = 0, state = 0, ret = 0;

   EDBUG(3, "ChangeEwinWinpart");
   active = ewin->state;
   state = ewin->bits[i].state;
   IclassApply(ewin->border->part[i].iclass, ewin->bits[i].win,
	       ewin->bits[i].w, ewin->bits[i].h, ewin->state, state,
	       ewin->bits[i].expose);
   if (ewin->border->part[i].flags == FLAG_TITLE)
      TclassApply(ewin->border->part[i].iclass, ewin->bits[i].win,
		  ewin->bits[i].w, ewin->bits[i].h, active, state,
		  ewin->bits[i].expose, ewin->border->part[i].tclass,
		  ewin->client.title);
   if (ewin->bits[i].win)
      ChangeEwinWinpartContents(ewin, i);
   if (!ewin->shapedone)
      PropagateShapes(ewin->win);
   else
     {
	if (ewin->border->changes_shape)
	   PropagateShapes(ewin->win);
     }
   ewin->shapedone = 1;
   ret = 1;
   EDBUG_RETURN(ret);
}

void
DrawEwin(EWin * ewin)
{
   int                 i, active, state;

   EDBUG(4, "DrawEwin");
   active = ewin->state;
   for (i = 0; i < ewin->border->num_winparts; i++)
     {
	state = ewin->bits[i].state;
	IclassApply(ewin->border->part[i].iclass, ewin->bits[i].win,
		    ewin->bits[i].w, ewin->bits[i].h, ewin->state, state,
		    ewin->bits[i].expose);
	if (ewin->border->part[i].flags == FLAG_TITLE)
	   TclassApply(ewin->border->part[i].iclass, ewin->bits[i].win,
		       ewin->bits[i].w, ewin->bits[i].h, active, state,
		       ewin->bits[i].expose, ewin->border->part[i].tclass,
		       ewin->client.title);
     }
   if (!ewin->shapedone)
      PropagateShapes(ewin->win);
   else
     {
	if (ewin->border->changes_shape)
	   PropagateShapes(ewin->win);
     }
   ewin->shapedone = 1;
   EDBUG_RETURN_;
}

int
ChangeEwinWinpartContents(EWin * ewin, int i)
{
   int                 active = 0, state = 0, ret = 0;

   EDBUG(3, "ChangeEwinWinpartContents");
   ret = 1;
   switch (ewin->border->part[i].flags)
     {
     case FLAG_TITLE:
	TclassApply(ewin->border->part[i].iclass, ewin->bits[i].win,
		    ewin->bits[i].w, ewin->bits[i].h, active, state,
		    ewin->bits[i].expose, ewin->border->part[i].tclass,
		    ewin->client.title);
	break;
     case FLAG_MINIICON:
	break;
     default:
	break;
     }
   EDBUG_RETURN(ret);
}

void
CalcEwinWinpart(EWin * ewin, int i)
{
   int                 x, y, w, h, ox, oy, max, min;
   int                 topleft, bottomright;

   EDBUG(4, "CalcEwinWinpart");
   topleft = ewin->border->part[i].geom.topleft.originbox;
   bottomright = ewin->border->part[i].geom.bottomright.originbox;
   if (topleft >= 0)
      CalcEwinWinpart(ewin, topleft);
   if (bottomright >= 0)
      CalcEwinWinpart(ewin, bottomright);
   x = y = 0;
   if (topleft == -1)
     {
	x = ((ewin->border->part[i].geom.topleft.x.percent * ewin->w) >> 10) +
	   ewin->border->part[i].geom.topleft.x.absolute;
	y = ((ewin->border->part[i].geom.topleft.y.percent * ewin->h) >> 10) +
	   ewin->border->part[i].geom.topleft.y.absolute;
     }
   else if (topleft >= 0)
     {
	x = ((ewin->border->part[i].geom.topleft.x.percent *
	      ewin->bits[topleft].w) >> 10) +
	   ewin->border->part[i].geom.topleft.x.absolute +
	   ewin->bits[topleft].x;
	y = ((ewin->border->part[i].geom.topleft.y.percent *
	      ewin->bits[topleft].h) >> 10) +
	   ewin->border->part[i].geom.topleft.y.absolute +
	   ewin->bits[topleft].y;
     }
   ox = oy = 0;
   if (bottomright == -1)
     {
	ox = ((ewin->border->part[i].geom.bottomright.x.percent * ewin->w) >> 10) +
	   ewin->border->part[i].geom.bottomright.x.absolute;
	oy = ((ewin->border->part[i].geom.bottomright.y.percent * ewin->h) >> 10) +
	   ewin->border->part[i].geom.bottomright.y.absolute;
     }
   else if (bottomright >= 0)
     {
	ox = ((ewin->border->part[i].geom.bottomright.x.percent *
	       ewin->bits[bottomright].w) >> 10) +
	   ewin->border->part[i].geom.bottomright.x.absolute +
	   ewin->bits[bottomright].x;
	oy = ((ewin->border->part[i].geom.bottomright.y.percent *
	       ewin->bits[bottomright].h) >> 10) +
	   ewin->border->part[i].geom.bottomright.y.absolute +
	   ewin->bits[bottomright].y;
     }
   w = (ox - x) + 1;
   max = ewin->border->part[i].geom.width.max;
   min = ewin->border->part[i].geom.width.min;
   if (w > max)
     {
	w = max;
	x = ((x + ox) - w) >> 1;
     }
   else if (w < min)
     {
	w = min;
     }
   h = (oy - y) + 1;
   max = ewin->border->part[i].geom.height.max;
   min = ewin->border->part[i].geom.height.min;
   if (h > max)
     {
	h = max;
	y = ((y + oy) - h) >> 1;
     }
   else if (h < min)
     {
	h = min;
     }
   ewin->bits[i].x = x;
   ewin->bits[i].y = y;
   ewin->bits[i].w = w;
   ewin->bits[i].h = h;
   EDBUG_RETURN_;
}

void
CalcEwinSizes(EWin * ewin)
{
   int                 i;
   char                reshape;

   EDBUG(4, "CalcEwinSizes");
   if (!ewin)
      EDBUG_RETURN_;
   for (i = 0; i < ewin->border->num_winparts; i++)
      CalcEwinWinpart(ewin, i);
   for (i = 0; i < ewin->border->num_winparts; i++)
      RealiseEwinWinpart(ewin, i);
   XSync(disp, False);
   reshape = 0;
   for (i = 0; i < ewin->border->num_winparts; i++)
      reshape |= DrawEwinWinpart(ewin, i);
   if (reshape)
     {
	PropagateShapes(ewin->win);
	ewin->shapedone = 1;
     }
   XSync(disp, False);
   EDBUG_RETURN_;
}

EWin               *
Adopt(Window win)
{
   EWin               *ewin;

   EDBUG(4, "Adopt");
   GrabX();
   ewin = CreateEwin();
   ewin->client.win = win;
   ICCCM_GetTitle(ewin);
   ICCCM_GetInfo(ewin);
   ICCCM_GetHints(ewin);
   ICCCM_GetColormap(ewin);
   ICCCM_GetShapeInfo(ewin);
   ICCCM_GetGeoms(ewin);
   SetEwinBorder(ewin);
   ICCCM_MatchSize(ewin);
   ICCCM_Adopt(ewin, win);
   UngrabX();
   EDBUG_RETURN(ewin);
}

EWin               *
CreateEwin()
{
   EWin               *ewin;

   EDBUG(5, "CreateEwin");
   ewin = Emalloc(sizeof(EWin));
   ewin->win = 0;
   ewin->x = -1;
   ewin->y = -1;
   ewin->w = -1;
   ewin->h = -1;
   ewin->client.win = 0;
   ewin->client.x = -1;
   ewin->client.y = -1;
   ewin->client.w = -1;
   ewin->client.h = -1;
   ewin->client.title = NULL;
   ewin->client.class = NULL;
   ewin->client.name = NULL;
   ewin->client.command = NULL;
   ewin->client.machine = NULL;
   ewin->client.icon_name = NULL;
   ewin->client.is_group_leader = 0;
   ewin->client.no_resize_h = 0;
   ewin->client.no_resize_v = 0;
   ewin->client.shaped = 0;
   ewin->client.icon_win = 0;
   ewin->client.icon_pmap = 0;
   ewin->client.icon_mask = 0;
   ewin->client.start_iconified = 0;
   ewin->client.group = 0;
   ewin->client.need_input = 0;
   ewin->client.transient = 0;
   ewin->client.already_placed = 0;
   ewin->client.aspect_min = 0.0;
   ewin->client.aspect_max = 65535.0;
   ewin->client.w_inc = 1;
   ewin->client.h_inc = 1;
   ewin->client.base_w = 0;
   ewin->client.base_h = 0;
   ewin->client.width.min = 0;
   ewin->client.height.min = 0;
   ewin->client.width.max = 65535;
   ewin->client.height.max = 65535;
   ewin->client.mwm_decor_border = 1;
   ewin->client.mwm_decor_resizeh = 1;
   ewin->client.mwm_decor_title = 1;
   ewin->client.mwm_decor_menu = 1;
   ewin->client.mwm_decor_minimize = 1;
   ewin->client.mwm_decor_maximize = 1;
   ewin->client.mwm_func_resize = 1;
   ewin->client.mwm_func_move = 1;
   ewin->client.mwm_func_minimize = 1;
   ewin->client.mwm_func_maximize = 1;
   ewin->client.mwm_func_close = 1;
   ewin->border = NULL;
   ewin->bits = NULL;
   ewin->state = 0;
   ewin->sticky = 0;
   ewin->desktop = -1;
   ewin->group = 0;
   ewin->visible = 0;
   ewin->active = 0;
   ewin->iconified = 0;
   ewin->parent = 0;
   ewin->ontop = 0;
   ewin->onbottom = 0;
   ewin->never_use_area = 0;
   ewin->floating = 0;
   ewin->win = ECreateWindow(root.win, -10, -10, 1, 1, 1);
   ewin->shapedone = 0;
   XSelectInput(disp, ewin->win, FocusChangeMask | SubstructureNotifyMask |
		SubstructureRedirectMask | EnterWindowMask | LeaveWindowMask |
		PointerMotionMask | PropertyChangeMask | FocusChangeMask);
   EDBUG_RETURN(ewin);
}

void
FreeEwin(EWin * ewin)
{
   EDBUG(5, "FreeEwin");
   if (!ewin)
      EDBUG_RETURN_;
   DesktopRemoveEwin(ewin);
   if (ewin->client.title)
      Efree(ewin->client.title);
   if (ewin->client.class)
      Efree(ewin->client.class);
   if (ewin->client.name)
      Efree(ewin->client.name);
   if (ewin->client.command)
      Efree(ewin->client.command);
   if (ewin->client.machine)
      Efree(ewin->client.machine);
   if (ewin->client.icon_name)
      Efree(ewin->client.icon_name);
   if (ewin->win)
      XDestroyWindow(disp, ewin->win);
   if (ewin->bits)
      Efree(ewin->bits);
   Efree(ewin);
   EDBUG_RETURN_;
}

BorderMatch        *
CreateBorderMatch(char *name, char *border)
{
   BorderMatch        *b;

   EDBUG(5, "CreateBorderMatch");
   b = Emalloc(sizeof(BorderMatch));
   if (!b)
      EDBUG_RETURN(NULL);
   b->name = duplicate(name);
   b->win_title = NULL;
   b->win_name = NULL;
   b->win_class = NULL;
   b->width.min = 0;
   b->width.max = 99999;
   b->height.min = 0;
   b->height.max = 99999;
   b->transient = -1;
   b->no_resize_h = -1;
   b->no_resize_v = -1;
   b->shaped = -1;
   b->border = duplicate(border);
   EDBUG_RETURN(b);
}

int
MatchEwinBorder(EWin * ewin, BorderMatch * b)
{
   EDBUG(4, "MatchEwinBorder");
   if ((b->win_title) && (!matchregexp(b->win_title, ewin->client.title)))
      EDBUG_RETURN(0);
   if ((b->win_name) && (!matchregexp(b->win_name, ewin->client.name)))
      EDBUG_RETURN(0);
   if ((b->win_class) && (!matchregexp(b->win_class, ewin->client.class)))
      EDBUG_RETURN(0);
   if ((ewin->client.w > b->width.max) || (ewin->client.w < b->width.min))
      EDBUG_RETURN(0);
   if ((ewin->client.h > b->height.max) || (ewin->client.h < b->height.min))
      EDBUG_RETURN(0);
   if ((b->transient >= 0) && (b->transient != ewin->client.transient))
      EDBUG_RETURN(0);
   if ((b->no_resize_h >= 0) && (b->no_resize_h != ewin->client.no_resize_h))
      EDBUG_RETURN(0);
   if ((b->no_resize_v >= 0) && (b->no_resize_v != ewin->client.no_resize_v))
      EDBUG_RETURN(0);
   if ((b->shaped >= 0) && (b->shaped != ewin->client.shaped))
      EDBUG_RETURN(0);
   EDBUG_RETURN(1);
}

void
SetEwinBorder(EWin * ewin)
{
   int                 i, num;
   Border             *b;
   char                s[1024];
   AwaitIclass        *await;
   BorderMatch       **lst;

   EDBUG(4, "SetEwinBorder");
   b = NULL;
   ICCCM_GetShapeInfo(ewin);
   if ((!ewin->client.mwm_decor_title) && (!ewin->client.mwm_decor_border))
      b = (Border *) FindItem("BORDERLESS", 0, LIST_FINDBY_NAME, LIST_TYPE_BORDER);
   else
     {
	lst = (BorderMatch **) ListItemType(&num, LIST_TYPE_BORDERMATCH);
	if (lst)
	  {
	     for (i = 0; i < num; i++)
	       {
		  if (MatchEwinBorder(ewin, lst[i]))
		    {
		       b = (Border *) FindItem(lst[i]->border, 0,
					       LIST_FINDBY_NAME,
					       LIST_TYPE_BORDER);
		       i = num;
		    }
	       }
	     Efree(lst);
	  }
     }
   if (!b)
      b = (Border *) FindItem("DEFAULT", 0, LIST_FINDBY_NAME, LIST_TYPE_BORDER);
   if (!b)
      b = FindItem("__FALLBACK_BORDER", 0, LIST_FINDBY_NAME, LIST_TYPE_BORDER);
   if (!b)
      EDBUG_RETURN_;
   if (ewin->border == b)
      EDBUG_RETURN_;
/* WARNING!!!!!!!!!! i have diabled on-the-fly border changing cause it */
/* seems netscape does soem Nasty-stuff with its transients */
   if (ewin->border)
      EDBUG_RETURN_;
   if (ewin->border)
     {
	for (i = 0; i < ewin->border->num_winparts; i++)
	  {
	     if (ewin->bits[i].win)
		XDestroyWindow(disp, ewin->bits[i].win);
	  }
	if (ewin->bits)
	   Efree(ewin->bits);
     }
   ewin->border = b;
   if (b->num_winparts > 0)
      ewin->bits = Emalloc(sizeof(EWinBit) * b->num_winparts);
   else
      ewin->bits = NULL;
   for (i = 0; i < b->num_winparts; i++)
     {
	if (b->part[i].iclass->external)
	  {
	     ewin->bits[i].win = 0;
	     Esnprintf(s, sizeof(s), "request imageclass %s",
		       b->part[i].iclass->name);
	     CommsBroadcast(s);
	     await = Emalloc(sizeof(AwaitIclass));
	     await->client_win = ewin->client.win;
	     await->ewin_bit = i;
	     await->iclass = b->part[i].iclass;
	     AddItem(await, b->part[i].iclass->name, 0, LIST_TYPE_AWAIT_ICLASS);
	  }
	else
	  {
	     ewin->bits[i].win = ECreateWindow(ewin->win, -10, -10, 1, 1, 0);
	     XMapWindow(disp, ewin->bits[i].win);
	     /*
	      * KeyPressMask KeyReleaseMask ButtonPressMask ButtonReleaseMask
	      * EnterWindowMask LeaveWindowMask PointerMotionMask 
	      * PointerMotionHintMask Button1MotionMask Button2MotionMask
	      * Button3MotionMask Button4MotionMask Button5MotionMask
	      * ButtonMotionMask KeymapStateMask ExposureMask 
	      * VisibilityChangeMask StructureNotifyMask ResizeRedirectMask 
	      * SubstructureNotifyMask SubstructureRedirectMask 
	      * FocusChangeMask PropertyChangeMas ColormapChangeMask 
	      * OwnerGrabButtonMask
	      */
	     XSelectInput(disp, ewin->bits[i].win,
			  ExposureMask | KeyPressMask | KeyReleaseMask |
			  ButtonPressMask | ButtonReleaseMask |
		       EnterWindowMask | LeaveWindowMask | PointerMotionMask);
	     ewin->bits[i].x = -10;
	     ewin->bits[i].y = -10;
	     ewin->bits[i].w = -10;
	     ewin->bits[i].h = -10;
	     ewin->bits[i].cx = -99;
	     ewin->bits[i].cy = -99;
	     ewin->bits[i].cw = -99;
	     ewin->bits[i].ch = -99;
	     ewin->bits[i].state = 0;
	     ewin->bits[i].expose = 0;
	  }
     }
   XMoveWindow(disp, ewin->client.win, b->border.left, b->border.top);
   CalcEwinSizes(ewin);
   EDBUG_RETURN_;
}

void
ResizeEwin(EWin * ewin, int w, int h)
{
   int                 resize;

   EDBUG(3, "ResizeEwin");
   resize = 0;
   if ((w != ewin->client.w) || (h != ewin->client.h))
      resize = 1;
   ewin->client.w = w;
   ewin->client.h = h;
   ICCCM_MatchSize(ewin);
   ewin->w = ewin->client.w + ewin->border->border.left + ewin->border->border.right;
   ewin->h = ewin->client.h + ewin->border->border.top + ewin->border->border.bottom;
   ICCCM_Configure(ewin);
   XResizeWindow(disp, ewin->win, ewin->w, ewin->h);
   CalcEwinSizes(ewin);
   EDBUG_RETURN_;
}

void
MoveEwin(EWin * ewin, int x, int y)
{
   int                 move;	/* , resize; */

   EDBUG(3, "MoveEwin");
   move = 0;
   if ((x != ewin->y) || (y != ewin->y))
      move = 1;
   ewin->x = x;
   ewin->y = y;
   XMoveWindow(disp, ewin->win, ewin->x, ewin->y);
   EDBUG_RETURN_;
}

void
MoveResizeEwin(EWin * ewin, int x, int y, int w, int h)
{
   int                 move, resize;

   EDBUG(3, "MoveResizeEwin");
   move = 0;
   resize = 0;
   if ((x != ewin->y) || (y != ewin->y))
      move = 1;
   if ((w != ewin->client.w) || (h != ewin->client.h))
      resize = 1;
   ewin->x = x;
   ewin->y = y;
   ewin->client.w = w;
   ewin->client.h = h;
   ICCCM_MatchSize(ewin);
   ewin->w = ewin->client.w + ewin->border->border.left + ewin->border->border.right;
   ewin->h = ewin->client.h + ewin->border->border.top + ewin->border->border.bottom;
   ICCCM_Configure(ewin);
   XMoveResizeWindow(disp, ewin->win, ewin->x, ewin->y, ewin->w, ewin->h);
   CalcEwinSizes(ewin);
   EDBUG_RETURN_;
}

void
FloatEwin(EWin * ewin)
{
   EDBUG(3, "FloatEwin");
   ewin->floating = 1;
   DesktopRemoveEwin(ewin);
   ewin->desktop = 0;
   ConformEwinToDesktop(ewin);
   RaiseEwin(ewin);
   EDBUG_RETURN_;
}

void
FloatEwinAt(EWin * ewin, int x, int y)
{
   EDBUG(3, "FloatEwinAt");
   ewin->floating = 1;
   if (ewin->sticky)
     {
	ewin->sticky = 0;
	ewin->state &= ~EWIN_STICKY;
	DesktopRemoveEwin(ewin);
	ewin->sticky = 1;
	ewin->state |= EWIN_STICKY;
     }
   else
      DesktopRemoveEwin(ewin);
   ewin->desktop = 0;
   ewin->x = x;
   ewin->y = y;
   ConformEwinToDesktop(ewin);
   RaiseEwin(ewin);
   EDBUG_RETURN_;
}

void
RestackEwin(EWin * ewin)
{
   Window             *wl;
   EWin              **lst;
   int                 num, bnum, wnum;
   int                 i, j, tot;
   Button            **blst;

   EDBUG(3, "RestackEwin");
   blst = (Button **) ListItemType(&bnum, LIST_TYPE_BUTTON);
   num = desks.desk[ewin->desktop].num;
   tot = 0;
   wl = NULL;
   if ((ewin->floating) || (ewin->sticky))
     {
	if (blst)
	   Efree(blst);
	XRaiseWindow(disp, ewin->win);
	EDBUG_RETURN_;
     }
   if (ewin->onbottom)
     {
	DesktopRemoveEwin(ewin);
	DesktopAddEwinToBottom(ewin);
	XLowerWindow(disp, ewin->win);
	EDBUG_RETURN_;
     }
   j = -1;
   for (i = 31; i >= 0; i--)
     {
	if (deskorder[i] == ewin->desktop)
	  {
	     j = i - 1;
	     i = -1;
	  }
     }
   if (ewin->desktop != 0)
      j = -1;
   if (blst)
     {
	for (i = 0; i < bnum; i++)
	  {
	     if (blst[i]->sticky)
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = blst[i]->win;
	       }
	  }
     }
   lst = (EWin **) ListItemType(&wnum, LIST_TYPE_EWIN);
   if (lst)
     {
	for (i = 0; i < wnum; i++)
	  {
	     if ((lst[i]->sticky) || (lst[i]->floating))
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = lst[i]->win;
	       }
	  }
	Efree(lst);
     }
   if (j >= 0)
     {
	for (i = 0; i <= j; i++)
	  {
	     if (deskorder[i] == 0)
		i = 32;
	     else
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = desks.desk[deskorder[i]].win;
	       }
	  }
     }
   if (blst)
     {
	for (i = 0; i < bnum; i++)
	  {
	     if ((blst[i]->desktop == ewin->desktop) && (blst[i]->ontop == 1) &&
		 (!blst[i]->sticky))
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = blst[i]->win;
	       }
	  }
     }
   tot += num;
   wl = Erealloc(wl, tot * sizeof(Window));
   for (i = 0; i < num; i++)
     {
	wl[tot - num + i] = desks.desk[ewin->desktop].list[i];
     }
   if (blst)
     {
	for (i = 0; i < bnum; i++)
	  {
	     if ((blst[i]->desktop == ewin->desktop) &&
		 (blst[i]->ontop == -1) &&
		 (!blst[i]->sticky))
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = blst[i]->win;
	       }
	  }
     }
   tot++;
   wl = Erealloc(wl, tot * sizeof(Window));
   wl[tot - 1] = desks.desk[ewin->desktop].win;
   XRestackWindows(disp, wl, tot);
   if (wl)
      Efree(wl);
   if (blst)
      Efree(blst);
   EDBUG_RETURN_;
}

void
RaiseEwin(EWin * ewin)
{
   EDBUG(3, "RaiseEwin");
   if (ewin->win)
     {
	if ((ewin->floating) || (ewin->sticky))
	  {
	     RemoveItem("EWIN", ewin->client.win, LIST_FINDBY_ID,
			LIST_TYPE_EWIN);
	     AddItem(ewin, "EWIN", ewin->client.win, LIST_TYPE_EWIN);
	     XRaiseWindow(disp, ewin->win);
	  }
	else if (ewin->onbottom)
	  {
	     DesktopRemoveEwin(ewin);
	     DesktopAddEwinToBottom(ewin);
	     XLowerWindow(disp, ewin->win);
	  }
	else
	  {
	     DesktopRemoveEwin(ewin);
	     DesktopAddEwinToTop(ewin);
	     RestackEwin(ewin);
	  }
     }
   EDBUG_RETURN_;
}

void
LowerEwin(EWin * ewin)
{
   EDBUG(3, "LowerEwin");
   if ((ewin->win) && (!ewin->floating))
     {
	DesktopRemoveEwin(ewin);
	DesktopAddEwinToBottom(ewin);
	RestackEwin(ewin);
     }
   EDBUG_RETURN_;
}

void
ShowEwin(EWin * ewin)
{
   EDBUG(3, "ShowEwin");
   if (ewin->visible)
      EDBUG_RETURN_;
   if (ewin->client.win)
      XMapWindow(disp, ewin->client.win);
   if (ewin->win)
      XMapRaised(disp, ewin->win);
   ewin->visible = 1;
   EDBUG_RETURN_;
}

void
HideEwin(EWin * ewin)
{
   EDBUG(3, "HideEwin");
   if (!ewin->visible)
      EDBUG_RETURN_;
   if (ewin->win)
     {
	XUnmapWindow(disp, ewin->win);
     }
   ewin->visible = 0;
   EDBUG_RETURN_;
}

Border             *
CreateBorder(char *name)
{
   Border             *b;

   EDBUG(5, "CreateBorder");
   b = Emalloc(sizeof(Border));
   if (!b)
      EDBUG_RETURN(NULL);
   b->name = duplicate(name);
   b->border.left = 0;
   b->border.right = 0;
   b->border.top = 0;
   b->border.bottom = 0;
   b->num_winparts = 0;
   b->part = NULL;
   b->changes_shape = 0;
   EDBUG_RETURN(b);
}

void
AddBorderPart(Border * b, ImageClass * iclass, ActionClass * aclass,
	      TextClass * tclass, char ontop, int flags, char isregion,
	      int wmin, int wmax, int hmin, int hmax, int torigin,
	      int txp, int txa, int typ, int tya, int borigin, int bxp,
	      int bxa, int byp, int bya)
{
   int                 n;

   EDBUG(6, "AddBorderPart");
   b->num_winparts++;
   n = b->num_winparts;
   b->part = Erealloc(b->part, n * sizeof(WinPart));
   if (!iclass)
      iclass = FindItem("__FALLBACK_ICLASS", 0, LIST_FINDBY_NAME,
			LIST_TYPE_ICLASS);
   b->part[n - 1].iclass = iclass;
   b->part[n - 1].aclass = aclass;
   b->part[n - 1].tclass = tclass;
   b->part[n - 1].ontop = ontop;
   b->part[n - 1].flags = flags;
   b->part[n - 1].region.is = isregion;
   b->part[n - 1].geom.width.min = wmin;
   b->part[n - 1].geom.width.max = wmax;
   b->part[n - 1].geom.height.min = hmin;
   b->part[n - 1].geom.height.max = hmax;
   b->part[n - 1].geom.topleft.originbox = torigin;
   b->part[n - 1].geom.topleft.x.percent = txp;
   b->part[n - 1].geom.topleft.x.absolute = txa;
   b->part[n - 1].geom.topleft.y.percent = typ;
   b->part[n - 1].geom.topleft.y.absolute = tya;
   b->part[n - 1].geom.bottomright.originbox = borigin;
   b->part[n - 1].geom.bottomright.x.percent = bxp;
   b->part[n - 1].geom.bottomright.x.absolute = bxa;
   b->part[n - 1].geom.bottomright.y.percent = byp;
   b->part[n - 1].geom.bottomright.y.absolute = bya;
   EDBUG_RETURN_;
}
