#include "E.h"

void
CreateCurve(ModCurve * c)
{
   int                 i, j, cx, v1, v2, val, dist;

   EDBUG(6, "CreateCurve");
   if (c->num == 0)
     {
	for (i = 0; i < 256; i++)
	   c->map[i] = i;
	EDBUG_RETURN_;
     }
   cx = 0;
   c->map[cx++] = c->py[0];
   for (i = 1; i < c->num; i++)
     {
	v1 = c->py[i - 1];
	v2 = c->py[i];
	dist = c->px[i] - c->px[i - 1];
	if (dist < 2)
	   c->map[cx++] = v2;
	else
	  {
	     for (j = 0; j < dist; j++)
	       {
		  val = ((v2 * j) + (v1 * (dist - j - 1))) / (dist - 1);
		  c->map[cx++] = (unsigned char)val;
	       }
	  }
     }
   EDBUG_RETURN_;
}

ColorModifierClass *
CreateCMClass(char *name,
	      int rnum, unsigned char *rpx, unsigned char *rpy,
	      int gnum, unsigned char *gpx, unsigned char *gpy,
	      int bnum, unsigned char *bpx, unsigned char *bpy)
{
   ColorModifierClass *cm;

   EDBUG(5, "CreateCMCLass");
   cm = Emalloc(sizeof(ColorModifierClass));
   if (!cm)
      EDBUG_RETURN(NULL);
   cm->name = duplicate(name);
   if (rnum < 2)
      cm->red.num = 0;
   else
     {
	cm->red.num = rnum;
	cm->red.px = Emalloc(rnum);
	memcpy(cm->red.px, rpx, rnum);
	cm->red.py = Emalloc(rnum);
	memcpy(cm->red.py, rpy, rnum);
     }
   if (gnum < 2)
      cm->green.num = 0;
   else
     {
	cm->green.num = gnum;
	cm->green.px = Emalloc(gnum);
	memcpy(cm->green.px, gpx, gnum);
	cm->green.py = Emalloc(gnum);
	memcpy(cm->green.py, gpy, gnum);
     }
   if (bnum < 2)
      cm->blue.num = 0;
   else
     {
	cm->blue.num = bnum;
	cm->blue.px = Emalloc(bnum);
	memcpy(cm->blue.px, bpx, bnum);
	cm->blue.py = Emalloc(bnum);
	memcpy(cm->blue.py, bpy, bnum);
     }
   CreateCurve(&(cm->red));
   CreateCurve(&(cm->green));
   CreateCurve(&(cm->blue));
   EDBUG_RETURN(cm);
}
