#include "E.h"

#define WIN_HINT_MASK_FLAGS             (1<<0)
#define WIN_HINT_MASK_DESKTOP           (1<<1)
#define WIN_HINT_MASK_DESKTOP_MASK      (1<<2)
#define WIN_HINT_MASK_LAYER             (1<<3)

#define WIN_HINT_STICKY                 (1<<0)
#define WIN_HINT_NEVER_USE_AREA         (1<<1)
#define WIN_HINT_LAYER                  (1<<2)

#define XA_WIN_ICONS                    "XA_WIN_ICONS"
typedef struct _win_icons
  {
     Pixmap              pmap;
     Pixmap              mask;
  }
WinIcons;

/* Which workspace / desktop the app wants to be on. The WM will set this */
/* or change it as the window changes desktops, and the app can set it to the */
/* desired desktop to have the window be on. Any chnages to htis property */
/* should be honored by the WM. If this hint does not exist the WM will */
/* create it. */
#define XA_WIN_WORKSPACE                "XA_WIN_WORKSPACE"
typedef struct _win_workspace
  {
     /* a simple desktop number for those who dont want to exist on */
     /* multiple desktops, and don't want to go setting a whole mask */
     /* desktop 0 is the "root" or first desktop, and it goes up from */
     /* there (for example Enlightenment supports 32 desktops so it will */
     /* go usp to 31 - numbers over 31 are "wrapped" by E) */
     /* if set to -1 the window can be regarded as sticky */
     CARD32              desktop;
     /* a desktop mask. 1 means it exists there, 0 doesnt. there is room for */
     /* 128 desktops here. LSB of desktop_mask0 is desktop 0, MSB is 32 */
     /* LSB desktop_mask1 is 33 etc. */
     CARD32              desktop_mask0;
     CARD32              desktop_mask1;
     CARD32              desktop_mask2;
     CARD32              desktop_mask3;
  }
WinWorkspace;

/* The layer the window exists in */
/*      0 = Desktop */
/*      1 = Below */
/*      2 = Normal (default app layer) */
/*      4 = OnTop */
/*      6 = Dock (always on top - for panel) */
/* The app sets this alone, not the WM. If this property changes the WM */
/* should comply and change the appearance/behavior of the Client window */
/* if this hint does nto exist the WM Will create it ont he Client window */
#define WIN_LAYER_DESKTOP                0
#define WIN_LAYER_BELOW                  1
#define WIN_LAYER_NORMAL                 2
#define WIN_LAYER_ONTOP                  4
#define WIN_LAYER_DOCK                   6
#define WIN_LAYER_ABOVE_DOCK             8
#define XA_WIN_LAYER                     "XA_WIN_LAYER"
/* WIN_LAYER = CARD32 */

/* flags for the window's state. The WM will change these as needed when */
/* state changes. If the property changes the WM will comply and change the */
/* windows state accordingly. if the Hint does not exist the WM will create */
/* it on the client window. 0 for the bit means off, 1 means on. unused */
/* (default) values are 0 */
#define WIN_STATE_MAXIMIZED_HORIZ        (1<<0)
#define WIN_STATE_MAXIMIZED_VERT         (1<<1)
#define WIN_STATE_SHADED                 (1<<2)
#define WIN_STATE_HIDDEN                 (1<<3)
#define WIN_STATE_HID_WORKSPACE          (1<<4)
#define WIN_STATE_HID_TRANSIENT          (1<<5)
#define XA_WIN_STATE                     "XA_WIN_STATE"
/* WIN_STATE = CARD32 */

/* Hints set by app only */
#define WIN_HINTS_SKIP_FOCUS             (1<<1)
#define WIN_HINTS_SKIP_WINLIST           (1<<2)
#define WIN_HINTS_SKIP_TASKBAR           (1<<3)
#define WIN_HINTS_GROUP_TRANSIENT        (1<<4)
#define XA_WIN_HINTS                     "XA_WIN_HINTS"
/* WIN_HINTS = CARD32 */

/* Application state - also "color reactiveness" - the app can keep changing */
/* this property when it changes its state and the WM or monitoring program */
/* will pick this up and display somehting accordingly */
#define WIN_APP_STATE_NONE                 0
#define WIN_APP_STATE_ACTIVE1              1
#define WIN_APP_STATE_ACTIVE2              2
#define WIN_APP_STATE_ERROR1               3
#define WIN_APP_STATE_ERROR2               4
#define WIN_APP_STATE_FATAL_ERROR1         5
#define WIN_APP_STATE_FATAL_ERROR2         6
#define WIN_APP_STATE_IDLE1                7
#define WIN_APP_STATE_IDLE2                8
#define WIN_APP_STATE_WAITING1             9
#define WIN_APP_STATE_WAITING2             10
#define WIN_APP_STATE_WORKING1             11
#define WIN_APP_STATE_WORKING2             12
#define WIN_APP_STATE_NEED_USER_INPUT1     13
#define WIN_APP_STATE_NEED_USER_INPUT2     14
#define WIN_APP_STATE_STRUGGLING1          15
#define WIN_APP_STATE_STRUGGLING2          16
#define WIN_APP_STATE_DISK_TRAFFIC1        17
#define WIN_APP_STATE_DISK_TRAFFIC2        18
#define WIN_APP_STATE_NETWORK_TRAFFIC1     19
#define WIN_APP_STATE_NETWORK_TRAFFIC2     20
#define WIN_APP_STATE_OVERLOADED1          21
#define WIN_APP_STATE_OVERLOADED2          22
#define WIN_APP_STATE_PERCENT000_1         23
#define WIN_APP_STATE_PERCENT000_2         24
#define WIN_APP_STATE_PERCENT010_1         25
#define WIN_APP_STATE_PERCENT010_2         26
#define WIN_APP_STATE_PERCENT020_1         27
#define WIN_APP_STATE_PERCENT020_2         28
#define WIN_APP_STATE_PERCENT030_1         29
#define WIN_APP_STATE_PERCENT030_2         30
#define WIN_APP_STATE_PERCENT040_1         31
#define WIN_APP_STATE_PERCENT040_2         32
#define WIN_APP_STATE_PERCENT050_1         33
#define WIN_APP_STATE_PERCENT050_2         34
#define WIN_APP_STATE_PERCENT060_1         35
#define WIN_APP_STATE_PERCENT060_2         36
#define WIN_APP_STATE_PERCENT070_1         37
#define WIN_APP_STATE_PERCENT070_2         38
#define WIN_APP_STATE_PERCENT080_1         39
#define WIN_APP_STATE_PERCENT080_2         40
#define WIN_APP_STATE_PERCENT090_1         41
#define WIN_APP_STATE_PERCENT090_2         42
#define WIN_APP_STATE_PERCENT100_1         43
#define WIN_APP_STATE_PERCENT100_2         44
#define XA_WIN_APP_STATE                   "XA_WIN_APP_STATE"
/* WIN_APP_STATE = CARD32 */

/* Properties set on the root window (or desktop window) */

/* WIN_WORKSPACE (same as above) contains the current desktop number */

/* A newline delimited string of desktop names */
#define XA_WIN_WORKSPACE_NAMES             "XA_WIN_WORKSPACE_NAMES"
/* WIN_WORKSPACE_NAMES = char * */

/* The availabe work area for client windows. The WM can set this and the WM */
/* and/or clients may change ti at any time. If it is changed the WM and/or  */
/* clients should honor the changes. If this property does not exist a client */
/* or WM can create it. */
#define XA_WIN_WORKAREA                    "XA_WIN_WORKAREA"
typedef struct _win_workarea
  {
     CARD32              min_x;
     CARD32              min_y;
     CARD32              max_x;
     CARD32              max_y;
  }
WinWorkarea;

void               *
AtomGet(Window win, Atom to_get, Atom type, int *size)
{
   unsigned char      *retval;
   Atom                type_ret;
   unsigned long       bytes_after, num_ret;
   int                 format_ret;
   long                length;
   void               *data;

   EDBUG(5, "AtomGet");
   retval = NULL;
   length = 0x7fffffff;
   XGetWindowProperty(disp, win, to_get, 0,
		      length,
		      False, type,
		      &type_ret,
		      &format_ret,
		      &num_ret,
		      &bytes_after,
		      &retval);
   if (retval)
     {
	data = Emalloc(num_ret << 2);
	if (data)
	   memcpy(data, retval, num_ret << 2);
	XFree(retval);
	*size = num_ret << 2;
	EDBUG_RETURN(data);
     }
   EDBUG_RETURN(NULL);
}

void
GNOME_GetHintIcons(EWin * ewin)
{
   Atom                atom_get;
   unsigned char      *retval;
   int                 size;
   int                 i;
   WinIcons           *ic;
   Pixmap              pmap;
   Pixmap              mask;

   /* the atom we want to get */
   atom_get = XInternAtom(disp, XA_WIN_ICONS, False);
   retval = AtomGet(ewin->client.win, atom_get, XA_PIXMAP, &size);
   if (retval)
     {
	ic = (WinIcons *) retval;
	for (i = 0; i < (size / (sizeof(CARD32) << 1)); i++)
	  {
	     pmap = ic[i].pmap;
	     mask = ic[i].mask;
	  }
	Efree(retval);
     }
   EDBUG_RETURN_;
}

void
GNOME_GetHints(EWin * ewin)
{
   GNOME_GetHintIcons(ewin);
   EDBUG_RETURN_;
}
