#include "E.h"

void
HandleSigHup(int num)
{
   EDBUG(7, "HandleSigHup");
   doExit("restart");
   EDBUG_RETURN_;
}

void
HandleSigInt(int num)
{
   EDBUG(7, "HandleSigQuit");
   doExit(NULL);
   EDBUG_RETURN_;
}

void
HandleSigQuit(int num)
{
   EDBUG(7, "HandleSigQuit");
   doExit(NULL);
   EDBUG_RETURN_;
}

void
HandleSigIll(int num)
{
   EDBUG(7, "HandleSigIll");
   UngrabX();
   Alert("Enlightenment received an Illegal Instruction Signal from the\n"
	 "Operating System Kernel. This most likely is due to you having\n"
	 "installed an run a binary of Enlightenment that was compiled\n"
	 "for a make or model of CPU not 100% identical or compatible\n"
	 "with yours. Please either obtain the correct package for your\n"
	 "system, or re-compile enlightenment and possibly any support\n"
	 "libraries that you got in binary format to run Enlightenment.\n");
   EDBUG_RETURN_;
}

void
HandleSigAbrt(int num)
{
   EDBUG(7, "HandleSigAbrt");
   doExit(NULL);
   EDBUG_RETURN_;
}

void
HandleSigFpe(int num)
{
   EDBUG(7, "HandleSigFpe");
   UngrabX();
   Alert("Enlightenment received an Floating Point Exception Signal from the\n"
	 "Operating System Kernel. This means that Enlightenment or support\n"
	 "library routines it calls have performed an illegal mathematical\n"
	 "operation (most likely dividing a number by zero). This is most\n"
	 "likely a bug. It is recommended to restart now.\n"
	 "If you wish to help fix this please compile Enlightenment with\n"
	 "debugging symbols in and run Enlightenment under gdb so you can\n"
	 "backtrace for where it died and send in a useful bug report with\n"
	 "backtrace information and variable dumps etc.\n");
   EDBUG_RETURN_;
}

void
HandleSigSegv(int num)
{
   EDBUG(7, "HandleSigSegv");
   UngrabX();
   Alert("Enlightenment received an Segment Violation (Segfault) Signal from the\n"
	 "Operating System Kernel. This means that Enlightenment or support\n"
     "library routines it calls have accessed areas of your system's memory\n"
	 "that they are not allowed access to. This is most likely a bug.\n"
	 "It is recommended to restart now.\n"
	 "If you wish to help fix this please compile Enlightenment with\n"
	 "debugging symbols in and run Enlightenment under gdb so you can\n"
	 "backtrace for where it died and send in a useful bug report with\n"
	 "backtrace information and variable dumps etc.\n");
   EDBUG_RETURN_;
}

void
HandleSigPipe(int num)
{
   EDBUG(7, "HandleSigPipe");
   EDBUG_RETURN_;
}

void
HandleSigAlrm(int num)
{
   EDBUG(7, "HandleSigAlrm");
   HandleTimerEvent();
   EDBUG_RETURN_;
}
void
HandleSigTerm(int num)
{
   EDBUG(7, "HandleSigTerm");
   doExit(NULL);
   EDBUG_RETURN_;
}
void
HandleSigUsr1(int num)
{
   EDBUG(7, "HandleSigUsr1");
   EDBUG_RETURN_;
}

void
HandleSigUsr2(int num)
{
   EDBUG(7, "HandleSigUsr2");
   EDBUG_RETURN_;
}

void
HandleSigChild(int num)
{
   int                 status;
   struct rusage       ruse;

   EDBUG(7, "HandleSigChild");
   while (wait3(&status, WNOHANG, &ruse) > 0);
   EDBUG_RETURN_;
}

void
HandleSigTstp(int num)
{
   EDBUG(7, "HandleSigTstp");
   EDBUG_RETURN_;
}

void
HandleSigBus(int num)
{
   EDBUG(7, "HandleSigBus");
   UngrabX();
   Alert("Enlightenment received an Bus Error Signal from the\n"
	 "Operating System Kernel. It is suggested you check your hardware\n"
	 "and OS installation. It is highly unusual to get these signals.\n");
   EDBUG_RETURN_;
}

void
HandleXError(Display * d, XErrorEvent * ev)
{
   EDBUG(7, "HandleXError");
   if ((ev->request_code == X_ChangeWindowAttributes) &&
       (ev->error_code == BadAccess))
     {
	Alert("Another Window Manager is already running.\n"
	    "You will have to quit your current window Manager first before\n"
	      "you can successfully run Enlightenment.\n"
	      "If you haven't edited your user startup files, Enlightenment\n"
	      "can do that now for you, so when you log in again after\n"
	      "quitting your current window manager, you will have\n"
	      "Enlightenment running. If you want to do this, click left\n"
	      "button for OK, otherwise middle or right mouse button\n"
	      "to restart Enlightenment or Quit now.\n");
	AddE();
	EExit(1);
     }
   EDBUG_RETURN_;
}

void
HandleXIOError(Display * d)
{
   EDBUG(7, "HandleXIOError");
   if (d == disp)
     {
	Alert("ERROR - FATAL: Lost primary connection to display.\n"
	      "Giving up\n");
	EExit(100);
     }
   EExit(1);
   EDBUG_RETURN_;
}
