#include "E.h"

void
MapUnmap(int start)
{
   static Window      *wlist = NULL;
   Window              par;
   Window              rt;
   XWindowAttributes   attr;
   static unsigned int num = 0;
   int                 i;

   EDBUG(6, "MapUnmap");
   switch (start)
     {
     case 0:
	XQueryTree(disp, root.win, &rt, &par, &wlist, &num);
	if (wlist)
	  {
	     for (i = 0; i < num; i++)
	       {
		  XGetWindowAttributes(disp, wlist[i], &attr);
		  if (attr.map_state == IsUnmapped)
		     wlist[i] = 0;
		  else
		     XUnmapWindow(disp, wlist[i]);
	       }
	  }
	break;
     case 1:
	if (wlist)
	  {
	     for (i = 0; i < num; i++)
	       {
		  if (wlist[i])
		    {
		       if (XGetWindowAttributes(disp, wlist[i], &attr))
			 {
			    if (attr.override_redirect)
			       XMapWindow(disp, wlist[i]);
			    else
			      {
				 AddToFamily(wlist[i]);
			      }
			 }
		    }
	       }
	     XFree(wlist);
	  }
	break;
     default:
	break;
     }
   EDBUG_RETURN_;
}

void
SetupSignals()
{
   struct sigaction    sa;

   EDBUG(6, "SetupSignals");
   sa.sa_handler = HandleSigHup;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGHUP, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigInt;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGINT, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigQuit;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGQUIT, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigIll;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGILL, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigAbrt;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGABRT, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigFpe;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGFPE, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigSegv;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGSEGV, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigPipe;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGPIPE, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigAlrm;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGALRM, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigTerm;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGTERM, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigUsr1;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGUSR1, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigUsr2;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGUSR2, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigChild;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGCHLD, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigTstp;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGTSTP, &sa, (struct sigaction *)0);
   sa.sa_handler = HandleSigBus;
   sa.sa_flags = 0;
   sigemptyset(&sa.sa_mask);
   sigaction(SIGBUS, &sa, (struct sigaction *)0);
   EDBUG_RETURN_;
}

void
SetupX()
{
   int                 test_event_base, test_error_base, test_v1, test_v2;
   int                 shape_event_base, shape_error_base;

   EDBUG(6, "SetupX");
   /* Open a connection to the diplay nominted by the DISPLAY variable */
   disp = XOpenDisplay(NULL);
   /* if cannot connect to display */
   if (!disp)
     {
	Alert("Enlightenment cannot connect to the display nominated by\n"
	      "your shell's DISPLAY environment variable. You may set this\n"
	      "variable to indicate which display name Enlightenment is to\n"
	      "connect to. It may be that you do not have an Xserver already\n"
	      "running to serve that Display connection, or that you do not\n"
	      "have permission to connect to that display. Please make sure\n"
	      "all is correct before trying again. Run an Xserver by running\n"
	      "xdm or startx first, or contact your local system\n"
	      "administrator, or Xserver vendor, or read the X, xdm and\n"
	      "startx manual pages before proceeding.\n");
	EExit(1);
     }
   /* set up an error handler for then E would normally have fatal X errors */
   XSetErrorHandler((XErrorHandler) HandleXError);
   /* set up a handler for when the X Connection goes down */
   XSetIOErrorHandler((XIOErrorHandler) HandleXIOError);
   /* Check for the Shape Extension */
   if (!XShapeQueryExtension(disp, &shape_event_base, &shape_error_base))
     {
	Alert("FATAL ERROR:\n"
	      "This Xserver does not support the Shape extension.\n"
	      "This is required for Enlightenment to run.\n"
	      "Exiting.\n");
	EExit(1);
     }
   /* check for the XTEST extension */
   if (XTestQueryExtension(disp, &test_event_base, &test_error_base, &test_v1, &test_v2))
     {
	/* make Enlightenment immune to other clients using XGrabServer */
	XTestGrabControl(disp, True);
     }
   else
      Alert("WARNING:\n"
	    "This Xserver does not support the XTest extension.\n"
	    "This is required for Enlightenment to run properly.\n"
	    "Enlightenment will continue to run, but parts may not.\n"
	    "Work correctly.\n"
	    "Please contact your system administrator, or see the manuals\n"
	    "For your XServer to find out how to enable the XTest\n"
	    "Extension\n");
   /* record the event base for shape change events */
   event_base_shape = shape_event_base;
   /* initialise imlib */
   id = Imlib_init(disp);
   if (!id)
     {
	Alert("FATAL ERROR:\n"
	      "Enlightenment is unable to initialise Imlib.\n"
	      "Exiting.\n");
	EExit(1);
     }
   fd = Fnlib_init(id);
   if (!fd)
     {
	Alert("FATAL ERROR:\n"
	      "Enlightenment is unable to initialise Fnlib.\n"
	      "Exiting.\n");
	EExit(1);
     }
   root.win = id->x.root;
   root.vis = Imlib_get_visual(id);
   root.depth = id->x.depth;
   root.cmap = Imlib_get_colormap(id);
   root.scr = DefaultScreen(disp);
   root.w = DisplayWidth(disp, root.scr);
   root.h = DisplayHeight(disp, root.scr);
   root.focuswin = ECreateWindow(root.win, -100, -100, 5, 5, 0);
   /* warn, if necessary about visual problems */
   if (DefaultVisual(disp, root.scr) != root.vis)
     {
	ImlibInitParams     p;

/*      
 * Alert("WARNING:\n"
 * "The Visual used for the Root Window (Desktop Background) does\n"
 * "not match the visual that Imlib has chosen to use (which\n"
 * "will the the visual with the greatest bit depth / greatest\n"
 * "number of colours). This may result in backgrounds set by\n"
 * "Enlightenment either not working, or looking strange.\n"
 * "You can fix this by running your Xserver with its default\n"
 * "Visual being the one with the highest bit-depth. Please\n"
 * "refer to your Xserver manuals, or contact your system\n"
 * "administrator or Xserver vendor.\n");
 */
	p.flags = PARAMS_VISUALID;
	p.visualid = XVisualIDFromVisual(DefaultVisual(disp, root.scr));
	ird = Imlib_init_with_params(disp, &p);
     }
   else
      ird = NULL;
   /* warn, if necessary about lack fo multi-head support */
   if (ScreenCount(disp) > 1)
     {
	Alert("WARNING:\n"
	      "Your Xserver supports a multi-headed configuration with\n"
	      "multiple screens attached to the one display. Enlightenment\n"
	      "does not currently support multi-headed setups, and as a\n"
	      "result will only manage the first screen (this one).\n");
     }
   /* warn, if necessary about X version problems */
   if (ProtocolVersion(disp) != 11)
     {
	Alert("WARNING:\n"
	      "This is not an X11 Xserver. It infact talks the X%i protocol.\n"
	      "This may mean Enlightenment will either not function, or\n"
	      "function incorrectly. If it is later than X11, then your\n"
	      "server is one the author(s) of Enlightenment neither have\n"
	      "access to, nor have heard of.\n", ProtocolVersion(disp));
     }
   /* sleect all the root window events to start managing */
   XSelectInput(disp, root.win,
		SubstructureNotifyMask | ButtonPressMask | ButtonReleaseMask |
		EnterWindowMask | LeaveWindowMask | ButtonMotionMask |
		PropertyChangeMask | SubstructureRedirectMask | KeyPressMask |
		KeyReleaseMask | PointerMotionMask);
   XSync(disp, False);
   ICCCM_SetIconSizes();
   ICCCM_Focus(NULL);
   MWM_SetInfo();
   initFunctionArray();
   mode.mode = MODE_NONE;
   mode.deskmode = MODE_NONE;
   mode.ewin = NULL;
   mode.button = NULL;
   mode.noewin = 0;
   mode.px = 0;
   mode.py = 0;
   mode.x = 0;
   mode.y = 0;
   mode.focusmode = FOCUS_SLOPPY;
   mode.focuswin = NULL;
   mode.mouse_over_win = NULL;
   mode.click_focus_grabbed = 0;
   mode.movemode = 0;
   mode.resizemode = 1;
   mode.slidemode = 0;
   mode.cleanupslide = 1;
   mode.mapslide = 1;
   mode.slidespeedmap = 4000;
   mode.slidespeedcleanup = 6000;
   mode.doingslide = 0;
   mode.server_grabbed = 0;
   mode.desktop_bg_timeout = 240;
   mode.sound = 1;
   mode.button_move_resistance = 5;
   mode.button_move_pending = 0;
   mode.current_cmap = 0;
   mode.autosave = 1;

   desks.dragdir = 2;
   desks.dragbar_width = 16;
   desks.dragbar_ordering = 1;
   desks.dragbar_length = 0;
   desks.slidein = 1;
   desks.slidespeed = 3200;
   desks.hiqualitybg = 1;
   EDBUG_RETURN_;
}

void
SetupDirs()
{
   char               *home;
   char                s[1024], ss[1024];

   EDBUG(6, "SetupDirs");
   home = homedir(getuid());
   Esnprintf(s, sizeof(s), "%s/.enlightenment", home);
   if (!home)
      EDBUG_RETURN_;
   if (exists(s))
     {
	if (isfile(s))
	  {
	     Alert("%s is a file not a directory. %s will be renamed %s.old and\n"
		   "a %s direcotry will be created.\n", s, s, s);
	     Esnprintf(ss, sizeof(ss), "%s/.enlightenment.old", home);
	     mv(s, ss);
	     md(s);
	  }
     }
   else
     {
	md(s);
	Alert("This is just a friendly message that the following directory:\n"
	      "%s\n"
	      "has been created by Enlightenment. You are free to chnage the\n"
	      "permissions on it as you please, as long as you are able to\n"
	   "read and write to the directory's contents, which Enlightenment\n"
	   "will fill with user-dependant information as time goes on.\n", s);
     }
   Efree(home);
   EDBUG_RETURN_;
}

void
SetupEnv()
{
   char                s[1024];

   Esnprintf(s, sizeof(s), "EVERSION=%s", ENLIGHTENMENT_VERSION);
   putenv(s);
   Esnprintf(s, sizeof(s), "EROOT=%s", ENLIGHTENMENT_ROOT);
   putenv(s);
   Esnprintf(s, sizeof(s), "EPID=%i", getpid());
   putenv(s);
   Esnprintf(s, sizeof(s), "ETHEME=%s", themepath);
   putenv(s);
}
