#include "E.h"

typedef struct _qentry
  {
     long                in_time;
     void                (*func) (int val, void *data);
     struct _qentry     *next;
     char                locked;
  }
Qentry;

Qentry             *q_first;

void
DoIn(long milsec, void (*func) (int val, void *data))
{
   Qentry             *qe;
   struct itimerval    itv, ctv;

   EDBUG(5, "DoIn");
   qe = Emalloc(sizeof(Qentry));
   if (!qe)
      EDBUG_RETURN_;
   qe->func = func;
   qe->next = NULL;
   qe->locked = 0;
   if (!q_first)
     {
	itv.it_interval.tv_sec = (milsec / 1000);
	itv.it_interval.tv_sec = 1000 * (milsec - (milsec / 1000));
	itv.it_value.tv_sec = (milsec / 1000);
	itv.it_value.tv_sec = 1000 * (milsec - (milsec / 1000));
	q_first = qe;
	qe->in_time = milsec;
	setitimer(ITIMER_REAL, &itv, &ctv);
     }
   else
     {
	q_first->locked = 1;
	if (q_first->next)
	   q_first->next->locked = 1;
	getitimer(ITIMER_REAL, &ctv);
     }
   EDBUG_RETURN_;
}

void
InitTimerQueue()
{
   EDBUG(6, "InitTimerQueue");
   q_first = NULL;
   EDBUG_RETURN_;
}

void
HandleTimerQueue()
{
   EDBUG(6, "HandleTimerQueue");
   EDBUG_RETURN_;
}

void
HandleTimerEvent()
{
   EDBUG(6, "HandleTimerQueue");
/* lock the head of the queue up */
   q_first->locked = 1;
   if (q_first->next)
      q_first->next->locked = 1;
   EDBUG_RETURN_;
}
