package MLine;

use Tk;
use Tk::Canvas;


sub new {
    my $self = {};
    my $class = shift;
    bless $self,$class;
    $self->{Coords} = shift if @_;  
    $self->{Config} = shift if @_;
    $self->{Config} = [] unless exists $self->{Config};
    return $self;
}

sub create {
    my $self = shift;
    my $c = shift;
    $self->{Canvas} = $c if defined $c;
    $self->{Id} = $self->{Canvas}->create('line', @{$self->{Coords}},@{$self->{Config}});
    return $self->{Id};
}

sub get_id {
    my $self = shift;
    return $self->{Id};
}

sub change_coords {
    my $self = shift;
    $self->{Coords} = [@_];
    $self->destroy();
    $self->{Id} =  $self->create();
    $self->{Canvas}->addtag($self->{Group},'withtag',$self->{Id});
    return $self->{Id};
}

sub destroy {
    my $self = shift;  
    $self->{Canvas}->delete($self->{Id}) if exists $self->{Id};
}

sub group {
    my $self = shift;
    my $group = shift;
    $self->{Group} = $group;
    my $c = $self->{Canvas};
    $c->addtag($group,'withtag',$self->{Id});
}

sub ungroup {
    my $self = shift;
    my $c = $self->{Canvas};
    $c->dtag($self->{Id},$self->{Group});
    $self->{Group}='';
}

sub get_group {
    my $self = shift;
    return $self->{Group};
}

sub configure {
    my $self = shift;
    $self->{Canvas}->itemconfigure($self->{Id},@_);
#    my $args = join ",",@_;
#  main::debug 0, "itemconfigure($self->{Id},$args)";
}

sub select {
    my $self = shift;
    my $c = $self->{Canvas};
    $c->addtag('sel','withtag',$self->{Id});
    $c->itemconfigure($self->{Id},-fill => 'grey');
}

sub deselect {
    my $self = shift;
    my $c = $self->{Canvas};
    $c->dtag($self->{Id},'sel');
    $c->itemconfigure($self->{Id},@{$self->{Config}});
}



sub get_coords {
    my $self = shift;
#    return @{$self->{Coords}};
    return $self->{Canvas}->coords($self->{Id});
}


1;






