{ # image context 

    my ($w_frame_list,$w,$b,$reload);
   local ($infile);

# try converting to ppm if its 'convert'
sub togif {
    my ($photo,$out) = @_;
    if ($HAVE{convert}) {
	system "convert $photo ppm:$out" || message "error converting $photo";
#	debug 0, "convert $photo ppm:$out";
    }
    elsif ($HAVE{xpmtoppm} and $HAVE{ppmtogif}) {
	my $photin = `cat $photo | $fvwmconfbin/changexpm | xpmtoppm | ppmtogif `;
	open (OUT,">$out");
	print OUT $photin;
	close OUT;
    }
    else {
	return if exists $WARN{imgconv};
	$WARN{imgconv} = 'Yes';
	message "Can't find image conversion programs.
  You need either 'convert' from the imagemagick suite or a bunch 
 of programs from the netpbm suite.  This message will not be repeated this session.";
    }
}

sub toxpm {
    my ($photo,$out) = @_;
    if ($HAVE{convert}) {
	system "convert $photo xpm:$out" || message "error converting $photo";
#	debug 0, "convert $photo xpm:$out";
    }
    elsif ($HAVE{giftopnm} and $HAVE{ppmtoxpm} ) {
	system("giftopnm < $photo | ppmtoxpm > $out");
    }
    else {
	return if exists $WARN{imgconv};
	$WARN{imgconv} = 'Yes';
	message "Can't find image conversion programs.
  You need either 'convert' from the imagemagick suite or a bunch 
 of programs from the netpbm suite.  This message will not be repeated this session.";
    }
}


sub  set_photo_file {
    my ($photo) = shift;
    my $testf = $photo;
#    if ($photo =~ /\.xpm/) {
#	$testf =~ s/\.xpm$/\.gif/;
#	if (-e tilde_expand($testf) ) {
#	    return $testf;
#	}
#    }
    togif(tilde_expand($photo),"$fvwm_conf_user_dir/tmp/TitleBar$$");
    return "$fvwm_conf_user_dir/tmp/TitleBar$$";
} ## end set_photo_file

sub find_xpm {
    my($dir,$file) = @_;
    if($file =~ /\.xpm$|\.XPM$/) {
	return "$dir/$file";
    }
#    elsif($file =~ /\.gif$|\.GIF$/) {
    else {
	my $newf = $file;
	$newf =~ s#\.gif$|\.GIF$#\.xpm#;
	$newf =~ s#\.\w+$##;  # any number of letters following dot.
	$newf .= '.xpm';
	return "$dir/$newf" if -e tilde_expand("$dir/$newf");
	if ( not -w tilde_expand($dir) ) {
	    message "Can't write to directory $dir to make xpm from $file";
	    beep();
	    return undef;
	}
#        system("giftopnm < $dir/$file | ppmtoxpm > $dir/$newf");
        toxpm(tilde_expand("$dir/$file"),tilde_expand("$dir/$newf"));
	return "$dir/$newf" if -e tilde_expand("$dir/$newf");
	message "Failed making pixmap from gif";
	return undef;
    }
#    else {
#	beep();
#	message("Can't find the xpm");
#	return undef;
#    }
}

##############################################################################
#     Choose xpm's for backgrounds

sub image_read_dir {
    my ($dir,$filtstring) = @_;
    local(*SOMEDIR);
    my $edir = $dir;
#    $edir =~ s#^\~/#$ENV{HOME}/#;
    opendir SOMEDIR, tilde_expand($edir)  || beep();
    my @images = grep !/^\.$|^\.\.$/,sort readdir SOMEDIR;
    closedir SOMEDIR;
    my @dirs = grep( -d tilde_expand("$edir/$_"),@images);
    @images = grep ! -d tilde_expand("$edir/$_"), @images;
    if ($filtstring eq 'gif' ) {
	@images =   grep /\.gif$|\.GIF$/,@images;
    }
    elsif($filtstring eq 'xpm' ) {
	@images =      grep /\.xpm$|\.XPM$/,@images;
    }
    elsif($filtstring eq 'jpg' ) {
	@images =      grep /\.jpg$|\.JPG$|\.jpeg$|\.JPEG$/,@images;
    }
    closedir SOMEDIR;
    return (@dirs,@images);
}

###################################################################################

sub set_images {

    my $image_list_height = 10;


    my $image_list_width = 20  ;
    my $p= 16; #padding string
    my $p1 =11;

    $SETIMAGES->destroy if Exists($SETIMAGES);
    $SETIMAGES = $MW->Toplevel(@topcon);
     
    $w = $SETIMAGES ;
    $w->title('Image Selector');
    make_decor_style_frame($w);
    my $hfr = make_help_dismiss($w,"File:images");

    my $m = $hfr->Menubutton(@menbutcon,-text=>'Directory',);
    $m-> pack(-side=>'left');
    
    my $filtstring = 'None';
    $filtstring = $STATE{ImageFilter} if exists $STATE{ImageFilter};
    my $mfilt = $hfr->Menubutton(@menbutcon,-text=>'Filter',);
    $mfilt-> pack(-side=>'left');

    my @images = image_read_dir "$STATE{ImageDir}",$filtstring;



    $hfr->Label(@labcon,-textvariable=>\$filtstring,

		)->pack(-side=>'left');

    my $root_sub = sub {	
	my $one = shift;
	set($CONFIG{Global}{RootBackground},
	    "xv -quit -rmode $one -root $STATE{ImageDir}/$infile");
    };

    my $im_root_sub = sub {	
	set($CONFIG{Global}{RootBackground},
	    "display -window root  $STATE{ImageDir}/$infile");
    };
    my $im_stretch_sub = sub {	
	set($CONFIG{Global}{RootBackground},
	    "display -geometry ${RWIDTH}x${RHEIGHT}\! -window root  $STATE{ImageDir}/$infile");
    };

    my $mr = $hfr->Menubutton(@menbutcon,-text=>'Root',);
    $mr-> pack(-side=>'right');
    if ($HAVE{display}) {
	$mr->command(-label=>'IM tile', -command=> $im_root_sub);
	$mr->command(-label=>'IM stretch', -command=> $im_stretch_sub);

    }
    if ($HAVE{xv}) {
	foreach $one ('0  ','1  ','2  ','3  ','4  ','5  ','6  ','7  ','8  ','9  '){
	    $mr->command(
			 -label => "xv $one",
			 -command =>  [$root_sub,$one]

			 );
	}
    }

    my $xvsub = sub{	system "cd  $STATE{ImageDir}; xv $STATE{ImageDir}/$infile&"};
    my $pmsub = sub{	system "cd  $STATE{ImageDir};pixmap -f $STATE{ImageDir}/$infile&"};
    my $imsub = sub{	system "cd  $STATE{ImageDir};display $STATE{ImageDir}/$infile&"};

    if ($HAVE{xv}) {
	my $xvb = $hfr->Button(@butcon,-text=>'xv',-command=>$xvsub);
	$xvb->pack(-padx=>'5',-side=>'right');
    }
    if ($HAVE{pixmap}) {
	my $pmb = $hfr->Button(@butcon,-text=>'pix',-command=>$pmsub);
	$pmb->pack(-padx=>'5',-side=>'right');
    }
    if ($HAVE{display}) {
	my $pmb = $hfr->Button(@butcon,-text=>'IM',-command=>$imsub);
	$pmb->pack(-padx=>'5',-side=>'right');
    }
    bind_history($mr,$CONFIG{Global}{RootBackground});
    $w_frame = $w->Frame(@fracon, );
    


    my $w_frame_scroll = $w_frame->Scrollbar(@scalcon);
    my $w_frame_list = $w_frame->Listbox(@liscon,
		 -yscrollcommand => ['set', $w_frame_scroll], -setgrid => 1,
					 , -height => $image_list_height);
    $w_frame_scroll->configure(-command => ['yview', $w_frame_list]);


    $w_frame_list->insert(0, @images );


#    $w_frame_list->configure(-width=> max_length(@images));
    $reload = sub { 
	my $one = shift;
			@images = image_read_dir $one,$filtstring;
			$w_frame_list->delete('0','end');

#	$w_frame_list->configure(-width=> '10');
	$w_frame_list->configure(-width=> max_length(@images));
	$w_frame_list->insert(0, @images );
#	debug 0, "max is " . max_length(@images);
	                $STATE{ImageFilter} = $filtstring;
			$STATE{ImageDir}=$one;
#	                $STATE{ImageDir} =~ s#^\~/#$ENV{HOME}/#;
                   } ;

    $w_frame->Label(@labcon,-textvariable=>\$STATE{ImageDir},
				  -font => $small_font)->pack();
    my $dirbut = $w_frame->Button(@butcon,-text=>'Directory Up',
		     -command => sub {
			 $STATE{ImageDir} =~ s#/[\w\d\.]+$##;
			 &$reload($STATE{ImageDir});
		     }

				  );
    $dirbut->pack(-side => 'top');

    $w_frame_scroll->pack(-side => 'right', -fill => 'y');

    $mfilt->command(-label=>'None', -command => sub{$filtstring = 'None';&$reload($STATE{ImageDir})});
    $mfilt->command(-label=>'gif', -command => sub{$filtstring = 'gif';&$reload($STATE{ImageDir})});
    $mfilt->command(-label=>'xpm', -command => sub{$filtstring = 'xpm';&$reload($STATE{ImageDir})});
    $mfilt->command(-label=>'jpg', -command => sub{$filtstring = 'jpg';&$reload($STATE{ImageDir})});


    foreach $one (sort @imagepath){
	$m->command(
	     -label => $one,
		    -command =>  [$reload,$one]

	     );
    }
    $m->separator;
    $m->command(-label=>('edit directory list'),
		-command=> 
		sub {editor($w,"$fvwm_conf_user_dir/imagepaths")},

		);
    $m->command(-label=>('re-read directory list'),
    -command => sub {
	read_image_paths();set_images();});

    $w_frame->pack(-side => 'right', -expand => 'yes', -fill => 'both');
    $w_frame_list->pack(-side => 'left', -expand => 'yes', -fill => 'both');
    my $picfr = $w->Frame(@fracon);
    $picfr->pack(-side=>'top',-pady=>'4');
    $picfr->Label(@labcon, -relief =>'flat',
    -textvariable=> \$infile)->pack(-side=>'top',-pady=>'4');
    $b = $picfr->Label(@labcon,-relief=>'sunken' );
    $b->pack(-side=>'top');
    my $lsub = 		sub {
			    $dirbut->configure(bg=> 'red');
			    $dirbut->update;
			    my $i = $w_frame_list->curselection();
			    $infile = $images[$i];
			    if(-d tilde_expand("$STATE{ImageDir}/$infile") ) {
				$STATE{ImageDir} = "$STATE{ImageDir}/$infile";
				&$reload($STATE{ImageDir});
				$dirbut->configure(bg=> $butbg);
				return;
			    }
				
			    $phfile = set_photo_file "$STATE{ImageDir}/$infile";
			    $w->Photo('image', file => tilde_expand($phfile)  );
##!!!			    system "rm -f $phfile"; watch out !!!!
			    $b->configure(-image => 'image');
			    $dirbut->configure(bg=> $butbg);
};
    $w_frame_list->bind('<Button-1>' => $lsub);
        $w->bind('<Down>' => 
                 sub { 
		     my $i = $w_frame_list->curselection();
		     if ($i < $#images) {
			 $w_frame_list->selectionClear($i);
			 $w_frame_list->selectionSet($i+1);
			 $w_frame_list->see($i+1);
			 &$lsub;
		     }
		 });
        $w->bind('<Up>' => 
                 sub { 
		     my $i = $w_frame_list->curselection();
		     if ($i > 0)  {
			 $w_frame_list->selectionClear($i);
			 $w_frame_list->selectionSet($i-1);
			 $w_frame_list->see($i-1);
			 &$lsub;
		     }
		 });
    my $fr = $w->Frame(@fracon,);

    $fr->pack(-side => 'top',-fill=>'x',);
#    $fr->pack(-side => 'top',-fill=>'x',-expand => 1);

     $fr->Label(@labcon,-text=>'Border for Decor: ')->pack(-side=>'left');
     $fr->Label(@labcon,-textvariable=> \$DECOR)->pack(-side=>'left');

    $fra =  $w->Frame(@fracon,);
    $fra->pack(-side => 'top',-fill=>'x');
    labbutlist($fra,
#        'L', pad('Border',$p),
        'B', pad('Active',$p1), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set($CONFIG{Decors}{$DECOR}{BorderActivePixmap},
		"TiledPixmap $file");
         },$CONFIG{Decors}->{$DECOR}->{BorderActivePixmap},
         'B', pad('Clear Active',$p), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	     set($CONFIG{Decors}{$DECOR}{BorderActivePixmap},'Simple');
        }, $CONFIG{Decors}->{$DECOR}->{BorderActivePixmap},   
);
    my $fr5 = $w->Frame(@fracon,);

    $fr5->pack(-side => 'top',-fill=>'x',);
    $fra5 =  $w->Frame(@fracon,);
    $fra5->pack(-side => 'top',-fill=>'x',);
    labbutlist($fra5,
 
        'B', pad('Inactive',$p1), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set($CONFIG{Decors}->{$DECOR}->{BorderInactivePixmap},
		"TiledPixmap $file");}
	,$CONFIG{Decors}->{$DECOR}->{BorderInactivePixmap},
        'B', pad('Clear Inactive',$p), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set($CONFIG{Decors}->{$DECOR}->{BorderInactivePixmap},'Simple');}
        ,$CONFIG{Decors}->{$DECOR}->{BorderInactivePixmap},
     );

    my $fr1 = $w->Frame(@fracon,);

    $fr1->pack(-side => 'top',-fill=>'x',);
#    $fr1->pack(-side => 'top',-fill=>'x',-expand => 1);

my $lab1=$fr1->Button(@labcon,-text=>'Title for Decor: ');
    $lab1->pack(-side=>'left');
    bind_help($lab1,'File:TitleColor');
     $fr1->Label(@labcon,-textvariable=> \$DECOR)->pack(-side=>'left');

my    $fra1 =  $w->Frame(@fracon,);
    $fra1->pack(-side => 'top',-fill=>'x',);
    labbutlist($fra1,
        'B', pad('ActiveUp',$p1), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set($CONFIG{Decors}->{$DECOR}->{TitleActiveUp},
		"TiledPixmap $file");}
         ,$CONFIG{Decors}->{$DECOR}->{TitleActiveUp},
         'B', pad('Clear ActiveUp',$p), sub {
	     set($CONFIG{Decors}->{$DECOR}->{TitleActiveUp},'Simple');}
        , $CONFIG{Decors}->{$DECOR}->{TitleActiveUp},   
    );

my    $fra2 =  $w->Frame(@fracon,);
    $fra2->pack(-side => 'top',-fill=>'x',);
    labbutlist($fra2,

       'B', pad('ActiveDown',$p1), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	   set($CONFIG{Decors}->{$DECOR}->{TitleActiveDown},
	       "TiledPixmap $file");}
         ,$CONFIG{Decors}->{$DECOR}->{TitleActiveDown},
         'B', pad('Clear ActiveDown',$p), sub {
	     set($CONFIG{Decors}->{$DECOR}->{TitleActiveDown}, 'Simple');}
        , $CONFIG{Decors}->{$DECOR}->{TitleActiveDown}

    );
my    $fra3 =  $w->Frame(@fracon,);
    $fra3->pack(-side => 'top',-fill=>'x',);
    labbutlist($fra3,
        'B', pad('Inactive',$p1), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set($CONFIG{Decors}->{$DECOR}->{TitleInactive},
		"TiledPixmap $file");}
	,$CONFIG{Decors}->{$DECOR}->{TitleInactive},
        'B', pad('Clear Inactive',$p), sub {
	    set($CONFIG{Decors}->{$DECOR}->{TitleInactive},'Simple');}
         ,$CONFIG{Decors}->{$DECOR}->{TitleInactive},
     );

################################################################################
# BUTTONS
my $p2 = 8;
# try reusing $lab1 and $fr1
 $fr1 = $w->Frame(@fracon,);
$fr1->pack(-side => 'top',-fill=>'x',);

$lab1=$fr1->Button(@labcon,-text=>'Buttons: Active Up ');
    $lab1->pack(-side=>'left');
    bind_help($lab1,'File:ISButtons');
#     $fr1->Label(@labcon,-textvariable=> \$DECOR)->pack(-side=>'left');

    $fra1 =  $w->Frame(@fracon,);
    $fra1->pack(-side => 'top',-fill=>'x',);
    labbutlist($fra1,
        'B', pad('Single',$p2), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set(button_style_ref()->{ActiveUp},
		"Pixmap $file");}
         ,button_style_ref()->{ActiveUp},
        'B', pad('Tiled',$p2), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set(button_style_ref()->{ActiveUp},
		"TiledPixmap $file");}
         ,button_style_ref()->{ActiveUp},
        'B', pad('Clear',$p2), sub {
	    set(button_style_ref()->{ActiveUp},
		"");}
         ,button_style_ref()->{ActiveUp},
    );

 $fr1 = $w->Frame(@fracon,);
$fr1->pack(-side => 'top',-fill=>'x',);
#########################
$lab1=$fr1->Button(@labcon,-text=>'Buttons: Active Down ');
    $lab1->pack(-side=>'left');
#    bind_help($lab1,'File:TitleColor');
    bind_help($lab1,'File:ISButtons');
#     $fr1->Label(@labcon,-textvariable=> \$DECOR)->pack(-side=>'left');

    $fra1 =  $w->Frame(@fracon,);
    $fra1->pack(-side => 'top',-fill=>'x',);
    labbutlist($fra1,
        'B', pad('Single',$p2), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set(button_style_ref()->{ActiveDown},
		"Pixmap $file");}
         ,button_style_ref()->{ActiveDown},
        'B', pad('Tiled',$p2), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set(button_style_ref()->{ActiveDown},
		"TiledPixmap $file");}
         ,button_style_ref()->{ActiveDown},
        'B', pad('Clear',$p2), sub {
	    set(button_style_ref()->{ActiveDown},
		"");}
         ,button_style_ref()->{ActiveDown},
    );

 $fr1 = $w->Frame(@fracon,);
$fr1->pack(-side => 'top',-fill=>'x',);
#############
$lab1=$fr1->Button(@labcon,-text=>'Buttons:  Inactive');
    $lab1->pack(-side=>'left');
    bind_help($lab1,'File:ISButtons');
#    bind_help($lab1,'File:TitleColor');
#     $fr1->Label(@labcon,-textvariable=> \$DECOR)->pack(-side=>'left');

    $fra1 =  $w->Frame(@fracon,);
    $fra1->pack(-side => 'top',-fill=>'x',);
    labbutlist($fra1,
        'B', pad('Single',$p2), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set(button_style_ref()->{Inactive},
		"Pixmap $file");}
         ,button_style_ref()->{Inactive},
        'B', pad('Tiled',$p2), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set(button_style_ref()->{Inactive},
		"TiledPixmap $file");}
         ,button_style_ref()->{Inactive},
        'B', pad('Clear',$p2), sub {
	    set(button_style_ref()->{Inactive},
		"");}
         ,button_style_ref()->{Inactive},
    );
################################################################

$fra6 =  $w->Frame(@fracon,);
$fra6->pack(-side => 'top',-fill=>'x',);

my $labf =    labbutlist($fra6,
        'B', pad('Icon',$p1), sub {
	    my $file = find_xpm($STATE{ImageDir},$infile) or return;
	    set($CONFIG{Styles}->{$STYLE}->{IconPixmap},
		"$file");}
         ,$CONFIG{Styles}->{$STYLE}->{IconPixmap},
       'L' , '  for Style:  '
    );

$labf->Label(@labcon,-textvariable=>\$STYLE)->pack(-side=>'left');

    


}#  end  set_images

sub put_image_on_tool {
    my $path = shift;
    my($dir,$image) = ($path =~ m#^[^\~/]*([\~/].+)/([^/]+)$#);
#		       debug 0, "'$dir':  '$image'";
    return unless defined $dir and defined $image and -d tilde_expand("$dir");
    $STATE{ImageDir} = $dir;
    &$reload($STATE{ImageDir});
    my $phfile = set_photo_file tilde_expand"$STATE{ImageDir}/$image";
    $w->Photo('image', file => $phfile  );
    $b->configure(-image => 'image');
    $infile = $image;
}

} #end image context
1;
