/* $Id: xmisc.h,v 1.14 1998/08/02 23:43:22 gjb Exp $
 * xmisc.h
 * (C) 1997, 1998 Maciej Stachowiak and Greg J. Badros
 */

#ifndef XMISC_H__
#define XMISC_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "image.h"
#include "window_fwd.h"
#include <X11/Xlib.h>

#define ScwmWindow   struct ScwmWindow

extern XGCValues Globalgcv;
extern unsigned long Globalgcm;
extern XEvent Event;

Window WXGetPointerWindowOffsets(Window w, int *pxReturn, int *pyReturn);
Window WXGetPointerOffsets(Window w, int *pxRoot, int *pyRoot, int *pxReturn, int *pyReturn);
Window WXGetPointerChild(Window wParent);
Bool FXGetWindowTopLeft(Window w, int *pxReturn, int *pyReturn);
Bool FXGetWindowSize(Window w, int *pwidthReturn, int *pheightReturn);
Bool FXWindowAccessible(Display *dpy, Window w);
void DrawImage(Window w, scwm_image *psimg, int cpixXoffset, int cpixYoffset, GC gc);
XTextProperty *PNewXTextPropertyFromSz(const char *sz);
int flush_expose(Window w);
void RestoreWithdrawnLocation(ScwmWindow *, Bool);
void SetGCColors(GC gc, Pixel pix, Pixel pixBG);
void SetGCFg(GC gc, Pixel pix);
void SetGCFb(GC gc, Pixel pix);
void RelieveRectangle(Window win,int x,int y,int w, int h,GC Hilite,GC Shadow);
char *SzExtractTextPropValue(const XTextProperty *pxtp);

#ifdef I18N
#define XFONT_TYPE XFontSet
#define XFONT_FONTTYPE(X) ((X)->fontset)
#else
#define XFONT_TYPE XFontStruct *
#define XFONT_FONTTYPE(X) ((X)->xfs)
#endif

int ComputeXTextWidth(XFONT_TYPE pxfs, const char *sz, int cch);


#undef ScwmWindow

#endif /* XMISC_H__ */

/* Local Variables: */
/* tab-width: 8 */
/* c-basic-offset: 2 */
/* End: */
