/*
 *  menu.c:			
 *
 *  Written by:		Ullrich Hafner
 *		
 *  Copyright (C) 1998 Ullrich Hafner <hafner@informatik.uni-wuerzburg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 1998/08/26 19:00:37 $
 *  $Author: hafner $
 *  $Revision: 1.8 $
 *  $State: Exp $
 */


#include "config.h"

#include <gtk/gtk.h>
#include <stdio.h>
#if HAVE_STRING_H
#	include <string.h>
#else /* not HAVE_STRING_H */
#	include <strings.h>
#endif /* not HAVE_STRING_H */

#include "window.h"
#include "icons.h"
#include "menu.h"
#include "dialog.h"
#include "error.h"

/*******************************************************************************

			    global variables
  
*******************************************************************************/

proplist_t *orig_wmaker;		/* original WindowMaker file */

/*******************************************************************************

				prototypes
  
*******************************************************************************/

static void
about (GtkWidget *w, gpointer ptr);
static void
readme (GtkWidget *w, gpointer ptr);
static void
copying (GtkWidget *w, gpointer ptr);
static void
homepage (GtkWidget *w, gpointer ptr);
static void
revert_popup (GtkWidget *w, gpointer ptr);
static void
revert_and_exit (GtkWidget *w, gpointer ptr);
static void
upgrade (GtkWidget *w, gpointer ptr);

/*******************************************************************************

				public code
  
*******************************************************************************/

GtkWidget *
make_menubar (void)
/*
 *  Generate menu bar.
 *
 *  Return value:
 *	menu bar widget
 */
{
   GtkWidget *file_menu = gtk_menu_new ();
   GtkWidget *help_menu = gtk_menu_new ();
   GtkWidget *item, *menu_bar;
   
   item = gtk_menu_item_new_with_label ("Save");
   gtk_menu_append (GTK_MENU (file_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (save_config_file), NULL);

   if (orig_wmaker)
   {
      item = gtk_menu_item_new_with_label ("Revert");
      gtk_menu_append (GTK_MENU (file_menu), item);
      gtk_signal_connect_object (GTK_OBJECT (item), "activate",
				 GTK_SIGNAL_FUNC (revert_popup), NULL);
   }

   item = gtk_menu_item_new();
   gtk_menu_append (GTK_MENU (file_menu), item);

   item = gtk_menu_item_new_with_label ("Upgrade");
   gtk_menu_append (GTK_MENU (file_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (upgrade), NULL);

   item = gtk_menu_item_new();
   gtk_menu_append (GTK_MENU (file_menu), item);

   item = gtk_menu_item_new_with_label ("Exit");
   gtk_menu_append (GTK_MENU (file_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (quit), NULL);

   item = gtk_menu_item_new_with_label ("About");
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (about), NULL);

   item = gtk_menu_item_new_with_label ("Manual");
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (readme), NULL);

   item = gtk_menu_item_new_with_label ("Copying");
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (copying), NULL);

#if defined(NETSCAPE) || (defined(LYNX) && defined(XTERM))
   item = gtk_menu_item_new();
   gtk_menu_append (GTK_MENU (help_menu), item);

   item = gtk_menu_item_new_with_label ("Homepage");
   gtk_menu_append (GTK_MENU (help_menu), item);
   gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			      GTK_SIGNAL_FUNC (homepage), NULL);
#endif /* defined(NETSCAPE) || (defined(LYNX) && defined(XTERM)) */

   menu_bar  = gtk_menu_bar_new ();
   
   item = gtk_menu_item_new_with_label ("File");
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), file_menu);
   gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), item);

   item = gtk_menu_item_new_with_label ("Help");
   gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), help_menu);
   gtk_menu_item_right_justify (GTK_MENU_ITEM (item));
   gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), item);

   gtk_widget_show_all (menu_bar);
   
   return menu_bar;
}

GtkWidget *
make_toolbar (void)
/*
 *  Generate toolbar.
 *
 *  Return value:
 *	toolbar widget
 */
{
   GtkWidget *toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
					 GTK_TOOLBAR_ICONS);

   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			    NULL, "Save and exit WindowMaker configuration.",
			    "Toolbar/Exit",
			    gtk_pixmap_new ((p_array + P_EXIT)->pixmap,
					    (p_array + P_EXIT)->mask),
			    (GtkSignalFunc) quit, NULL);
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			    NULL, "Save WindowMaker file.",
			    "Toolbar/Save",
			    gtk_pixmap_new ((p_array + P_DISK)->pixmap,
					    (p_array + P_DISK)->mask),
			    (GtkSignalFunc) save_config_file, NULL);
   gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			    NULL, "Documentation.",
			    "Toolbar/Help",
			    gtk_pixmap_new ((p_array + P_HELP)->pixmap,
					    (p_array + P_HELP)->mask),
			    (GtkSignalFunc) readme, NULL);
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			    NULL,
			    "Get and install new attribute description file.",
			    "Toolbar/Install",
			    gtk_pixmap_new ((p_array + P_INSTALL)->pixmap,
					    (p_array + P_INSTALL)->mask),
			    (GtkSignalFunc) upgrade, NULL);
#if defined(NETSCAPE) || (defined(LYNX) && defined(XTERM))
   gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
			    NULL, "Wmakerconf homepage.",
			    "Toolbar/WWW",
			    gtk_pixmap_new ((p_array + P_HOME)->pixmap,
					    (p_array + P_HOME)->mask),
			    (GtkSignalFunc) homepage, NULL);
#endif /* defined(NETSCAPE) || (defined(LYNX) && defined(XTERM)) */

   gtk_widget_show_all (toolbar);
   return toolbar;
}

/*******************************************************************************

				private code
  
*******************************************************************************/

static void
about (GtkWidget *w, gpointer ptr)
/*
 *  Popup 'about' window displaying some interesting information
 *  about the author of the package;-)
 *
 *  No return value.
 */
{
   static GtkWidget *window = NULL;

   if (!window)
   {
      GtkWidget *button;
      
      window = gtk_dialog_new ();
      gtk_window_set_title (GTK_WINDOW (window), "About");

      gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			  GTK_SIGNAL_FUNC (gtk_false), NULL);
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  (GtkSignalFunc) gtk_widget_destroyed,
			  &window);

      button = gtk_button_new_with_label ("Close");
      gtk_widget_show (button);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), button,
			  TRUE, TRUE, 0);
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 (GtkSignalFunc) gtk_widget_destroy,
				 GTK_OBJECT (window));

      gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (window)->vbox), 5);

      
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  make_pixmap (WMAKERDIR "/Icons/GNUstep3D.xpm", 0, 0,
				       NULL),
			  FALSE, FALSE, 5);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new ("Wmakerconf, Version " VERSION),
			  FALSE, FALSE, 5);
      /*
       *  Read version of WMWmakerconf file
       */
      {
	 FILE *version = fopen (PKGDATADIR "/wmaker-version", "r");

	 if (version)
	 {
	    char line [MAXSTRLEN];

	    strcpy (line, "Wmakerconf-data, Version ");
	    if (fgets (line + strlen (line), MAXSTRLEN - strlen (line), version))
	       gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
				   gtk_label_new (line), FALSE, FALSE, 5);
	    fclose (version);
	 }
      }
      
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new ("Copyright (C) 1998, Ullrich Hafner"),
			  FALSE, FALSE, 5);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new ("<hafner@informatik.uni-wuerzburg.de>"),
			  FALSE, FALSE, 5);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
			  gtk_label_new ("http://www-info2.informatik.uni"
					 "-wuerzburg.de/staff/ulli/wmakerconf"),
			  FALSE, FALSE, 5);
   }
   if (!GTK_WIDGET_VISIBLE (window))
      gtk_widget_show_all (window);
   else
      gtk_widget_hide (window);
}

static void
readme (GtkWidget *w, gpointer ptr)
/*
 *  Popup 'readme' window displaying the README file of the distribution.
 *
 *  No return value.
 */
{
   static GtkWidget *window = NULL;

   if (!window)
   {
      GtkWidget *button;
      FILE	*input = fopen (PKGDATADIR "/README", "r");

      if (!input)
	 return;
   
      window = gtk_dialog_new ();
      gtk_window_set_title (GTK_WINDOW (window), "Manual");

      gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			  GTK_SIGNAL_FUNC (gtk_false), NULL);
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  (GtkSignalFunc) gtk_widget_destroyed,
			  &window);

      button = gtk_button_new_with_label ("Close");
      gtk_widget_show (button);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), button,
			  TRUE, TRUE, 0);
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 (GtkSignalFunc) gtk_widget_destroy,
				 GTK_OBJECT (window));
   
      {
	 GtkWidget *text, *vscrollbar, *hscrollbar, *table;
	 char	buffer [MAXSTRLEN];
      
	 table = gtk_table_new (2, 2, FALSE);
	 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
	 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
	 gtk_widget_show (table);
	 gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (window)->vbox),
				     5);
	 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), table,
			     TRUE, TRUE, 5);

	 text = gtk_text_new (NULL, NULL);
	 gtk_text_set_editable (GTK_TEXT (text), FALSE);
	 gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
			   GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			   GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	 gtk_widget_show (text);

	 hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
	 gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
			   GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
	 gtk_widget_show (hscrollbar);

	 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
	 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
			   GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	 gtk_widget_show (vscrollbar);

	 gtk_text_freeze (GTK_TEXT (text));

	 gtk_widget_realize (text);
	 gtk_text_set_editable (GTK_TEXT (text), NO);

	 while (fgets (buffer, MAXSTRLEN, input))
	    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, buffer, -1);
	 fclose (input);
      }
      gtk_widget_set_usize (window, 500, 500);
   }
   if (!GTK_WIDGET_VISIBLE (window))
      gtk_widget_show_all (window);
   else
      gtk_widget_hide (window);
}

static void
copying (GtkWidget *w, gpointer ptr)
/*
 *  Popup 'copying' window displaying the COPYING file of the distribution.
 *
 *  No return value.
 */
{
   static GtkWidget *window = NULL;

   if (!window)
   {
      GtkWidget *button;
      FILE	*input = fopen (PKGDATADIR "/COPYING", "r");

      if (!input)
	 return;
   
      window = gtk_dialog_new ();
      gtk_window_set_title (GTK_WINDOW (window), "Manual");

      gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			  GTK_SIGNAL_FUNC (gtk_false), NULL);
      gtk_signal_connect (GTK_OBJECT (window), "destroy",
			  (GtkSignalFunc) gtk_widget_destroyed,
			  &window);
      button = gtk_button_new_with_label ("Close");
      gtk_widget_show (button);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), button,
			  TRUE, TRUE, 0);
      gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				 (GtkSignalFunc) gtk_widget_destroy,
				 GTK_OBJECT (window));
   
      {
	 GtkWidget *text, *vscrollbar, *hscrollbar, *table;
	 char	buffer [MAXSTRLEN];
      
	 table = gtk_table_new (2, 2, FALSE);
	 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
	 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
	 gtk_widget_show (table);
	 gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (window)->vbox),
				     5);
	 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), table,
			     TRUE, TRUE, 5);

	 text = gtk_text_new (NULL, NULL);
	 gtk_text_set_editable (GTK_TEXT (text), FALSE);
	 gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
			   GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			   GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	 gtk_widget_show (text);

	 hscrollbar = gtk_hscrollbar_new (GTK_TEXT (text)->hadj);
	 gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
			   GTK_EXPAND | GTK_FILL | GTK_SHRINK, GTK_FILL, 0, 0);
	 gtk_widget_show (hscrollbar);

	 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
	 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
			   GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	 gtk_widget_show (vscrollbar);

	 gtk_text_freeze (GTK_TEXT (text));

	 gtk_widget_realize (text);
	 gtk_text_set_editable (GTK_TEXT (text), NO);

	 while (fgets (buffer, MAXSTRLEN, input))
	    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, buffer, -1);
	 fclose (input);
      }
      gtk_widget_set_usize (window, 500, 500);
   }
   if (!GTK_WIDGET_VISIBLE (window))
      gtk_widget_show_all (window);
   else
      gtk_widget_hide (window);
}

static void
homepage (GtkWidget *w, gpointer ptr)
/*
 *  Load homepage of wmakerconf.
 *
 *  No return value.
 */
{
#define HOMEPAGE "http://www-info2.informatik.uni-wuerzburg.de/staff/ulli/wmakerconf"
#ifdef NETSCAPE   
   system (NETSCAPE " -remote 'openURL(" HOMEPAGE ",  new-window)' || "
	   NETSCAPE " " HOMEPAGE " &");
#else
#	ifdef LYNX
   system ("xterm -e " LYNX " " HOMEPAGE " &");
#	endif   
#endif
   ;
}

static void
revert_popup (GtkWidget *w, gpointer ptr)
/*
 *  Popup revert and quit dialog window.
 *
 *  No return value.
 */
{
   dialog_popup (DIALOG_QUESTION, "Revert to backupfile of 'WindowMaker` \n"
		 "and exit wmakerconf?", revert_and_exit, NULL);
}

static void
revert_and_exit (GtkWidget *w, gpointer ptr)
/*
 *  Revert old WindowMaker file and quit.
 *
 *  No return value.
 */
{
   if (!PLSave (orig_wmaker, YES))
      warning ("Can't revert to backupfile of `WindowMaker'. "
	       "Please manually revert to file WindowMaker.bak.");
   gtk_main_quit ();
}

static void
upgrade (GtkWidget *w, gpointer ptr)
/*
 *  Upgrade wmakerconf attribute file.
 *
 *  No return value.
 */
{
#ifdef XTERM   
   system (XTERM " -e " PERL " " PKGDATADIR "/upgrade.pl &");
#else  /* not XTERM */
   ;
#endif /* not XTERM */
}


