#!/bin/sh

conf=config.status

if [ ! -f "$conf" ]; then
    echo "\"config.status\" not found. You should run \"configure\" first."
    exit -1
fi

get_word()
{
    file=$1
    word=$2

    grep "$word=" $file | sed "s/$word=\(.*\)/\1/"
    unset file word
}

pwd=`pwd`
if [ "`basename $pwd`" = script ]; then
    cd ..
fi

OS=`get_word $conf OS`
CFLAGS=`get_word $conf CFLAGS`
CC=`get_word $conf CC`
XINC=`get_word $conf XINC`
XLIB=`get_word $conf XLIB`

INSTALL_XCIN=`get_word $conf INSTALL_XCIN`
INSTALL_INPTABS=`get_word $conf INSTALL_INPTABS`
INSTALL_DOCS=`get_word $conf INSTALL_DOCS`
INSTALL_UTILS=`get_word $conf INSTALL_UTILS`

PATH_XCIN_PREFIX=`get_word $conf PATH_XCIN_PREFIX`
PATH_XCIN_BIN=`get_word $conf PATH_XCIN_BIN`
PATH_XCIN_DIR=`get_word $conf PATH_XCIN_DIR`
PATH_XCIN_MAN=`get_word $conf PATH_XCIN_MAN`

OPT_XCIN_CFONT=`get_word $conf OPT_XCIN_CFONT`
OPT_XCIN_EFONT=`get_word $conf OPT_XCIN_EFONT`
OPT_UTIL_CIN2TAB=`get_word $conf OPT_UTIL_CIN2TAB`
OPT_UTIL_TSINTOOLS=`get_word $conf OPT_UTIL_TSINTOOLS`
OPT_INPTAB_SRC=`get_word $conf OPT_INPTAB_SRC`
OPT_INPTAB_PHONE=`get_word $conf OPT_INPTAB_PHONE`
OPT_INPTAB_PINYIN=`get_word $conf OPT_INPTAB_PINYIN`
OPT_INPTAB_CJ=`get_word $conf OPT_INPTAB_CJ`
OPT_INPTAB_ZBOSH=`get_word $conf OPT_INPTAB_ZBOSH`
OPT_INPTAB_CANTON=`get_word $conf OPT_INPTAB_CANTON`

#
#  Checking for install
#
# Make sure to not get the incompatible SysV /etc/install and
# /usr/sbin/install, which might be in PATH before a BSD-like install,
# or the SunOS /usr/etc/install directory, or the AIX /bin/install,
# or the AFS install, which mishandles nonexistent args, or
# /usr/ucb/install on SVR4, which tries to use the nonexistent group
# `staff'.  On most BSDish systems install is in /usr/bin, not /usr/ucb
# anyway.  Sigh.
if test "z${INSTALL}" = "z" ; then
  echo checking for install
  IFS="${IFS=   }"; saveifs="$IFS"; IFS="${IFS}:"
  for dir in $PATH; do
    test -z "$dir" && dir=.
    case $dir in
    /etc|/usr/sbin|/usr/etc|/usr/afsws/bin) ;;
    *)
      if test -f $dir/installbsd; then
        INSTALL="$dir/installbsd -c" # OSF1
        INSTALL_PROGRAM='$(INSTALL)'
        INSTALL_DATA='$(INSTALL) -m 644'
        INSTALL_DIR='$(INSTALL) -d'
        break
      fi
      if test -f $dir/install; then
        if grep dspmsg $dir/install >/dev/null 2>&1; then
          : # AIX
        else
          INSTALL="$dir/install -c"
          INSTALL_PROGRAM='$(INSTALL)'
          INSTALL_DATA='$(INSTALL) -m 644'
          INSTALL_DIR='$(INSTALL) -d'
          break
        fi
      fi
      ;;
    esac
  done
  IFS="$saveifs"
fi
INSTALL=${INSTALL-cp}
INSTALL_PROGRAM=${INSTALL_PROGRAM-'$(INSTALL)'}
INSTALL_DATA=${INSTALL_DATA-'$(INSTALL)'}
INSTALL_DIR=${INSTALL_DIR-mkdir}

cat >> $conf << EOF
INSTALL=$INSTALL
INSTALL_PROGRAM=$INSTALL_PROGRAM
INSTALL_DATA=$INSTALL_DATA
INSTALL_DIR=$INSTALL_DIR
EOF


#
#  Create Makefile
#
echo "Creating Makefile ...."
src=script/Makefile.in
dist=Makefile

makeall=""
installall=""
if [ "$INSTALL_XCIN" = yes ] || [ "$INSTALL_UTILS" = yes ]; then
    makeall="${makeall}make_xcin "
    installall="${installall}install_xcin "
fi
if [ "$INSTALL_INPTABS" = yes ]; then
    makeall="${makeall}make_inptab "
    installall="${installall}install_inptab "
fi
if [ "$INSTALL_DOCS" = yes ]; then
    installall="${installall}install_doc "
fi
sed "s/@MAKEALL@/$makeall/;\
     s/@INSTALLALL@/$installall/" $src > $dist


#
#  Create src/Makefile
#
echo "Creating src/Makefile ...."
src=src/Makefile.in
dist=src/Makefile

makeall=""
installall=""
if [ "$INSTALL_XCIN" = yes ]; then
    makeall="${makeall}xcin "
    installall="${installall}install_xcin "
fi

if [ "$INSTALL_UTILS" = yes ] && [ "$OPT_UTIL_CIN2TAB" = yes ]; then
    makeall="${makeall}cin2tab "
    installall="${installall}install_cin2tab "
fi

if [ "$INSTALL_UTILS" = yes ] && [ "$OPT_UTIL_TSINTOOLS" = yes ]; then
    makeall="${makeall}tsintools "
    installall="${installall}install_tsintools "
fi
if [ "$INSTALL_INPTABS" = yes ] && [ "$OPT_INPTAB_SRC" = yes ]; then
    installall="${installall}install_tsintabsrc "
fi
sed "s/@MAKEALL@/$makeall/;\
     s/@INSTALLALL@/$installall/" $src > $dist


#
#  Create doc/Makefile
#
echo "Creating doc/Makefile ...."
src=doc/Makefile.in
dist=doc/Makefile

makeall=""
installall=""
if [ "$INSTALL_XCIN" = yes ]; then
    installall="${installall}xcin.1 "
fi
if [ "$INSTALL_UTILS" = yes ] && [ "$OPT_UTIL_CIN2TAB" = yes ]; then
    installall="${installall}cin2tab.1 "
fi
sed "s/@MAKEALL@/$makeall/;\
     s/@INSTALLALL@/$installall/" $src > $dist
    

#
#  Create input_tab/Makefile
#
echo "Creating input_tab/Makefile ...."
src=input_tab/Makefile.in
dist=input_tab/Makefile

makeall=""
installall=""
if [ "$INSTALL_INPTABS" = yes ] && [ "$OPT_INPTAB_PHONE" = yes ]; then
    makeall="${makeall}phone.tab "
    installall="${installall}phone.tab* "
    if [ "$OPT_INPTAB_SRC" = yes ]; then
	installall="${installall}phone.cin "
    fi
fi
if [ "$INSTALL_INPTABS" = yes ] && [ "$OPT_INPTAB_PINYIN" = yes ]; then
    makeall="${makeall}pinyin.tab "
    installall="${installall}pinyin.tab* "
    if [ "$OPT_INPTAB_SRC" = yes ]; then
	installall="${installall}pinyin.cin "
    fi
fi
if [ "$INSTALL_INPTABS" = yes ] && [ "$OPT_INPTAB_CJ" = yes ]; then
    makeall="${makeall}cj.tab "
    installall="${installall}cj.tab* "
    if [ "$OPT_INPTAB_SRC" = yes ]; then
	installall="${installall}cj.cin "
    fi
fi
if [ "$INSTALL_INPTABS" = yes ] && [ "$OPT_INPTAB_ZBOSH" = yes ]; then
    makeall="${makeall}zmdbosh.tab "
    installall="${installall}zmdbosh.tab* "
    if [ "$OPT_INPTAB_SRC" = yes ]; then
	installall="${installall}zmdbosh.cin "
    fi
fi
if [ "$INSTALL_INPTABS" = yes ] && [ "$OPT_INPTAB_CANTON" = yes ]; then
    makeall="${makeall}cantonese.tab "
    installall="${installall}cantonese.tab* "
    if [ "$OPT_INPTAB_SRC" = yes ]; then
	installall="${installall}cantonese.cin "
    fi
fi
sed "s/@MAKEALL@/$makeall/;\
     s/@INSTALLALL@/$installall/" $src > $dist

