#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "history.h"

#if 0
void main (void)
    {
    int i;
    list commands;
    init_list (&commands, 10, 1, 1);
    add_to_end (&commands, "one");
    add_to_end (&commands, "two");
    add_to_end (&commands, "three");
    write_list (&commands);
    remove_from_top (&commands);
    remove_from_top (&commands);
    remove_from_top (&commands);
    remove_from_top (&commands);
    write_list (&commands);
    add_to_end (&commands, "four");
    add_to_end (&commands, "five");
    add_to_end (&commands, "six");
    add_to_end (&commands, "seven");
    add_to_end (&commands, "eight");
    add_to_end (&commands, "nine");
    add_to_end (&commands, "ten");
    add_to_end (&commands, "eleven");
    add_to_end (&commands, "twelve");
    add_to_end (&commands, "thirteen");
    add_to_end (&commands, "fourteen");
    add_to_end (&commands, "fifteen");
    commands.consider_last_entry_temp = 1;
    add_to_end (&commands, "sixteen");
    write_list (&commands);
    fprintf (stderr, "now entering mode where\n\
'a' goes up and shows entry and\
'z' goes down\n");
    if (commands.current_entries > 0)
        fprintf (stderr, "entry is %s", return_current (&commands));
    while (1)
        {
        i = getc (stdin);
        if (i == 'a')
            {
            if (0 == backward_current (&commands))
                fprintf (stderr, "entry is %s", return_current (&commands));
            }
        else if (i == 'z')
            {
            if (0 == forward_current (&commands))
                fprintf (stderr, "entry is %s", return_current (&commands));
            }

        }

    }

*/
#endif

void init_list (list * commands, int max, int snap_current_to_newest, int autopop)
    {
    commands->max_entries = max;
    commands->current_entries = 0;
    commands->top = NULL;
    commands->last = NULL;
    commands->current = NULL;
    commands->snap_current_to_newest = snap_current_to_newest;
    commands->autopop = autopop;
    commands->consider_last_entry_temp = 0;
    }

/* little private thingy */
int add_to_end (list * commands, const char *incoming)
    {
    entry *temp;

    if (commands->consider_last_entry_temp)
        {
        remove_from_end (commands);
        commands->consider_last_entry_temp = 0;
        }

    if (commands->current_entries == commands->max_entries)
        {
        if (commands->autopop)
            remove_from_top (commands);
        else
            {
            list_error ("list full\n", 0);
            return (2);
            }
        }

    temp = (entry *) malloc (sizeof (entry));
    if (temp == NULL)
        {
        list_error ("no memory to add entry to list\n", 1);
        return (1);
        }

    istrncpy (temp->command, incoming, MAX_COMMAND - 1);

    temp->next = NULL;

    if (commands->current_entries == 0)
        {
        commands->current = temp;
        commands->top = temp;
        temp->last = NULL;
        }
    else
        {
        commands->last->next = temp;
        temp->last = commands->last;
        if (commands->snap_current_to_newest)
            commands->current = temp;
        }

    commands->last = temp;

    commands->current_entries++;
    return (0);
    }

int remove_from_top (list * commands)
    {
    entry *temp;

    if (commands->current_entries == 0)
        {
        list_error ("list already empty\n", 0);
        return (2);
        }

    if (commands->current == commands->top)
        commands->current = commands->top->next;

    temp = commands->top;
    commands->top = commands->top->next;
    free (temp);
    if (commands->top != NULL)
        commands->top->last = NULL;
    commands->current_entries--;
    return (0);
    }

int remove_from_end (list * commands)
    {
    entry *temp;

    if (commands->current_entries == 0)
        {
        list_error ("list already empty\n", 0);
        return (2);
        }

    if (commands->current == commands->last)
        commands->current = commands->last->last;

    temp = commands->last;
    commands->last = commands->last->last;
    free (temp);
    if (commands->last != NULL)
        commands->last->next = NULL;
    commands->current_entries--;
    return (0);
    }

int forward_current (list * commands)
    {
    if (commands->current != NULL)
        {
        if (commands->current->next != NULL)
            commands->current = commands->current->next;
        return (0);
        }
    return (1);
    }

int backward_current (list * commands)
    {
    if (commands->current != NULL)
        {
        if (commands->current->last != NULL)
            commands->current = commands->current->last;
        return (0);
        }
    return (1);
    }

const char *return_current (list * commands)
    {
    if (commands->current != NULL)
        return (commands->current->command);
    else
        return (NULL);
    }

void write_list (list * commands)
    {
    entry *temp;
    temp = commands->top;
    if (temp == NULL)
        list_error ("no entries to write\n", 0);

    while (temp != NULL)
        {
        fprintf (stderr, "\n%s\n", temp->command);
        temp = temp->next;
        }
    }


void list_error (char *message, int importance)
    {
#ifndef DEBUG
    if (importance)
#endif
        fprintf (stderr, "\nlist_error: %s", message);
    }
