#define _USE_BSD
#include <ctype.h>
#include <config.h>
#include "pty.h"
#include "xwin.h"
#include "main.h"
#include "utmp_write.h"

RETSIGTYPE reaper(int);
RETSIGTYPE write_user_outof_utmp_and_quit(int);

extern char pty_name[12];
extern char *tty;
extern pid_t pid;
extern pid_t pid2;

int main (int argc, char **argv)
    {
    int fd1, fd2;
    int p[2];
    /* node * standard_patterns; */

    fd1 = pty_master ();
    fd2 = pty_slave (fd1);

    signal_handle (SIGCHLD, reaper);

    if (pid < (pid_t) 0)
        {
        /* The fork failed. */
        fprintf (stderr, "Fork failed.\n");
        return (-1);
        }
    else
        {
        if(pipe(p))
        	{
        	fprintf(stderr, "Pipe failed.\n");
        	return(-1);
        	}
        pid2=fork();
        if(pid2==(pid_t) 0)
        	{
        	setuid(getuid());
        	open_window (argc, argv, fd1, p[1]);
        	}
        else if(pid2 < (pid_t) 0)
        	{
	        /* The fork failed. */
	        fprintf (stderr, "Fork failed.\n");
	        return (-1);
	        }
	else    
	    	{
        	char throwaway[255];
        	int i=0;
        	do
        		{
        		if(read(p[0], &throwaway[i], 1))
        			i++;
        		if(i>255) {
        			throwaway[255]=0;
        			break;
        			}
        		} while(throwaway[i-1]);
        	write_user_into_utmp (throwaway);
	        /* :-) */
	        signal_handle (SIGQUIT, write_user_outof_utmp_and_quit);
	        signal_handle (SIGTERM, write_user_outof_utmp_and_quit);
		signal_handle (SIGSEGV, write_user_outof_utmp_and_quit); 
	        signal_handle (SIGHUP, write_user_outof_utmp_and_quit);
        	signal_handle (SIGINT, write_user_outof_utmp_and_quit);
        	signal_handle (SIGPIPE, write_user_outof_utmp_and_quit);
        	signal_handle (SIGINT, write_user_outof_utmp_and_quit);
        	signal_handle (SIGCHLD, write_user_outof_utmp_and_quit);
        	signal_handle (SIGALRM, SIG_IGN);
        	/* wheee */
        	pause();
        	write_user_outof_utmp_and_quit(15);
        	}
        }
    return (0);
    }

