#ifndef MAIN_HEADER
#define MAIN_HEADER

#include "./regexp/regexp.h"
#include "arbitrary.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>


/*Xlib*/
#include <X11/Xlib.h>

#ifdef HAVE_XPM
/*xpm support here we gooooo*/
#include <X11/xpm.h>
#endif


typedef struct
    {
    int autoanswer;
    int autorun;
    int autorefresh;
    char libpath[MAXFILELEN+1]; 
	char defaultpic[MAXFILELEN+1];
    char soundhandler[MAXFILELEN+1]; 
	Pixmap bitmap;
	int use_bitmap;
	int mailactive;
    }init_info;

typedef struct
	{
	char *command;
	char *title;
	int use_bitmap;
	Pixmap bitmap;
	char *soundclip;
	}response_struct;

struct nod 
	{
	char title[MAX_TITLE];
	char command[MAX_COMMAND];
	char pattern[MAX_PATTERN];
	/*sound file to use*/
	char soundclip[MAX_PICTURE];
	/*pixmaps or bitmaps to use*/
	char picture[MAX_PICTURE];
	Pixmap bitmap;
	struct nod *next;
	int use_bitmap;
	};


struct nod2 
	{
	char title[MAX_TITLE];
	char determined_command[MAX_COMMAND];
	struct nod2 *next;
	};

struct nod3
    {
    char title[MAX_TITLE];
    char filename[MAXFILELEN+1]; 
	struct nod3 *next;
    };
    
struct nod4
	{
    char title[MAX_TITLE];
	char mailfile[MAXFILELEN+1]; 
	char command[MAX_COMMAND];
	struct nod4 *next;
	char picture[MAX_PICTURE];
	/*sound file to use*/
	char soundclip[MAX_PICTURE];
	XtIntervalId timer;
	time_t last_change;
	off_t size;
	Pixmap bitmap;
	int use_bitmap;
    int allowread;
    int touch;
	};

typedef struct nod  node;
typedef struct nod2 det_node;
typedef struct nod3 config_node;
typedef struct nod4 mail_node;


response_struct * send_line_for_pattern_match(char *,node *);
void read_and_output(int );
char * examine_command(char *,regexp *);
char * examine_determined(char *,char *,char *);
void istrncpy(char *,const char *,int );
void unpriv_system(char *);
int unpriv_open(char *,int );
char *process_for_variables(char *,int );
#endif
