/* xkeycaps, Copyright (c) 1991, 1992, 1993 Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the default keymap of the Sun type 5 Japanese keyboard
 * as interpreted by MIT X11R5 after having applied the UNOFFICIAL patch found
 * in "ftp.x.org:/pub/sunkbd.930314.tar.Z".
 * Generated by Kazutaka Yokota (yokota@zodiac.mech.utsunomiya-u.ac.jp).
 */

#ifndef  SunXK_F36
# define SunXK_F36     0x1005FF10
#endif
#ifndef  SunXK_F37
# define SunXK_F37     0x1005FF11
#endif
#ifndef  SunXK_Props
# define SunXK_Props   0x1005FF70
#endif
#ifndef  SunXK_Front
# define SunXK_Front   0x1005FF71
#endif
#ifndef  SunXK_Copy
# define SunXK_Copy    0x1005FF72
#endif
#ifndef  SunXK_Open
# define SunXK_Open    0x1005FF73
#endif
#ifndef  SunXK_Paste
# define SunXK_Paste   0x1005FF74
#endif
#ifndef  SunXK_Cut
# define SunXK_Cut     0x1005FF75
#endif
#ifndef  SunXK_Sys_Req
# define SunXK_Sys_Req 0x1005FF60
#endif

static const struct default_keycode_map sun5jp_xc_map [] = {

  /* these have keycodes but no keysyms in the default map */
  {   9, 0,		{ 0 }},	/* Dim, Quiet */
  {  11, 0,		{ 0 }},	/* Bright, Loud */
  {  22, 0,		{ 0 }},	/* non-existent? */
  {  52, 0,		{ 0 }},	/* DeGause, SoundOff */
  {  55, 0,		{ 0 }},	/* Power */
  {  82, 0,		{ 0 }},	/* non-existent? */
  { 131, 0,		{ 0 }},	/* non-existent? */

  {   8, 0,		{ XK_F11,	XK_F11,
			XK_Cancel }},
  {  10, 0,		{ XK_F12,	XK_F12,
			XK_Redo }},
  {  12, 0,		{ XK_F1 }},
  {  13, 0,		{ XK_F2 }},
  {  14, 0,		{ XK_F10 }},
  {  15, 0,		{ XK_F3 }},
  {  16, 0,		{ XK_F11 }},
  {  17, 0,		{ XK_F4 }},
  {  18, 0,		{ XK_F12 }},
  {  19, 0,		{ XK_F5 }},
  {  20, Mod2Mask,	{ XK_Mode_switch }},
  {  21, 0,		{ XK_F6 }},
  {  23, 0,		{ XK_F7 }},
  {  24, 0,		{ XK_F8 }},
  {  25, 0,		{ XK_F9 }},
  {  26, Mod3Mask,	{ XK_Alt_L }},
  {  27, 0,		{ XK_Up }},
  {  28, 0,		{ XK_F21,	XK_F21,
			XK_Pause,	XK_Break }},
  {  29, 0,		{ XK_F22,	XK_F22,
			XK_Print,	SunXK_Sys_Req }},
  {  30, 0,		{ XK_F23,	XK_F23,
			XK_Scroll_Lock }},
  {  31, 0,		{ XK_Left }},
  {  32, 0,		{ XK_F13,	XK_F13,
			SunXK_Props }},
  {  33, 0,		{ XK_F14,	XK_F14,
			XK_Undo }},
  {  34, 0,		{ XK_Down }},
  {  35, 0,		{ XK_Right }},
  {  36, 0,		{ XK_Escape }},
  {  37, 0,		{ XK_1,	XK_exclam,
			XK_kana_NU }},
  {  38, 0,		{ XK_2,	XK_quotedbl,
			XK_kana_FU }},
  {  39, 0,		{ XK_3,	XK_numbersign,
			XK_kana_A,	XK_kana_a }},
  {  40, 0,		{ XK_4,	XK_dollar,
			XK_kana_U,	XK_kana_u }},
  {  41, 0,		{ XK_5,	XK_percent,
			XK_kana_E,	XK_kana_e }},
  {  42, 0,		{ XK_6,	XK_ampersand,
			XK_kana_O,	XK_kana_o }},
  {  43, 0,		{ XK_7,	XK_apostrophe,
			XK_kana_YA,	XK_kana_ya }},
  {  44, 0,		{ XK_8,	XK_parenleft,
			XK_kana_YU,	XK_kana_yu }},
  {  45, 0,		{ XK_9,	XK_parenright,
			XK_kana_YO,	XK_kana_yo }},
  {  46, 0,		{ XK_0,	XK_0,
			XK_kana_WA,	XK_kana_WO }},
  {  47, 0,		{ XK_minus,	XK_equal,
			XK_kana_HO }},
  {  48, 0,		{ XK_asciicircum,	XK_asciitilde,
			XK_kana_HE }},
  {  49, 0,		{ XK_backslash,	XK_bar,
			XK_prolongedsound }},
  {  50, 0,		{ XK_BackSpace }},
  {  51, 0,		{ XK_Insert }},
  {  53, 0,		{ XK_F25,	XK_F25,
			XK_KP_Divide }},
  {  54, 0,		{ XK_F26,	XK_F26,
			XK_KP_Multiply }},
  {  56, 0,		{ XK_F15,	XK_F15,
			SunXK_Front }},
  {  57, 0,		{ XK_Delete,	XK_Delete,
			XK_KP_Decimal }},
  {  58, 0,		{ XK_F16,	XK_F16,
			SunXK_Copy }},
  {  59, 0,		{ XK_Home }},
  {  60, 0,		{ XK_Tab }},
  {  61, 0,		{ XK_q,	XK_Q,
			XK_kana_TA }},
  {  62, 0,		{ XK_w,	XK_W,
			XK_kana_TE }},
  {  63, 0,		{ XK_e,	XK_E,
			XK_kana_I,	XK_kana_i }},
  {  64, 0,		{ XK_r,	XK_R,
			XK_kana_SU }},
  {  65, 0,		{ XK_t,	XK_T,
			XK_kana_KA }},
  {  66, 0,		{ XK_y,	XK_Y,
			XK_kana_N }},
  {  67, 0,		{ XK_u,	XK_U,
			XK_kana_NA }},
  {  68, 0,		{ XK_i,	XK_I,
			XK_kana_NI }},
  {  69, 0,		{ XK_o,	XK_O,
			XK_kana_RA }},
  {  70, 0,		{ XK_p,	XK_P,
			XK_kana_SE }},
  {  71, 0,		{ XK_at,	XK_grave,
			XK_voicedsound }},
  {  72, 0,		{ XK_bracketleft,	XK_braceleft,
			XK_semivoicedsound,	XK_kana_openingbracket }},
  {  73, 0,		{ XK_Delete }},
  {  74, 0,		{ XK_Multi_key }},
  {  75, 0,		{ XK_F27,	XK_F27,
			XK_KP_7,	XK_Home }},
  {  76, 0,		{ XK_Up,	XK_F28,
			XK_KP_8 }},
  {  77, 0,		{ XK_F29,	XK_F29,
			XK_KP_9,	XK_Prior }},
  {  78, 0,		{ XK_F24,	XK_F24,
			XK_KP_Subtract }},
  {  79, 0,		{ XK_F17,	XK_F17,
			SunXK_Open }},
  {  80, 0,		{ XK_F18,	XK_F18,
			SunXK_Paste }},
  {  81, 0,		{ XK_End }},
  {  83, ControlMask,	{ XK_Control_L }},
  {  84, 0,		{ XK_a,	XK_A,
			XK_kana_CHI }},
  {  85, 0,		{ XK_s,	XK_S,
			XK_kana_TO }},
  {  86, 0,		{ XK_d,	XK_D,
			XK_kana_SHI }},
  {  87, 0,		{ XK_f,	XK_F,
			XK_kana_HA }},
  {  88, 0,		{ XK_g,	XK_G,
			XK_kana_KI }},
  {  89, 0,		{ XK_h,	XK_H,
			XK_kana_KU }},
  {  90, 0,		{ XK_j,	XK_J,
			XK_kana_MA }},
  {  91, 0,		{ XK_k,	XK_K,
			XK_kana_NO }},
  {  92, 0,		{ XK_l,	XK_L,
			XK_kana_RI }},
  {  93, 0,		{ XK_semicolon,	XK_plus,
			XK_kana_RE }},
  {  94, 0,		{ XK_colon,	XK_asterisk,
			XK_kana_KE }},
  {  95, 0,		{ XK_bracketright,	XK_braceright,
			XK_kana_MU,	XK_kana_closingbracket }},
  {  96, 0,		{ XK_Return }},
  {  97, 0,		{ XK_KP_Enter }},
  {  98, 0,		{ XK_Left,	XK_F30,
			XK_KP_4 }},
  {  99, 0,		{ XK_F31,	XK_F31,
			XK_KP_5 }},
  { 100, 0,		{ XK_Right,	XK_F32,
			XK_KP_6 }},
  { 101, 0,		{ XK_Insert,	XK_Insert,
			XK_KP_0 }},
  { 102, 0,		{ XK_F19,	XK_F19,
			XK_Find }},
  { 103, 0,		{ XK_Prior }},
  { 104, 0,		{ XK_F20,	XK_F20,
			SunXK_Cut }},
  { 105, 0,		{ XK_Num_Lock }},
  { 106, ShiftMask,	{ XK_Shift_L }},
  { 107, 0,		{ XK_z,	XK_Z,
			XK_kana_TSU,	XK_kana_tsu }},
  { 108, 0,		{ XK_x,	XK_X,
			XK_kana_SA }},
  { 109, 0,		{ XK_c,	XK_C,
			XK_kana_SO }},
  { 110, 0,		{ XK_v,	XK_V,
			XK_kana_HI }},
  { 111, 0,		{ XK_b,	XK_B,
			XK_kana_KO }},
  { 112, 0,		{ XK_n,	XK_N,
			XK_kana_MI }},
  { 113, 0,		{ XK_m,	XK_M,
			XK_kana_MO }},
  { 114, 0,		{ XK_comma,	XK_less,
			XK_kana_NE,	XK_kana_comma }},
  { 115, 0,		{ XK_period,	XK_greater,
			XK_kana_RU,	XK_kana_fullstop }},
  { 116, 0,		{ XK_slash,	XK_question,
			XK_kana_ME,	XK_kana_conjunctive }},
  { 117, ShiftMask,	{ XK_Shift_R }},
  { 118, 0,		{ XK_backslash,	XK_underscore,
			XK_kana_RO }},
  { 119, 0,		{ XK_F33,	XK_F33,
			XK_KP_1,	XK_End }},
  { 120, 0,		{ XK_Down,	XK_F34,
			XK_KP_2 }},
  { 121, 0,		{ XK_F35,	XK_F35,
			XK_KP_3,	XK_Next }},
  { 122, 0,		{ XK_Execute }},
  { 123, 0,		{ XK_Kanji }},
  { 124, 0,		{ XK_Henkan_Mode }},
  { 125, 0,		{ XK_Help }},
  { 126, LockMask,	{ XK_Caps_Lock }},
  { 127, Mod1Mask,	{ XK_Meta_L }},
  { 128, 0,		{ XK_space }},
  { 129, Mod1Mask,	{ XK_Meta_R }},
  { 130, 0,		{ XK_Next }},
  { 132, 0,		{ XK_KP_Add }},
  { 133, 0,		{ XK_KP_Divide }},
  { 134, 0,		{ XK_KP_Multiply }},
  { 135, 0,		{ XK_KP_Decimal }},
  { 136, 0,		{ XK_KP_7 }},
  { 137, 0,		{ XK_KP_8 }},
  { 138, 0,		{ XK_KP_9 }},
  { 139, 0,		{ XK_KP_Subtract }},
  { 140, 0,		{ XK_KP_Enter }},
  { 141, 0,		{ XK_KP_4 }},
  { 142, 0,		{ XK_KP_5 }},
  { 143, 0,		{ XK_KP_6 }},
  { 144, 0,		{ XK_KP_0 }},
  { 145, 0,		{ XK_KP_1 }},
  { 146, 0,		{ XK_KP_2 }},
  { 147, 0,		{ XK_KP_3 }},
  { 148, 0,		{ XK_KP_Add }},
  { 149, 0,		{ XK_nobreakspace }},
  { 150, 0,		{ XK_exclamdown }},
  { 151, 0,		{ XK_cent }},
  { 152, 0,		{ XK_sterling }},
  { 153, 0,		{ XK_currency }},
  { 154, 0,		{ XK_yen }},
  { 155, 0,		{ XK_brokenbar }},
  { 156, 0,		{ XK_section }},
  { 157, 0,		{ XK_diaeresis }},
  { 158, 0,		{ XK_copyright }},
  { 159, 0,		{ XK_ordfeminine }},
  { 160, 0,		{ XK_guillemotleft }},
  { 161, 0,		{ XK_notsign }},
  { 162, 0,		{ XK_hyphen }},
  { 163, 0,		{ XK_registered }},
  { 164, 0,		{ XK_macron }},
  { 165, 0,		{ XK_degree }},
  { 166, 0,		{ XK_plusminus }},
  { 167, 0,		{ XK_twosuperior }},
  { 168, 0,		{ XK_threesuperior }},
  { 169, 0,		{ XK_acute }},
  { 170, 0,		{ XK_mu }},
  { 171, 0,		{ XK_paragraph }},
  { 172, 0,		{ XK_periodcentered }},
  { 173, 0,		{ XK_cedilla }},
  { 174, 0,		{ XK_onesuperior }},
  { 175, 0,		{ XK_masculine }},
  { 176, 0,		{ XK_guillemotright }},
  { 177, 0,		{ XK_onequarter }},
  { 178, 0,		{ XK_onehalf }},
  { 179, 0,		{ XK_threequarters }},
  { 180, 0,		{ XK_questiondown }},
  { 181, 0,		{ XK_Agrave,	XK_Agrave }},
  { 182, 0,		{ XK_Aacute,	XK_Aacute }},
  { 183, 0,		{ XK_Acircumflex,	XK_Acircumflex }},
  { 184, 0,		{ XK_Atilde,	XK_Atilde }},
  { 185, 0,		{ XK_Adiaeresis,	XK_Adiaeresis }},
  { 186, 0,		{ XK_Aring,	XK_Aring }},
  { 187, 0,		{ XK_AE,	XK_AE }},
  { 188, 0,		{ XK_Ccedilla,	XK_Ccedilla }},
  { 189, 0,		{ XK_Egrave,	XK_Egrave }},
  { 190, 0,		{ XK_Eacute,	XK_Eacute }},
  { 191, 0,		{ XK_Ecircumflex,	XK_Ecircumflex }},
  { 192, 0,		{ XK_Ediaeresis,	XK_Ediaeresis }},
  { 193, 0,		{ XK_Igrave,	XK_Igrave }},
  { 194, 0,		{ XK_Iacute,	XK_Iacute }},
  { 195, 0,		{ XK_Icircumflex,	XK_Icircumflex }},
  { 196, 0,		{ XK_Idiaeresis,	XK_Idiaeresis }},
  { 197, 0,		{ XK_ETH,	XK_ETH }},
  { 198, 0,		{ XK_Ntilde,	XK_Ntilde }},
  { 199, 0,		{ XK_Ograve,	XK_Ograve }},
  { 200, 0,		{ XK_Oacute,	XK_Oacute }},
  { 201, 0,		{ XK_Ocircumflex,	XK_Ocircumflex }},
  { 202, 0,		{ XK_Otilde,	XK_Otilde }},
  { 203, 0,		{ XK_Odiaeresis,	XK_Odiaeresis }},
  { 204, 0,		{ XK_multiply }},
  { 205, 0,		{ XK_Ooblique,	XK_Ooblique }},
  { 206, 0,		{ XK_Ugrave,	XK_Ugrave }},
  { 207, 0,		{ XK_Uacute,	XK_Uacute }},
  { 208, 0,		{ XK_Ucircumflex,	XK_Ucircumflex }},
  { 209, 0,		{ XK_Udiaeresis,	XK_Udiaeresis }},
  { 210, 0,		{ XK_Yacute,	XK_Yacute }},
  { 211, 0,		{ XK_THORN,	XK_THORN }},
  { 212, 0,		{ XK_ssharp }},
  { 213, 0,		{ XK_agrave,	XK_agrave }},
  { 214, 0,		{ XK_aacute,	XK_aacute }},
  { 215, 0,		{ XK_acircumflex,	XK_acircumflex }},
  { 216, 0,		{ XK_atilde,	XK_atilde }},
  { 217, 0,		{ XK_adiaeresis,	XK_adiaeresis }},
  { 218, 0,		{ XK_aring,	XK_aring }},
  { 219, 0,		{ XK_ae,	XK_ae }},
  { 220, 0,		{ XK_ccedilla,	XK_ccedilla }},
  { 221, 0,		{ XK_egrave,	XK_egrave }},
  { 222, 0,		{ XK_eacute,	XK_eacute }},
  { 223, 0,		{ XK_ecircumflex,	XK_ecircumflex }},
  { 224, 0,		{ XK_ediaeresis,	XK_ediaeresis }},
  { 225, 0,		{ XK_igrave,	XK_igrave }},
  { 226, 0,		{ XK_iacute,	XK_iacute }},
  { 227, 0,		{ XK_icircumflex,	XK_icircumflex }},
  { 228, 0,		{ XK_idiaeresis,	XK_idiaeresis }},
  { 229, 0,		{ XK_eth,	XK_eth }},
  { 230, 0,		{ XK_ntilde,	XK_ntilde }},
  { 231, 0,		{ XK_ograve,	XK_ograve }},
  { 232, 0,		{ XK_oacute,	XK_oacute }},
  { 233, 0,		{ XK_ocircumflex,	XK_ocircumflex }},
  { 234, 0,		{ XK_otilde,	XK_otilde }},
  { 235, 0,		{ XK_odiaeresis,	XK_odiaeresis }},
  { 236, 0,		{ XK_division }},
  { 237, 0,		{ XK_oslash,	XK_oslash }},
  { 238, 0,		{ XK_ugrave,	XK_ugrave }},
  { 239, 0,		{ XK_uacute,	XK_uacute }},
  { 240, 0,		{ XK_ucircumflex,	XK_ucircumflex }},
  { 241, 0,		{ XK_udiaeresis,	XK_udiaeresis }},
  { 242, 0,		{ XK_yacute,	XK_yacute }},
  { 243, 0,		{ XK_thorn,	XK_thorn }},
  { 244, 0,		{ XK_ydiaeresis }},
  };
