/*
 * Copyright 1996, 1997, 1998 Computing Research Labs,
 * New Mexico State University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COMPUTING RESEARCH LAB OR NEW MEXICO STATE UNIVERSITY BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
 * OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef lint
#ifdef __GNUC__
static char rcsid[] __attribute__ ((unused)) = "$Id: setup.c,v 1.1 1998/07/24 16:12:30 mleisher Exp $";
#else
static char rcsid[] = "$Id: setup.c,v 1.1 1998/07/24 16:12:30 mleisher Exp $";
#endif
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>
#include <Xm/DialogS.h>
#include "FGrid.h"
#include "xmbdfed.h"

typedef struct {
    Widget shell;
    Widget form;
    Widget hint;
    Widget ok;
} MXFEditorOtherOptions;

typedef struct {
    Widget shell;
    Widget form;
    Widget insert;
    Widget overwrite;
    Widget correct_metrics;
    Widget keep_unencoded;
    Widget keep_comments;
    Widget pad_cells;
    Widget psize;
    Widget hres;
    Widget vres;
    Widget prop;
    Widget mono;
    Widget cell;
    Widget save;
    Widget update;
    Boolean saved;
} MXFEditorSetup;

static unsigned long active_editor;
static MXFEditorSetup setup;
static MXFEditorOtherOptions other;

static void
#ifndef _NO_PROTO
EnableUpdate(Widget w, XtPointer client_data, XtPointer call_data)
#else
EnableUpdate(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    XtSetSensitive(setup.update, True);
}

static void
#ifndef _NO_PROTO
DoUpdate(Widget w, XtPointer client_data, XtPointer call_data)
#else
DoUpdate(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    MXFEditor *ed;
    unsigned long i;
    char *s;
    Arg av[1];

    ed = &editors[active_editor];

    xmbdfed_opts.overwrite_mode =
        (XmToggleButtonGetState(setup.overwrite) == True) ? 1 : 0;

    /*
     * Make sure this specific font grid has its overwrite flag set.
     */
    XtSetArg(av[0], XmNgridOverwriteMode, xmbdfed_opts.overwrite_mode);
    XtSetValues(ed->fgrid, av, 1);

    xmbdfed_opts.font_opts.correct_metrics =
        (XmToggleButtonGetState(setup.correct_metrics) == True) ? 1 : 0;
    xmbdfed_opts.font_opts.keep_unencoded =
        (XmToggleButtonGetState(setup.keep_unencoded) == True) ? 1 : 0;
    xmbdfed_opts.font_opts.keep_comments =
        (XmToggleButtonGetState(setup.keep_comments) == True) ? 1 : 0;
    xmbdfed_opts.font_opts.pad_cells =
        (XmToggleButtonGetState(setup.pad_cells) == True) ? 1 : 0;

    s = XmTextFieldGetString(setup.psize);
    xmbdfed_opts.font_opts.point_size = _bdf_atol(s, 0, 10);
    XtFree(s);

    s = XmTextFieldGetString(setup.hres);
    xmbdfed_opts.font_opts.resolution_x = _bdf_atoul(s, 0, 10);
    XtFree(s);

    s = XmTextFieldGetString(setup.vres);
    xmbdfed_opts.font_opts.resolution_y = _bdf_atoul(s, 0, 10);
    XtFree(s);

    if (XmToggleButtonGetState(setup.prop) == True)
      xmbdfed_opts.font_opts.font_spacing = BDF_PROPORTIONAL;
    else if (XmToggleButtonGetState(setup.mono) == True)
      xmbdfed_opts.font_opts.font_spacing = BDF_MONOSPACE;
    else
      xmbdfed_opts.font_opts.font_spacing = BDF_CHARCELL;

    /*
     * Make sure all editors have their "Auto Corrections" View menu option
     * enabled or disabled depending on the "Correct Metrics" option.
     */
    for (i = 0; i < num_editors; i++) {
        if (xmbdfed_opts.font_opts.correct_metrics != 0 &&
            XmuttFontGridFontMessages(editors[i].fgrid) != 0)
          XtSetSensitive(editors[i].viewmenu.acmsgs, True);
        else
          XtSetSensitive(editors[i].viewmenu.acmsgs, False);
    }

    /*
     * Update the glyph editors with a potentially new pixel size.
     */
    GlyphEditChangePixelSize(xmbdfed_opts.pixel_size);

    setup.saved = False;
    XtSetSensitive(setup.save, True);
    XtSetSensitive(setup.update, False);
}

static void
#ifndef _NO_PROTO
DoSave(Widget w, XtPointer client_data, XtPointer call_data)
#else
DoSave(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    FILE *out;
    char *home, path[BUFSIZ];

    if ((home = getenv("HOME")) != 0) {
        sprintf(path, "%s/.xmbdfedrc", home);
        if ((out = fopen(path, "w")) != 0) {
            /*
             * First, write the XmBDFEditor options.
             */
            fprintf(out, "#########################\n");
            fprintf(out, "#\n# XmBDFEditor options.\n#\n");
            fprintf(out, "#########################\n\n");
            fprintf(out, "#\n# Skip pages with no glyphs.\n#\n");
            if (xmbdfed_opts.no_blanks)
              fprintf(out, "skip_blank_pages true\n\n");
            else
              fprintf(out, "skip_blank_pages false\n\n");
            if (xmbdfed_opts.really_exit)
              fprintf(out, "really_exit true\n\n");
            else
              fprintf(out, "really_exit false\n\n");
            if (xmbdfed_opts.overwrite_mode)
              fprintf(out, "grid_overwrite_mode true\n\n");
            else
              fprintf(out, "grid_overwrite_mode false\n\n");

            if (xmbdfed_opts.accelerator != 0)
              fprintf(out, "close_accelerator %s\n\n",
                      xmbdfed_opts.accelerator);
            if (xmbdfed_opts.accelerator_text != 0)
              fprintf(out, "close_accelerator_text %s\n\n",
                      xmbdfed_opts.accelerator_text);

            fprintf(out, "pixel_size %ld\n\n", xmbdfed_opts.pixel_size);

            /*
             * The save the BDF specific options.
             */
            fprintf(out, "#########################\n");
            fprintf(out, "#\n# BDF font options.\n#\n");
            fprintf(out, "#########################\n\n");
            bdf_save_options(out, &xmbdfed_opts.font_opts);
            fclose(out);
            setup.saved = True;
        } else
          ErrorDialog("Unable to save setup!");
    } else
      ErrorDialog("Unable to locate user home directory!");

    if (setup.saved == True)
      XtSetSensitive(setup.save, False);
}

static void
#ifndef _NO_PROTO
SetTTFHint(Widget w, XtPointer client_data, XtPointer call_data)
#else
SetTTFHint(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    XmToggleButtonCallbackStruct *cb;

    cb = (XmToggleButtonCallbackStruct *) call_data;
    xmbdfed_opts.font_opts.ttf_hint = (cb->set == True) ? 1 : 0;
    XtSetSensitive(setup.update, True);
}

static void
#ifndef _NO_PROTO
SetPixelSize(Widget w, XtPointer client_data, XtPointer call_data)
#else
SetPixelSize(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    xmbdfed_opts.pixel_size = (unsigned long) client_data;
    XtSetSensitive(setup.update, True);
}

static void
#ifndef _NO_PROTO
DoOtherOptions(Widget w, XtPointer client_data, XtPointer call_data)
#else
DoOtherOptions(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    int i;
    Widget frame, opts, pdown, label, pb;
    XmString s;
    Cardinal ac;
    Arg av[10];

    if (other.shell == 0) {
        sprintf(title, "%s - Other Options", app_name);
        ac = 0;
        XtSetArg(av[ac], XmNtitle, title); ac++;
        XtSetArg(av[ac], XmNallowShellResize, True); ac++;
        XtSetArg(av[ac], XmNdeleteResponse, XmUNMAP); ac++;
        other.shell = XtCreatePopupShell("xmbdfed_options_shell",
                                         xmDialogShellWidgetClass, top,
                                         av, ac);

        ac = 0;
        XtSetArg(av[ac], XmNverticalSpacing, 5); ac++;
        XtSetArg(av[ac], XmNmarginWidth, 2); ac++;
        XtSetArg(av[ac], XmNmarginHeight, 2); ac++;
        other.form = XtCreateWidget("xmbdfed_other_form", xmFormWidgetClass,
                                    other.shell, av, ac);

        ac = 0;
        XtSetArg(av[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
        XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        frame = XtCreateManagedWidget("xmbdfed_other_ttf_frame",
                                      xmFrameWidgetClass, other.form, av, ac);

        ac = 0;
        XtSetArg(av[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
        label = XtCreateManagedWidget("True Type Options", xmLabelWidgetClass,
                                      frame, av, ac);

        if (xmbdfed_opts.font_opts.ttf_hint)
          XtSetArg(av[0], XmNset, True);
        else
          XtSetArg(av[0], XmNset, False);
        other.hint = XtCreateManagedWidget("Hint Glyphs",
                                           xmToggleButtonWidgetClass, frame,
                                           av, 1);
        XtAddCallback(other.hint, XmNvalueChangedCallback, SetTTFHint, 0);

        ac = 0;
        XtSetArg(av[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
        XtSetArg(av[ac], XmNtopWidget, frame); ac++;
        XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        frame = XtCreateManagedWidget("xmbdfed_other_gedit_frame",
                                      xmFrameWidgetClass, other.form, av, ac);

        ac = 0;
        XtSetArg(av[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
        label = XtCreateManagedWidget("Glyph Editor Options",
                                      xmLabelWidgetClass, frame, av, ac);

        s = XmStringCreateSimple("Pixel Size:");
        ac = 0;
        XtSetArg(av[ac], XmNlabelString, s); ac++;
        opts = XmCreateOptionMenu(frame, "xmbdfed_other_pixel_size", av, ac);
        XmStringFree(s);

        pdown = XmCreatePulldownMenu(opts, "xmbdfed_pixel_sizes", 0, 0);

        ac = 0;
        XtSetArg(av[ac], XmNsubMenuId, pdown); ac++;
        XtSetValues(opts, av, ac);
        for (i = 2; i <= 10; i++) {
            sprintf(name, "%dx%d", i, i);
            pb = XtCreateManagedWidget(name, xmPushButtonWidgetClass, pdown,
                                       0, 0);
            XtAddCallback(pb, XmNactivateCallback, SetPixelSize,
                          (XtPointer) i);
            if (i == xmbdfed_opts.pixel_size) {
                XtSetArg(av[0], XmNmenuHistory, pb);
                XtSetValues(opts, av, 1);
            }
        }

        XtManageChild(opts);

        ac = 0;
        XtSetArg(av[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
        XtSetArg(av[ac], XmNtopWidget, frame); ac++;
        XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(av[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
        frame = XtCreateManagedWidget("xmbdfed_other_button_frame",
                                      xmFrameWidgetClass, other.form, av, ac);

        pb = XtCreateManagedWidget("Close", xmPushButtonWidgetClass, frame,
                                   0, 0);
        XtAddCallback(pb, XmNactivateCallback, DoClose,
                      (XtPointer) other.shell);
    }

    XtManageChild(other.form);
    XtPopup(other.shell, XtGrabNone);
}

static void
#ifndef _NO_PROTO
BuildSetupDialog(void)
#else
BuildSetupDialog()
#endif
{
    Widget frame, rc, label, pb, form;
    Cardinal ac;
    Arg av[10];

    setup.saved = True;

    sprintf(title, "%s - Configuration", app_name);
    ac = 0;
    XtSetArg(av[ac], XmNtitle, title); ac++;
    XtSetArg(av[ac], XmNallowShellResize, True); ac++;
    XtSetArg(av[ac], XmNdeleteResponse, XmUNMAP); ac++;
    setup.shell = XtCreatePopupShell("xmbdfed_setup_shell",
                                     xmDialogShellWidgetClass, top, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNverticalSpacing, 5); ac++;
    XtSetArg(av[ac], XmNmarginWidth, 2); ac++;
    XtSetArg(av[ac], XmNmarginHeight, 2); ac++;
    setup.form = XtCreateWidget("xmbdfed_setup_form", xmFormWidgetClass,
                                setup.shell, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    frame = XtCreateManagedWidget("xmbdfed_setup_edit_frame",
                                  xmFrameWidgetClass, setup.form, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
    label = XtCreateManagedWidget("Grid Edit Options", xmLabelWidgetClass,
                                  frame, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNradioBehavior, True); ac++;
    XtSetArg(av[ac], XmNorientation, XmHORIZONTAL); ac++;
    rc = XtCreateManagedWidget("xmbdfed_setup_edit_rowcol",
                               xmRowColumnWidgetClass, frame, av, ac);

    setup.insert = XtCreateManagedWidget("Insert Mode",
                                       xmToggleButtonWidgetClass, rc, 0, 0);
    XtAddCallback(setup.insert, XmNvalueChangedCallback, EnableUpdate, 0);

    setup.overwrite = XtCreateManagedWidget("Overwrite Mode",
                                       xmToggleButtonWidgetClass, rc, 0, 0);
    XtAddCallback(setup.overwrite, XmNvalueChangedCallback, EnableUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg(av[ac], XmNtopWidget, frame); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    frame = XtCreateManagedWidget("xmbdfed_setup_fload_frame",
                                  xmFrameWidgetClass, setup.form, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
    label = XtCreateManagedWidget("Font Load/Save Options", xmLabelWidgetClass,
                                  frame, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNorientation, XmHORIZONTAL); ac++;
    XtSetArg(av[ac], XmNnumColumns, 2); ac++;
    XtSetArg(av[ac], XmNpacking, XmPACK_COLUMN); ac++;
    rc = XtCreateManagedWidget("xmbdfed_setup_fload_rowcol",
                               xmRowColumnWidgetClass, frame, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNvisibleWhenOff, True); ac++;
    setup.correct_metrics = XtCreateManagedWidget("Correct Metrics",
                                                  xmToggleButtonWidgetClass,
                                                  rc, av, ac);
    XtAddCallback(setup.correct_metrics, XmNvalueChangedCallback,
                  EnableUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNvisibleWhenOff, True); ac++;
    setup.keep_unencoded = XtCreateManagedWidget("Keep Unencoded",
                                                 xmToggleButtonWidgetClass,
                                                 rc, av, ac);
    XtAddCallback(setup.keep_unencoded, XmNvalueChangedCallback,
                  EnableUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNvisibleWhenOff, True); ac++;
    setup.keep_comments = XtCreateManagedWidget("Keep Comments",
                                                xmToggleButtonWidgetClass,
                                                rc, av, ac);
    XtAddCallback(setup.keep_comments, XmNvalueChangedCallback,
                  EnableUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNvisibleWhenOff, True); ac++;
    setup.pad_cells = XtCreateManagedWidget("Pad Character Cells",
                                            xmToggleButtonWidgetClass,
                                            rc, av, ac);
    XtAddCallback(setup.pad_cells, XmNvalueChangedCallback,
                  EnableUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg(av[ac], XmNtopWidget, frame); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    frame = XtCreateManagedWidget("xmbdfed_setup_fsize_frame",
                                  xmFrameWidgetClass, setup.form, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
    label = XtCreateManagedWidget("New Font Size Options", xmLabelWidgetClass,
                                  frame, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNorientation, XmHORIZONTAL); ac++;
    XtSetArg(av[ac], XmNpacking, XmPACK_COLUMN); ac++;
    XtSetArg(av[ac], XmNnumColumns, 3); ac++;
    XtSetArg(av[ac], XmNisAligned, True); ac++;
    XtSetArg(av[ac], XmNentryAlignment, XmALIGNMENT_END); ac++;
    rc = XtCreateManagedWidget("xmbdfed_setup_fsize_rowcol",
                               xmRowColumnWidgetClass, frame, av, ac);

    label = XtCreateManagedWidget("Point Size:", xmLabelWidgetClass, rc,
                                  0, 0);
    ac = 0;
    XtSetArg(av[ac], XmNcolumns, 6); ac++;
    setup.psize =
        XtCreateManagedWidget("xmbdfed_setup_point_size",
                              xmTextFieldWidgetClass, rc, av, ac);
    XtAddCallback(setup.psize, XmNvalueChangedCallback, EnableUpdate, 0);

    label = XtCreateManagedWidget("Horizontal Resolution:",
                                  xmLabelWidgetClass, rc, 0, 0);
    setup.hres =
        XtCreateManagedWidget("xmbdfed_setup_resolution_x",
                              xmTextFieldWidgetClass, rc, av, ac);
    XtAddCallback(setup.hres, XmNvalueChangedCallback, EnableUpdate, 0);

    label = XtCreateManagedWidget("Vertical Resolution:",
                                  xmLabelWidgetClass, rc, 0, 0);
    setup.vres =
        XtCreateManagedWidget("xmbdfed_setup_resolution_y",
                              xmTextFieldWidgetClass, rc, av, ac);
    XtAddCallback(setup.vres, XmNvalueChangedCallback, EnableUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg(av[ac], XmNtopWidget, frame); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    frame = XtCreateManagedWidget("xmbdfed_setup_fspace_frame",
                                  xmFrameWidgetClass, setup.form, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNchildType, XmFRAME_TITLE_CHILD); ac++;
    label = XtCreateManagedWidget("New Font Spacing Options",
                                  xmLabelWidgetClass, frame, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNradioBehavior, True); ac++;
    XtSetArg(av[ac], XmNorientation, XmHORIZONTAL); ac++;
    rc = XtCreateManagedWidget("xmbdfed_setup_fspace_rowcol",
                               xmRowColumnWidgetClass, frame, av, ac);

    setup.prop = XtCreateManagedWidget("Proportional",
                                       xmToggleButtonWidgetClass, rc, 0, 0);
    XtAddCallback(setup.prop, XmNvalueChangedCallback, EnableUpdate, 0);

    setup.mono = XtCreateManagedWidget("Monospace",
                                       xmToggleButtonWidgetClass, rc, 0, 0);
    XtAddCallback(setup.mono, XmNvalueChangedCallback, EnableUpdate, 0);

    setup.cell = XtCreateManagedWidget("Character Cell",
                                       xmToggleButtonWidgetClass, rc, 0, 0);
    XtAddCallback(setup.cell, XmNvalueChangedCallback, EnableUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg(av[ac], XmNtopWidget, frame); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    frame = XtCreateManagedWidget("xmbdfed_setup_button_frame",
                                  xmFrameWidgetClass, setup.form, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNfractionBase, 4); ac++;
    form = XtCreateManagedWidget("xmbdfed_setup_button_form",
                                 xmFormWidgetClass, frame, av, ac);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNleftPosition, 0); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNrightPosition, 1); ac++;
    XtSetArg(av[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    setup.update = XtCreateManagedWidget("Update", xmPushButtonWidgetClass,
                                         form, av, ac);
    XtAddCallback(setup.update, XmNactivateCallback, DoUpdate, 0);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNleftPosition, 1); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNrightPosition, 2); ac++;
    XtSetArg(av[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    setup.save = XtCreateManagedWidget("Save Setup", xmPushButtonWidgetClass,
                                       form, av, ac);
    XtAddCallback(setup.save, XmNactivateCallback, DoSave, 0);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNleftPosition, 2); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNrightPosition, 3); ac++;
    XtSetArg(av[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    pb = XtCreateManagedWidget("Other Options", xmPushButtonWidgetClass, form,
                               av, ac);
    XtAddCallback(pb, XmNactivateCallback, DoOtherOptions, 0);

    ac = 0;
    XtSetArg(av[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(av[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNleftPosition, 3); ac++;
    XtSetArg(av[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(av[ac], XmNrightPosition, 4); ac++;
    XtSetArg(av[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    pb = XtCreateManagedWidget("Close", xmPushButtonWidgetClass, form, av, ac);
    XtAddCallback(pb, XmNactivateCallback, DoClose, (XtPointer) setup.shell);
}

void
#ifndef _NO_PROTO
DoSetupDialog(Widget w, XtPointer client_data, XtPointer call_data)
#else
DoSetupDialog(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
#endif
{
    char nbuf[20];

    if (setup.shell == 0)
      BuildSetupDialog();

    if (xmbdfed_opts.overwrite_mode)
      XmToggleButtonSetState(setup.overwrite, True, False);
    else
      XmToggleButtonSetState(setup.insert, True, False);

    if (xmbdfed_opts.font_opts.correct_metrics)
      XmToggleButtonSetState(setup.correct_metrics, True, False);

    if (xmbdfed_opts.font_opts.keep_unencoded)
      XmToggleButtonSetState(setup.keep_unencoded, True, False);

    if (xmbdfed_opts.font_opts.keep_comments)
      XmToggleButtonSetState(setup.keep_comments, True, False);

    if (xmbdfed_opts.font_opts.pad_cells)
      XmToggleButtonSetState(setup.pad_cells, True, False);

    sprintf(nbuf, "%ld", xmbdfed_opts.font_opts.point_size);
    XmTextFieldSetString(setup.psize, nbuf);

    sprintf(nbuf, "%ld", xmbdfed_opts.font_opts.resolution_x);
    XmTextFieldSetString(setup.hres, nbuf);

    sprintf(nbuf, "%ld", xmbdfed_opts.font_opts.resolution_y);
    XmTextFieldSetString(setup.vres, nbuf);

    if (xmbdfed_opts.font_opts.font_spacing == BDF_PROPORTIONAL)
      XmToggleButtonSetState(setup.prop, True, True);
    else if (xmbdfed_opts.font_opts.font_spacing == BDF_MONOSPACE)
      XmToggleButtonSetState(setup.mono, True, True);
    else
      XmToggleButtonSetState(setup.cell, True, True);

    if (setup.saved == False)
      XtSetSensitive(setup.save, True);
    else
      XtSetSensitive(setup.save, False);
    XtSetSensitive(setup.update, False);

    /*
     * Set the active editor.
     */
    active_editor = (unsigned long) client_data;

    XtManageChild(setup.form);
    XtPopup(setup.shell, XtGrabNone);
}
