// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: pkglistvect.cc,v 1.6 1997/06/01 04:30:20 jgg Exp $
/* ######################################################################

   Package List Vector - Ordered Package list in main memory, stored in a 
                         vector

   The internal storage is a STL vector template of pkgSCtrlInfo objects.
   priv_iterator is a special derived class which contains the current 
   and end point of the iteration.
   
   A word of warning, like the STL vector class if a new item is inserted 
   into the vector all of the iterators become invalid.
   
   ##################################################################### */
									/*}}}*/

#include <pkglib/pkglistvect.h>

// PkgListVect::Find - Locate a package by name				/*{{{*/
// ---------------------------------------------------------------------
/* Locate a package by the name field. */
pkgSPkgCtrlInfo pkgPkgListVect::Find(string Name) const
{
   // Construct a Package element and then locate it.
   pkgElmPackage Target;
   Target.Value(Name);
   
   vector<pkgSPkgCtrlInfo>::const_iterator I = List.begin();
   for (;I != List.end(); I++)
      if ((*I)->Find(Target) != 0)
	 return *I;

   return 0;
}
									/*}}}*/
// PkgListVect::Find - Locate a package by element			/*{{{*/
// ---------------------------------------------------------------------
/* Locate a package by the name field. */
pkgSPkgCtrlInfo pkgPkgListVect::Find(const pkgElement &Target) const
{
   // Search for any matches of the element
   vector<pkgSPkgCtrlInfo>::const_iterator I = List.begin();
   for (;I != List.end(); I++)
      if ((*I)->Find(Target) != 0)
	 return *I;

   return 0;
}
									/*}}}*/
// PkgListVect::begin - Start iteration					/*{{{*/
// ---------------------------------------------------------------------
/* The iterator class will ensure our private iterator is erased */
pkgPkgList::iterator pkgPkgListVect::begin()
{
   // Return the end iterator
   if (List.size() == 0)
      return end();
   
   return pkgPkgList::iterator(new priv_iterator(List));
}
									/*}}}*/
// PkgListVect::insert - Insert an item at an iterator position		/*{{{*/
// ---------------------------------------------------------------------
/* */
void pkgPkgListVect::insert(pkgPkgList::iterator,pkgSPkgCtrlInfo &)
{
}
									/*}}}*/
// PkgListVect::priv_iterator::Next - ++ the iterator			/*{{{*/
// ---------------------------------------------------------------------
/* False is returned when the iterator is at it's end */
bool pkgPkgListVect::priv_iterator::Next()
{
   Itr++;
   Cur = *Itr;
   return !(Itr == End);
}
									/*}}}*/
// PkgListVect::priv_iterator::priv_iterator - Constructor		/*{{{*/
// ---------------------------------------------------------------------
/* Only the start/end of the iteration is stored in the iterator. */
pkgPkgListVect::priv_iterator::priv_iterator(vector<pkgSPkgCtrlInfo> &List)
{
   Itr = List.begin();
   End = List.end();
   Cur = *Itr;
}
									/*}}}*/
