static char host_ck_rcsid[]="$Id: host_ck.c,v 1.2 1997/04/11 18:47:10 green Exp $";

/*----------------------------------------------------
 * host_ck.c Tom Green Thu Jun 09 14:32:00 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: host_ck.c,v $
 * Revision 1.2  1997/04/11 18:47:10  green
 * changed getdomainname() to dqs_getdomainname()
 *
 * Revision 1.1.1.1  1997/04/10 15:10:26  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 1.7  1996/06/27 01:55:11  nrl
 * changes to accomodate osf gcc
 *
 * Revision 1.5  1994/06/19  18:55:04  green
 * don't write "THE" conf_file/resolve_file as it overwrites when
 * "config -f"
 *
 * cleaned up host_ck.c do_host_ck.c
 *
 * Revision 1.4  1994/06/17  18:34:32  green
 * misc...
 *
 * Revision 1.2  1994/06/13  13:44:29  green
 * moved the functions out of host_ck.c into do_host_ck.c so that
 * config and host_ck could share the same code.
 *
 * added Joe's get_res_ports() to do_host_ck.c
 *
 * Revision 1.1  1994/06/09  18:54:42  green
 * added "host_ck.c" to provide a sanity checker of hostname, peername,
 * DNS/YP/etc_hosts configurations on host.  This program will inform
 * the user as to how to set up the configuration and provide a
 * pre-cursory warning of machines which are "ill-configed".(by this I
 * mean OS configurations...)
 *
 * note that "config" utilizes the same sort of routines to build a
 * configuration - but you might not want to run config on all slaves
 *
 *
 *--------------------------------------------------*/

#define MAINPROGRAM
#include "../SRC/h.h"
#include "../SRC/def.h"
#include "../SRC/dqs.h"
#include "../SRC/struct.h"
#include "../SRC/func.h"
#include "../SRC/globals.h"
#include "../SRC/dqs_errno.h"

main(argc,argv)
int argc;
char **argv;
{
     int  port=8888;
     char host_name[MAX_STRING_SIZE];
     char peer_name[MAX_STRING_SIZE];
     char domain_name[MAX_STRING_SIZE];

     if (gethostname(host_name,MAX_STRING_SIZE)) 
     {
          perror("gethostname() failure");
          exit(-1);
     }

     if (dqs_getdomainname(domain_name,MAX_STRING_SIZE))
          perror("dqs_getdomainname() failure - continuing");

     port=start_server(port);
     start_client(port,host_name,peer_name);

     printf("\n\nhostname\t>%s<\npeername\t>%s<\ndomainname\t>%s<\n\n",
            host_name,peer_name,domain_name);

     fflush(stdout);

     if (!domain_name[0])
     {
	  fprintf(stderr,"ERROR!: domainname NOT SET!\n");
	  fprintf(stderr,"\tsetting cell_name to hostname\n");
	  sprintf(domain_name,"%s",host_name);
     }

     if (!strstr(host_name,domain_name))
     fprintf(stderr,"warning: unqualified hostname\n");

     if (!strstr(peer_name,domain_name))
     fprintf(stderr,"warning: unqualified peername\n");

     fflush(stderr);

     printf("\n\n***************************************************\n");
     printf("if \"STATIC_CONFIGURATION==TRUE\" in dqs.h\n");
     printf("dqs.h\n\n\t#define DEFAULT_CELL\t\"%s\"\n",domain_name);
     printf("\n-----------------------------------------------------\n");
     printf("else if \"STATIC_CONFIGURATION==FALSE\" in dqs.h\n");
     printf("conf_file\n\n\tDEFAULT_CELL\t%s\n",domain_name);
     if (strcmp(host_name,peer_name))
     {
	  printf("\n\n***************************************************\n");
	  printf("dqs.h\n\n\t#define DEFAULT_HOST\t\"%s\"\n",peer_name);
     }
     printf("\n*****************************************************\n");
     printf("resolve_file\n\n");
     printf("%s %s %s NONE NONE\n",
	    domain_name,host_name,peer_name);
     printf("\n*****************************************************\n");
     printf("if you qmaster host has multiple network devices,\nreplace the \"NONE\" fields(eg: fields 4/5 in the\nresolve_file) with the corresponding hostname(s)\n"); 
     printf("\n*****************************************************\n");
     printf("queues configured for this host should use\n\n");
     printf("\thostname\t%s\n",host_name);

     fflush(stdout);

     printf("\n");
     fflush(stderr);
     fflush(stdout);
  
}

