static char qdel_rcsid[]="qdel.c,v 1.2 1994/11/28 16:55:34 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  qdel.c,v
 * Revision 1.2  1994/11/28  16:55:34  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qdel_popup;
static Widget           widget_qdelrc;
static Widget           widget_qdellabel;
static Widget           widget_qdelframe;
static Widget           widget_qdelmenu;
static Widget           widget_qdelmain;
static Widget           widget_qdelexec;
static Widget           widget_qdelclear;
static Widget           widget_qdelclose;
static Widget           widget_qdelseparator;
static Widget           widget_qdelopt;

struct optionstruct qdelmenu[]={
  0,"Help   ","-help",(int)FLAGTYPE,"False",NULL,
  0,"Verify ","-verify",(int)FLAGTYPE,"False",NULL,
  0,"Job ID ",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qdelexec - Activate callback for exec
 */
XtCallbackProc pb_qdelexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QDEL_BINARY,qdelmenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qdelclear - Activate callback for clear
 */
XtCallbackProc pb_qdelclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qdelmenu);
}


/***********************************************************
 * pb_qdelclose - Activate callback for close
 */

XtCallbackProc pb_qdelclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qdel_dialog - Create widgets used for the qdel menu
 */
int create_qdel_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qdel_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qdel_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qdel_form = XtCreateManagedWidget("form", formWidgetClass, qdel_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qdellabel=
	XtCreateManagedWidget("Qdel",labelWidgetClass,qdel_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qdellabel); ii++;
  widget_qdelmain=XtCreateManagedWidget("box",formWidgetClass,qdel_form,
                                        args,ii);
  exec=QmonAddButtonN(widget_qdelmain,NULL,"Exec",(XtCallbackProc)pb_qdelexec,NULL);
  clear=QmonAddButtonN(widget_qdelmain,exec,"Clear",(XtCallbackProc)pb_qdelclear,NULL);
  close=QmonAddButtonN(widget_qdelmain,clear,"Close",(XtCallbackProc)pb_qdelclose,NULL);

  widget_qdelopt=createmenuoptions(qdel_form,widget_qdelmain,qdelmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qdel - Open the qdel menu
 */
int openwidget_qdel()
{
  XtPopup(qdel_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qdel - Close the qdel menu
 */
int closewidget_qdel()
{
  XtPopdown(qdel_popup);
}
