
/* WARNING -- This C source program generated by Wart preprocessor. */
/* Do not edit this file; edit the Wart-format source file instead, */
/* and then run it through Wart to produce a new C source file.     */

/* Wart Version Info: */
char *wartv = "Wart Version 2A(012) 9 February 1998";

char *protv =                                                     /* -*-C-*- */
"C-Kermit Protocol Module 6.1.106, 8 February 1998";

/* C K C P R O  -- C-Kermit Protocol Module, in Wart preprocessor notation. */
/*
  Author: Frank da Cruz <fdc@columbia.edu>,
  Columbia University Academic Information Systems, New York City.

  Copyright (C) 1985, 1998, Trustees of Columbia University in the City of New
  York.  The C-Kermit software may not be, in whole or in part, licensed or
  sold for profit as a software product itself, nor may it be included in or
  distributed with commercial products or otherwise distributed by commercial
  concerns to their clients or customers without written permission of the
  Office of Kermit Development and Distribution, Columbia University.  This
  copyright notice must not be removed, altered, or obscured.
*/
#include "ckcsym.h"
#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
#ifdef OS2
#ifndef NT
#define INCL_NOPM
#define INCL_VIO			/* Needed for ckocon.h */
#include <os2.h> 
#undef COMMENT
#endif /* NT */
#include "ckocon.h"
#endif /* OS2 */

/*
 Note -- This file may also be preprocessed by the UNIX Lex program, but 
 you must indent the above #include statements before using Lex, and then
 restore them to the left margin in the resulting C program before compilation.
 Also, the invocation of the "wart()" function below must be replaced by an
 invocation  of the "yylex()" function.  It might also be necessary to remove
 comments in the %%...%% section.
*/

/* State definitions for Wart (or Lex) */
#define ipkt 1
#define rfile 2
#define rattr 3
#define rdata 4
#define ssinit 5
#define ssfile 6
#define ssattr 7
#define ssdata 8
#define sseof 9
#define sseot 10
#define serve 11
#define generic 12
#define get 13
#define rgen 14

/* External C-Kermit variable declarations */
  extern char *versio, *srvtxt, *cmarg, *cmarg2, **cmlist, *rf_err;
  extern char * snd_move, * snd_rename;
  extern char filnam[], fspec[], ttname[];
  extern CHAR sstate, *rpar(), *srvptr, *data;
  extern int timint, rtimo, nfils, hcflg, xflg, flow, mdmtyp, network;
  extern int rejection, moving, fncact, bye_active, urserver;
  extern int protocol, prefixing, filcnt, carrier, fnspath;
  extern int recursive;
  extern struct ck_p ptab[];
  extern int remfile, rempipe, xferstat, filestatus;
  extern char * remdest;

static int s_timint = -1;		/* For saving timeout value */

#ifdef STREAMING
extern int streaming, streamok;
static int cancel = 0;

static VOID
streamon() {
    if (streamok) {
	debug(F100,"streamon","",0);
	streaming = 1;
	timint = 0;			/* No timeouts while streaming. */
    }
}

static VOID
streamoff() {
    if (streaming) {
	debug(F100,"streamoff","",0);
	streaming = 0;
	timint = s_timint;		/* Restore timeout */
    }
}
#else
#define streamon()
#define streamoff()
#endif /* STREAMING */

#ifndef NOSPL
_PROTOTYP( int addmac, (char *, char *) );
_PROTOTYP( int zzstring, (char *, char **, int *) );
#endif /* NOSPL */
#ifndef NOICP
_PROTOTYP( int cmdsrc, (void) );
#endif /* NOICP */

#ifndef NOSERVER
  extern char * x_user, * x_passwd, * x_acct;
  extern int x_login, x_logged;
#endif /* NOSERVER */

#ifdef CK_SPEED
  extern int ttnproto;			/* Network protocol */
  extern short ctlp[];			/* Control-character prefix table */
#endif /* CK_SPEED */

#ifdef NETCONN
#ifdef TCPSOCKET
#include "ckcnet.h"
  extern int me_binary, tn_b_nlm, tn_nlm;
#endif /* TCPSOCKET */
#endif /* NETCONN */

#ifdef TCPSOCKET
#ifndef NOLISTEN
  extern int tcpsrfd;
#endif /* NOLISTEN */
#endif /* TCPSOCKET */

  extern int cxseen, czseen, server, srvdis, local, displa, bctu, bctr, bctl;
  extern int quiet, tsecs, parity, backgrd, nakstate, atcapu, wslotn, winlo;
  extern int wslots, success, xitsta, rprintf, discard, cdtimo, keep, fdispla;
  extern int timef, stdinf, rscapu, sendmode, epktflg, epktrcvd, epktsent;
  extern int binary, fncnv;
  extern long speed, ffc, crc16, calibrate, dest;
  extern char *DIRCMD, *DIRCM2, *DELCMD, *TYPCMD, *SPACMD, *SPACM2, *WHOCMD;
  extern CHAR *rdatap;
  extern struct zattr iattr;

#ifdef VMS
  extern int batch;
#endif /* VMS */

#ifdef GFTIMER
  extern CKFLOAT fptsecs;
#endif /* GFTIMER */

  extern CHAR *srvcmd;
  extern CHAR *epktmsg;

#ifdef CK_TMPDIR
extern int f_tmpdir;			/* Directory changed temporarily */
extern char savdir[];			/* For saving current directory */
extern char * dldir;
#endif /* CK_TMPDIR */

#ifndef NOSPL
  extern int cmdlvl;
  char querybuf[QBUFL+1] = { NUL, NUL }; /* QUERY response buffer */
  char *qbufp = querybuf;		/* Pointer to it */
  int qbufn = 0;			/* Length of data in it */
  extern int query;			/* Query-active flag */
#else
  extern int tlevel;
#endif /* NOSPL */

#ifdef NT
  extern int escape;
#endif /* NT */
/*
  If the following flag is nonzero when the protocol module is entered,
  then server mode persists for exactly one transaction, rather than
  looping until BYE or FINISH is received.
*/
int justone = 0;

static int r_save = -1;
static int p_save = -1;

_PROTOTYP(static VOID xxproto,(void));
_PROTOTYP(static int sgetinit,(int));
_PROTOTYP(int sndspace,(int));
_PROTOTYP(int wart,(void));

/* Flags for the ENABLE and DISABLE commands */
extern int
  en_cpy, en_cwd, en_del, en_dir, en_fin, en_get, en_bye, en_mai, en_pri,
  en_hos, en_ren, en_sen, en_spa, en_set, en_typ, en_who, en_ret,
  en_mkd, en_rmd;
#ifndef NOSPL
extern int en_asg, en_que;
#endif /* NOSPL */

/* Global variables declared here */

  int what = W_INIT;			/* What I am doing */
  int whatru = 0;			/* What are you */

/* Local variables */

  static char vstate = 0;  		/* Saved State   */
  static char vcmd = 0;    		/* Saved Command */
  static int reget = 0;			/* Flag for executing REGET */
  static int retrieve = 0;		/* Flag for executing RETRIEVE */

  static int x;				/* General-purpose integer */
  static char *s;			/* General-purpose string pointer */

/* Macros - Note, BEGIN is predefined by Wart (and Lex) as "state = ", */
/* BEGIN is NOT a GOTO! */
#define TINIT if (tinit() < 0) return(-9)
#define SERVE TINIT; resetc(); nakstate=1; what=W_NOTHING; cmarg2=""; \
sendmode=SM_SEND; recursive=r_save; fnspath=p_save; BEGIN serve;
#define RESUME if (!server) { return(0); } else \
if (justone) { justone=0; return(0); } else { SERVE; }
#ifdef GFTIMER
#define QUIT x=quiet; quiet=1; clsif(); clsof(1); tsecs=gtimer(); \
 fptsecs=gftimer(); quiet=x; return(success)
#else
#define QUIT x=quiet; quiet=1; clsif(); clsof(1); tsecs=gtimer(); quiet=x; \
 return(success)
#endif /* GFTIMER */


#define BEGIN state =

int state = 0;

int
wart()
{
    int c,actno;
    extern char tbl[];
    while (1) {
	c = input() - 32;
        if (c < 0 || c > 95) c = 0;
	if ((actno = tbl[c + state*96]) != -1)
	    switch(actno) {
case 1:
    { TINIT;				/* Send file(s) */
    if (sinit() > 0) BEGIN ssinit;
       else RESUME; }
    break;
case 2:
    { TINIT; nakstate = 1; BEGIN get; }
    break;
case 3:
    {					/* Client sends a GET command */
    TINIT;
    vstate = get;
    reget = 0;
    retrieve = 0;
    vcmd = 0;
    if (sipkt('I') >= 0)
      BEGIN ipkt;
    else
      RESUME;
}
    break;
case 4:
    {					/* Client sends a RETRIEVE command */
    TINIT;
    vstate = get;
    reget = 0;
    retrieve = 1;
    vcmd = 0;
    if (sipkt('I') >= 0)
      BEGIN ipkt;
    else
      RESUME;
}
    break;
case 5:
    {					/* Client sends a REGET command */
    TINIT;
    vstate = get;
    reget = 1;
    retrieve = 0;
    vcmd = 0;
    if (sipkt('I') >= 0)
      BEGIN ipkt;
    else
      RESUME;
}
    break;
case 6:
    {					/* Client sends a Host command */
    TINIT;
    vstate = rgen;
    vcmd = 'C';
    if (sipkt('I') >= 0)
      BEGIN ipkt;
    else
      RESUME;
}
    break;
case 7:
    { TINIT;				/* Client sends a Kermit command */
    vstate = rgen;
    vcmd = 'K';
    if (sipkt('I') >= 0)
      BEGIN ipkt;
    else
      RESUME;
}
    break;
case 8:
    {					/* Client sends a REMOTE command */
    TINIT;
    vstate = rgen;
    vcmd = 'G';
    if (sipkt('I') >= 0)
      BEGIN ipkt;
    else
      RESUME;
}
    break;
case 9:
    {					/* Enter server mode */
    int x;
    x = justone;
    debug(F101,"x justone 1","",justone);
    SERVE;				/* tinit() clears justone... */
    debug(F101,"x justone 2","",justone);
    justone = x;
}
    break;
case 10:
    {
    int b1 = 0, b2 = 0;
    if (!data) TINIT;			/* "ABEND" -- Tell other side. */
#ifndef pdp11
    if (epktflg) {			/* If because of E-PACKET command */
	b1 = bctl; b2 = bctu;		/* Save block check type */
	bctl = bctu = 1;		/* set it to 1 */
    }
#endif /* pdp11 */
    errpkt((CHAR *)"User cancelled");	/* Send the packet */
#ifndef pdp11
    if (epktflg) {			/* Restore the block check */
	epktflg = 0;
	bctl = b1; bctu = b2;
    }
#endif /* pdp11 */
    success = 0;
    return(0);				/* Return from protocol. */
}
    break;
case 11:
    {			/* Receive Send-Init packet. */
#ifndef NOSERVER
    if (state == rgen)
      urserver = 1;
    if (state == serve && x_login && !x_logged) {
	errpkt((CHAR *)"Login required");
	SERVE;
    } else
#endif /* NOSERVER */
      if (state == serve && !ENABLED(en_sen)) { /* Not in server mode */
	errpkt((CHAR *)"SEND disabled"); /* when SEND is disabled. */
	RESUME;
    } else {				/* OK to go ahead. */
#ifdef CK_TMPDIR
	if (dldir && !f_tmpdir) {	/* If they have a download directory */
	    debug(F110,"receive download dir",dldir,0);
	    if (s = zgtdir()) {		/* Get current directory */
		debug(F110,"receive current dir",s,0);
		if (zchdir(dldir)) {	/* Change to download directory */
		    debug(F100,"receive zchdir ok","",0);
		    strncpy(savdir,s,TMPDIRLEN);
		    f_tmpdir = 1;	/* Remember that we did this */
		} else
		  debug(F100,"receive zchdir failed","",0);
	    }
	}
#endif /* CK_TMPDIR */
	nakstate = 1;			/* Can send NAKs from here. */
	rinit(rdatap);			/* Set parameters */
	bctu = bctr;			/* Switch to agreed-upon block check */
	bctl = (bctu == 4) ? 2 : bctu;	/* Set block-check length */
	what = W_RECV;			/* Remember we're receiving */
	resetc();			/* Reset counters */
	rtimer();			/* Reset timer */
#ifdef GFTIMER
	rftimer();
#endif /* GFTIMER */
	streamon();
	BEGIN rfile;			/* Go into receive-file state */
    }
}
    break;
case 12:
    {				/* Get ack for I-packet */
    int x = 0;
    spar(rdatap);			/* Set parameters */
    winlo = 0;				/* Set window-low back to zero */
    urserver = 1;			/* So I know I'm talking to a server */
    if (vcmd) {				/* If sending a generic command */
	TINIT;
	x = scmd(vcmd,(CHAR *)cmarg);	/* Do that */
	debug(F111,"Sent G packet",cmarg,x);
	vcmd = 0;			/* and then un-remember it. */
    } else if (vstate == get) {
	debug(F101,"REGET sstate","",sstate);
	x = srinit(reget, retrieve);	/* GET or REGET */
    }
    if (x < 0) {			/* If command was too long */
	errpkt((CHAR *)"Command too long for server"); /* cancel both sides. */
	success = 0;
	RESUME;
    } else {
	rtimer();			/* Reset the elapsed seconds timer. */
#ifdef GFTIMER
	rftimer();
#endif /* GFTIMER */
	winlo = 0;			/* Window back to 0, again. */
	nakstate = 1;			/* Can send NAKs from here. */
	BEGIN vstate;			/* Switch to desired state */
    }
}
    break;
case 13:
    {				/* Ignore Error reply to I packet */
    int x = 0;
    winlo = 0;				/* Set window-low back to zero */
    if (vcmd) {				/* In case other Kermit doesn't */
	TINIT;
	x = scmd(vcmd,(CHAR *)cmarg);	/* understand I-packets. */
	vcmd = 0;			/* Otherwise act as above... */
    } else if (vstate == get) x = srinit(reget, retrieve);
    if (x < 0) {			/* If command was too long */
	errpkt((CHAR *)"Command too long for server"); /* cancel both sides. */
	success = 0;
	RESUME;
    } else {
	winlo = 0;			/* Back to packet 0 again. */
	freerpkt(winlo);		/* Discard the Error packet. */
	nakstate = 1;			/* Can send NAKs from here. */
	BEGIN vstate;
    }
}
    break;
case 14:
    {		/* Resend of previous I-pkt ACK, same seq number! */
    srinit(reget, retrieve);		/* Send the GET packet again. */
}
    break;
case 15:
    {				/* Get I-packet */
#ifndef NOSERVER
    spar(rdatap);			/* Set parameters from it */
    ack1(rpar());			/* Respond with our own parameters */
    pktinit();				/* Reinitialize packet numbers */
#endif /* NOSERVER */
}
    break;
case 16:
    {				/* Get Receive-Init (GET) */
#ifndef NOSERVER
    if (x_login && !x_logged) {
	errpkt((CHAR *)"Login required");
	SERVE;
    } else if (sgetinit(0) < 0) {
	RESUME;
    } else {
	BEGIN ssinit;
    }
#endif /* NOSERVER */
}
    break;
case 17:
    {				/* GET and DELETE ("retrieve") */
#ifndef NOSERVER
    if (x_login && !x_logged) {
	errpkt((CHAR *)"Login required");
	RESUME;
    } else if (!ENABLED(en_del)) {
	errpkt((CHAR *)"Deleting files is disabled");
	RESUME;
    } else if (sgetinit(0) < 0) {
	RESUME;
    } else {
	moving = 1;
	BEGIN ssinit;
    }
#endif /* NOSERVER */
}
    break;
case 18:
    {				/* GET recursively */
#ifndef NOSERVER
#ifdef RECURSIVE
    recursive = 1;
    if (fnspath == PATH_OFF)
      fnspath = PATH_REL;
    if (x_login && !x_logged) {
	errpkt((CHAR *)"Login required");
	RESUME;
    } else if (sgetinit(0) < 0) {
	RESUME;
    } else {
	BEGIN ssinit;
    }
#endif /* RECURSIVE */
#endif /* NOSERVER */
}
    break;
case 19:
    {				/* GET recursively and delete */
#ifndef NOSERVER
#ifdef RECURSIVE
    recursive = 1;			/* Set these before sgetinit() */
    if (fnspath == PATH_OFF)
      fnspath = PATH_REL;		/* Don't worry, they will be */
    moving = 1;				/* reset next time through. */
    if (x_login && !x_logged) {
	errpkt((CHAR *)"Login required");
	RESUME;
    } else if (!ENABLED(en_del)) {
	errpkt((CHAR *)"Deleting files is disabled");
	RESUME;
    } else if (sgetinit(0) < 0) {
	RESUME;
    } else {
	BEGIN ssinit;
    }
#endif /* RECURSIVE */
#endif /* NOSERVER */
}
    break;
case 20:
    {				/* Get REGET */
#ifndef NOSERVER
    if (x_login && !x_logged) {
	errpkt((CHAR *)"Login required");
	SERVE;
    } else if (sgetinit(1) < 0) {
	RESUME;
    } else {
	BEGIN ssinit;
    }
#endif /* NOSERVER */
}
    break;
case 21:
    {				/* Generic server command */
#ifndef NOSERVER
    srvptr = srvcmd;			/* Point to command buffer */
    decode(rdatap,putsrv,0);		/* Decode packet data into it */
    putsrv(NUL);			/* Insert a couple nulls */
    putsrv(NUL);			/* for termination */
    if (srvcmd[0]) {
	sstate = srvcmd[0];		/* Set requested start state */
	if (x_login && !x_logged && sstate != 'I') {
	    errpkt((CHAR *)"Login required");
	    SERVE;
	} else {
	    nakstate = 0;		/* Now I'm the sender. */
	    what = W_REMO;		/* Doing a REMOTE command. */
#ifdef STREAMING
	    if (!streaming)
#endif /* STREAMING */
	      if (timint < 1)
		timint = chktimo(rtimo,timef); /* Switch to per-packet timer */
	    binary = XYFT_T;		/* Switch to text mode */
	    BEGIN generic;		/* Switch to generic command state */
	}
    } else {
	errpkt((CHAR *)"Badly formed server command"); /* report error */
	RESUME;			/* & go back to server command wait */
    }
#endif /* NOSERVER */
}
    break;
case 22:
    {				/* Receive Host command */
#ifndef NOSERVER
    if (x_login && !x_logged) {
	errpkt((CHAR *)"Login required");
	SERVE;
    } else
      if (!ENABLED(en_hos)) {
	errpkt((CHAR *)"REMOTE HOST disabled");
	RESUME;
    } else {
	srvptr = srvcmd;		/* Point to command buffer */
	decode(rdatap,putsrv,0);	/* Decode command packet into it */
	putsrv(NUL);			/* Null-terminate */
	nakstate = 0;			/* Now sending, not receiving */
	binary = XYFT_T;		/* Switch to text mode */
	if (syscmd((char *)srvcmd,"")) { /* Try to execute the command */
	    what = W_REMO;		/* Doing a REMOTE command. */
#ifdef STREAMING
	    if (!streaming)
#endif /* STREAMING */
	      if (timint < 1)
		timint = chktimo(rtimo,timef); /* Switch to per-packet timer */
	    BEGIN ssinit;		/* If OK, send back its output */
	} else {			/* Otherwise */
	    errpkt((CHAR *)"Can't do system command"); /* report error */
	    RESUME;			/* & go back to server command wait */
	}
    }
#endif /* NOSERVER */
}
    break;
case 23:
    {				/* User typed Ctrl-C... */
    xitsta |= what;
#ifndef NOSERVER
    if (!ENABLED(en_fin)) {
	errpkt((CHAR *)"QUIT disabled");
	RESUME;
    } else {
	success = 0;
	QUIT;
    }
#endif /* NOSERVER */
}
    break;
case 24:
    {				/* Server got a NAK in command-wait */
#ifndef NOSERVER
    errpkt((CHAR *)"Did you say RECEIVE instead of GET?");
    RESUME;
#endif /* NOSERVER */
}
    break;
case 25:
    {				/* Any other command in this state */
#ifndef NOSERVER
    if (c != ('E' - SP) && c != ('Y' - SP)) /* except E and Y packets. */
      errpkt((CHAR *)"Unimplemented server function");
    /* If we answer an E with an E, we get an infinite loop. */
    /* A Y (ACK) can show up here if we sent back a short-form reply to */
    /* a G packet and it was echoed.  ACKs can be safely ignored here. */
    RESUME;				/* Go back to server command wait. */
#endif /* NOSERVER */
}
    break;
case 26:
    {				/* Login/out */
#ifndef NOSERVER
    char f1[LOGINLEN+1], f2[LOGINLEN+1], f3[LOGINLEN+1];
    CHAR *p;
    int len, i;

    f1[0] = NUL; f2[0] = NUL; f3[0] = NUL;
    if (x_login) {			/* Login required */
	len = 0;
	if (srvcmd[1])			/* First length field */
	  len = xunchar(srvcmd[1]);	/* Separate the parameters */
	if (len > 0 && len <= LOGINLEN) { /* Have username */
	    p = srvcmd + 2;		/* Point to it */
	    for (i = 0; i < len; i++)	/* Copy it */
	      f1[i] = p[i];
	    f1[len] = NUL;		/* Terminate it */
	    p += len;			/* Point to next length field */
	    if (*p) {			/* If we have one */
		len = xunchar(*p++);	/* decode it */
		if (len > 0 && len <= LOGINLEN) {
		    for (i = 0; i < len; i++) /* Same deal for password */
		      f2[i] = p[i];
		    f2[len] = NUL;
		    p += len;		/* And account */
		    if (*p) {
			len = xunchar(*p++);	
			if (len > 0 && len <= LOGINLEN) {
			    for (i = 0; i < len; i++)
			      f3[i] = p[i];
			    f3[len] = NUL;
			}
		    }
		}
	    }
	}
	debug(F110,"XXX user",f1,0);
	debug(F110,"XXX pass",f2,0);
	debug(F110,"XXX acct",f3,0);
	if (!f1[0]) {
	    if (x_logged) {
		tlog(F110,"Logged out",x_user,0);
		ack1((CHAR *)"Logged out");
	    } else {
		ack1((CHAR *)"You were not logged in");
	    }
	    x_logged = 0;
	} else {
	    x_logged = 0;
	    if (x_user && x_passwd) {	/* Username and password must match */
		if (!strcmp(x_user,f1))
		  if (!strcmp(x_passwd,f2))
		    x_logged = 1;
	    } else if (x_user) {	/* Only username must match */
		if (!strcmp(x_user,f1))
		    x_logged = 1;
	    }		  
	    if (x_logged) {
		tlog(F110,"Logged in", x_user, 0);
		ack1((CHAR *)"Logged in");
	    } else {
		tlog(F110,"Login failed", f1, 0);
		ack1((CHAR *)"Login failed");
	    }
	}
    } else {
	ack1((CHAR *)"No login required");
    }
    SERVE;
#endif /* NOSERVER */
}
    break;
case 27:
    {				/* Got REMOTE CD command */
#ifndef NOSERVER
    if (!ENABLED(en_cwd)) {
	errpkt((CHAR *)"REMOTE CD disabled");
	RESUME;
    } else {
	if (!cwd((char *)(srvcmd+1))) errpkt((CHAR *)"Can't change directory");
	RESUME;				/* Back to server command wait */
    }
#endif /* NOSERVER */
}
    break;
case 28:
    {				/* Got REMOTE PWD command */
#ifndef NOSERVER
    if (!ENABLED(en_cwd)) {
	errpkt((CHAR *)"REMOTE CD disabled");
	RESUME;
    } else {
	if (encstr((CHAR *)zgtdir()) > -1) /* Get & encode current directory */
	  ack1(data);			/* If it fits, send it back in ACK */
	RESUME;				/* Back to server command wait */
    }
#endif /* NOSERVER */
}
    break;
case 29:
    {				/* REMOTE DIRECTORY command */
#ifndef NOSERVER
    char *n2;
    if (!ENABLED(en_dir)) {		/* If DIR is disabled, */
	errpkt((CHAR *)"REMOTE DIRECTORY disabled"); /* refuse. */
	RESUME;
    } else {				/* DIR is enabled. */
	if (!ENABLED(en_cwd)) {		/* But CWD is disabled */
	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */
	    if (strcmp((char *)(srvcmd+2),n2)) { /* so refuse. */
		errpkt((CHAR *)"Access denied");
		RESUME;			/* Remember, this is not a goto! */
	    }
	}	
	if (state == generic) {			/* It's OK to go ahead. */
#ifdef COMMENT
	    n2 = (*(srvcmd+2)) ? DIRCMD : DIRCM2;
	    if (syscmd(n2,(char *)(srvcmd+2)))  /* If it can be done */
#else
	    if (snddir((char*)(srvcmd+2)))
#endif /* COMMENT */
	      {
		  BEGIN ssinit;		/* send the results back; */
	    } else {			/* otherwise */
		errpkt((CHAR *)"Can't list directory"); /* report failure, */
		RESUME;			/* return to server command wait */
	    }
	}
    }
#endif /* NOSERVER */
}
    break;
case 30:
    {				/* REMOTE DELETE (Erase) command */
#ifndef NOSERVER
    char *n2;
    if (!ENABLED(en_del)) {
	errpkt((CHAR *)"REMOTE DELETE disabled");    
	RESUME;
    } else {				/* DELETE is enabled */
	if (!ENABLED(en_cwd)) {		/* but CWD is disabled */
	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */
	    if (strcmp((char *)(srvcmd+2),n2)) { /* so refuse. */
		errpkt((CHAR *)"Access denied");
		RESUME;			/* Remember, this is not a goto! */
	    }
	} else if (isdir((char *)(srvcmd+2))) { /* A directory name? */
	    errpkt((CHAR *)"It's a directory");
	    RESUME;
	}
	if (state == generic) {		/* It's OK to go ahead. */
	    if (
#ifdef COMMENT
	    syscmd(DELCMD,(char *)(srvcmd+2)) /* Old way */
#else
	    snddel((char*)(srvcmd+2))	/* New way */
#endif /* COMMENT */
		) {
		BEGIN ssinit;		/* If OK send results back */
	    } else {			/* otherwise */
		errpkt((CHAR *)"Can't remove file"); /* report failure */
		RESUME;			/* & return to server command wait */
	    }
	}
    }
#endif /* NOSERVER */
}
    break;
case 31:
    {				/* FINISH */
#ifndef NOSERVER
    if (!ENABLED(en_fin)) {
	errpkt((CHAR *)"FINISH disabled");    
	RESUME;
    } else {
	ack();				/* Acknowledge */
	xxscreen(SCR_TC,0,0L,"");	/* Display */
	return(0);			/* Done */
    }
#endif /* NOSERVER */
}
    break;
case 32:
    {				/* BYE (Logout) */
#ifndef NOSERVER
    if (!ENABLED(en_bye)) {
	errpkt((CHAR *)"BYE disabled");    
	RESUME;
    } else {
	ack();				/* Acknowledge */
	msleep(500);
	ttres();			/* Reset the terminal */
	xxscreen(SCR_TC,0,0L,"");	/* Display */
	doclean();			/* Clean up files, etc */
#ifdef DEBUG
	debug(F100,"C-Kermit BYE - Loggin out...","",0);
	zclose(ZDFILE);
#endif /* DEBUG */
	return(zkself());		/* Try to log self out */
    }
#endif /* NOSERVER */
}
    break;
case 33:
    {				/* REMOTE HELP */
#ifndef NOSERVER
    if (sndhlp(NULL)) {
	BEGIN ssinit;			/* try to send it */
    } else {				/* If not ok, */
	errpkt((CHAR *)"Can't send help"); /* send error message instead */
	RESUME;				/* and return to server command wait */
    }
#endif /* NOSERVER */
}
    break;
case 34:
    {                            /* REMOTE RENAME */
#ifndef NOSERVER
#ifdef ZRENAME
    if (!ENABLED(en_ren)) {
	errpkt((CHAR *)"REMOTE RENAME disabled");
	RESUME;
    } else {				/* RENAME is enabled */
	char *str1, *str2, f1[256], f2[256];
	int len1, len2;
	len1 = xunchar(srvcmd[1]);	/* Separate the parameters */
	len2 = xunchar(srvcmd[2+len1]);
	strncpy(f1,(char *)(srvcmd+2),len1);
	f1[len1] = NUL;
	strncpy(f2,(char *)(srvcmd+3+len1),len2);
	f2[len2] = NUL; 

	len2 = xunchar(srvcmd[2+len1]);
	strncpy(f1,(char *)(srvcmd+2),len1);
	f1[len1] = NUL;
	strncpy(f2,(char *)(srvcmd+3+len1),len2);
	f2[len2] = NUL; 
	    
	if (!ENABLED(en_cwd)) {		/* If CWD is disabled */
	    zstrip(f1,&str1);		/* and they included a pathname, */
	    zstrip(f2,&str2);
	    if ( strcmp(f1,str1) || strcmp(f2,str2) ) { /* refuse. */
		errpkt((CHAR *)"Access denied");
		RESUME;			/* Remember, this is not a goto! */
	    }
	}	
	if (state == generic) {		/* It's OK to go ahead. */
	    if (zrename(f1,f2)) {	/* Try */ 
		errpkt((CHAR *)"Can't rename file"); /* Give error msg */
	    } else ack();
	    RESUME;			/* Wait for next server command */
	}
    }
#else /* no ZRENAME */
    /* Give error message */
    errpkt((CHAR *)"REMOTE RENAME not available"); 
    RESUME;				/* Wait for next server command */
#endif /* ZRENAME */
#endif /* NOSERVER */
}
    break;
case 35:
    {                            /* REMOTE COPY */
#ifndef NOSERVER
#ifdef ZCOPY
    if (!ENABLED(en_cpy)) {
	errpkt((CHAR *)"REMOTE COPY disabled");
	RESUME;
    } else {
	char *str1, *str2, f1[256], f2[256];
	int  len1, len2;
        len1 = xunchar(srvcmd[1]);	/* Separate the parameters */
        len2 = xunchar(srvcmd[2+len1]);
        strncpy(f1,(char *)(srvcmd+2),len1);
        f1[len1] = NUL;
        strncpy(f2,(char *)(srvcmd+3+len1),len2);
        f2[len2] = NUL; 

	if (!ENABLED(en_cwd)) {		/* If CWD is disabled */
	    zstrip(f1,&str1);		/* and they included a pathname, */
            zstrip(f2,&str2);
	    if (strcmp(f1,str1) || strcmp(f2,str2)) { /* Refuse. */
		errpkt((CHAR *)"Access denied");
		RESUME;			/* Remember, this is not a goto! */
	    }
	}	
	if (state == generic) {		/* It's OK to go ahead. */
            if (zcopy(f1,f2)) {		/* Try */ 
		errpkt((CHAR *)"Can't copy file"); /* give error message */
	    } else ack();
            RESUME;			/* wait for next server command */
	}
    }
#else /* no ZCOPY */
    errpkt((CHAR *)"REMOTE COPY not available"); /* give error message */
    RESUME;				/* wait for next server command */
#endif /* ZCOPY */
#endif /* NOSERVER */
}
    break;
case 36:
    {				/* REMOTE SET */
#ifndef NOSERVER
    if (!ENABLED(en_set)) {
	errpkt((CHAR *)"REMOTE SET disabled");
	RESUME;
    } else {
	if (remset((char *)(srvcmd+1)))	/* Try to do what they ask */
	  ack();			/* If OK, then acknowledge */
	else				/* Otherwise */
	  errpkt((CHAR *)"Unknown REMOTE SET parameter"); /* give error msg */
	RESUME;				/* Return to server command wait */
    }
#endif /* NOSERVER */
}
    break;
case 37:
    {				/* REMOTE TYPE */
#ifndef NOSERVER
    char *n2;
    if (!ENABLED(en_typ)) {
	errpkt((CHAR *)"REMOTE TYPE disabled");
	RESUME;
    } else {
	if (!ENABLED(en_cwd)) {		/* If CWD disabled */
	    zstrip((char *)(srvcmd+2),&n2); /* and they included a pathname, */
	    if (strcmp((char *)(srvcmd+2),n2)) { /* refuse. */
		errpkt((CHAR *)"Access denied");
		RESUME;			/* Remember, this is not a goto! */
	    }
	}	
	if (state == generic) {		/* It's OK to go ahead. */
	    binary = XYFT_T;		/* Use text mode for this. */
	    if (			/* (RESUME didn't change state) */
#ifdef COMMENT
	      syscmd(TYPCMD,(char *)(srvcmd+2))	/* Old way */
#else
	      sndtype((char *)(srvcmd+2)) /* New way */
#endif /* COMMENT */
		)
	      BEGIN ssinit;		/* OK */
	    else {			/* not OK */
		errpkt((CHAR *)"Can't type file"); /* give error message */
		RESUME;			/* wait for next server command */
	    }
	}
    }
#endif /* NOSERVER */
}
    break;
case 38:
    {				/* REMOTE MKDIR */
#ifndef NOSERVER
#ifdef CK_MKDIR
    if (!ENABLED(en_mkd)) {
	errpkt((CHAR *)"REMOTE MKDIR disabled");
	RESUME;
    } else if (!ENABLED(en_cwd)) {	/* If CWD disabled */
	errpkt((CHAR *)"Directory access restricted");
	RESUME;				/* Remember, this is not a goto! */
    }	
    if (state == generic) {		/* OK to go ahead. */
	char *p = NULL;
	x = ckmkdir(0,(char *)(srvcmd+2),&p,0,1); /* Make the directory */
	if (!p) p = "";
	if (x > -1) {
	    encstr((CHAR *)p);		/* OK - encode the name */
	    ack1(data);			/* Send short-form response */
	    RESUME;
	} else {			/* not OK */
	    if (!*p) p = "Directory creation failure";
	    errpkt((CHAR *)p);		/* give error message */
	    RESUME;			/* Wait for next server command */
	}
    }
#else
    errpkt((CHAR *)"REMOTE MKDIR not available");
    RESUME;
#endif /* CK_MKDIR */
#endif /* NOSERVER */
}
    break;
case 39:
    {				/* REMOTE RMDIR */
#ifndef NOSERVER
#ifdef CK_MKDIR
    if (!ENABLED(en_rmd)) {
	errpkt((CHAR *)"REMOTE RMDIR disabled");
	RESUME;
    } else if (!ENABLED(en_cwd)) {	/* If CWD disabled */
	errpkt((CHAR *)"Directory access restricted");
	RESUME;				/* Remember, this is not a goto! */
    }	
    if (state == generic) {		/* OK to go ahead. */
	char *p = NULL;
	x = ckmkdir(1,(char *)(srvcmd+2),&p,0,1);
	if (!p) p = "";
	if (x > -1) {
	    encstr((CHAR *)p);		/* OK - encode the name */
	    ack1(data);			/* Send short-form response */
	    RESUME;
	} else {			/* not OK */
	    if (!*p) p = "Directory removal failure";
	    errpkt((CHAR *)p);		/* give error message */
	    RESUME;			/* Wait for next server command */
	}
    }
#else
    errpkt((CHAR *)"REMOTE RMDIR not available");
    RESUME;
#endif /* CK_MKDIR */
#endif /* NOSERVER */
}
    break;
case 40:
    {				/* REMOTE SPACE */
#ifndef NOSERVER
    if (!ENABLED(en_spa)) {
	errpkt((CHAR *)"REMOTE SPACE disabled");
	RESUME;
    } else {
	x = srvcmd[1];			/* Get area to check */
	x = ((x == NUL) || (x == SP)
#ifdef OS2
	     || (x == '!') || (srvcmd[3] == ':')
#endif /* OS2 */
	     );
	if (!x && !ENABLED(en_cwd)) {	/* CWD disabled */
	    errpkt((CHAR *)"Access denied"); /* and non-default area given, */
	    RESUME;			/* refuse. */
	} else {
#ifdef OS2
_PROTOTYP(int sndspace,(int));
	    if (sndspace(x ? toupper(srvcmd[2]) : 0)) {
		BEGIN ssinit;		/* send the report. */
	    } else {			/* If not ok, */
		errpkt((CHAR *)"Can't send space"); /* send error message */
		RESUME;			/* and return to server command wait */
	    }
#else
	    x = (x ? syscmd(SPACMD,"") : syscmd(SPACM2,(char *)(srvcmd+2)));
	    if (x) {			/* If we got the info */
		BEGIN ssinit;		/* send it */
	    } else {			/* otherwise */
		errpkt((CHAR *)"Can't check space"); /* send error message */
		RESUME;			/* and await next server command */
	    }
#endif /* OS2 */
	}
    }
#endif /* NOSERVER */
}
    break;
case 41:
    {				/* REMOTE WHO */
#ifndef NOSERVER
    if (!ENABLED(en_who)) {
	errpkt((CHAR *)"REMOTE WHO disabled");
	RESUME;
    } else {
#ifdef OS2
_PROTOTYP(int sndwho,(char *));
	    if (sndwho((char *)(srvcmd+2))) {
		BEGIN ssinit;		/* try to send it */
	    } else {			/* If not ok, */
		errpkt((CHAR *)"Can't do who command"); /* send error msg */
		RESUME;			/* and return to server command wait */
	    }
#else
	if (syscmd(WHOCMD,(char *)(srvcmd+2))) {
	    BEGIN ssinit;
	} else {
	    errpkt((CHAR *)"Can't do who command");
	    RESUME;
	}
#endif /* OS2 */
    }
#endif /* NOSERVER */
}
    break;
case 42:
    {				/* Variable query or set */
#ifndef NOSERVER
#ifndef NOSPL
    char c;
    c = *(srvcmd+2);			/* Q = Query, S = Set */
    if (c == 'Q') {			/* Query */
	if (!ENABLED(en_que)) { /* Security */
	    errpkt((CHAR *)"REMOTE QUERY disabled");
	    RESUME;
	} else {			/* Query allowed */
	    int n; char *p, *q;
	    qbufp = querybuf;		/* Wipe out old stuff */
	    qbufn = 0;
	    querybuf[0] = NUL;
	    p = (char *) srvcmd + 3;	/* Pointer for making wrapper */
	    n = strlen((char *)srvcmd);	/* Position of end */
	    c = *(srvcmd+4);		/* Which type of variable */

	    if (*(srvcmd+6) == CMDQ) {	/* Starts with command quote? */
		p = (char *) srvcmd + 6; /* Take it literally */
		if (*p == CMDQ) p++;
	    } else {			/* They played by the rules */
		if (c == 'K') {		/* Kermit variable */
		    int k;
		    k = (int) strlen(p);
		    if (k > 0 && p[k-1] == ')') {
			p = (char *)(srvcmd + 4);
			*(srvcmd+4) = CMDQ;
			*(srvcmd+5) = 'f'; /* Function, so make it \f...() */
		    } else {
			*(srvcmd+3) = CMDQ; /* Stuff wrapping into buffer */
			*(srvcmd+4) = 'v';  /* Variable, so make it \v(...) */
			*(srvcmd+5) = '(';  /* around variable name */
			*(srvcmd+n) = ')';
			*(srvcmd+n+1) = NUL;
		    }
		} else {
		    *(srvcmd+3) = CMDQ; /* Stuff wrapping into buffer */
		    *(srvcmd+4) = 'v'; /*  Variable, so make it \v(...) */
		    *(srvcmd+5) = '(';	/* around variable name */
		    *(srvcmd+n) = ')';
		    *(srvcmd+n+1) = NUL;
		    if (c == 'S') {	/* System variable */
			*(srvcmd+4) = '$'; /*  so it's \$(...) */
		    } else if (c == 'G') { /* Non-\ Global variable */
			*(srvcmd+4) = 'm'; /*  so wrap it in \m(...) */
		    }
		}
	    }				/* Now evaluate it */
	    n = QBUFL;			/* Max length */
	    q = querybuf;		/* Where to put it */
	    if (zzstring(p,&q,&n) < 0) {
		errpkt((n > 0) ? (CHAR *)"Can't get value"
		               : (CHAR *)"Value too long"
		       );
		RESUME;
	    } else {
		if (encstr((CHAR *)querybuf) > -1) { /* Encode it */
		    ack1(data);		/* If it fits, send it back in ACK */
		    RESUME;
		} else if (sndstring(querybuf)) { /* Long form response */
		    BEGIN ssinit;
		} else {		/* sndhlp() fails */
		    errpkt((CHAR *)"Can't send value");
		    RESUME;
		}
	    }
	}
    } else if (c == 'S') {		/* Set (assign) */
	if (!ENABLED(en_asg)) {		/* Security */
	    errpkt((CHAR *)"REMOTE ASSIGN disabled");
	    RESUME;
	} else {			/* OK */
	    int n;
	    n = xunchar(*(srvcmd+3));	/* Length of name */
	    n = 3 + n + 1;		/* Position of length of value */
	    *(srvcmd+n) = NUL;		/* Don't need it */
	    if (addmac((char *)(srvcmd+4),(char *)(srvcmd+n+1)) < 0)
	      errpkt((CHAR *)"REMOTE ASSIGN failed");
	    else
	      ack();
	    RESUME;
	}
    } else {
	errpkt((CHAR *)"Badly formed server command");
	RESUME;
    }
#else
    errpkt((CHAR *)"Variable query/set not available");
    RESUME;
#endif /* NOSPL */
#endif /* NOSERVER */
}
    break;
case 43:
    {
#ifndef NOSERVER
    if (!ENABLED(en_fin)) {		/* Ctrl-C typed */
	errpkt((CHAR *)"QUIT disabled");
	RESUME;
    } else {
	success = 0;
	QUIT;
    }
#endif /* NOSERVER */
}
    break;
case 44:
    {				/* Anything else in this state... */
#ifndef NOSERVER
    errpkt((CHAR *)"Unimplemented REMOTE command"); /* Complain */
    RESUME;				/* and return to server command wait */
#endif /* NOSERVER */
}
    break;
case 45:
    {				/* Short-Form reply */
    urserver = 1;
#ifndef NOSERVER
#ifndef NOSPL
    if (query) {			/* If to query, */
	qbufp = querybuf;		/*  initialize query response buffer */
	qbufn = 0;
	querybuf[0] = NUL;
    }
#endif /* NOSPL */
    rf_err = "Can't open file";
    x = 1;
    if (remfile) {			/* Response redirected to file */
	if (rempipe)			/* or pipe */
#ifndef NOPUSH
	  x = zxcmd(ZOFILE,remdest);	/* Pipe: Start command */
#else
	  x = 0;
#endif /* NOPUSH */
	else
	  x = opena(remdest,&iattr);	/* File: Open with attributes */
    } else {	
	x = opent(&iattr);		/* "open" the screen */
    }
    if (x) {				/* If file was opened ok */
	if (decode(rdatap, 
#ifndef NOSPL
		   (query || !remfile) ? puttrm : 
#else
		   !remfile ? puttrm : 
#endif /* NOSPL */
		   zputfil, 1) < 0) {	/* Note: zputfil, not putfil. */
	    errpkt((CHAR *)"Error writing data");
	    RESUME;
	} else {
	    if (rdatap)			/* If we had data */
	      if (*rdatap)		/* add a line terminator */
		if (remfile) {		/* to file */
		    zsoutl(ZOFILE,"");
		} else {		/* or to screen. */
		    conoll("");
		}
	    if (bye_active && network) { /* I sent a BYE command and got */
		msleep(500);		/* the ACK... */
		tthang();
	    }
	    clsof(0);
	    success = 1;
	    RESUME;
	}
    } else {				/* otherwise */
	errpkt((CHAR *) rf_err);	/* send error message */
	RESUME;				/* and quit. */
    }
#endif /* NOSERVER */
}
    break;
case 46:
    {				/* File header */
    char *n2;
    xflg = 0;				/* Not screen data */
    cancel = 0;				/* Reset cancellation counter */
#ifdef CALIBRATE
    if (dest == DEST_N)
      calibrate = 1;
#endif /* CALIBRATE */
    if (!rcvfil(filnam)) {		/* Figure out local filename */
	errpkt((CHAR *)rf_err);		/* Trouble */
	RESUME;
    } else {				/* Real file, OK to receive */
	if (filcnt == 1)		/* rcvfil set this to 1 for 1st file */
	  crc16 = 0L;			/* Clear file CRC */
#ifndef NOFULLNAME
#ifdef ZFNQFP				/* Because of zfnqfp() */
#ifdef BIGBUFOK				/* Because it's another 1K buffer */
#define USEFULLNAME			/* Memory to burn - do it */
#else
#ifdef datageneral
#define USEFULLNAME
#endif /* datageneral */
#endif /* BIGBUFOK */
#endif /* ZFNQFP */
#endif /* NOFULLNAME */

#ifdef USEFULLNAME			/* Name to send back in ACK */
	if (!isabsolute(filnam)
#ifdef CALIBRATE
	    && !calibrate
#endif /* CALIBRATE */
	    ) {
	    CHAR tmpbuf[91];		/* Must fit in ACK Data field */
	    struct zfnfp * fnp;
	    fnp = zfnqfp(filnam,90,(char *)tmpbuf);
	    encstr(fnp ? tmpbuf: (CHAR *)filnam); /* Send the full pathname */
	} else
#endif /* USEFULLNAME */
	  encstr((CHAR *)filnam);	/* Encode the local filename */

	ack1(data);			/* Send it back in ACK */
	initattr(&iattr);		/* Clear file attribute structure */
	streamon();
	if (window(wslotn) < 0) {	/* Allocate negotiated window slots */
	    errpkt((CHAR *)"Can't open window");
	    RESUME;
	}
	BEGIN rattr;			/* Now expect Attribute packets */
    }
}
    break;
case 47:
    {				/* X-packet instead of file header */
    xflg = 1;				/* Screen data */
    cancel = 0;				/* Reset cancellation counter */
    ack();				/* Acknowledge the X-packet */
    initattr(&iattr);			/* Initialize attribute structure */
    streamon();
    if (window(wslotn) < 0) {		/* allocate negotiated window slots */
	errpkt((CHAR *)"Can't open window");
	RESUME;
    }
#ifndef NOSPL
    if (query) {			/* If this is the response to */
	qbufp = querybuf;		/* a query that we sent, initialize */
	qbufn = 0;			/* the response buffer */
	querybuf[0] = NUL;
    }
#endif /* NOSPL */
    what = W_REMO;			/* we're doing a REMOTE command */
    BEGIN rattr;			/* Expect Attribute packets */
}
    break;
case 48:
    {				/* Attribute packet */
    if (gattr(rdatap,&iattr) == 0) {	/* Read into attribute structure */
#ifdef CK_RESEND
	ack1((CHAR *)iattr.reply.val);	/* Reply with data */
#else
	ack();				/* If OK, acknowledge */
#endif /* CK_RESEND */
    } else {				/* Otherwise */
	extern long fsize;
	char *r;
	r = getreason(iattr.reply.val);
	ack1((CHAR *)iattr.reply.val);	/* refuse to accept the file */
	xxscreen(SCR_ST,ST_REFU,0L,r);	/* reason */
#ifdef TLOG
	if (tralog && !tlogfmt)
	  doxlog(what,filnam,fsize,binary,1,r);
#endif /* TLOG */
    }
}
    break;
case 49:
    {				/* First data packet */
    if (discard) {			/* if we're discarding the file */
	ack1((CHAR *)"X");		/* just ack the data like this. */
	cancel++;			/* and count it */
	BEGIN rdata;			/* and wait for more data packets. */
    } else {				/* Not discarding. */
	rf_err = "Can't open file";
	if (xflg) {			/* If screen data */
	    if (remfile) {		/* redirected to file */
		if (rempipe)		/* or pipe */
		  x = openc(ZOFILE,remdest); /* Pipe: start command */
		else
		  x = opena(remdest,&iattr); /* File: open with attributes */
	    } else {			/* otherwise */
		x = opent(&iattr);	/* "open" the screen */
	    }
	} else {			/* otherwise */
#ifdef CALIBRATE
	    if (calibrate) {		/* If calibration run */
		x = ckopenx(&iattr);	/* open nothing */
#ifdef STREAMING
		if (streaming)		/* Streaming */
		  fastack();		/* ACK without ACKing. */
		else
#endif /* STREAMING */
		  ack();		/* Send real ACK */
		BEGIN rdata;		/* Proceed to next state */
	    } else
#endif /* CALIBRATE */
#ifdef UNIX	    
/*
  In UNIX we can pipe the file data into the mail program, which is to be
  preferred to writing it out to a temp file and then mailing it afterwards.
  This depends rather heavily on all UNIXes having a mail command that
  accepts '-s "subject"' on the command line.  MAILCMD (e.g. mail, Mail, mailx)
  is defined in ckufio.c.
*/
	    if (*(iattr.disp.val) == 'M') {
		char *s;
		char tmp[1024];
		extern char ofn1[], *MAILCMD;
		s = iattr.disp.val + 1;
		sprintf(tmp,"%s -s %c%s%c %s", MAILCMD, '"', ofn1, '"', s);
		x = openc(ZOFILE,(char *)tmp);
	    } else if (*(iattr.disp.val) == 'P') { /* Ditto for print */
		char tmp[1024];
		extern char *PRINTCMD;
		sprintf(tmp,"%s %s", PRINTCMD, iattr.disp.val + 1);
		x = openc(ZOFILE,(char *)tmp);
	    } else
#endif /* UNIX */
	      x = opena(filnam,&iattr);	/* open the file, with attributes */
	}
	if (x) {			/* If file was opened ok */
	    int rc, qf;
#ifndef NOSPL
	    qf = query;
#else
	    qf = 0;
#endif /* NOSPL */

#ifdef CKTUNING
	    rc = (binary && !parity) ?
	      bdecode(rdatap,putfil):
	       decode(rdatap, qf ? puttrm : putfil, 1);
#else
	    rc = decode(rdatap, qf ? puttrm : putfil, 1);
#endif /* CKTUNING */
	    if (rc < 0) {
		errpkt((CHAR *)"Error writing data");
		RESUME;
	    }
#ifdef STREAMING
	    if (streaming)		/* Streaming was negotiated */
	      fastack();		/* ACK without ACKing. */
	    else
#endif /* STREAMING */
	      ack();			/* acknowledge it */
	    BEGIN rdata;		/* and switch to receive-data state */
	} else {			/* otherwise */
	    errpkt((CHAR *) rf_err);	/* send error packet */
	    RESUME;			/* and quit. */
	}
    }
}
    break;
case 50:
    {				/* EOT, no more files */
    ack();				/* Acknowledge the B packet */
    reot();				/* Do EOT things */
#ifdef CK_TMPDIR
/* If we were cd'd temporarily to another device or directory ... */
    if (f_tmpdir) {
	int x;
	x = zchdir((char *) savdir);	/* ... restore previous directory */
	f_tmpdir = 0;			/* and remember we did it. */
	debug(F111,"ckcpro.w B tmpdir restoring",savdir,x);
    }
#endif /* CK_TMPDIR */
    RESUME;				/* and quit */
}
    break;
case 51:
    {				/* Data packet */
    if (cxseen || discard) {		/* If file interrupt */
#ifdef STREAMING
	if (streaming) {
	    if (cancel++ == 0)
	      ack1((CHAR *)"X");	/* put "X" in ACK */
	    else
	      fastack();
	} else
#endif /* STREAMING */
	    ack1((CHAR *)"X");		/* put "X" in ACK */
    } else if (czseen) {		/* If file-group interrupt */
#ifdef STREAMING
	if (streaming) {
	    if (cancel++ == 0)
	      ack1((CHAR *)"Z");	/* put "Z" in ACK */
	    else
	      fastack();
	} else
#endif /* STREAMING */
	    ack1((CHAR *)"Z");		/* put "Z" in ACK */
    } else {
	int rc, qf;
#ifndef NOSPL
	qf = query;
#else
	qf = 0;
#endif /* NOSPL */
#ifdef CKTUNING
	rc = (binary && !parity) ?
	  bdecode(rdatap,putfil):
	    decode(rdatap, qf ? puttrm : putfil, 1);
#else
	rc = decode(rdatap, qf ? puttrm : putfil, 1);
#endif /* CKTUNING */
	if (rc < 0) {
	    discard = !keep;
	    errpkt((CHAR *)"Error writing data"); /* If failure, */
	    RESUME;
	} else				/* Data written OK, send ACK */
#ifdef STREAMING
	  if (streaming)
	    fastack();
	else
#endif /* STREAMING */
	  ack();
    }
}
    break;
case 52:
    {				/* EOF immediately after A-Packet. */
    rf_err = "Can't create file";
    timint = s_timint;
    if (discard) {			/* Discarding a real file... */
	x = 1;
    } else if (xflg) {			/* If screen data */
	if (remfile) {			/* redirected to file */
	    if (rempipe)		/* or pipe */
	      x = openc(ZOFILE,remdest); /* Pipe: start command */
	    else
	      x = opena(remdest,&iattr); /* File: open with attributes */
	} else {			/* otherwise */
	    x = opent(&iattr);		/* "open" the screen */
	}
#ifdef CALIBRATE
    } else if (calibrate) {		/* If calibration run */
	x = ckopenx(&iattr);		/* do this */
#endif /* CALIBRATE */
    } else {				/* otherwise */	
	x = opena(filnam,&iattr);	/* open the file, with attributes */
    }
    if (!x || reof(filnam, &iattr) < 0) { /* Now close & dispose of the file */
	errpkt((CHAR *) rf_err);	/* If problem, send error msg */
	RESUME;				/* and quit */
    } else {				/* otherwise */
	ack();				/* acknowledge the EOF packet */
	BEGIN rfile;			/* and await another file */
    }
}
    break;
case 53:
    {  				/* Ctrl-C or connection loss. */
    timint = s_timint;
    window(1);				/* Set window size back to 1... */
    cxseen = 1;
    x = clsof(1);			/* Close file */
    return(success = 0);		/* Failed */
}
    break;
case 54:
    {				/* End Of File (EOF) Packet */
/*  wslots = 1;	*/			/* (don't set) Window size back to 1 */
#ifndef COHERENT /* Coherent compiler blows up on this switch() statement. */
    x = reof(filnam, &iattr);		/* Handle the EOF packet */
    switch (x) {			/* reof() sets the success flag */
      case -3:				/* If problem, send error msg */
	errpkt((CHAR *)"Can't print file"); /* Fatal */
	RESUME;
	break;
      case -2:
	errpkt((CHAR *)"Can't mail file"); /* Fatal */
	RESUME;
	break;
      case 2:
      case 3:
	xxscreen(SCR_EM,0,0L,"Can't delete temp file"); /* Not fatal */
	RESUME;
	break;
      default:
	if (x < 0) {			/* Fatal */
	    errpkt((CHAR *)"Can't close file");
	    RESUME;
	} else {			/* Success */
#ifndef NOSPL
	    if (query)			/* Query reponses generally */
	      conoll("");		/* don't have line terminators */
#endif /* NOSPL */
	    ack();			/* Acknowledge the EOF packet */
	    BEGIN rfile;		/* and await another file */
	}
    }
#else
    if (reof(filnam, &iattr) < 0) {	/* Close the file */
	errpkt((CHAR *)"Error at end of file");
	RESUME;
    } else {				/* reof() sets success flag */
	ack();
	BEGIN rfile;
    }
#endif /* COHERENT */
}
    break;
case 55:
    {				/* ACK for Send-Init */
    spar(rdatap);			/* set parameters from it */
    bctu = bctr;			/* switch to agreed-upon block check */
    bctl = (bctu == 4) ? 2 : bctu;	/* Set block-check length */
#ifdef CK_RESEND
    if ((sendmode == SM_RESEND) && (!atcapu || !rscapu)) { /* RESEND */
	errpkt((CHAR *) "RESEND capabilities not negotiated");
	RESUME;
    } else {
#endif /* CK_RESEND */
	what = W_SEND;			/* Remember we're sending */
	x = sfile(xflg);		/* Send X or F header packet */
	cancel = 0;			/* Reset cancellation counter */
	if (x) {			/* If the packet was sent OK */
	    if (!xflg && filcnt == 1)	/* and it's a real file */
	      crc16 = 0L;		/* Clear the file CRC */
	    resetc();			/* reset per-transaction counters */
	    rtimer();			/* reset timers */
#ifdef GFTIMER
	    rftimer();
#endif /* GFTIMER */
	    streamon();			/* turn on streaming */
	    BEGIN ssfile;		/* and switch to receive-file state */
	} else {			/* otherwise send error msg & quit */
	    s = xflg ? "Can't execute command" : (char *)epktmsg;
	    if (!*s) s = "Can't open file";
	    errpkt((CHAR *)s);
	    RESUME;
	}
#ifdef CK_RESEND
    }
#endif /* CK_RESEND */
}
    break;
case 56:
    {				/* R packet was retransmitted. */
    xsinit();				/* Resend packet 0 */
}
    break;
case 57:
    {				/* Same deal if G packet comes again */
    xsinit();
}
    break;
case 58:
    {				/* Same deal if C packet comes again */
    xsinit();
}
    break;
case 59:
    {				/* ACK for F or X packet */
    srvptr = srvcmd;			/* Point to string buffer */
    decode(rdatap,putsrv,0);		/* Decode data field, if any */
    putsrv(NUL);			/* Terminate with null */
    ffc = 0L;				/* Reset file byte counter */
    if (*srvcmd) {			/* If remote name was recorded */
        if (sendmode != SM_RESEND) {
	    extern char * srfspec;
	    if (fdispla == XYFD_C || fdispla == XYFD_S)
	      xxscreen(SCR_AN,0,0L,(char *)srvcmd);
	    tlog(F110," remote name:",(char *) srvcmd,0L);
	    makestr(&srfspec,(char *)srvcmd);
        }
    }
    if (atcapu) {			/* If attributes are to be used */
	if (sattr(xflg | stdinf, 1) < 0) { /* send them */
	    errpkt((CHAR *)"Can't send attributes"); /* if problem, say so */
	    RESUME;			/* and quit */
	} else BEGIN ssattr;		/* if ok, switch to attribute state */
    } else {				/* Attributes not negotiated */
	if (window(wslotn) < 0) {	/* Open window */
	    errpkt((CHAR *)"Can't open window");
	    RESUME;
	}
	if ((x = sdata()) == -2) {	/* Send first data packet data */
	    window(1);			/* Failed, put window size back to 1 */
	    x = clsif();		/* Close input file */
	    return(success = 0);	/* Return failure */
	} else if (x == -9) {		/* User interrupted */
	    errpkt((CHAR *)"User cancelled"); /* Send Error packet */
	    window(1);			/* Set window size back to 1... */
	    timint = s_timint;		/* Restore timeout */
	    return(success = 0);	/* Failed */
	} else if (x == -1) {		/* EOF (empty file) */
	    window(1);			/* put window size back to 1, */
	    x = clsif();		/* If not ok, close input file, */
	    if (x < 0)
	      cxseen = 1;
	    seof((CHAR *)"");		/* send EOF packet, */
	    BEGIN sseof;		/* and switch to EOF state. */
	} else {			/* First data sent OK */
	    BEGIN ssdata;		/* All ok, switch to send-data state */
	}
    }
}
    break;
case 60:
    {				/* Got ACK to A packet */
    ffc = 0L;				/* Reset file byte counter */
    if (rsattr(rdatap) < 0) {		/* Was the file refused? */
	discard = 1;			/* Set the discard flag */
	clsif();			/* Close the file */
	sxeof((CHAR *)"D");		/* send EOF with "discard" code */
	BEGIN sseof;			/* switch to send-EOF state */
    } else if ((x = sattr(xflg | stdinf, 0)) < 0) { /* Send more? */
	errpkt((CHAR *)"Can't send attributes"); /* Trouble... */
	RESUME;
    } else if (x == 0) {		/* No more to send so now the data */
	if (window(wslotn) < 0) {	/* Allocate negotiated window slots */
	    errpkt((CHAR *)"Can't open window");
	    RESUME;
	}
	if ((x = sdata()) == -2) {	/* File accepted, send first data */
	    return(success = 0);	/* Failed */
	} else if (x == -9) {		/* User interrupted */
	    errpkt((CHAR *)"User cancelled"); /* Send Error packet */
	    window(1);			/* Set window size back to 1... */
	    timint = s_timint;		/* Restore timeout */
	    return(success = 0);	/* Failed */
	} else if (x == -1) {		/* EOF */
	    window(1);			/* put window size back to 1, */
	    x = clsif();		/* If not ok, close input file, */
	    if (x < 0)
	      cxseen = 1;
	    seof((CHAR *)"");		/* send EOF packet, */
	    BEGIN sseof;		/* and switch to EOF state. */
	} else {
	    BEGIN ssdata;		/* All ok, switch to send-data state */
	}
    }
}
    break;
case 61:
    {  				/* Ctrl-C or connection loss. */
    window(1);				/* Set window size back to 1... */
    cxseen = 1;				/* To indicate interruption */
    x = clsif();			/* Close file */
    return(success = 0);		/* Failed */
}
    break;
case 62:
    {				/* Got ACK to Data packet */
    canned(rdatap);			/* Check if file transfer cancelled */
    if ((x = sdata()) == -2) {		/* Try to send next data */
	window(1);			/* Set window size back to 1... */
	x = clsif();			/* Close file */
	return(success = 0);		/* Failed */
    } else if (x == -9) {		/* User interrupted */
	errpkt((CHAR *)"User cancelled"); /* Send Error packet */
	window(1);			/* Set window size back to 1... */
	timint = s_timint;		/* Restore original timeout */
	return(success = 0);		/* Failed */
    } else if (x == -1) {		/* EOF - finished sending data */
	window(1);			/* Set window size back to 1... */
	x = clsif();			/* Close file */
	if (x < 0)			/* Handle failure */
	  cxseen = 1;			/*  this way */
	if (cxseen || czseen)		/* If interrupted */
	  seof((CHAR *)"D");		/* send special EOF packet */
	else				/* otherwise */
	  seof((CHAR *)"");		/* regular EOF packet */
	BEGIN sseof;			/* and enter send-eof state */
    }
}
    break;
case 63:
    {				/* Got ACK to EOF */
    success = (cxseen == 0 && czseen == 0); /* Transfer status... */
    if (success && rejection > 0)	    /* If rejected, succeed if */
      if (rejection != '#' &&		    /* reason was date */
	  rejection != 1 && rejection != '?') /* or name; */
	success = 0;			    /* fail otherwise. */
    cxseen = 0;				/* This goes back to zero. */
    if (success) {			/* Only if transfer succeeded... */
	if (moving) {			/* If MOVE'ing */
	    tlog(F110," deleting",filnam,0); /* delete the file */
	    zdelet(filnam);
	} else if (snd_move) {		/* Or move it */
	    tlog(F110," moving source to",snd_move,0);
	    zrename(filnam,snd_move);
	} else if (snd_rename) {	/* Or rename it */
	    char *s = snd_rename;	/* Renaming string */
#ifndef NOSPL
	    int y;			/* Pass it thru the evaluator */
	    extern int cmd_quoting;	/* for \v(filename) */
	    if (cmd_quoting) {		/* But only if cmd_quoting is on */
		y = MAXRP;
		s = (char *)srvcmd;
		zzstring(snd_rename,&s,&y);
		s = (char *)srvcmd;
	    }
#endif /* NOSPL */
	    if (s) if (*s) {
		if (zrename(filnam,s) > -1)
		  tlog(F110," renaming source to",s,0);
		*s = NUL;
	    }
	}
    }
    if (gnfile() > 0) {			/* Any more files to send? */
	if (sfile(xflg))		/* Yes, try to send next file header */
	  BEGIN ssfile;			/* if ok, enter send-file state */
	else {				/* otherwise */
	    s = xflg ? "Can't execute command" : (char *)epktmsg;
	    if (!*s) s = "Can't open file";
	    errpkt((CHAR *)s);		/* send error message */
	    RESUME;			/* and quit */
	}
    } else {				/* No next file */
	tsecs = gtimer();		/* get statistics timers */
#ifdef GFTIMER
	fptsecs = gftimer();
#endif /* GFTIMER */
	seot();				/* send EOT packet */
	BEGIN sseot;			/* enter send-eot state */
    }
}
    break;
case 64:
    {				/* Got ACK to EOT */
    debug(F101,"sseot justone","",justone);
    RESUME;				/* All done, just quit */
}
    break;
case 65:
    {					/* Got Error packet, in any state */
    char *s = "";
    window(1);				/* Close window */
    timint = s_timint;			/* Restore original timeout */
    if (*epktmsg)			/* Message from Error packet */
      s = (char *)epktmsg;
    if (!*s) {				/* If not there then maybe here */
	s = (char *)rdatap;
	strncpy((char *)epktmsg,(char *)rdatap,PKTMSGLEN);
    }
    if (!*s)				/* Hopefully we'll never see this. */
      s = "Unknown error";
    success = 0;			/* For IF SUCCESS/FAIL. */
    debug(F101,"ckcpro.w justone at E pkt","",justone);
    x = quiet; quiet = 1;		/* Close files silently, */
    epktrcvd = 1;			/* Prevent messages from clsof() */
    clsif(); clsof(1); 			/* discarding any output file. */
    success = 0;			/* Transfer failed */
    xferstat = success;			/* Remember transfer status */
    ermsg(s);				/* Issue the message (calls screen). */
    tstats();				/* Get stats */
    quiet = x;				/* Restore quiet state */
/*
  If we are executing commands from a command file or macro, let the command
  file or macro decide whether to exit, based on SET { TAKE, MACRO } ERROR.
*/
    if (
#ifndef NOICP
	!cmdsrc() &&
#endif /* NOICP */
	backgrd && !server)
      fatal("Protocol error");
    xitsta |= what;			/* Save this for doexit(). */
#ifdef CK_TMPDIR
/* If we were cd'd temporarily to another device or directory ... */
    if (f_tmpdir) {
	int x;
	x = zchdir((char *) savdir);	/* ... restore previous directory */
	f_tmpdir = 0;			/* and remember we did it. */
	debug(F111,"ckcpro.w E tmpdir restored",savdir,x);
    }
#endif /* CK_TMPDIR */
    RESUME;
}
    break;
case 66:
    { success = 0; QUIT; }
    break;
case 67:
    {					/* Anything not accounted for above */
    errpkt((CHAR *)"Unexpected packet type"); /* Give error message */
    window(1);
    xitsta |= what;			/* Save this for doexit(). */
    RESUME;				/* and quit */
}
    break;

	    }
    }
}

char tbl[] = {
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 13, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 12, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 50, 67, 67, 65, 46, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 47, 67, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 48, 67, 67, 49, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 52, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 51, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 54, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 53,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 58, 67, 65, 67, 57, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 56, 67, 67, 67, 67, 67, 67, 55, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 59, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 60, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 62, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 61,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 63, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 64, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
-1, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 
25, 25, 25, 22, 25, 25, 25, 21, 17, 15, 20, 25, 25, 25, 24, 25, 
25, 25, 16, 11, 25, 25, 18, 19, 25, 25, 25, 25, 25, 25, 25, 25, 
25, 10, 25,  6, 25, 25, 25,  8,  4, 25,  5,  7, 25, 25, 25, 25, 
25, 23,  3,  1, 25, 25,  2, 25,  9, 25, 25, 25, 25, 25, 25, 25, 
-1, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 
44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 
44, 28, 44, 27, 29, 30, 31, 44, 33, 26, 44, 35, 32, 44, 44, 44, 
44, 44, 34, 36, 37, 40, 42, 41, 44, 44, 44, 44, 44, 44, 44, 44, 
44, 10, 44,  6, 39, 44, 44,  8,  4, 44,  5,  7, 44, 38, 44, 44, 
44, 43,  3,  1, 44, 44,  2, 44,  9, 44, 44, 44, 44, 44, 44, 44, 
-1, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 67, 67, 67, 15, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 11, 67, 67, 67, 67, 67, 14, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67, 
 0, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 67, 67, 65, 46, 67, 67, 67, 67, 67, 67, 67, 67, 67, 
67, 67, 67, 11, 67, 67, 67, 67, 47, 45, 67, 67, 67, 67, 67, 67, 
67, 10, 67,  6, 67, 67, 67,  8,  4, 67,  5,  7, 67, 67, 67, 67, 
67, 66,  3,  1, 67, 67,  2, 67,  9, 67, 67, 67, 67, 67, 67, 67 };


/*  P R O T O  --  Protocol entry function  */

#ifdef CK_SPEED
int f_ctlp = 0;			/* Control-character prefix table */
#ifdef COMMENT
short s_ctlp[256];
#endif /* COMMENT */
#endif /* CK_SPEED */

/*
  This is simply a wrapper for the real protocol function just below,
  that saves any items that might be changed automatically by protocol
  negotiations and then restores them upon exit from protocol mode.
*/
VOID
proto() {
    extern int b_save, f_save, c_save, ss_save, slostart, reliable, urclear;
#ifdef PIPESEND
    extern int pipesend;
#endif /* PIPESEND */
#ifdef OS2
    extern int cursorena[], cursor_save, term_io;
    extern BYTE vmode;
    extern int display_demo;
    int term_io_save;
#endif /* OS2 */
#ifdef IKS_OPTION 
    extern int ttnproto, network, me_iks;
    int iks_sent = 0;
#endif /* IKS_OPTION */

    int i;

#ifdef OS2
    cursor_save = cursorena[vmode];
    cursorena[vmode] = 0;
    term_io_save = term_io;
    term_io = 0;
#endif /* OS2 */
    b_save = binary;			/* SET FILE TYPE */
    f_save = fncnv;			/* SET FILE NAMES */
    c_save = bctr;
    p_save = fnspath;
    r_save = recursive;
    s_timint = timint;
    ss_save = slostart;
#ifdef COMMENT
/* Don't do this because then user can never find out what happened. */
#ifdef CK_SPEED
    for (i = 0; i < 256; i++)
      s_ctlp[i] = ctlp[i];
    f_ctlp = 1;
#endif /* CK_SPEED */
#endif /* COMMENT */
    if (reliable)
      slostart = 0;
#ifdef IKS_OPTION
    if (network && ttnproto == NP_TELNET && me_iks && sstate == 'x') {
        tn_siks(0);                     /* Send Kermit-Server Start */
        iks_sent = 1;
    }
#endif /* IKS_OPTION */

    xxproto();				/* Call the real protocol function */
    xferstat = success;			/* Remember transfer status */

#ifdef IKS_OPTION
    if (iks_sent) tn_siks(1);           /* Send Kermit-Server Stop */
#endif /* IKS_OPTION */

#ifdef STREAMING
    streaming = 0;
    streamok = 0;
#endif /* STREAMING */
#ifdef COMMENT
#ifdef CK_SPEED
    for (i = 0; i < 256; i++)
      ctlp[i] = s_ctlp[i];
    f_ctlp = 0;
#endif /* CK_SPEED */
#endif /* COMMENT */
    urclear = 0;
    if (!success) {
	xitsta |= what;
	tlog(F110," failed:",(char *)epktmsg,0);
    }
    debug(F111,"proto xferstat",epktmsg,xferstat);
    slostart = ss_save;
    if (s_timint > -1) {		/* Because of REMOTE SET */
	timint = s_timint;
	s_timint = -1;
    }
    recursive = r_save;
    fnspath = p_save;
    if (c_save > -1) {			/* Because of REMOTE SET */
	bctr = c_save;
	c_save = -1;
    }
    fncnv   = f_save;
    binary  = b_save;
#ifdef PIPESEND
    pipesend = 0;    			/* Next time might not be pipesend */
#endif /* PIPESEND */
#ifdef OS2
    cursorena[vmode] = cursor_save;
    term_io = term_io_save;
    display_demo = 1;
#endif /* OS2 */
}

static VOID
xxproto() {
    int x;
    long lx;
#ifdef CK_XYZ
#ifdef XYZ_INTERNAL
_PROTOTYP( int pxyz, (int) );
#endif /* XYZ_INTERNAL */
#endif /* CK_XYZ */

    char xss[2];			/* String representation of sstate */
    xss[0] = sstate;
    xss[1] = NUL;
    s_timint = timint;

    debug(F101,"xxproto entry justone","",justone);
    success = 0;

    if (local && ttchk() < 0) {		/* Giving BYE or FIN */
	if (bye_active)			/* but there is no connection */
	  return;
	if (sstate == 'g' && cmarg) {
	    if (*cmarg == 'L' || *cmarg == 'F')
	      return;
	}
    }

/* Set up the communication line for file transfer. */

    if (local && (speed < 0L) && (network == 0)) {
	xxscreen(SCR_EM,0,0L,"Sorry, you must 'set speed' first");
	return;
    }
    x = -1;
    if (ttopen(ttname,&x,mdmtyp,cdtimo) < 0) {
	debug(F111,"failed: proto ttopen local",ttname,local);
	xxscreen(SCR_EM,0,0L,"Can't open line");
	return;
    }
    if (x > -1) local = x;
    debug(F111,"proto ttopen local",ttname,local);

    lx = (local && !network) ? speed : -1;
#ifdef NETCONN
#ifdef CK_SPEED
    if (network && ttnproto == NP_TELNET) {
	ctlp[255] = ctlp[CR] = 1;
	if (parity == 'e' || parity == 'm') ctlp[127] = 1;
	if (flow == FLO_XONX) {		/* Also watch out for Xon/Xoff */
	    ctlp[17] = ctlp[19] = 1;
	    ctlp[17+128] = ctlp[19+128] = 1;
	}
    }
#endif /* CK_SPEED */
#endif /* NETCONN */
    if (ttpkt(lx,flow,parity) < 0) {	/* Put line in packet mode, */
	xxscreen(SCR_EM,0,0L,"Can't condition line");
	return;
    }
    if (local && !network && carrier != CAR_OFF) {
	int x;				/* Serial connection */
	x = ttgmdm();			/* with carrier checking */
	if (x > -1) {
	    if (!(x & BM_DCD)) {
		debug(F101,"proto ttgmdm","",0);
		xxscreen(SCR_EM,0,0L,"Carrier required but not detected");
		return;
	    }
	}
    }
    /* Send remote side's "receive" or "server" startup string, if any */
    if (local && ckindex((char *)xss,"srgcjhk",0,0,1)) {
	char *s = NULL;
	extern char * srvstring;
	if (sstate == 's') {		/* Sending file(s) */
	    s = binary ? ptab[protocol].h_b_init : ptab[protocol].h_t_init;
	} else if (protocol == PROTO_K) { /* Command for server */
	    s = srvstring;
	}
#ifdef CK_SPEED
#ifndef UNPREFIXZERO
	if (protocol == PROTO_K)	/* Because of C-strings... */
	  ctlp[0] = 1;
#endif /* UNPREFIXZERO */
#endif /* CK_SPEED */
	if (s) if (*s) {		/* If we have a command to send... */
	    char tmpbuf[356];
	    int stuff = -1, stuff2 = -1, len = 0;
	    extern int tnlm;
	    strcpy(tmpbuf,s);
	    if (sstate == 's')		/* Sending file(s) */
	      sprintf(tmpbuf, s, cmarg2[0] ? cmarg2 : cmarg); /* For XMODEM */
	    else			/* Command for server */
	      sprintf(tmpbuf, s);
	    strcat(tmpbuf, "\015");
	    if (tnlm)			/* TERMINAL NEWLINE ON */
	      stuff = LF;		/* Stuff LF */
#ifdef NETCONN
#ifdef TCPSOCKET
	    /* TELNET NEWLINE MODE */
	    if (network) {
		if (ttnproto == NP_TELNET) {
		    switch (me_binary ? tn_b_nlm : tn_nlm) {
		      case TNL_CR:
			break;
		      case TNL_CRNUL:
			break;
		      case TNL_CRLF:
			stuff2 = stuff;
			stuff = LF;
			break;
		    }
		}
#ifdef RLOGCODE
		else if (ttnproto == NP_RLOGIN) {
		    switch (tn_b_nlm) { /* Always BINARY */
		      case TNL_CR:
			break;
		      case TNL_CRNUL:
			stuff2 = stuff;
			stuff  = NUL;
			break;
		      case TNL_CRLF:
			stuff2 = stuff;
			stuff = LF;
			break;
		    }
		}
#endif /* RLOGCODE */
	    }
#endif /* TCPSOCKET */
#endif /* NETCONN */
	    len = strlen(tmpbuf);
	    if (stuff >= 0) {
		tmpbuf[len++] = stuff;
		if (stuff2 >= 0)
		  tmpbuf[len++] = stuff2;
		tmpbuf[len] = NUL;
	    }
	    ttol((CHAR *)tmpbuf,len);
	    if (protocol == PROTO_K)	/* Give remote Kermit time to start */
	      msleep(400);
	}
    }

#ifdef CK_XYZ
    if (protocol != PROTO_K) {		/* Non-Kermit protocol selected */
	char tmpbuf[356];
	char * s = "";
#ifdef XYZ_INTERNAL			/* Internal */
	success = !pxyz(sstate); 
#else
#ifdef CK_REDIR				/* External */
	switch (sstate) {
	  case 's':			/* 'Tis better to SEND... */
	    s = binary ? ptab[protocol].p_b_scmd : ptab[protocol].p_t_scmd;
	    break;
	  case 'v':			/* ... than RECEIVE */
	    s = binary ? ptab[protocol].p_b_rcmd : ptab[protocol].p_t_rcmd;
	    break;
	}
	if (!s) s = "";
	if (*s) {
	    sprintf(tmpbuf,s,(sstate == 's') ? fspec : cmarg2);
	    debug(F110,"ckcpro ttruncmd",tmpbuf,0);
	    success = ttruncmd(tmpbuf);
	} else {
	    printf("?Sorry, no external protocol defined for %s\r\n",
		   ptab[protocol].p_name
		   );
	}
#else
	printf(
"Sorry, only Kermit protocol is supported in this version of Kermit\n"
	       );
#endif /* CK_REDIR */
#endif /* XYZ_INTERNAL */
	return;
    }
#endif /* CK_XYZ */

#ifdef NTSIGX
    conraw();
    connoi();
#else
    if (!local)
      connoi();				/* No console interrupts if remote */
#endif /* NTSIG */

    if (sstate == 'x') {		/* If entering server mode, */
	server = 1;			/* set flag, */
	debug(F101,"server backgrd","",backgrd);
	debug(F101,"server quiet","",quiet);
	debug(F100,"SHOULD NOT SEE THIS IF IN BACKGROUND!","",0);
	if (!local) {			/* and issue appropriate message. */
	    if (!quiet && !backgrd) {
		conoll(srvtxt);
		conoll("KERMIT READY TO SERVE...");
	    }
	} else {
	    conol("Entering server mode on ");
	    conoll(ttname);
	    conoll("Type Ctrl-C to quit.");
	    if (srvdis) intmsg(-1L);
#ifdef TCPSOCKET
#ifndef NOLISTEN
	    if (network && tcpsrfd > 0)
	      ttol((CHAR *)"KERMIT READY TO SERVE...\015\012",26);
#endif /* NOLISTEN */
#endif /* TCPSOCKET */
	}
    } else
      server = 0;
#ifdef VMS
    if (!quiet && !backgrd)    /* So message doesn't overwrite prompt */
      conoll("");
    if (local) conres();       /* So Ctrl-C will work */
#endif /* VMS */
/*
  If in remote mode, not shushed, not in background, and at top command level,
  issue a helpful message telling what to do...
*/
    if (!local && !quiet && !backgrd) {
	if (sstate == 'v') {
	    conoll("Return to your local Kermit and give a SEND command.");
	    conoll("");
	    conoll("KERMIT READY TO RECEIVE...");
	} else if (sstate == 's') {
	    conoll("Return to your local Kermit and give a RECEIVE command.");
	    conoll("");
	    conoll("KERMIT READY TO SEND...");
	} else if ( sstate == 'g' || sstate == 'r' || sstate == 'h' ||
		    sstate == 'j' || sstate == 'c' ) {
	    conoll("Return to your local Kermit and give a SERVER command.");
	    conoll("");
	    conoll((sstate == 'r' || sstate == 'j' || sstate == 'h') ?
		   "KERMIT READY TO GET..." :
		   "KERMIT READY TO SEND SERVER COMMAND...");
	}
    }
#ifdef COMMENT
    if (!local) sleep(1);
#endif /* COMMENT */
/*
  The 'wart()' function is generated by the wart program.  It gets a
  character from the input() routine and then based on that character and
  the current state, selects the appropriate action, according to the state
  table above, which is transformed by the wart program into a big case
  statement.  The function is active for one transaction.
*/
    rtimer();				/* Reset elapsed-time timer */
#ifdef GFTIMER
    rftimer();
#endif /* GFTIMER */
    resetc();				/* & other per-transaction counters. */

    debug(F101,"proto calling wart, justone","",justone);

    wart();				/* Enter the state table switcher. */
/*
  Note: the following is necessary in case we have just done a remote-mode
  file transfer, in which case the controlling terminal modes have been
  changed by ttpkt().  In particular, special characters like Ctrl-C and
  Ctrl-\ might have been turned off (see ttpkt).  So this call to ttres() is
  essential.
*/
#ifdef OS2
    ttres();				/* Reset the communication device */
#else
    if (!local) {
	msleep(500);
	ttres();			/* Reset the communication device */
    }
#endif /* OS2 */
    xxscreen(SCR_TC,0,0L,"");		/* Transaction complete */
    x = quiet;
    quiet=1;
    clsif();				/* Failsafe in case we missed */
    clsof(1);				/* a case in the state machine. */
    quiet = x;

    if (server) {			/* Back from packet protocol. */
    	if (!quiet && !backgrd) {	/* Give appropriate message */
	    conoll("");
	    conoll("C-Kermit server done");
        }
        server = 0;			/* Not a server any more */
    }
}

static int
sgetinit(reget) int reget; {		/* Server end of GET command */
#ifdef PIPESEND
    extern int usepipes, pipesend;
#endif /* PIPESEND */
    if (!ENABLED(en_get)) {		/* Only if not disabled!  */
	errpkt((CHAR *)"GET disabled");
	return(-1);
    } else {				/* OK to go ahead. */
#ifdef WHATAMI
	debug(F101,"sgetinit whatru","",whatru);
	if (whatru & WMI_FLAG) {	/* Did we get WHATAMI info? */
	    debug(F101,"sgetinit binary (1)","",binary);
#ifdef VMS
	    if (binary != XYFT_I && binary != XYFT_L)
#else
#ifdef OS2
	    if (binary != XYFT_L)
#endif /* OS2 */
#endif /* VMS */
	    binary = (whatru & WMI_FMODE) ? /* Yes, set transfer mode */
	      XYFT_B : XYFT_T;		    /* automatically */
	    debug(F101,"sgetinit binary (2)","",binary);
	    fncnv = (whatru & WMI_FNAME) ? 1 : 0; /* And name conversion */
	}
#endif /* WHATAMI */
	srvptr = srvcmd;		/* Point to server command buffer */
	decode(rdatap,putsrv,0);	/* Decode the GET command into it */
	/* Accept multiple filespecs */
        cmarg2 = "";			/* Don't use cmarg2 */
	cmarg = "";			/* Don't use cmarg */
#ifndef NOMSEND				/* New way. */
	{
	    int n = 0;			/* But first check for quoted name */
	    if ((n = strlen((char *)srvcmd)) > 1) {
		/* Note: this does not allow for multiple quoted names */
		if ((srvcmd[0] == '{' && srvcmd[n-1] == '}') ||
		    (srvcmd[0] == '"' && srvcmd[n-1] == '"')) {
		    int i;
		    srvcmd[n-1] = '\0';
		    debug(F111,"sgetinit unquoting srvcmd",srvcmd,n);
		    for (i = 0; i < n-1; i++) /* Move over */
		      srvcmd[i] = srvcmd[i+1];
		} else
		  n = 0;
	    }
	    if (n == 0) {
		nfils = fnparse((char *)srvcmd); /* Use cmlist instead */
	    } else {
		nfils = 0 - zxpand((char *)srvcmd);
		cmarg = (char *)srvcmd;
	    }
	}
#endif /* NOMSEND */
#ifdef PIPESEND
	debug(F111,"sgetinit",srvcmd,usepipes);
	if (usepipes && ENABLED(en_hos) && *srvcmd == '!') {
	    cmarg = (char *)srvcmd + 1;	/* Point past the bang */
	    *srvcmd = NUL;
	    nfils = -1;
	    pipesend = 1;
	    debug(F111,"sgetinit pipesend",cmarg,pipesend);
	}
#endif /* PIPESEND */
#ifdef NOMSEND
#ifdef PIPESEND
	if (!pipesend)
#endif /* PIPESEND */
	  {
	      nfils = 0 - zxpand((char *)srvcmd);
	      cmarg = (char *)srvcmd;
	  }
#endif /* NOMSEND */
	nakstate = 0;			/* Now I'm the sender! */
	if (reget) sendmode = SM_RESEND;
	if (sinit() > 0) {		/* Send Send-Init */
#ifdef STREAMING
	    if (!streaming)
#endif /* STREAMING */
	      timint = chktimo(rtimo,timef); /* Switch to per-packet timer */
	    return(0);			/* If successful, switch state */
	} else return(-1);		/* Else back to server command wait */
    }
}
