#include "ckcsym.h"

/*  C K U U S 4 --  "User Interface" for C-Kermit, part 4  */

/*
  Author: Frank da Cruz <fdc@columbia.edu>,
  Columbia University Academic Information Systems, New York City.

  Copyright (C) 1985, 1998, Trustees of Columbia University in the City of New
  York.  The C-Kermit software may not be, in whole or in part, licensed or
  sold for profit as a software product itself, nor may it be included in or
  distributed with commercial products or otherwise distributed by commercial
  concerns to their clients or customers without written permission of the
  Office of Kermit Development and Distribution, Columbia University.  This
  copyright notice must not be removed, altered, or obscured.
*/

/*
  File ckuus4.c -- Functions moved from other ckuus*.c modules to even
  out their sizes.
*/
#include "ckcdeb.h"
#include "ckcasc.h"
#include "ckcker.h"
#include "ckuusr.h"
#include "ckuver.h"
#include "ckcnet.h"			/* Network symbols */

#ifdef CK_AUTHENTICATION
#include "ckuath.h"
#endif /* CK_AUTHENTICATION */

#ifdef VMS
#include <errno.h>			/* For \v(errno) */
extern char * ckvmserrstr(unsigned long);
#ifndef OLD_VMS
#include <lib$routines.h>		/* Not for VAX C 2.4 */
#else
#include <libdef.h>
#endif /* OLD_VMS */
_PROTOTYP(int vmsttyfd, (void) );
#endif /* VMS */

#ifdef OS2
#ifndef NT
#define INCL_NOPM
#define INCL_VIO			/* Needed for ckocon.h */
#include <os2.h> 
#undef COMMENT
#else 
#include <windows.h>
#include <tapi.h>
#include "ckntap.h"
#define APIRET ULONG
#endif /* NT */
#include "ckocon.h"
#include "ckoetc.h"
int StartedFromDialer = 0;
HWND hwndDialer = 0;
LONG KermitDialerID = 0;
#ifdef putchar
#undef putchar
#endif /* putchar */
#define putchar(x) conoc(x)
#ifdef CK_PID
#include <process.h>
#endif /* CK_PID */
#endif /* OS2 */

extern xx_strp xxstring;

#ifdef DEC_TCPIP
#include <descrip>
#include <dvidef>
#include <dcdef>
#endif /* DEC_TCPIP */

#include "ckcxla.h"			/* Character sets */
#ifdef CKOUNI
#include "ckouni.h"
#endif /* CKOUNI */

extern int quiet, network, xitsta, escape, nopush, xferstat;
#ifndef MAC
#ifndef AMIGA
extern int ttyfd;
#endif /* MAC */
#endif /* AMIGA */

#ifdef NETCONN
extern int tn_exit;
#endif /* NETCONN */
extern int exitonclose;

#ifdef TCPSOCKET
extern int ttnproto;
#ifdef IKS_OPTION
extern int tn_iks, u_iks, me_iks, u_iks_start, me_iks_start, autodl;
#endif /* IKS_OPTION */
#endif /* TCPSOCKET */

#ifndef NOICP				/* Most of this file... */

#ifndef AMIGA
#ifndef MAC
#include <signal.h>
#endif /* MAC */
#endif /* AMIGA */

#ifdef STRATUS				/* Stratus Computer, Inc.  VOS */
#ifdef putchar
#undef putchar
#endif /* putchar */
#define putchar(x) conoc(x)
#ifdef getchar
#undef getchar
#endif /* getchar */
#define getchar(x) coninc(0)
#endif /* STRATUS */

  
#ifdef ANYX25
extern int revcall, closgr, cudata;
int x25ver;
extern char udata[];
#ifndef IBMX25
extern int npadx3;
extern CHAR padparms[];
extern struct keytab padx3tab[];
#endif /* !IBMX25 */
#ifdef IBMX25
/* global variables only available for IBM X.25 - possibly interesting for
 * other implementations
 */
extern x25addr_t local_nua;
extern x25addr_t remote_nua;
#endif /* IBMX25 */
#endif /* ANYX25 */

#ifdef NETCONN
#ifndef NODIAL
extern int nnetdir;
extern char *netdir[];
#endif /* NODIAL */
extern char ipaddr[];
#ifdef TNCODE
extern int tn_duplex, tn_nlm, tn_binary, tn_b_nlm, u_binary, me_binary;
extern int tn_b_meu, tn_b_ume;
#ifdef CK_AUTHENTICATION 
extern int tn_auth;
#endif /* CK_AUTHENTICATION  */
#ifdef CK_ENCRYPTION
extern int tn_encrypt;
#endif /* CK_ENCRYPTION */
extern char *tn_term;
#endif /* TNCODE */

#ifdef CK_NETBIOS
extern unsigned short netbiosAvail;
extern unsigned long NetbeuiAPI;
extern unsigned char NetBiosName[];
extern unsigned char NetBiosAdapter;
extern unsigned char NetBiosLSN;
#endif /* CK_NETBIOS */

#ifdef TCPSOCKET
extern char myipaddr[];
extern int tcp_rdns;
#ifdef SOL_SOCKET
#ifdef SO_LINGER
extern int tcp_linger;
extern int tcp_linger_tmo;
#endif /* SO_LINGER */
#ifdef TCP_NODELAY
extern int tcp_nodelay;
#endif /* TCP_NODELAY */
#ifdef SO_SNDBUF
extern int tcp_sendbuf;
#endif /* SO_SNDBUF */
#ifdef SO_RCVBUF
extern int tcp_recvbuf;
#endif /* SO_RCVBUF */
#ifdef SO_KEEPALIVE
extern int tcp_keepalive;
#endif /* SO_KEEPALIVE */
#endif /* SOL_SOCKET */
#endif /* TCPSOCKET */
#endif /* NETCONN */

extern int cfilef;
extern char cmdfil[];

#ifndef NOSPL
extern int fndiags;			/* Function diagnostics on/off */
#ifdef CK_APC
extern int apcactive;			/* Nonzero = APC command was rec'd */
extern int apcstatus;			/* Are APC commands being processed? */
#ifdef DCMDBUF
extern char *apcbuf;			/* APC command buffer */
#else
extern char apcbuf[];
#endif /* DCMDBUF */
#endif /* CK_APC */

extern char evalbuf[];			/* EVALUATE result */
extern char uidbuf[], pwbuf[], prmbuf[];
_PROTOTYP( static char * fneval, (char *, char * [], int, char * ) );
_PROTOTYP( static VOID myflsh, (void) );
_PROTOTYP( static char * getip, (char *) );

static char hexdigits[16] = {
    '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'
};
extern char * tempdir;

#ifdef CK_REXX
extern char rexxbuf[];
#endif /* CK_REXX */

extern int tfline[];

/* These need to be internationalized... */

static
char *wkdays[] = {
    "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};
#endif /* NOSPL */

static
char *months[] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

#ifdef OS2
_PROTOTYP (int os2getcp, (void) );
#ifdef TCPSOCKET
extern char tcpname[];
#endif /* TCPSOCKET */
extern char startupdir[],exedir[];
extern int tcp_avail;
#ifdef DECNET
extern int dnet_avail;
#endif /* DECNET */
#ifdef SUPERLAT
extern int slat_avail;
#endif /* SUPERLAT */

extern int tt_type, max_tt;
extern struct tt_info_rec tt_info[];
extern int tt_rows[], tt_cols[];
#else /* OS2 */
extern int tt_rows, tt_cols;
#endif /* OS2 */

#ifdef CK_TAPI
extern int tttapi;
extern int tapipass;
extern struct keytab * tapilinetab;
extern struct keytab * _tapilinetab;
extern int ntapiline;
#endif /* CK_TAPI */

#ifdef VMS
extern char startupdir[];
#endif /* VMS */

#ifdef UNIX
extern char startupdir[];
#endif /* UNIX */

extern struct keytab colxtab[];

extern CHAR
  eol, feol, mypadc, mystch, padch, seol, stchr;

extern char ttname[], *ckxsys, *versio, **xargv, *zinptr;
extern char inidir[], *cksysid;

extern int activecmd, remonly, cmd_rows, cmd_cols;

extern struct ck_p ptab[];
extern char * srvstring;		/* autoserver string */
extern int protocol, prefixing, xfrcan, xfrchr, xfrnum, pktpaus;

extern int
  atcapr, autopar, bctr, bctu, bgset, bigrbsiz, bigsbsiz, binary, carrier,
  cdtimo, cmask, crunched, ckdelay, duplex, ebq, ebqflg, flow, fmask,
  fncact, fncnv, inecho, keep, local, lscapr, lscapu, xfermode,
  maxrps, maxsps, maxtry, mypadn, ncolx, dest, slostart,
  nettype, nmac, noinit, npad, parity, pktpaus, pktlog, pkttim, rcflag,
  retrans, rpackets, rptflg, rptq, rtimo, seslog, sessft, sosi, spackets,
  spsiz, spsizf, spsizr, stayflg, success, timeouts,
  tsecs, turn, turnch, urpsiz, wmax, wslotn, wslotr, xargc, xargs,
  zincnt, fdispla, tlevel, spmax, insilence, cmdmsk, timint, timef,
  fnrpath, fnspath, inbufsize, dironly, fileonly;
#ifdef OS2
extern int zxpn;
#endif /* OS2 */

#ifdef GFTIMER
extern CKFLOAT fptsecs, fpxfsecs;
#endif /* GFTIMER */
extern long xfsecs, tfcps;

extern CHAR * epktmsg;

#ifdef RECURSIVE
extern int recursive;
#endif /* RECURSIVE */

#ifdef VMS
  extern int frecl;
#endif /* VMS */

extern long
  ffc, filcnt, rptn, speed, tfc, tlci, tlco, ccu, ccp, vernum, xvernum, crc16;

#ifndef NOSPL
extern char fspec[], myhost[];
#endif /* NOSPL */

extern char *tfnam[];			/* Command file names */
#ifdef CK_TMPDIR
extern char *dldir;
#endif /* CK_TMPDIR */

#ifdef DCMDBUF
extern struct cmdptr *cmdstk;
extern char *line, *tmpbuf, *kermrc;
#else
extern struct cmdptr cmdstk[];
extern char line[], tmpbuf[], kermrcb[], *kermrc;
#endif /* DCMDBUF */

extern char pktfil[],			/* Packet log file name */
#ifdef DEBUG
  debfil[],				/* Debug log file name */
#endif /* DEBUG */
#ifdef TLOG
  trafil[],				/* Transaction log file name */
#endif /* TLOG */
  sesfil[];				/* Session log file name */

#ifndef NOXMIT				/* TRANSMIT command variables */
extern char xmitbuf[];
extern int xmitf, xmitl, xmitp, xmitx, xmits, xmitw, xmitt;
#endif /* NOXMIT */

#ifndef NOSPL
/* Script programming language items */
extern char **a_ptr[];			/* Arrays */
extern int a_dim[];
extern char * inpbuf, inchar[];		/* Buffers for INPUT and REINPUT */
extern char *inpbp;			/* And pointer to same */
#ifdef COMMENT
static char *inpbps = inpbuf;		/* And another */
#endif /* COMMENT */
static char *r3 = (char *)0;
extern int incount;			/* INPUT character count */
extern int m_found;			/* MINPUT result */
extern int maclvl;			/* Macro invocation level */
extern struct mtab *mactab;		/* Macro table */
extern char *mrval[];
extern int macargc[], cmdlvl;
extern char *m_line[];
extern char *m_arg[MACLEVEL][10]; /* You have to put in the dimensions */
extern char *g_var[GVARS];	  /* for external 2-dimensional arrays. */
#ifdef DCMDBUF
extern int *count, *inpcas;
#else
extern int count[], inpcas[];
#endif /* DCMDBUF */
#endif /* NOSPL */

#ifdef UNIX
extern int haslock;			/* For UUCP locks */
extern char flfnam[];
#endif /* UNIX */

#ifdef OS2ORUNIX
extern int maxnam, maxpath;		/* Longest name, path length */
#endif /* OS2ORUNIX */

extern int mdmtyp, mdmsav; 

#ifndef NODIAL
/* DIAL-related variables */
extern char modemmsg[];
extern MDMINF *modemp[];		/* Pointers to modem info structs */
extern int nmdm, dialhng, dialtmo, dialksp, dialdpy, dialsrt, dialmhu, dialsta;
extern int dialrtr, dialint, dialrstr, dialcon, dialcq, dialfld;
extern int mdmspd, dialec, dialdc, dialfc, dialmth, dialesc;
extern char *dialnum,   *dialini,  *dialdir[], *dialcmd,  *dialnpr,
 *dialdcon, *dialdcoff, *dialecon, *dialecoff, *dialhcmd, *diallac,
 *dialhwfc, *dialswfc,  *dialnofc, *dialpulse, *dialtone,
 *dialaaon, *dialaaoff;
extern char *diallcc,   *dialixp,  *dialixs,   *dialldp,  *diallds,
 *dialpxx,  *dialpxi,   *dialpxo,  *dialsfx,   *dialtfp;
extern char *diallcp,   *diallcs;
extern int ntollfree, nlocalac;
extern char *dialtfc[], *diallcac[];
extern int ndialdir, dialcnf, dialcvt, dialidt, dialpace;
extern long dialmax, dialcapas;

extern struct keytab mdmtab[];

#ifdef BIGBUFOK
#define ARGBUFSIZ 8191
#else
#define ARGBUFSIZ 1023
#endif /* BIGBUFOK */

#ifdef BIGBUFOK
extern char * dialmsg[];
#endif /* BIGBUFOK */

#endif /* NODIAL */

#ifndef NOCSETS
/* Translation stuff */
extern int fcharset, tcharset, tslevel, language, nlng, tcsr, tcsl;
extern struct keytab lngtab[];
extern struct csinfo fcsinfo[], tcsinfo[];
extern struct langinfo langs[];
#ifdef CK_ANSIC
extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* Character set */
extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* translation functions */
#else
extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])();	/* Character set */
extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])();	/* translation functions. */
#endif /* CK_ANSIC */
#endif /* NOCSETS */

#ifndef NOSPL
/* Built-in variable names, maximum length VNAML (20 characters) */

struct keytab vartab[] = {
    "_line",     VN_TFLN,  CM_INV,	/* 192 */
#ifdef OS2
    "_regname",  VN_REGN,  CM_INV,	/* 1.1.12 */
    "_regorg",   VN_REGO,  CM_INV,	/* 1.1.12 */
    "_regnum",   VN_REGS,  CM_INV,	/* 1.1.12 */
#endif /* OS2 */
    "apcactive", VN_APC,   CM_INV,	/* 192 */
    "argc",      VN_ARGC,  0,
    "args",      VN_ARGS,  0,
#ifdef BROWSER
    "browser",   VN_BROWSR,0,
    "browsopts", VN_BROPT, 0,
    "browsurl",  VN_URL,   0,
#endif /* BROWSER */
#ifndef NOCSETS
    "charset",   VN_CSET,  0,		/* 192 */
#endif /* NOCSETS */
    "cmdfile",   VN_CMDF,  0,
    "cmdlevel",  VN_CMDL,  0,
    "cmdsource", VN_CMDS,  0,
    "cols",      VN_COLS,  0,		/* 190 */
    "connection",VN_CONN,  0,		/* 190 */
    "count",     VN_COUN,  0,
    "cps",       VN_CPS,   0,		/* 190 */
    "cpu",	 VN_CPU,   0,
    "crc16",     VN_CRC16, 0,		/* 192 */
#ifndef NODIAL
    "d$ac",      VN_D_AC,  0,		/* 192 */
    "d$cc",      VN_D_CC,  0,		/* 192 */
    "d$ip",      VN_D_IP,  0,		/* 192 */
    "d$lc",      VN_D_LCP, 0,		/* 193 */
    "d$lcp",     VN_D_LCP, CM_INV,	/* 193 */
    "d$lp",      VN_D_LP,  0,		/* 192 */
#endif /* NODIAL */
    "date",      VN_DATE,  0,
    "day",       VN_DAY,   0,
    "dialnumber",VN_DNUM,  0,		/* 192 */
    "dialresult",VN_MDMSG, 0,		/* 192 */
    "dialstatus",VN_DIAL,  0,		/* 190 */
    "directory", VN_DIRE,  0,
    "download",  VN_DLDIR, 0,		/* 192 */
    "editor",    VN_EDITOR,0,
    "editfile",  VN_EDFILE,0,
    "editopts",  VN_EDOPT, 0,
    "errno",     VN_ERRNO, 0,		/* 192 */
    "errstring", VN_ERSTR, 0,		/* 192 */
    "escape",    VN_ESC,   0,		/* 193 */
    "evaluate",  VN_EVAL,  0,		/* 190 */
#ifdef OS2
     "exedir",   VN_EXEDIR,0,		/* 192 */
#endif /* OS2 */
    "exitstatus",VN_EXIT,  0,
    "filename",  VN_FNAM,  0,		/* 193 */
    "filenumber",VN_FNUM,  0,		/* 193 */
    "filespec",  VN_FILE,  0,
    "fsize",     VN_FFC,   0,		/* 190 */
    "ftype",     VN_MODE,  0,		/* 190 */
    "herald",    VN_HERALD,0,
    "home",      VN_HOME,  0,
    "host",      VN_HOST,  0,
    "input",     VN_IBUF,  0,
    "inchar",    VN_ICHR,  0,
    "incount",   VN_ICNT,  0,
    "inidir",    VN_INI,   0,		/* 192 */
    "instatus",  VN_ISTAT, 0,		/* 192 */
    "intime",    VN_INTIME,0,		/* 193 */
    "ipaddress", VN_IPADDR,0,		/* 192 */
#ifdef OS2
    "keyboard",  VN_KEYB,  0,
#endif /* OS2 */
#ifdef CK_KERBEROS    
    "krb4principal", VN_K4PRN, 0,
    "krb4realm",     VN_K4RLM, 0,
    "krb4service",   VN_K4SRV, 0,
    "krb5cc",        VN_K5CC,  0,
    "krb5principal", VN_K5PRN, 0,
    "krb5realm",     VN_K5RLM, 0,
    "krb5service",   VN_K5SRV, 0,
#endif /* CK_KERBEROS */
    "line",      VN_LINE,  0,
    "local",     VN_LCL,   0,
    "macro",     VN_MAC,   0,
    "minput",    VN_MINP,  0,		/* 192 */
    "model",     VN_MODL,  0,		/* 193 */
    "modem",     VN_MDM,   0,
#ifdef OS2
    "mousecurx", VN_MOU_X, 0,           /* K95 1.1.14 */
    "mousecury", VN_MOU_Y, 0,           /* K95 1.1.14 */
#endif /* OS2 */
#ifndef NODIAL
    "m_aa_off",  VN_M_ECX, 0,		/* all 192... */
    "m_aa_on",   VN_M_AAO, 0,
    "m_dc_off",  VN_M_DCX, 0,
    "m_dc_on",   VN_M_DCO, 0,
    "m_dial",    VN_M_DCM, 0,
    "m_ec_off",  VN_M_ECX, 0,
    "m_ec_on",   VN_M_ECO, 0,
    "m_fc_hw",   VN_M_HWF, 0,
    "m_fc_no",   VN_M_NFC, 0,
    "m_fc_sw",   VN_M_SWF, 0,
    "m_hup",     VN_M_HUP, 0,
    "m_init",    VN_M_INI, 0,
    "m_pulse",   VN_M_PDM, 0,
    "m_tone",    VN_M_TDM, 0,
#endif /* NODIAL */
    "name",      VN_NAME,  0,
    "ndate",     VN_NDAT,  0,
    "nday",      VN_NDAY,  0,
    "newline",   VN_NEWL,  0,
    "ntime",     VN_NTIM,  0,
    "osname",    VN_OSNAM, 0,		/* 193 */
    "osrelease", VN_OSREL, 0,		/* 193 */
    "osversion", VN_OSVER, 0,		/* 193 */
    "packetlen", VN_RPSIZ, 0,		/* 192 */
    "parity",    VN_PRTY,  0,		/* 190 */
    "password",  VN_PWD,   CM_INV,	/* 192 */
#ifdef PEXITSTAT
    "pexitstat", VN_PEXIT, 0,		/* 193 */
#endif /* PEXITSTAT */
#ifdef CK_PID
    "pid",       VN_PID,   0,		/* 193 */
#endif /* CK_PID */
    "platform",  VN_SYSV,  0,
    "printer",   VN_PRINT, 0,		/* 193 */
    "program",   VN_PROG,  0,
    "prompt",    VN_PRM,   CM_INV,	/* 192 */
    "protocol",  VN_PROTO, 0,		/* 192 */
    "p_8bit",    VN_P_8BIT,0,		/* 193 */
    "p_ctl",     VN_P_CTL, 0,		/* 193 */
    "p_rpt",     VN_P_RPT, 0,		/* 193 */
    "query",     VN_QUE,   0,		/* 190 */
    "return",    VN_RET,   0,
#ifdef CK_REXX
    "rexx",      VN_REXX,  0,		/* 190 */
#endif /* CK_REXX */
    "rows",      VN_ROWS,  0,		/* 190 */
#ifdef OS2
    "select",    VN_SELCT, 0,		/* 192 */
#endif /* OS2 */
    "sendlist",  VN_SNDL,  0,
    "speed",     VN_SPEE,  0,
#ifdef OS2
    "space",     VN_SPA,   0,
    "startup",   VN_STAR,  0,		/* 190 */
#else
#ifdef UNIX
    "startup",   VN_STAR,  0,		/* 193 */
#else
#ifdef VMS
    "startup",   VN_STAR,  0,		/* 193 */
#endif /* VMS */
#endif /* UNIX */
#endif /* OS2 */
    "status",    VN_SUCC,  0,
    "sysid",     VN_SYSI,  0,
    "system",    VN_SYST,  0,
    "terminal",  VN_TTYP,  0,
#ifdef OS2
    "termkey",   VN_TRMK,  CM_INV,      /* 192 */
#endif /* OS2 */
    "test",      VN_TEST,  0,		/* 193 */
    "tfsize",    VN_TFC,   0,
    "time",      VN_TIME,  0,
    "tmpdir",    VN_TEMP,  0,		/* 192 */
#ifdef CK_TRIGGER
    "trigger",   VN_TRIG,  0,		/* 193 */
#endif /* CK_TRIGGER */
#ifdef CK_TTYFD
    "ttyfd",     VN_TTYF,  0,
#endif /* CK_TTYFD */
#ifdef BROWSER
    "url",    	 VN_URL,   CM_INV,	/* 193 */
#endif /* BROWSER */
    "userid",    VN_UID,   0,		/* 192 */
    "version",   VN_VERS,  0,
    "window",    VN_WINDO, 0,		/* 192 */
#ifdef IBMX25
    "x25local_nua", VN_X25LA, 0,	/* 193 */
    "x25remote_nua", VN_X25RA, 0,	/* 193 */
#endif /* IBMX25 */
    "xferstatus",VN_XFSTAT,0,		/* 193 */
    "xfermsg",   VN_XFMSG, 0,		/* 193 */
    "xprogram",  VN_XPROG, 0,		/* 193 */
    "xversion",  VN_XVNUM, 0		/* 192 */
};
int nvars = (sizeof(vartab) / sizeof(struct keytab));
#endif /* NOSPL */

#ifndef NOSPL
struct keytab fnctab[] = {		/* Function names */
#ifdef OS2
    ".oox",       FN_OOX, CM_INV,	/* ... */
#endif /* OS2 */
    "basename",   FN_BSN, 0,		/* Basename */
    "break",      FN_BRK, 0,		/* Break (as in Snobol) */
    "ca",         FN_CAP, CM_INV|CM_ABR, /* Abbreviation for capitablize */
    "cap",        FN_CAP, CM_INV|CM_ABR, /* Abbreviation for capitablize */
    "capitalize", FN_CAP, 0,		/* First Letter -> uppercase */
    "caps",       FN_CAP, CM_INV,	/* ditto */
    "character",  FN_CHR, 0,		/* Character from code */
    "checksum",   FN_CHK, 0,		/* Checksum */
    "code",       FN_COD, 0,		/* Code from character */
#ifndef NOPUSH
    "command",    FN_CMD, 0,		/* Output from a command */
#endif /* NOPUSH */
    "contents",   FN_CON, 0,		/* Definition (contents) of variable */
    "crc16",      FN_CRC, 0,		/* CRC-16 */
#ifdef OS2
    "crypt",      FN_CRY, CM_INV,
#endif /* OS2 */
#ifdef ZFCDAT
    "date",       FN_FD,  0,		/* File modification/creation date */
#endif /* ZFCDAT */
    "definition", FN_DEF, 0,		/* Return definition of given macro */
    "dimension",  FN_DIM, 0,		/* Dimension of array */
    "directories",FN_DIR, 0,		/* List of directories */
    "dirname",    FN_DNAM,0,		/* Directory part of filename */
#ifdef FN_ERRMSG
    "errstring",  FN_ERRMSG, 0,         /* Error code to message */
#endif /* FN_ERRMSG */
    "evaluate",   FN_EVA, 0,		/* Evaluate given arith expression */
    "execute",    FN_EXE, 0,		/* Execute given macro */
    "files",      FN_FC,  0,		/* File count */
    "hexify",     FN_HEX, 0,		/* Hexify */
    "index",      FN_IND, 0,		/* Index (string search) */
    "ipaddress",  FN_IPA, 0,		/* Find and return IP address */
#ifdef CK_KERBEROS
    "krbisvalid",    FN_KRB_IV, 0,	/* Kerberos functions */
    "krbnextticket", FN_KRB_NX, 0,
    "krbtickets",    FN_KRB_TK, 0,
    "krbtimeleft",   FN_KRB_TT, 0,
#endif /* CK_KERBEROS */
    "length",     FN_LEN, 0,		/* Return length of argument */
    "literal",    FN_LIT, 0,		/* Return argument literally */
    "lop",        FN_STL, 0,		/* Lop */
    "lower",      FN_LOW, 0,		/* Return lowercased argument */
    "lpad",       FN_LPA, 0,		/* Return left-padded argument */
    "ltrim",      FN_LTR, 0,		/* Left-Trim */
    "maximum",    FN_MAX, 0,		/* Return maximum of two arguments */
    "minimim",    FN_MIN, 0,		/* Return minimum of two arguments */
    "modulus",    FN_MOD, CM_INV,	/* Return modulus of two arguments */
    "n2hex",      FN_2HEX, 0,		/* Number to hex */
    "n2octal",    FN_2OCT, 0,		/* Number to octal */
    "nextfile",   FN_FIL, 0,		/* Next file in list */
    "pathname",   FN_FFN, 0,		/* Full file name */
#ifndef NORANDOM
    "random",     FN_RAND,0,		/* Random number */
#endif /* NORANDOM */
#ifndef NOPUSH
    "rawcommand", FN_RAW, 0,		/* Output from a command (raw) */
#endif /* NOPUSH */
#ifdef RECURSIVE
    "rdirectories", FN_RDIR, 0,		/* Recursive directory list */
    "rfiles",       FN_RFIL, 0,		/* Recursive file list */
#endif /* RECURSIVE */
    "rep",        FN_REP, CM_INV|CM_ABR,
    "repeat",     FN_REP, 0,		/* Repeat argument given # of times */
    "replace",    FN_RPL, 0,		/* Replace characters in string */
    "reverse",    FN_REV, 0,		/* Reverse the argument string */
    "right",      FN_RIG, 0,		/* Rightmost n characters of string */
    "rindex",     FN_RIX, 0,		/* Right index */
    "rpad",       FN_RPA, 0,		/* Right-pad the argument */
#ifdef OS2
    "scrncurx",	  FN_SCRN_CX,  0,	/* Screen Cursor X Pos */
    "scrncury",	  FN_SCRN_CY,  0,	/* Screen Cursor Y Pos */
    "scrnstr",	  FN_SCRN_STR, 0,	/* Screen String */
#endif /* OS2 */
    "size",       FN_FS,  0,		/* File size */
    "span",       FN_SPN, 0,		/* Span - like Snobol */
    "split",      FN_SPLIT, 0,		/* Split string into words */
    "stripn",     FN_STN, 0,		/* Strip n chars */
    "stripx",     FN_STX, 0,		/* Strip "extension" */
    "substring",  FN_SUB, 0,		/* Extract substring from argument */
    "tod2secs",   FN_TOD, 0,		/* Time-of-day-to-secs-since-midnite */
    "trim",       FN_TRM, 0,		/* Trim */
    "unhexify",   FN_UNH, 0,		/* Unhexify */
    "upper",      FN_UPP, 0,		/* Return uppercased argument */
    "verify",	  FN_VER, 0,		/* Verify */
    "word",       FN_WORD,0		/* Extract a word */
};
int nfuncs = (sizeof(fnctab) / sizeof(struct keytab));
#endif /* NOSPL */

#ifndef NOSPL				/* Buffer for expansion of */
#ifdef BIGBUFOK				/* built-in variables. */
#define VVBUFL 1024
#else
#define VVBUFL 256
#endif /* BIGBUFOK */
char vvbuf[VVBUFL+1];
#endif /* NOSPL */

struct keytab disptb[] = {		/* Log file disposition */
    "append",    1,  0,
    "new",       0,  0
};

/* 
  P R E S C A N -- A quick look through the command-line options for 
  items that must be handled before the initialization file is executed.
*/
#ifdef NT
extern int StartedFromDialer;
#endif /* NT */
#ifdef OS2 
extern int k95stdio;
unsigned long startflags = 0L;
#endif /* OS2 */

VOID
prescan(y) int y; {
    extern int howcalled;
    int yargc; char **yargv;
    char x;
    char *yp;

    yargc = xargc;
    yargv = xargv;

#ifdef DCMDBUF
    if (!kermrc)
      if (!(kermrc = (char *) malloc(KERMRCL+1)))
	fatal("prescan: no memory for kermrc");
#endif /* DCMDBUF */

    strcpy(kermrc,KERMRC);		/* Default init file name */

    if (howcalled != I_AM_KERMIT)
      return;

#ifndef NOCMDL
#ifndef NOICP
    if (yargc > 1 && *yargv[1] != '-') { /* Filename as 1st argument */
#ifdef OS2
	extern char startupdir[], exedir[], inidir[];
	char * scriptenv, * keymapenv;
#endif /* OS2 */
#ifdef DCMDBUF
	extern char * cmdbuf;
#else
	extern char cmdbuf[];
#endif /* DCMDBUF */
	char takepath[1024];
	char *s;
	int x, y;

	if (!isabsolute(yargv[1])) {	/* If not absolute */
	    /* Set up search path... */
#ifdef OS2    
#ifdef NT
	    scriptenv = getenv("K95SCRIPTS");
	    keymapenv = getenv("K95KEYMAPS");
#else /* NT */
	    scriptenv = getenv("K2SCRIPTS");
	    keymapenv = getenv("K2KEYMAPS");
#endif /* NT */
	    if (!scriptenv)
	      scriptenv = getenv("CK_SCRIPTS");
	    if (!keymapenv)
	      keymapenv = getenv("CK_KEYMAPS");

	    debug(F110,"startupdir",startupdir,0);
	    debug(F110,"inidir",inidir,0);
	    debug(F110,"exedir",exedir,0);
	    sprintf(takepath,
		    /* semicolon-separated path list */
		    "%s%s%s%s%s;%s%s;%s%s;%s;%s%s;%s%s;%s;%s%s;%s%s", 
		    scriptenv?scriptenv:"",
		    (scriptenv && scriptenv[strlen(scriptenv)-1]==';')?"":";",
		    keymapenv?keymapenv:"",
		    (keymapenv && keymapenv[strlen(keymapenv)-1]==';')?"":";",
		    startupdir,
		    startupdir, "SCRIPTS/",    
		    startupdir, "KEYMAPS/",
		    inidir,
		    inidir, "SCRIPTS/",
		    inidir, "KEYMAPS/",
                    zhome(),
                    zhome(), "SCRIPTS/",
                    zhome(), "KEYMAPS/",
		    exedir,
		    exedir, "SCRIPTS/",
		    exedir, "KEYMAPS/"
                );
#else /* not OS2 */
#ifndef NOSPL
	    y = 1024;			/* Look in home directory */
	    s = takepath;
	    zzstring("\\v(home)",&s,&y);
#else
	    takepath[0] = '\0';
#endif /* NOSPL */
#endif /* OS2 */
/*
  All the logic for searching the take path is in the command parser.
  So even though we aren't parsing commands, we initialize and call the
  parser from here, with the purported filename stuffed into the command
  buffer, followed by some carriage returns to make the parser return.
  If the file is not found, or otherwise not accessible, the parser prints
  an appropriate message, and then we just exit.
*/
	    cmdini();			/* Allocate command buffers etc */
	    cmini(0);			/* Initialize them */
	    /* Stuff filename into command buf with braces in case of spaces */
	    sprintf(cmdbuf,"{%s}",yargv[1]);
	    debug(F110,"prescan cmdbuf",cmdbuf,0);
	    strcat(cmdbuf,"\r\r");	/* And some carriage returns */
	    if ((y = cmifip("","",&s,&x,0,takepath,xxstring)) < 0)
	      doexit(BAD_EXIT,xitsta);
	    cmres();
	} else
	  s = yargv[1];
	/* cfilef = 1; */	/* Command file */
#ifdef ZFNQFP
	zfnqfp(s,CKMAXPATH,cmdfil);	/* In case of CD in file */
#else
	strncpy(cmdfil,s,CKMAXPATH);
#endif /* ZFNQFP */
	yargc -= 1;			/* Skip past the filename */
	yargv += 1;			/* Otherwise we'll get an error */
    }
#endif /* NOICP */
    while (--yargc > 0) {		/* Go through command-line args */
	yargv++;
	yp = *yargv+1;			/* Pointer for bundled args */
	if (**yargv == '=') return;	/* Same rules as cmdlin()... */
#ifdef VMS
	else if (**yargv == '/')
	  continue;
#endif /* VMS */
    	else if (**yargv == '-') {	/* Got an option (begins with dash) */
	    x = *(*yargv+1);		/* Get option letter */
	    while (x) {			/* Allow for bundled options */
		debug(F000,"prescan arg","",x);
		switch (x) {
#ifdef OS2
		  case 'W':
		    if (*(yp+1))
		      fatal("invalid argument bundling after -W"); 
		    yargv++, yargc--;
		    if (yargc < 1)
		      fatal("Window handle missing");
		    if (y) {
			yargv++, yargc--;
			break; 
		    } else {	
			hwndDialer = (HWND) atol(*yargv);
			StartedFromDialer = 1;
			yargv++, yargc--;
			KermitDialerID = atol(*yargv) ;
		    }
		    break;

		  case '#':		/* K95 initialization options */
		    if (*(yp+1)) {
			fatal("invalid argument bundling"); 
		    }
		    yargv++, yargc--;
		    if (yargc < 1)
		      fatal("-# argument missing");
		    startflags = atol(*yargv);
		    break;
#endif /* OS2 */

#ifndef NOSPL
		case 'M':				/* My User Name */
		      if (*(yp+1)) {
			  fatal("invalid argument bundling");
		      }
		      yargv++, yargc--;
		      if ((yargc < 1) || (**yargv == '-')) {
			  fatal("missing username");
		      }
		      if ((int)strlen(*yargv) > 63) {
			  fatal("username too long");
		      }
		      strcpy(uidbuf,*yargv);
		      break;
#endif /* NOSPL */
		  case 'R':		/* Remote-only advisory */
#ifdef CK_IFRO
		    remonly = 1;
#endif /* CK_IFRO */
		    break;
		  case 'S':		/* STAY */
		    stayflg = 1;
		    break;
		  case 'h':
		  case 'Y':		/* No init file */
		    noinit = 1;
		    break;
		  case 'd':		/* = SET DEBUG ON */
#ifdef DEBUG
		    if (!deblog)
		      deblog = debopn("debug.log",0);
#endif /* DEBUG */
		    break;
		  case 'y':		/* Alternative init file */
		    yargv++, yargc--;
		    if (yargc < 1) fatal("missing name in -y");
		    if (!y)
		      break;
		    strcpy(kermrc,*yargv); /* Replace init file name */
		    rcflag = 1;		/* Flag that this has been done */
		    break;
		  case 'z':		/* = SET BACKGROUND OFF */
		    bgset = 0;
		    break;
#ifdef CK_NETBIOS
		  case 'N':
		    {
			int n ;
			yargv++, yargc--;
			if (y)
			  break;
			if (strlen(*yargv) != 1 || (*yargv)[0] == 'X') {
			    NetBiosAdapter = -1;
			} else {
			    n = atoi(*yargv);
			    if (n >= 0 && n <= 9)
			      NetBiosAdapter = n;
			    else
			      NetBiosAdapter = -1;
			} 
		    } 
		    break;
#endif /* CK_NETBIOS */
		  default:
		    break;
		}
		x = *++yp;		/* See if options are bundled */
	    }
	}
    }
#endif /* NOCMDL */
}

static int tr_int;			/* Flag if TRANSMIT interrupted */

#ifndef MAC
SIGTYP
#ifdef CK_ANSIC
trtrap(int foo)				/* TRANSMIT interrupt trap */
#else 
trtrap(foo) int foo;			/* TRANSMIT interrupt trap */
#endif /* CK_ANSIC */
/* trtrap */ {
#ifdef __EMX__
    signal(SIGINT, SIG_ACK);
#endif
    tr_int = 1;				/* (Need arg for ANSI C) */
    SIGRETURN;
}
#endif /* MAC */
#endif /* NOICP */

/*  G E T T C S  --  Get Transfer (Intermediate) Character Set  */

/*
  Given two file character sets, this routine picks out the appropriate
  "transfer" character set to use for translating between them.
  The transfer character set number is returned.

  Translation between two file character sets is done, for example,
  by the CONNECT, TRANSMIT, and TRANSLATE commands.

  Translation between Kanji character sets is not yet supported.
*/
int
gettcs(cs1,cs2) int cs1, cs2; {
#ifdef NOCSETS				/* No character-set support */
    return(0);				/* so no translation */
#else
    int tcs = TC_TRANSP;
#ifdef KANJI
/* Kanji not supported yet */
    if (fcsinfo[cs1].alphabet == AL_JAPAN ||
	fcsinfo[cs2].alphabet == AL_JAPAN )
      tcs = TC_TRANSP;
    else
#endif /* KANJI */
#ifdef CYRILLIC
/*
  I can't remember why we don't test both sets here, but I think there
  must have been a reason...
*/
      if (fcsinfo[cs2].alphabet == AL_CYRIL)
	tcs = TC_CYRILL;
      else
#endif /* CYRILLIC */
#ifdef LATIN2
	if (cs1 == FC_2LATIN || cs2 == FC_2LATIN ||
	    cs1 == FC_CP852  || cs2 == FC_CP852 )
	  tcs = TC_2LATIN;
	else
#endif /* LATIN2 */
#ifdef HEBREW
	  if (fcsinfo[cs1].alphabet == AL_HEBREW ||
	      fcsinfo[cs2].alphabet == AL_HEBREW )
	    tcs = TC_HEBREW;
	  else
#endif /* HEBREW */
#ifdef GREEK
	  if (fcsinfo[cs1].alphabet == AL_GREEK ||
	      fcsinfo[cs2].alphabet == AL_GREEK )
	    tcs = TC_GREEK;
	  else
#endif /* GREEK */
	    tcs = TC_1LATIN;
    return(tcs);
#endif /* NOCSETS */
}

#ifndef NOLOCAL
/*  D O C O N E C T  --  Do the connect command  */
/*
  q = 0 means issue normal informational message about how to get back, etc.
  q != 0 means to skip the message.
*/

int
doconect(q) int q; {
    int x, z;				/* Return code */
    extern int what;
#ifdef CK_AUTODL
    extern CHAR ksbuf[];
#endif /* CK_AUTODL */
#ifndef NOKVERBS			/* Keyboard macro material */
    extern int keymac, keymacx;
#endif /* NOKVERBS */
    extern int justone;
    int qsave;				/* For remembering "quiet" value */
#ifdef OS2
    extern int term_io;
    extern int display_demo;
    int term_io_save;
#endif /* OS2 */
/*
  Saving, changing, and restoring the global "quiet" variable around calls
  to conect() to control whether the verbose CONNECT message is printed is
  obviously less elegant than passing a parameter to conect(), but we do it
  this way to avoid the need to change all of the ck?con.c modules.  NOTE:
  it is important to restore the value immediately upon return in case there
  is an autodownload or APC.
*/
    qsave = quiet;			/* Save it */
    if (!quiet && q > -1)
      quiet = q;			/* Use argument temporarily */
    conres();				/* Put console back to normal */
    debug(F101,"doconect justone 1","",justone);
#ifdef CK_AUTODL
    ksbuf[0] = NUL;			/* Autodownload packet buffer */
#endif /* CK_AUTODL */
#ifdef OS2
    display_demo = 1;                   /* Remember to display demo */
#endif /* OS2 */
#ifdef IKS_OPTION
    if (network && ttnproto == NP_TELNET && me_iks
#ifdef CK_AUTODL
	&& autodl
#endif /* CK_AUTODL */
	) {
        tn_siks(0);                     /* Send Kermit-Server Start */
    }
#endif /* IKS_OPTION */
    x = conect();			/* Connect the first time */
#ifdef IKS_OPTION
    if (network && ttnproto == NP_TELNET && me_iks
#ifdef CK_AUTODL
	&& autodl
#endif /* CK_AUTODL */
	) {
        tn_siks(1);                     /* Send Kermit-Server Stop */
    }
#endif /* IKS_OPTION */
    quiet = qsave;			/* Restore "quiet" value */
    debug(F101,"doconect justone 2","",justone);

#ifdef NETCONN
    if (network && tn_exit && ttchk() < 0)
      doexit(GOOD_EXIT,xitsta);		/* Exit with good status */      
#endif /* NETCONN */

#ifdef OS2ORUNIX
    /* Exit on disconnect if the port is not open or carrier detect */
    if (exitonclose && (ttchk() < 0))
      doexit(GOOD_EXIT,xitsta);
#endif /* OS2ORUNIX */

    concb((char)escape);		/* Restore console for commands */
    conint(trap,stptrap);
    bgchk();

#ifdef OS2
    term_io_save = term_io;		/* Disable I/O by emulator */
    term_io = 0;
#endif /* OS2 */

#ifdef CK_APC
/*
  If an APC command was received during CONNECT mode, we define it now
  as a macro, execute the macro, and then return to CONNECT mode.
  We do this in a WHILE loop in case additional APCs come during subsequent
  CONNECT sessions.
*/
    debug(F101,"doconect apcactive","",apcactive);
    debug(F101,"doconect success","",success);
    debug(F101,"doconect xferstat","",xferstat);

    while (x > 0 && (apcactive == APC_LOCAL || 
	   (apcactive == APC_REMOTE && apcstatus != APC_OFF))) {
	debug(F101,"doconect justone 3","",justone);
        if (mlook(mactab,"_apc_commands",nmac) == -1) {
            debug(F110,"doconect about to execute APC",apcbuf,0);
            domac("_apc_commands",apcbuf,cmdstk[cmdlvl].ccflgs|CF_APC);
            delmac("_apc_commands");
        } else {
            debug(F100,"doconect APC in progress","",0);
        }
	if (!apcactive)			/* In case CLEAR APC was in APC */
	  break;
	/* Also don't reconnect if autodownload failed - very confusing! */
	/* Let them view the local screen to see what happened. */
	if (apcactive == APC_LOCAL & !xferstat) {
	    apcactive = APC_INACTIVE;
	    break;
	}
#ifdef OS2
	msleep(250);
#endif /* OS2 */
	debug(F101,"doconect justone 4","",justone);
	qsave = quiet;			/* Do this again... */
	if (!quiet && q > -1)
	  quiet = q;
#ifdef CK_AUTODL
	ksbuf[0] = NUL;
#endif /* CK_AUTODL */
#ifdef IKS_OPTION
        if (network && ttnproto == NP_TELNET && me_iks && autodl) {
            tn_siks(0);                 /* Send Kermit-Server Start */
        }
#endif /* IKS_OPTION */
	x = conect();			/* Re-CONNECT. */
#ifdef IKS_OPTION
        if (network && ttnproto == NP_TELNET && me_iks && autodl) {
            tn_siks(1);                 /* Send Kermit-Server Stop */
        }
#endif /* IKS_OPTION */
#ifdef OS2
        term_io = term_io_save;
#endif /* OS2 */
	quiet = qsave;
	debug(F101,"doconect justone 5","",justone);
#ifdef NETCONN
	if (network && ttchk() < 0) {
	    if (tn_exit || exitonclose)
	      doexit(GOOD_EXIT,xitsta);
	    else
	      break;
	}
#endif /* NETCONN */

#ifdef OS2ORUNIX
	/* If connection dropped */
	if (ttchk() < 0) {
	    concb((char)escape);	/* Restore console. */
	    if (exitonclose)
	      doexit(GOOD_EXIT,xitsta);
	    else
	      break;
	}
#endif /* OS2ORUNIX */
    }					/* Loop back for more. */
#endif /* CK_APC */

#ifndef NOKVERBS
    if ((keymac > 0) && (keymacx > -1)) { /* Executing a keyboard macro? */
	/* Set up the macro and return */
	/* Do not clear the keymac flag */
	return(dodo(keymacx,NULL,CF_KMAC|cmdstk[cmdlvl].ccflgs));
    }
#endif /* NOKVERBS */
#ifdef OS2
    term_io = term_io_save;
#endif /* OS2 */
    what = W_COMMAND;			/* Back in command mode. */
    return(x);				/* Done. */
}
#endif /* NOLOCAL */

#ifndef NOICP 
#ifdef COMMENT
/*
  It seemed that this was needed for OS/2, in which \v(cmdfile) and other
  file-oriented variables or functions can return filenames containing
  backslashes, which are subsequently interpreted as quotes rather than
  directory separators (e.g. see commented section for VN_CMDF below).
  But the problem can't be cured at this level.  Example:

    type \v(cmdfile)

  Without doubling, the filename is parsed correctly, but then when passed
  to UNIX 'cat' through the shell, the backslash is removed, and then cat
  can't open the file.  With doubling, the filename is not parsed correctly
  and the TYPE command fails immediately with a "file not found" error.
*/
/*
  Utility routine to double all backslashes in a string.
  s1 is pointer to source string, s2 is pointer to destination string,
  n is length of destination string, both NUL-terminated.
  Returns 0 if OK, -1 if not OK (destination string too short).
*/
int
dblbs(s1,s2,n) char *s1, *s2; int n; {
    int i = 0;
    while (*s1) {
	if (*s1 == '\\') {
	    if (++i > n) return(-1);
	    *s2++ = '\\';
	}
	if (++i > n) return(-1);
	*s2++ = *s1++;
    }
    *s2 = NUL;
    return(0);
}
#endif /* COMMENT */

char * 
gmdmtyp() {				/* Get modem type */
#ifndef NODIAL
    int i, x;
    x = mdmtyp;
    if (x < 0)				/* In case of network dialing */
      x = mdmsav;
    if (x < 1)    
      return("none");
    else
      for (i = 0; i < nmdm; i++)
	if ((mdmtab[i].kwval == x) && (mdmtab[i].flgs == 0))
	  return(mdmtab[i].kwd);
#endif /* NODIAL */
    return("none");
}

#ifndef NOXMIT
#ifndef NOLOCAL
/*  T R A N S M I T  --  Raw upload  */

/*  Obey current line, duplex, parity, flow, text/binary settings. */
/*  Returns 0 upon apparent success, 1 on obvious failure.  */

/***
 Things to add:
 . Make both text and binary mode obey set file bytesize.
 . Maybe allow user to specify terminators other than CR?
 . Maybe allow user to specify prompts other than single characters?
***/

/*  T R A N S M I T  --  Raw upload  */

/*  s is the filename, t is the turnaround (prompt) character  */

/*
  Maximum number of characters to buffer.
  Must be less than LINBUFSIZ
*/
#define XMBUFS 120

#ifdef NETCONN
#ifndef IAC
#define IAC 255
#endif /* IAC */
#endif /* NETCONN */

int
#ifdef CK_ANSIC
transmit(char * s, char t)
#else
transmit(s,t) char *s; char t;
#endif /* CK_ANSIC */
/* transmit */ {
#ifdef MAC
    extern char sstate;
    int count = 100;
#else
#ifdef OS2
#ifdef NT
SIGTYP (* oldsig)(int);			/* For saving old interrupt trap. */
#else /* NT */
SIGTYP (* volatile oldsig)(int);	/* For saving old interrupt trap. */
#endif /* NT */

#else /* OS2 */
    SIGTYP (* oldsig)();
#endif /* OS2 */
#endif /* MAC */
    long zz;
    int z = 1;				/* Return code. 0=fail, 1=succeed. */
    int x, c, i;			/* Workers... */
    int myflow;
    int mybinary;
#ifdef COMMENT
    CHAR csave;
#endif /* COMMENT */
    char *p;

#ifndef NOCSETS
    int tcs = TC_TRANSP;		/* Intermediate (xfer) char set */
    int langsv = L_USASCII;		/* Save current language */

#ifdef CKOUNI
    _PROTOTYP ( USHORT (*sxo), (CHAR) ) = NULL; /* Translation functions */
    _PROTOTYP ( int (*rxo), (USHORT) ) = NULL;
    _PROTOTYP ( USHORT (*sxi), (CHAR) ) = NULL;
    _PROTOTYP ( int (*rxi), (USHORT) ) = NULL;
#else /* CKOUNI */
    _PROTOTYP ( CHAR (*sxo), (CHAR) ) = NULL; /* Translation functions */
    _PROTOTYP ( CHAR (*rxo), (CHAR) ) = NULL;
    _PROTOTYP ( CHAR (*sxi), (CHAR) ) = NULL;
    _PROTOTYP ( CHAR (*rxi), (CHAR) ) = NULL;
#endif /* CKOUNI */
#endif /* NOCSETS */

/*
   If a system-specific binary mode is set (MacBinary, Image, Labeled, etc),
   revert to "normal" binary mode for duration of TRANSMIT command.
*/
    mybinary = binary;
    if (binary) binary = XYFT_B;
    if (zopeni(ZIFILE,s) == 0) {	/* Open the file to be transmitted */
	printf("?Can't open file %s\n",s);
	binary = mybinary;
	return(0);
    }
    x = -1;				/* Open the communication line */
    if (ttopen(ttname,&x,mdmtyp,cdtimo) < 0) {	/* (no harm if already open) */
	printf("Can't open device %s\n",ttname);
	binary = mybinary;
	return(0);
    }
    zz = x ? speed : -1L;
    if (binary) {			/* Binary file transmission */
	myflow = (flow == FLO_XONX) ? FLO_NONE : flow;
	if (ttvt(zz,myflow) < 0) {	/* So no Xon/Xoff! */
	    printf("Can't condition line\n");
	    binary = mybinary;
	    return(0);
	}
    } else {
	if (ttpkt(zz,flow,parity) < 0) { /* Put the line in "packet mode" */
	    printf("Can't condition line\n"); /* so Xon/Xoff will work, etc. */
	    binary = mybinary;
	    return(0);
	}
    }

#ifndef NOCSETS
#ifdef CKOUNI
/* Set up character set translations */
    if (binary == 0) {
	if (tcsr == tcsl || binary) {	/* Remote and local sets the same? */
	    sxo = NULL;			/* Or file type is not text? */
	    rxo = NULL;		
	    sxi = NULL;
	    rxi = NULL;
	} else {  
   	    sxo = xl_u[tcsl];
	    rxo = xl_tx[tcsr];
	    rxi = xl_tx[tcsl];
	    sxi = xl_u[tcsr];
	}
/*
   This is to prevent use of zmstuff() and zdstuff() by translation functions.
   They only work with disk i/o, not with communication i/o.  Luckily Russian
   translation functions don't do any stuffing...
*/
	langsv = language;
	language = L_USASCII;
    }
#else /* CKOUNI */
    tcs = gettcs(tcsr,tcsl);		/* Get intermediate set. */

/* Set up character set translations */
    if (binary == 0) {

	if (tcsr == tcsl || binary) {	/* Remote and local sets the same? */
	    sxo = rxo = NULL;		/* Or file type is not text? */
	    sxi = rxi = NULL;
	} else {			/* Otherwise, set up */
	    sxo = xls[tcs][tcsl];	/* translation function */
	    rxo = xlr[tcs][tcsr];	/* pointers for output functions */
	    sxi = xls[tcs][tcsr];	/* and for input functions. */
	    rxi = xlr[tcs][tcsl];
	}
/*
  This is to prevent use of zmstuff() and zdstuff() by translation functions.
  They only work with disk i/o, not with communication i/o.  Luckily Russian
  translation functions don't do any stuffing...
*/
	langsv = language;
	language = L_USASCII;
    }
#endif /* CKOUNI */
#endif /* NOCSETS */

    i = 0;				/* Beginning of buffer. */
#ifndef MAC
#ifndef AMIGA
    oldsig = signal(SIGINT, trtrap);	/* Save current interrupt trap. */
#endif /* AMIGA */
#endif /* MAC */
    tr_int = 0;				/* Have not been interrupted (yet). */
    z = 1;				/* Return code presumed good. */
#ifdef VMS
    conres();
#endif /* VMS */

    c = 0;				/* Initial condition */
    while (c > -1) {			/* Loop for all characters in file */
#ifdef MAC
	/*
	 * It is expensive to run the miniparser so don't do it for
	 * every character.
	 */
	if (--count < 0) {
	    count = 100;
	    miniparser(1);
	    if (sstate == 'a') {
		sstate = '\0';
		z = 0;
		break;
	    }
	}
#else /* Not MAC */
	if (tr_int) {			/* Interrupted? */
	    printf("^C...\n");		/* Print message */
	    z = 0;
	    break;
	}
#endif /* MAC */
	c = zminchar();			/* Get a file character */
	debug(F101,"transmit char","",c);
	if (c == -1)			/* Test for end-of-file */
	  break;
	if (c < 0) {			/* Other error */
	    z = 0;
	    goto xmitexit;	    
	}
	c &= fmask;			/* Apply SET FILE BYTESIZE mask */

	if (binary) {			/* If binary file, */
	    if (ttoc(dopar((char) c)) < 0) { /* else just send the char */
		printf("?Can't transmit character\n");
		z = 0;
		goto xmitexit;
	    }
#ifdef TNCODE
	    if (c == IAC && network && ttnproto == NP_TELNET)
	      ttoc((char)IAC);
#endif /* TNCODE */
	    if (xmitw) msleep(xmitw);	/* Pause if requested */
	    if (xmitx) {		/* SET TRANSMIT ECHO ON? */
		if (duplex) {		/* Yes, for half duplex */
#ifdef OS2
		    /* Echo to emulator */
		    scriptwrtbuf((USHORT)(c & cmdmsk));
#endif /* OS2 */
		    if (conoc((char)(c & cmdmsk)) < 0) { /* echo locally. */
			z = 0;
			goto xmitexit;
		    }
		} else {		/* For full duplex, */
		    int i, n;		/* display whatever is there. */
		    n = ttchk();	/* See how many chars are waiting */
		    if (n < 0) {	/* Connection dropped? */
			z = 0;
			goto xmitexit;
		    }
		    for (i = 0; i < n; i++) { /* Read and echo that many. */
			x = ttinc(xmitt); /* Timed read just in case. */
			if (x > -1) {	/* If no timeout */
#ifdef OS2
			    /* Echo to emulator */
			    scriptwrtbuf((USHORT)x);
#endif /* OS2 */
			    if (parity) x &= 0x7f; /* display the char, */
			    if (conoc((char)(x & cmdmsk)) < 0) {
				z = 0;
				goto xmitexit;
			    }
			} else if ( x == -2 ) {
                            printf("Connection closed.\n");
                            ttclos(1);
			} else if ( x == -3 ) {
			    printf(
			    "Session Limit exceeded - closing connection.\n"
				   );
                            ttclos(1);
                        } else
			  break;
		    }
		}
	    } else ttflui();		/* Not echoing, just flush input. */

	} else {			/* Text mode, line at a time. */

	    if (c == '\n') {		/* Got a line */
		int stuff = -1;
		if (i == 0) {		/* Blank line? */
		    if (xmitf)		/* Yes, insert fill if asked. */
		      line[i++] = dopar((char) xmitf);
		}
		if (i == 0 || ((char) line[i-1]) != ((char) dopar(CR)))
		  line[i++] = dopar(CR); /* Terminate it with CR */
		if (xmitl) {
		    stuff = LF;
#ifdef TNCODE
		} else if (network &&	/* TELNET NEWLINE ON/OFF/RAW */
			   (ttnproto == NP_TELNET) &&
			   (tn_nlm != TNL_CR)) {
		    stuff = (tn_nlm == TNL_CRLF) ? LF : NUL;
#endif /* TNCODE */
		}
		if (stuff > -1)
		  line[i++] = dopar((char)stuff);

	    } else if (c != -1) {	/* Not a newline, regular character */
#ifdef COMMENT
		csave = c;		/* Remember untranslated version */
#endif /* COMMENT */
#ifndef NOCSETS
		/* Translate character sets */
#ifdef CKOUNI
		if (cs_is_nrc(tcsl) || c > 127) 
		  if (sxo) c = (*sxo)((CHAR)c); /* Local to intermediate */
		if (c >= 32)
		  if (rxo) c = (*rxo)((CHAR)c); /* Intermediate to remote */
#else /* CKOUNI */
		if (sxo) c = (*sxo)((CHAR)c); /* From local to intermediate */
		if (rxo) c = (*rxo)((CHAR)c); /* From intermediate to remote */
#endif /* CKOUNI */
#endif /* NOCSETS */

		if (xmits && parity && (c & 0200)) { /* If shifting */
		    line[i++] = dopar(SO);          /* needs to be done, */
		    line[i++] = dopar((char)c);	    /* do it here, */
		    line[i++] = dopar(SI);          /* crudely. */
		} else {
		    line[i++] = dopar((char)c); /* else, just char itself */
#ifdef TNCODE
		    if (c == IAC && network && ttnproto == NP_TELNET)
		      line[i++] = IAC;
#endif /* TNCODE */
		}
	    }

/* Send characters if buffer full, or at end of line, or at end of file */

	    if (i >= XMBUFS || c == '\n' || c == -1) {
		p = line;
		line[i] = '\0';
		debug(F111,"transmit buf",p,i);
		if (ttol((CHAR *)p,i) < 0) { /* try to send it. */
		    printf("Can't send buffer\n");
		    z = 0;
		    break;
		}
		i = 0;			/* Reset buffer pointer. */

/* Worry about echoing here. "xmitx" is SET TRANSMIT ECHO flag. */

		if (duplex && xmitx) {	/* If local echo, echo it */
		    if (parity || cmdmsk == 0x7f) { /* Strip off high bits */
			char *s = p;		    /* if necessary */
			while (*s) {
			    *s &= 0x7f;
			    s++;
			}
		    }
#ifdef OS2
		    {			/* Echo to emulator */
			char *s = p;	
			while (*s) {
			    scriptwrtbuf((USHORT)*s);
                            s++;
			}
		    }
#endif /* OS2 */
		    if (conoll(p) < 0) {
			z = 0;
			goto xmitexit;
		    }
		}
		if (xmitw)		/* Give receiver time to digest. */
		  msleep(xmitw);
		if (t != 0 && c == '\n') { /* Want a turnaround character */
		    x = 0;		   /* Wait for it */
		    while (x != t) {
			if ((x = ttinc(xmitt)) < 0) {
                            switch (x) {
			      case -2:
                                printf("Connection closed.\n");
                                ttclos(1);
                                z = 0;
				goto xmitexit;
			      case -3:
				printf(
			       "Session Limit exceeded - closing connection.\n"
				       );
                                ttclos(1);
                                z = 0;
				goto xmitexit; 
			      default:
                                z = 0;
				goto xmitexit; 
                            }
                        }
			if (xmitx && !duplex && x > -1) { /* Echo any echoes */
			    if (parity) x &= 0x7f;
#ifndef NOCSETS
#ifdef CKOUNI
			    if (cs_is_nrc(tcsr) || x > 127) 
			      if (sxi) x = (*sxi)((CHAR)x);
			    if (x >= 32)
			      if (rxi) x = (*rxi)((USHORT)x);
#else /* CKOUNI */
			    if (sxi) x = (*sxi)((CHAR)x); /* But translate */
			    if (rxi) x = (*rxi)((CHAR)x); /* them first... */
#endif /* CKOUNI */
#endif /* NOCSETS */
			    if (conoc((char) x) < 0) { z = 0; goto xmitexit; }
			}
		    }
		} else if (xmitx && !duplex) { /* Otherwise, */
		    int n;
		    while ((n = ttchk()) > 0) {	/* echo for as long as */
			if ((x = ttinc(xmitt)) < 0) { /* anything is there. */
                            switch (x) {
			      case -2:
                                printf("Connection closed.\n");
                                ttclos(1);
                                z = 0;
				goto xmitexit;
			      case -3:
				printf(
			       "Session Limit exceeded - closing connection.\n"
				       );
                                ttclos(1);
                                z = 0;
				goto xmitexit;
			      default:
                                break;
                            }
                        }
			if (x > -1) {
#ifdef OS2
			/* Echo to emulator which takes care of translation  */
			    scriptwrtbuf((USHORT)x);
#endif /* OS2 */
			    if (parity) x &= 0x7f;
#ifndef NOCSETS
#ifdef CKOUNI
			    if (cs_is_nrc(tcsr) || x > 127) 
			      if (sxi) x = (*sxi)((CHAR)x);
			    if (x >= 32)
			      if (rxi) x = (*rxi)((USHORT)x);
#else /* CKOUNI */
			    if (sxi) x = (*sxi)((CHAR)x); /* Translate first */
			    if (rxi) x = (*rxi)((CHAR)x);
#endif /* CKOUNI */
#endif /* NOCSETS */
			    if (conoc((char)x) < 0) { z = 0; goto xmitexit; }
			}
		    }
		    if (n < 0) {	/* Connection dropped? */
			z = 0;
			goto xmitexit;
		    }
		} else ttflui();	/* Otherwise just flush input buffer */
	    }				/* End of buffer-dumping block */
	}				/* End of text mode */
    }					/* End of character-reading loop */

xmitexit:

    if (z > 0) {
	if (*xmitbuf) {			/* Anything to send at EOF? */
	    p = xmitbuf;		/* Yes, point to string. */
	    while (*p)			/* Send it. */
	      ttoc(dopar(*p++));	/* Don't worry about echo here. */
	}
    }

#ifndef AMIGA
#ifndef MAC
    signal(SIGINT,oldsig);		/* Put old signal action back. */
#endif /* MAC */
#endif /* AMIGA */
#ifdef VMS
    concb(escape);			/* Put terminal back, */
#endif /* VMS */
    zclose(ZIFILE);			/* Close file, */
#ifndef NOCSETS
    language = langsv;			/* restore language, */
#endif /* NOCSETS */
    binary = mybinary;			/* restore transfer mode, */
    ttres();				/* and terminal modes, */
    return(z);				/* and return successfully. */
}
#endif /* NOLOCAL */
#endif /* NOXMIT */

#ifndef NOCSETS

_PROTOTYP( CHAR (*sxx), (CHAR) );       /* Local translation function */
_PROTOTYP( CHAR (*rxx), (CHAR) );       /* Local translation function */
_PROTOTYP( CHAR zl1as, (CHAR) );	/* Latin-1 to ascii */
_PROTOTYP( CHAR xl1as, (CHAR) );	/* ditto */

/*  X L A T E  --  Translate a local file from one character set to another */

/*
  Translates input file (fin) from character set csin to character set csout
  and puts the result in the output file (fout).  The two character sets are
  file character sets from fcstab.
*/

int
xlate(fin, fout, csin, csout) char *fin, *fout; int csin, csout; {

#ifndef MAC
#ifdef OS2
#ifdef NT
    SIGTYP (* oldsig)(int);		/* For saving old interrupt trap. */
#else /* NT */
    SIGTYP (* volatile oldsig)(int);	/* For saving old interrupt trap. */
#endif /* NT */
#else /* OS2 */    
    SIGTYP (* oldsig)();		/* For saving old interrupt trap. */
#endif /* OS2 */
#endif /* MAC */
    int filecode;			/* Code for output file */

    int z = 1;				/* Return code. */
    int c, tcs;				/* Workers */

    if (zopeni(ZIFILE,fin) == 0) {	/* Open the file to be translated */
	printf("?Can't open input file %s\n",fin);
	return(0);
    }
#ifdef MAC
/*
  If user specified no output file, it goes to the screen.  For the Mac,
  this must be done a special way (result goes to a new window); the Mac
  doesn't have a "controlling terminal" device name.
*/
    filecode = !strcmp(fout,CTTNAM) ? ZCTERM : ZOFILE;
#else
#ifdef VMS
    filecode = !strcmp(fout,CTTNAM) ? ZCTERM : ZMFILE;
#else
    filecode = ZOFILE;
#endif /* VMS */
#endif /* MAC */

    if (zopeno(filecode,fout,NULL,NULL) == 0) { /* And the output file */
	printf("?Can't open output file %s\n",fout);
	return(0);
    }
#ifndef AMIGA
#ifndef MAC
    oldsig = signal(SIGINT, trtrap);	/* Save current interrupt trap. */
#endif /* MAC */
#endif /* AMIGA */

    tr_int = 0;				/* Have not been interrupted (yet). */
    z = 1;				/* Return code presumed good. */

    tcs = gettcs(csin,csout);		/* Get intermediate set. */

    printf("%s (%s) => %s (%s)\n",	/* Say what we're doing. */
	   fin, fcsinfo[csin].name,
	   fout,fcsinfo[csout].name
    );
    printf("via %s", tcsinfo[tcs].name);
    if (language)
      printf(", language: %s\n",langs[language].description);
    printf("\n\n");

    if (csin == csout) {		/* Input and output sets the same? */
	sxx = rxx = NULL;		/* If so, no translation. */
    } else {				/* Otherwise, set up */
	sxx = xls[tcs][csin];		/* translation function */
	rxx = xlr[tcs][csout];		/* pointers. */
	if (rxx == zl1as) rxx = xl1as;
    }
    while ((c = zminchar()) != -1) {	/* Loop for all characters in file */
	if (tr_int) {			/* Interrupted? */
	    printf("^C...\n");		/* Print message */
	    z = 0;
	    break;
	}
	if (sxx) c = (*sxx)((CHAR)c);	/* From fcs1 to tcs */
	if (rxx) c = (*rxx)((CHAR)c);	/* from tcs to fcs2 */

	if (zchout(filecode,(char)c) < 0) { /* Output the xlated character */
	    printf("File output error\n");
	    z = 0;
	    break;
	}
    }
#ifndef AMIGA
#ifndef MAC
    signal(SIGINT,oldsig);		/* put old signal action back. */
#endif /* MAC */
#endif /* AMIGA */

    tr_int = 0;
    zclose(ZIFILE);			/* close files, */
    zclose(filecode);
    return(z);				/* and return successfully. */
}
#endif /* NOCSETS */

/*  D O L O G  --  Do the log command  */

int
dolog(x) int x; {
    int y, disp; char *s = NULL;
#ifdef ZFNQFP
    struct zfnfp * fnp;
#endif /* ZFNQFP */

    switch (x) {			/* Which log... */

#ifdef DEBUG
      case LOGD:
	y = cmofi("Name of debugging log file","debug.log",&s,xxstring);
	break;
#endif /* DEBUG */

      case LOGP:
	y = cmofi("Name of packet log file","packet.log",&s,xxstring);
	break;

#ifndef NOLOCAL
      case LOGS:
	y = cmofi("Name of session log file","session.log",&s,xxstring);
	break;
#endif /* NOLOCAL */

#ifdef TLOG
      case LOGT:
	y = cmofi("Name of transaction log file","transact.log",&s,
		  xxstring);
	break;
#endif /* TLOG */

      default:
	printf("\n?Unknown log designator - %d\n",x);
	return(-2);
    }
    if (y < 0) return(y);
    if (y == 2) {
	printf("?Sorry, %s is a directory name\n",s);
	return(-9);
    }
#ifdef ZFNQFP
    if (fnp = zfnqfp(s,TMPBUFSIZ - 1,tmpbuf)) {
	if (fnp->fpath)
	  if ((int) strlen(fnp->fpath) > 0)
	    s = fnp->fpath;
    }
#endif /* ZFNQFP */

    strcpy(line,s);
    s = line;
#ifdef MAC
    y = 0;
#else
    if ((y = cmkey(disptb,2,"Disposition","new",xxstring)) < 0)
      return(y);
#endif /* MAC */
    disp = y;    
    if ((y = cmcfm()) < 0) return(y);

    switch (x) {

#ifdef DEBUG
      case LOGD:
	return(deblog = debopn(s,disp));
#endif /* DEBUG */

      case LOGP:
	return(pktlog = pktopn(s,disp));

#ifndef NOLOCAL
      case LOGS:
	return(seslog = sesopn(s,disp));
#endif /* NOLOCAL */

#ifdef TLOG
      case LOGT:
	return(tralog = traopn(s,disp));
#endif /* TLOG */

      default:
	return(-2);
    }
}

int
pktopn(s,disp) char *s; int disp; {
    extern char pktfil[];
    static struct filinfo xx;
    int y;

    zclose(ZPFILE);
    if(s[0] == '\0') return(0);
    if (disp) {
	xx.bs = 0; xx.cs = 0; xx.rl = 0; xx.org = 0; xx.cc = 0;
	xx.typ = 0; xx.dsp = XYFZ_A; xx.os_specific = '\0';
	xx.lblopts = 0;
	pktlog = zopeno(ZPFILE,s,NULL,&xx);
    } else pktlog = zopeno(ZPFILE,s,NULL,NULL);
    if (pktlog > 0)
      strcpy(pktfil,s);
    else
      *pktfil = '\0';
    return(pktlog);
}

int
traopn(s,disp) char *s; int disp; {
#ifdef TLOG
    extern char trafil[];
    extern int tlogfmt;
    static struct filinfo xx;
    int y;

    zclose(ZTFILE);
    if(s[0] == '\0') return(0);
    if (disp) {
	xx.bs = 0; xx.cs = 0; xx.rl = 0; xx.org = 0; xx.cc = 0;
	xx.typ = 0; xx.dsp = XYFZ_A; xx.os_specific = '\0';
	xx.lblopts = 0;
	tralog = zopeno(ZTFILE,s,NULL,&xx);
    } else tralog = zopeno(ZTFILE,s,NULL,NULL);
    if (tralog > 0 && tlogfmt > 0) {
	strcpy(trafil,s);
	tlog(F110,"Transaction Log:",versio,0L);
#ifndef MAC
	tlog(F100,ckxsys,"",0L);
#endif /* MAC */
	ztime(&s);
	tlog(F100,s,"",0L);
    } else *trafil = '\0';
    return(tralog);
#else
    return(0);
#endif /* TLOG */
}

#ifndef NOLOCAL
int
sesopn(s,disp) char * s; int disp; {
    extern char sesfil[];
    static struct filinfo xx;
    int y;

    zclose(ZSFILE);
    if(s[0] == '\0') return(0);
    if (disp) {
	xx.bs = 0; xx.cs = 0; xx.rl = 0; xx.org = 0; xx.cc = 0;
	xx.typ = 0; xx.dsp = XYFZ_A; xx.os_specific = '\0';
	xx.lblopts = 0;
	seslog = zopeno(ZSFILE,s,NULL,&xx);
    } else seslog = zopeno(ZSFILE,s,NULL,NULL);
    if (seslog > 0)
      strcpy(sesfil,s);
    else
      *sesfil = '\0';
    return(seslog);
}
#endif /* NOLOCAL */

int
debopn(s,disp) char *s; int disp; {
#ifdef DEBUG
#ifdef CK_UTSNAME
    extern char unm_mch[], unm_nam[], unm_rel[], unm_ver[], unm_mod[];
#endif /* CK_UTSNAME */
#ifdef OS2
    extern char ckxsystem[];
#endif /* OS2 */
    char *tp;
    static struct filinfo xx;

    zclose(ZDFILE);

    if (disp) {
	xx.bs = 0; xx.cs = 0; xx.rl = 0; xx.org = 0; xx.cc = 0;
	xx.typ = 0; xx.dsp = XYFZ_A; xx.os_specific = '\0';
	xx.lblopts = 0;
	deblog = zopeno(ZDFILE,s,NULL,&xx);
    } else deblog = zopeno(ZDFILE,s,NULL,NULL);
    if (deblog > 0) {
	strcpy(debfil,s);
	debug(F110,"Debug Log ",versio,0);
#ifndef MAC
#ifdef OS2
	debug(F110,ckxsys,ckxsystem,0);
#else /* OS2 */
	debug(F100,ckxsys,"",0);
#endif /* OS2 */
#endif /* MAC */
#ifdef CK_UTSNAME
	if (unm_mch[0]) {
	    debug(F110,"uname machine",unm_mch,0);
	    if (unm_mod[0])
	      debug(F110,"uname model  ",unm_mod,0);
	    debug(F110,"uname sysname",unm_nam,0);
	    debug(F110,"uname release",unm_rel,0);
	    debug(F110,"uname version",unm_ver,0);
	}
	deblog = 0;
	ztime(&tp);
	deblog = 1;
	debug(F100,tp,"",0);
#endif /* UTSNAME */
    } else *debfil = '\0';
    return(deblog);
#else
    return(0);
#endif /* MAC */
}

#ifndef NOSHOW

/*  SHOW command routines */

#ifndef NOLOCAL
#ifdef ANYX25
int
shox25(n) int n; {
    if (nettype == NET_SX25) {
	printf("SunLink X.25 V%d.%d",x25ver / 10,x25ver % 10);
	if (ttnproto == NP_X3) printf(", PAD X.3, X.28, X.29 protocol,");
	printf("\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
	printf(" Reverse charge call %s",
	       revcall ? "selected" : "not selected");
	printf (", Closed user group ");
	if (closgr > -1)
	  printf ("%d",closgr);
	else
	  printf ("not selected");
	printf("\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
	printf(" Call user data %s.\n", cudata ? udata : "not selected");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    } else if (nettype == NET_VX25) {
	if (ttnproto == NP_X3) printf(", PAD X.3, X.28, X.29 protocol,");
	printf("\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
	printf(" Reverse charge call %s",
	       revcall ? "selected" : "not selected");
	printf (", Closed user group [unsupported]");
	if (closgr > -1)
	  printf ("%d",closgr);
	else
	  printf ("not selected");
	printf (",");
	printf("\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
	printf(" Call user data %s.\n", cudata ? udata : "not selected");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    } else if (nettype == NET_IX25) {
	printf("AIX NPI X.25\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
	printf("\n Reverse charge call %s",
	       revcall ? "selected" : "not selected");
	printf (", Closed user group [unsupported]");
	if (closgr > -1)
	  printf ("%d",closgr);
	else
	  printf ("not selected");
	printf (",");
	printf("\n Call user data %s.\n", cudata ? udata : "not selected");
    }
    return(n);
}

#ifndef IBMX25
int
shopad(n) int n; {
    int i;
    printf("\nX.3 PAD Parameters:\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    for (i = 0; i < npadx3; i++) {
	printf(" [%d] %s %d\n",padx3tab[i].kwval,padx3tab[i].kwd,
	       padparms[padx3tab[i].kwval]);
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    }
    return(n);
}
#endif /* IBMX25 */
#endif /* ANYX25 */

VOID
shoparc() {
    extern int reliable;
    int i; char *s;
    long zz;

    printf("Communications Parameters:\n");
    if (network) {
	printf(" Host: %s%s",ttname,reliable ? " (reliable)" : "");
    } else {
#ifdef OS2
	printf(" Port: %s%s, speed: ",ttname,reliable ? " (reliable)" : "");
#else
	printf(" Line: %s%s, speed: ",ttname,reliable ? " (reliable)" : "");
#endif /* OS2 */
	if ((zz = ttgspd()) < 0) {
	    printf("unknown");
        } else {
	    if (speed == 8880) printf("75/1200");
	    else if (speed == 134) printf("134.5");
	    else printf("%ld",zz);
	}
    }
    if (network)
      printf("\n Mode: ");
    else
      printf(", mode: ");
    if (local) printf("local"); else printf("remote");
    if (network == 0) {
#ifdef CK_TAPI
	if (tttapi && !tapipass )
	  printf(", modem: %s","TAPI");
	else
#endif /* CK_TAPI */
	printf(", modem: %s",gmdmtyp());
    } else {
#ifdef NETCONN
       if (nettype == NET_TCPA) printf(", TCP/IP");
       if (nettype == NET_TCPB) printf(", TCP/IP");
       if (nettype == NET_DEC) {
	   if (ttnproto == NP_LAT) printf(", DECnet LAT");
	   else if ( ttnproto == NP_CTERM ) printf(", DECnet CTERM");
	   else printf(", DECnet");
       }
       if (nettype == NET_SLAT) printf(", Meridian Technologies' SuperLAT");
#ifdef NETFILE
       if (nettype == NET_FILE) printf(", local file");
#endif /* NETFILE */
#ifdef NETCMD
       if (nettype == NET_CMD) printf(", sub-process");
#endif /* NETCMD */
#ifdef NETDLL
       if (nettype == NET_DLL) printf(", dynamic load library");
#endif /* NETDLL */
#ifdef SSH
       if (nettype == NET_SSH) printf(", Secure Shell");
#endif /* SSH */
       if (nettype == NET_PIPE) printf(", Named Pipes");
#ifdef ANYX25
       if (shox25(0) < 0) return;
#endif /* ANYX25 */
       if (ttnproto == NP_TELNET) {
	   printf(", telnet protocol");
#ifdef CK_ENCRYPTION
	   if (ck_krb_encrypting() && ck_krb_decrypting())
	     printf(" (SECURE)");
#endif /* CK_ENCRYPTION */
       }
#endif /* NETCONN */
    }
    if (local) {
	i = parity ? 7 : 8;
	if (i == 8) i = (cmask == 0177) ? 7 : 8;
	printf("\n Terminal bits: %d, p",i);
    } else printf("\n P");
    printf("arity: %s",parnam((char)parity));
    printf(", duplex: ");
    if (duplex) printf("half, "); else printf("full, ");
    printf("flow: ");
    if (flow == FLO_KEEP) printf("keep");
        else if (flow == FLO_AUTO) printf("auto");
        else if (flow == FLO_XONX) printf("xon/xoff");
	else if (flow == FLO_NONE) printf("none");
	else if (flow == FLO_RTSC) printf(network ? "none" : "rts/cts");
	else if (flow == FLO_DTRT) printf(network ? "none" : "dtr/cts");
        else if (flow == FLO_DTRC) printf(network ? "none" : "dtr/cd");
	else printf("%d",flow);
    printf(", handshake: ");
    if (turn) printf("%d\n",turnch); else printf("none\n");
#ifdef COMMENT
    if (local && !network) {		/* SET CARRIER-WATCH */
#endif /* COMMENT */
	if (carrier == CAR_OFF) s = "off";
	else if (carrier == CAR_ON) s = "on";
	else if (carrier == CAR_AUT) s = "auto";
	else s = "unknown";
	printf(" Carrier-watch: %s", s);
	if (carrier == CAR_ON) {
	    if (cdtimo) printf(", timeout: %d sec", cdtimo);
	    else printf(", timeout: none");
	}
#ifdef COMMENT
    }
#endif /* COMMENT */
#ifdef UNIX
    if (local && !network && haslock && *flfnam) /* UUCP lockfile, UNIX only */
      printf(", lockfile: %s",flfnam);
#endif /* UNIX */
    printf("\n Escape character: %d (^%c)\n",escape,ctl(escape));
}

#ifdef TNCODE

#ifdef CK_AUTHENTICATION
_PROTOTYP(int ck_krb_authenticated, (VOID));
extern int forward_flag, forwarded_tickets;
#endif /* CK_AUTHENTICATION */
#ifdef CK_ENCRYPTION
_PROTOTYP(int ck_krb_encrypting, (VOID));
_PROTOTYP(int ck_krb_decrypting, (VOID));
#endif /* CK_ENCRYPTION */

int
shotel(n) int n; {
#ifdef CK_ENVIRONMENT
    extern int tn_env_flg;
#endif /* CK_ENVIRONMENT */
#ifdef CK_SNDLOC
    extern char * tn_loc;
#endif /* CK_SNDLOC */
    printf("SET TELNET parameters:\n echo: %s\n NVT newline-mode: ",
	   tn_duplex ? "local" : "remote");
    switch (tn_nlm) {
      case TNL_CRNUL: printf("%s\n","off (cr-nul)"); break;
      case TNL_CRLF:  printf("%s\n","on (cr-lf)"); break;
      case TNL_CR:    printf("%s\n","raw (cr)"); break;
      case TNL_LF:    printf("%s\n","(lf)"); break;
    }
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
#ifdef CK_AUTHENTICATION
    {
        int type = ck_krb_authenticated();   
        printf(" authentication: ");
        switch (tn_auth) {
	  case TN_NG_AC: printf( "accepted " ); break;
	  case TN_NG_RF: printf( "refused  " ); break;
	  case TN_NG_RQ: printf( "requested"); break;
	  case TN_NG_MU: printf( "required "); break;
        }
        printf("   in use: ");
        switch (type) {
	  case 0:
            printf("none");
            break;
	  case 1:
            printf("Kerberos IV");
            break;
	  case 2:
            printf("Kerberos V");
            break;
          case 5:
            printf("SRP");
            break;
        }
        printf("\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
        if (forward_flag)
	  printf("  credentials forwarding requested %s\n",
		 forwarded_tickets ? "and completed" : 
		 "but not completed");
        else        
	  printf("  credentials forwarding disabled\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
    }
#endif /* CK_AUTHENTICATION */
#ifdef CK_ENCRYPTION
    {
        int i,x;
        int e_type = ck_krb_encrypting();
        int d_type = ck_krb_decrypting();
        char * e_str = NULL, * d_str = NULL;
        static struct keytab * tnetbl = NULL;
        static int ntnetbl = 0;

        x = ck_get_crypt_table(&tnetbl,&ntnetbl);

        for (i = 0; i < ntnetbl; i++) {
            if (e_type == tnetbl[i].kwval)
	      e_str = tnetbl[i].kwd;
            if (d_type == tnetbl[i].kwval)
	      d_str = tnetbl[i].kwd;
        }
        printf(" encryption: ");
        switch (tn_encrypt) {
	  case TN_NG_AC: printf( "accepted " ); break;
	  case TN_NG_RF: printf( "refused  " ); break;
	  case TN_NG_RQ: printf( "requested"); break;
	  case TN_NG_MU: printf( "required "); break;
        }
        printf("       in use: ");
        switch ((e_type ? 1 : 0) | (d_type ? 2 : 0)) {
	  case 0:
            printf("plain text in both directions");
            break;
	  case 1:
            printf("%s output, plain text input",e_str);
            break;
	  case 2:
            printf("plain text output, %s input",d_str);
            break;
	  case 3:
            printf("%s output, %s input",e_str,d_str);
            break;
        }
        printf("\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
    }
#endif /* CK_ENCRYPTION */
#ifdef IKS_OPTION
    printf(" kermit-server: ");
    switch (tn_iks) {
      case TN_NG_AC: printf( "accepted " ); break;
      case TN_NG_RF: printf( "refused  " ); break;
      case TN_NG_RQ: printf( "requested"); break;
      case TN_NG_MU: printf( "required "); break;
    }
    printf("\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
#endif /* IKS_OPTION */
    printf(" BINARY newline-mode: ");
    switch (tn_b_nlm) {
      case TNL_CRNUL: printf("%s\n","off (cr-nul)"); break;
      case TNL_CRLF:  printf("%s\n","on (cr-lf)"); break;
      case TNL_CR:    printf("%s\n","raw (cr)"); break;
      case TNL_LF:    printf("%s\n","(lf)"); break;
    }
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
    printf(" binary-mode: ");
    switch (tn_binary) {
      case TN_NG_AC: printf( "accepted, " ); break ;
      case TN_NG_RF: printf( "refused, " ); break;
      case TN_NG_RQ: printf( "requested, "); break;
    };
    printf("host=%s, c-kermit=%s\n", u_binary ? "BINARY" : "NVT",
        me_binary ? "BINARY" : "NVT" ) ;
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
    printf(" bug binary-me-means-u-too: %s\n",showoff(tn_b_meu));
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
    printf(" bug binary-u-means-me-too: %s\n",showoff(tn_b_ume));
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
    printf(" terminal-type: ");
    if (tn_term) {
	printf("%s\n",tn_term);
    } else {
	char *p;
#ifdef OS2
	p = (tt_type >= 0 && tt_type <= max_tt) ?
	  tt_info[tt_type].x_name :
	    "UNKNOWN";
#else
	p = getenv("TERM");
#endif /* OS2 */
	if (p)
	  printf("none (%s will be used)\n",p);
	else printf("none\n");
    }
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
#ifdef CK_ENVIRONMENT
    printf(" environment: %s\n", showoff(tn_env_flg));
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0; 
#endif /* CK_ENVIRONMENT */
#ifdef CK_SNDLOC
    printf(" location: %s\n", tn_loc ? tn_loc : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
#endif /* CK_SNDLOC */
    return(n);
}
#endif /* TNCODE */

#ifdef CK_NETBIOS 
static int
shonb(n) int n; {
    printf("NETBIOS parameters:\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    printf(" API       : %s\n",
	   NetbeuiAPI ?
	   "NETAPI.DLL - IBM Extended Services or Novell Netware Requester"
	   : "ACSNETB.DLL - IBM Network Transport Services/2" ) ;
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    printf(" Local Name: [%s]\n", NetBiosName);
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    printf(" Adapter   : %d\n", NetBiosAdapter);
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    if (NetBiosLSN > 0xFF) {
	printf(" Session   : %d\n", NetBiosLSN);
    } else {
	printf(" Session   : none active\n");
    }
    if (++n > cmd_rows - 3) if (!askmore()) return(-1); else n = 0;
    return(n);
}
#endif /* CK_NETBIOS */

#ifndef NONET
int
shonet() {

#ifndef NETCONN
    printf("\nNo networks are supported in this version of C-Kermit\n");

#else /* rest of this routine */

    int i, n = 4;

#ifndef NODIAL
    if (nnetdir <= 1) {
	printf("\nNetwork directory: %s\n",netdir[0] ? netdir[0] : "(none)");
	n++;
    } else {
	int i;
	printf("\nNetwork directories:\n");
	for (i = 0; i < nnetdir; i++) {
	    printf("%2d. %s\n",i,netdir[i]);
	    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
	}
    }
#endif /* NODIAL */

#ifdef OS2
    printf("\nNetwork availability:\n");
#else
    printf("\nSupported networks:\n");
#endif /* OS2 */
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;

#ifdef VMS

#ifdef MULTINET
    printf(" TGV MultiNet TCP/IP");
#else
#ifdef WINTCP
    printf(" WOLLONGONG WIN/TCP");
#else
#ifdef DEC_TCPIP
    {
	static $DESCRIPTOR(tcp_desc,"_TCP0:");
        int status;
	long devclass;
	static int itmcod = DVI$_DEVCLASS;

#ifdef COMMENT
	status = LIB$GETDVI(&itmcod, 0, &tcp_desc, &devclass);
#else
	/* Martin Zinser 9/96 */
	status = lib$getdvi(&itmcod, 0, &tcp_desc, &devclass);
#endif /* COMMENT */
	if ((status & 1) && (devclass == DC$_SCOM))
	  printf(" Process Software Corporation TCPware for OpenVMS");
	else
	  printf(" DEC TCP/IP Services for (Open)VMS");
    }
#else
#ifdef CMU_TCPIP
    printf(" CMU-OpenVMS/IP");
#else
    printf(" None");
#endif /* CMU_TCPIP */
#endif /* DEC_TCPIP */
#endif /* WINTCP */
#endif /* MULTINET */
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#ifdef TNCODE
    printf(", TELNET protocol\n\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    n = shotel(n);
    if (n < 0) return(0);
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* TNCODE */
    printf("\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;

#else /* Not VMS */

#ifdef SUNX25
    printf(" SunLink X.25\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* SUNX25 */

#ifdef STRATUSX25
    printf(" Stratus VOS X.25\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* STRATUSX25 */

#ifdef IBMX25
    printf(" IBM AIX X.25\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* IBMX25 */

#ifdef HPX25
    printf(" HP-UX X.25\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* HPX25 */

#ifdef DECNET
#ifdef OS2
#ifdef NT
    if (dnet_avail)
      printf(" DECnet, LAT and CTERM protocols\n");
    else
      printf(" DECnet, LAT and CTERM protocols - not available\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#else /* NT */
    if (dnet_avail)
      printf(" DECnet, LAT protocol\n");
    else
      printf(" DECnet, LAT protocol - not available\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* NT */
#else
    printf(" DECnet\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* OS2 */
#endif /* DECNET */

#ifdef NPIPE
    printf(" Named Pipes\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* NPIPE */

#ifdef CK_NETBIOS
    if (netbiosAvail)
      printf(" NETBIOS\n");
    else
      printf(" NETBIOS - not available\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* CK_NETBIOS */

#ifdef SUPERLAT
    if (slat_avail)
      printf(" SuperLAT\n");
    else
      printf(" SuperLAT - not available\n") ;
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* SUPERLAT */

#ifdef TCPSOCKET
    if (
#ifdef OS2
	tcp_avail
#else
	1
#endif /* OS2 */
	) {
        if (!myipaddr[0])
	  getlocalipaddr();
	if (myipaddr[0])
#ifdef OS2ONLY
	  printf(" TCP/IP [%s] via %s\n", myipaddr, tcpname);
#else
	  printf(" TCP/IP [%s]\n",myipaddr);
#endif /* OS2ONLY */
	else
#ifdef OS2ONLY
	  printf(" TCP/IP via %s\n", tcpname);
#else
	  printf(" TCP/IP\n");
#endif /* OS2ONLY */
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;

#ifdef TNCODE
	if (nettype == NET_TCPB) {
	    printf("\n");
	    n = shotel(++n);
	    if (n < 0) return(0);
	    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
	}
#endif /* TNCODE */
#ifdef OS2
    } else {
        printf(" TCP/IP - not available%s\n",tcpname[0] ? tcpname : "" );
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* OS2 */
    }
#endif /* TCPSOCKET */

#ifdef CK_NETBIOS 
    if (netbiosAvail && nettype == NET_BIOS) {
       printf("\n") ;
       if ((n = shonb(++n)) < 0) return(0);
       if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    } 
#endif /* CK_NETBIOS */

#endif /* VMS */

    printf("\nActive network connection:\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;

    if (network) {
	printf(" Host: %s",ttname);
	if ((nettype == NET_TCPA || nettype == NET_TCPB) && *ipaddr)
	  printf(" [%s]",ipaddr);
    } else
      printf(" Host: none");
    printf(", via: ");
    if (nettype == NET_TCPA || nettype == NET_TCPB)
      printf("tcp/ip\n");
    else if (nettype == NET_SX25)
      printf("SunLink X.25\n");
    else if (nettype == NET_VX25)
      printf("Stratus VOS X.25\n");
    else if (nettype == NET_IX25)
      printf("IBM AIX X.25\n");
    else if (nettype == NET_HX25)
      printf("HP-UX X.25\n");
    else if (nettype == NET_DEC) {
	if ( ttnproto == NP_LAT )
	  printf("DECnet LAT\n");
	else if ( ttnproto == NP_CTERM )
	  printf("DECnet CTERM\n");
	else
	  printf("DECnet\n");
    } else if (nettype == NET_PIPE)
      printf("Named Pipes\n");
    else if (nettype == NET_BIOS)
      printf("NetBIOS\n");
    else if (nettype == NET_SLAT)
      printf("SuperLAT\n");

#ifdef NETFILE
    else if ( nettype == NET_FILE )
      printf("local file\n");
#endif /* NETFILE */
#ifdef NETCMD
    else if ( nettype == NET_CMD )
      printf("sub-process\n");
#endif /* NETCMD */
#ifdef NETDLL
    else if ( nettype == NET_DLL )
      printf("dynamic link library\n");
#endif /* NETDLL */
#ifdef SSH
    else if ( nettype == NET_SSH )
      printf("Secure Shell\n");
#endif /* SSH */
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;

#ifdef ANYX25
    if ((nettype == NET_SX25) ||
	(nettype == NET_VX25) ||
	(nettype == NET_IX25))
      if ((n = shox25(n)) < 0) return(0);
#endif /* ANYX25 */

#ifdef TCPSOCKET
    if (nettype == NET_TCPA || nettype == NET_TCPB) {
	printf(" Reverse DNS lookup: %s\n", showooa(tcp_rdns));
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;

#ifdef SOL_SOCKET
#ifdef SO_KEEPALIVE
	printf(" Keepalive: %s\n", showoff(tcp_keepalive));
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* SO_KEEPALIVE */

#ifdef SO_LINGER
	printf(" Linger: %s", tcp_linger ? "on, " : "off\n" );
	if (tcp_linger) {
	    if (tcp_linger_tmo)
	      printf("%d x 10 milliseconds\n",tcp_linger_tmo);
	    else
	      printf("no timeout\n");
	}
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* SO_LINGER */

#ifdef TCP_NODELAY
	printf(" Nodelay: %s\n", showoff(tcp_nodelay));
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* TCP_NODELAY */

#ifdef SO_SNDBUF
	if (tcp_sendbuf <= 0)
	  printf(" Send buffer: (default size)\n");
	else
	  printf(" Send buffer: %d bytes\n", tcp_sendbuf);
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* SO_SNDBUF */
#ifdef SO_RCVBUF 
	if (tcp_recvbuf <= 0)
	  printf(" Receive buffer: (default size)\n");
	else
	  printf(" Receive buffer: %d bytes\n", tcp_recvbuf);
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
#endif /* SO_RCVBUF */
#endif /* SOL_SOCKET */
    }

#ifdef RLOGCODE
    if (ttnproto == NP_RLOGIN) {
	printf(" LOGIN (rlogin) protocol\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0; 
    }
#endif /* RLOGCODE */

#ifdef TNCODE
    if (ttnproto == NP_TELNET) {
	printf(" TELNET protocol\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0; 
	printf(" Echoing is currently %s\n",duplex ? "local" : "remote");
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0; 
    }
#endif /* TNCODE */
    if (ttnproto == NP_TCPRAW) {
	printf(" Raw TCP socket\n");
	if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0; 
    }
#endif /* TCPSOCKET */
    printf("\n");
#endif /* NETCONN */
    return(0);
}
#endif /* NONET */

#ifndef NODIAL
VOID
shodial() {
    if (mdmtyp >= 0 || local != 0) doshodial();
}

VOID
shods(s) char *s; {			/* Show a dial-related string */
    char c;
    if (s == NULL || !(*s)) {		/* Empty? */
	printf("(none)\n");
    } else {				/* Not empty. */
	while (c = *s++)		/* Can contain controls */
	  if (c == '\\')		/* a backslash */
	    printf("\\\\");
	  else if (c > 31 && c < 127) {
	      putchar(c);
	  } else
	    printf("\\{%d}",c);
	printf("\n");
    }
}

int
doshodial() {

    int i, n = 2;

    printf(" Dial status:  %d", dialsta);

#ifdef BIGBUFOK
    if (dialsta > 90)
      printf(" = Unknown error");
    else if (dialsta < 0)
      printf(" = (none)");
    else if (dialsta < 30 && dialmsg[dialsta])
      printf(" = %s", dialmsg[dialsta]);
#endif /* BIGBUFOK */
    n++;
    if (ndialdir <= 1) {
	printf("\n Dial directory: %s\n",dialdir[0] ? dialdir[0] : "(none)");
    } else {
	int i;
	printf("\n Dial directories:\n");
	for (i = 0; i < ndialdir; i++)
	  printf("%2d. %s\n",i+1,dialdir[i]);
	n += ndialdir;
    }
    printf(" Dial method:  ");
    if      (dialmth == XYDM_D) printf("default");
    else if (dialmth == XYDM_P) printf("pulse  ");
    else if (dialmth == XYDM_T) printf("tone   ");
    printf("         Dial sort: %s\n",dialsrt ? "on" : "off");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(" Dial hangup:  %s             Dial display: %s\n",
	   dialhng ? "on " : "off", dialdpy ? "on" : "off");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(" Dial retries: %-6d          Dial interval: %d\n",
	   dialrtr, dialint);
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(" Dial timeout: ");
    if (dialtmo > 0)
      printf("%4d sec", dialtmo);
    else
      printf("0 (auto)");
    printf("        Redial number: %s\n",dialnum ? dialnum : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(" Dial confirmation: %s        Dial convert-directory: %s\n",
	   dialcnf ? "on " : "off",
	   dialcvt ? ((dialcvt == 1) ? "on" : "ask") : "off");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(" Dial ignore-dialtone: %s", dialidt ? "on " : "off");
    printf("     Dial pacing: %d\n",dialpace);
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial prefix:                  %s\n", dialnpr ? dialnpr : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial suffix:                  %s\n", dialsfx ? dialsfx : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial country-code:            %-12s", diallcc ? diallcc : "(none)");
    printf("Dial connect:  %s", dialcon ? ((dialcon == 1) ? "on" : "auto")
	   : "off");
    if (dialcon != CAR_OFF)
      printf(" %s", dialcq ? "quiet" : "verbose");
    printf(
"\n Dial area-code:               %-12s", diallac ? diallac : "(none)");
    n++;
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf("Dial restrict: ");
    if (dialrstr == 5) printf("international\n");
    else if (dialrstr == 4) printf("long-distance\n");
    else if (dialrstr == 2) printf("local\n");
    else if (dialrstr == 6) printf("none\n");
    else printf("?\n");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(" Dial lc-area-codes:           ");
    if (nlocalac == 0)
      printf("(none)");
    else
      for (i = 0; i < nlocalac; i++)
	printf("%s ", diallcac[i]);
    printf(
"\n Dial lc-prefix:               %s\n", diallcp ? diallcp : "(none)");
    n++;
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial lc-suffix:               %s\n", diallcs ? diallcs : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial ld-prefix:               %s\n", dialldp ? dialldp : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial ld-suffix:               %s\n", diallds ? diallds : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial force-long-distance      %s\n", showoff(dialfld));
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial intl-prefix:             %s\n", dialixp ? dialixp : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial intl-suffix:             %s\n", dialixs ? dialixs : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial toll-free-area-code:     ");
    if (ntollfree == 0)
      printf("(none)");
    else
      for (i = 0; i < ntollfree; i++)
	printf("%s ", dialtfc[i]);
    printf(
"\n Dial toll-free-prefix:        %s\n",
	   dialtfp ? dialtfp :
	  (dialldp ? dialldp : "(none)")
	  );
    n++;
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial pbx-exchange:            %s\n", dialpxx ? dialpxx : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial pbx-internal-prefix:     %s\n", dialpxi ? dialpxi : "(none)");
    if (++n > cmd_rows - 3) if (!askmore()) return(0); else n = 0;
    printf(
" Dial pbx-outside-prefix:      %s\n", dialpxo ? dialpxo : "(none)");
    return(0);
}
#endif /* NODIAL */
#endif /* NOLOCAL */

/*  Show File Parameters */

static char *
pathval(x) int x; {
    switch (x) {
      case PATH_OFF: return("off");
      case PATH_ABS: return("absolute");
      case PATH_REL: return("relative");
      default: return("unknown");
    }
}

VOID
shofil() {
    char *s; int i;
#ifdef PATTERNS
    extern int patterns;
#endif /* PATTERNS */
    extern char * rfspec, * sfspec;
#ifdef UNIX
    extern int zobufsize, zofbuffer, zofblock;
#endif /* UNIX */
#ifdef CK_CTRLZ
    extern int eofmethod;
#endif /* CK_CTRLZ */

    printf("\n");

#ifdef VMS
    printf(" File record-Length:      %5d\n",frecl);
#endif /* VMS */

    printf(" Transfer mode:           %s\n",
	   xfermode == XMODE_A ?
	   "automatic" :
	   "manual"
	   );

    printf(" File type:               ");
    switch (binary) {
      case XYFT_T: s = "text";	       break;
#ifdef VMS
      case XYFT_B: s = "binary fixed"; break;
      case XYFT_I: s = "image";        break;
      case XYFT_L: s = "labeled";      break;
      case XYFT_U: s = "binary undef"; break;
#else
#ifdef MAC
      case XYFT_B: s = "binary";       break;
      case XYFT_M: s = "macbinary";    break;
#else
      case XYFT_B: s = "binary";       break;
#ifdef CK_LABELED
      case XYFT_L: s = "labeled";      break;
#endif /* CK_LABELED */
#endif /* MAC */
#endif /* VMS */
      default: s = "?"; break;
    }
    printf("%s\n",s);
#ifdef PATTERNS
    printf(" File patterns:           %s", showoff(patterns));
    if (patterns)
      printf(" (SHOW PATTERNS for list)");
    printf("\n");
#endif /* PATTERNS */
    if (fncnv == XYFN_L)
      s = "literal";
    else if (fncnv == XYFN_C)
      s = "converted";
    else
      s = "(unknown)";
    printf(" File names:              %s\n",s);
    printf(" Send pathnames:          %s\n", pathval(fnspath));
    printf(" Receive pathnames:       %s\n", pathval(fnrpath));
    printf(" File collision:          ");
    for (i = 0; i < ncolx; i++)
      if (colxtab[i].kwval == fncact) break;
    printf("%s\n", (i == ncolx) ? "unknown" : colxtab[i].kwd);
    printf(" File destination:        %s\n",
	   (dest == DEST_D) ? "disk" :
	   ((dest == DEST_S) ? "screen" :
	    ((dest == DEST_N) ? "nowhere" :
	    "printer"))
	   );
    printf(" File incomplete:         %s\n", keep ? "keep" : "discard");
    printf(" File bytesize:           %d\n",(fmask == 0177) ? 7 : 8);
#ifndef NOCSETS
    printf(" File character-set:      %s\n",fcsinfo[fcharset].keyword);
#endif /* NOCSETS */

    printf(" File end-of-line:        ");
    switch (feol) {
      case XYFA_C: printf("%s\n","cr"); break;
      case XYFA_L: printf("%s\n","lf"); break;
      case XYFA_2: printf("%s\n","crlf"); break;
    }
#ifdef CK_CTRLZ
    printf(" File eof:                %s\n", eofmethod ? "ctrl-z" : "length");
#endif /* CK_CTRLZ */
#ifdef COMMENT
    printf(" File display:            ");
    switch (fdispla) {
      case XYFD_N: printf("%s\n","none"); break;
      case XYFD_R: printf("%s\n","serial"); break;
      case XYFD_C: printf("%s\n","fullscreen"); break;
      case XYFD_S: printf("%s\n","crt"); break;
    }
#endif /* COMMENT */
#ifdef CK_TMPDIR
    printf(" File download-directory: %s\n", dldir ? dldir : "(none)");
#ifdef COMMENT
    i = 256;
    s = line;
    zzstring("\\v(tmpdir)",&s,&i);
    printf(" Temporary directory:     %s\n", line);
#endif /* COMMENT */
#endif /* CK_TMPDIR */
#ifdef KERMRC
    printf(" Initialization file:     %s\n", noinit ? "(none)" :
#ifdef CK_SYSINI
	   CK_SYSINI
#else
	   kermrc
#endif /* CK_SYSINI */
	   );
#endif /* KERMRC */

#ifdef UNIX
    printf(" Disk output buffer:      %d (writes are %s, %s)\n",
	   zobufsize,
	   zofbuffer ? "buffered" : "unbuffered",
	   zofblock ? "blocking" : "nonblocking"
	   );
#endif /* UNIX */
#ifdef OS2ORUNIX
    printf(" Longest filename:        %d\n", maxnam);
    printf(" Longest pathname:        %d\n", maxpath);
#endif /* OS2ORUNIX */

    printf(" Last file sent:          %s\n", sfspec ? sfspec : "(none)");
    printf(" Last file received:      %s\n", rfspec ? rfspec : "(none)");
    printf(" Also see: SHOW PROTOCOL");
#ifdef CK_LABELED
    printf(", SHOW LABELED");
#endif /* CK_LABELED */
#ifdef PATTERNS
    printf(", SHOW PATTERNS");
#endif /* PATTERNS */
#ifdef STREAMING
    printf(", SHOW STREAMING");
#endif /* STREAMING */
#ifndef NOCSETS
    printf(", SHOW CHARACTER-SETS");
#endif /* NOCSETS */
    printf("\n\n");
}

VOID
shoparp() {				/* Protocol */
    extern int docrc;
    char *s;

#ifdef CK_TIMERS
    extern int rttflg;
#endif /* CK_TIMERS */

    printf("Protocol: %s\n",ptab[protocol].p_name);

    if (protocol == PROTO_K) {
	printf("\nProtocol Parameters:   Send    Receive");
	if (timef)
	  printf("\n Timeout (used=%2d):%7d*%8d ", timint, rtimo, pkttim);
	else
	  printf("\n Timeout (used=%2d):%7d%9d ",  timint, rtimo, pkttim);
#ifdef XFRCAN
	printf("       Cancellation:    %s",showoff(xfrcan));
	if (xfrcan)
	  printf(" %d %d", xfrchr, xfrnum);
#endif /* XFRCAN */
	printf("\n Padding:      %11d%9d", npad,   mypadn);
	if (bctr == 4)
	  printf("        Block Check: blank-free-2\n");
	else
	  printf("        Block Check: %6d\n",bctr);
	printf(  " Pad Character:%11d%9d", padch,  mypadc);
	printf("        Delay:       %6d\n",ckdelay);
	printf(  " Pause:        %11d%9d", pktpaus, pktpaus);
	printf("        Attributes: %s\n",showoff(atcapr));
	printf(  " Packet Start: %11d%9d", mystch, stchr);
	printf("        Max Retries: %6d\n",maxtry);
	printf(  " Packet End:   %11d%9d", seol,   eol);
	if (ebqflg)
	  printf("        8th-Bit Prefix: '%c'",ebq);
	printf(  "\n Packet Length:%11d ", spmax);
	printf("%8d     ",  urpsiz);
	if (rptflg)
	  printf("   Repeat Prefix:  '%c'",rptq);
	printf(  "\n Maximum Length: %9d%9d", maxsps, maxrps);
	printf("        Window Size:%7d set, %d used\n",wslotr,wmax);
	printf(    " Buffer Size:  %11d%9d", bigsbsiz, bigrbsiz);
	printf("        Locking-Shift:    ");
	if (lscapu == 2) {
	    printf("forced");
	} else {
	    printf("%s", (lscapr ? "enabled" : "disabled"));
	    if (lscapr) printf(",%s%s", (lscapu ? " " : " not "), "used");
	}
	printf("\n\n");

        if (!(s = ptab[protocol].h_b_init)) s = "";
	printf(" Auto-upload command (binary): %s\n", *s ? s : "(none)");
        if (!(s = ptab[protocol].h_t_init)) s = "";
	printf(" Auto-upload command (text):   %s\n", *s ? s : "(none)");
        if (!(s = srvstring)) s = "";
	printf(" Auto-server command:          %s\n", *s ? s : "(none)");

#ifdef CK_TIMERS
	if (rttflg) {
	    extern int mintime, maxtime;
	    printf(" Packet timeouts: dynamic %d:%d\n", mintime, maxtime);
	} else {
	    printf(" Packet timeouts: fixed\n");
	}
#endif /* CK_TIMERS */
	printf(" Transfer mode:   %s", xfermode == XMODE_A ?
	       "automatic   " :
	       "manual      "
	       );
	printf(" Transfer slow-start: %s, crc: %s\n",
	       showoff(slostart),
	       showoff(docrc)
	       );
#ifdef PIPESEND
	{
	    extern int usepipes;
            printf(" Transfer pipes:  %s         ",usepipes ? "on " : "off");
	}
#endif /* PIPESEND */
#ifndef NOCSETS
	printf(" Transfer character-set: ");
	if (tcharset == TC_TRANSP)
	  printf("transparent\n");
	else
	  printf("%s\n", tcsinfo[tcharset].keyword );
#endif /* NOCSETS */
#ifdef PIPESEND
	{
	    extern char * sndfilter, * rcvfilter;
	    printf(" Send filter:     %s\n", sndfilter ? sndfilter : "(none)");
	    printf(" Receive filter:  %s\n", rcvfilter ? rcvfilter : "(none)");
	}
#endif /* PIPESEND */
	printf("\n");
	printf("Also see: SHOW FILE");
#ifdef CK_LABELED
	printf(", SHOW LABELED");
#endif /* CK_LABELED */
#ifdef PATTERNS
	printf(", SHOW PATTERNS");
#endif /* PATTERNS */
#ifdef STREAMING
	printf(", SHOW STREAMING");
#endif /* STREAMING */
#ifndef NOCSETS
	printf(", SHOW CHARACTER-SETS");
#endif /* NOCSETS */
    }

#ifdef CK_XYZ
#ifdef XYZ_INTERNAL
    if (protocol != PROTO_K) {
	int i;
	int x;
	printf(" Transfer mode: %s\n", binary ? "binary" : "text");
        if (protocol == PROTO_Z) {		/* Zmodem */
            printf(" Window size:   ");
            if (ptab[protocol].winsize < 1)
              printf("none\n");
            else
              printf("%d\n",wslotr);
#ifdef COMMENT
            printf(" Packet (frame) length: ");
            if (ptab[protocol].spktlen < 0)
              printf("none\n");
            else
              printf("%d\n",spmax);
#endif /* COMMENT */
        } else {
            if (ptab[protocol].spktlen >= 1000)
              printf(" 1K packets\n");
            else
              printf(" 128-byte packets\n");
        }
	printf(" Pathname stripping when sending:   %s\n",
               showoff(ptab[protocol].fnsp)
               );
	printf(" Pathname stripping when receiving: %s\n",
               showoff(ptab[protocol].fnrp)
               );
	printf(" Filename collision action:         ");
	for (i = 0; i < ncolx; i++)
          if (colxtab[i].kwval == fncact) break;
	printf("%-12s", (i == ncolx) ? "unknown" : colxtab[i].kwd);

	printf("\n Escape control characters:          ");
	x = ptab[protocol].prefix;
	if (x == PX_ALL)
	  printf("all\n");
	else if (x == PX_CAU || x==PX_WIL)
	  printf("minimal\n");
	else
	  printf("none\n");
        if (!(s = ptab[protocol].h_b_init))
	  s = "";
	printf(" Autoreceive command (binary): %s\n", *s ? s : "(none)");
        if (!(s = ptab[protocol].h_t_init))
	  s = "";
	printf(" Autoreceive command (text):   %s\n", *s ? s : "(none)");
    }
#else
    if (protocol != PROTO_K) {
	printf("\nExecuted by external commands:\n\n");
	s = ptab[protocol].p_b_scmd; 
	if (!s) s = "";
	printf(" SEND command (binary):        %s\n", *s ? s : "(none)");
	s = ptab[protocol].p_t_scmd; 
	if (!s) s = "";
	printf(" SEND command (text):          %s\n", *s ? s : "(none)");
	s = ptab[protocol].p_b_rcmd; 
	if (!s) s = "";
	printf(" RECEIVE command (binary):     %s\n", *s ? s : "(none)");
	s = ptab[protocol].p_t_rcmd; 
	if (!s) s = "";
	printf(" RECEIVE command (text):       %s\n", *s ? s : "(none)");
	s = ptab[protocol].h_b_init; 
	if (!s) s = "";
	printf(" Autoreceive command (binary): %s\n", *s ? s : "(none)");
	s = ptab[protocol].h_t_init; 
	if (!s) s = "";
	printf(" Autoreceive command (text):   %s\n", *s ? s : "(none)");
    }
#endif /* XYZ_INTERNAL */
#endif /* CK_XYZ */
}

#ifndef NOCSETS
VOID
shoparl() {
#ifdef COMMENT
    int i;
/* Misleading... */
    printf("\nAvailable Languages:\n");
    for (i = 0; i < MAXLANG; i++) {
	printf(" %s\n",langs[i].description);
    }
#else
    printf("\nLanguage-specific translation rules: %s\n",
	   language == L_USASCII ? "none" : langs[language].description);
    shocharset();
    printf("\n\n");
#endif /* COMMENT */
}

VOID
shocharset() {
    int x;
    printf("\n File Character-Set: %s (%s), ",
	   fcsinfo[fcharset].keyword,
	   fcsinfo[fcharset].name
	   );
    if ((x = fcsinfo[fcharset].size) == 128) printf("7-bit");
    else if (x == 256) printf("8-bit");
    else printf("multibyte");
    printf("\n Transfer Character-Set");
#ifdef COMMENT
    if (tslevel == TS_L2)
      printf(": (international)");
    else
#endif /* COMMENT */
    if (tcharset == TC_TRANSP)
      printf(": Transparent");
    else
      printf(": %s (%s)",tcsinfo[tcharset].keyword, tcsinfo[tcharset].name);
}
#endif /* NOCSETS */

VOID
shopar() {
    printf("SHOW what?\n");
}
#endif /* NOSHOW */

/*  D O S T A T  --  Display file transfer statistics.  */

int
dostat(brief) int brief; {
    extern long filrej, peakcps, lastspmax;
    extern char whoareu[];
    int n = 0;
    extern int docrc;

#ifdef CK_TTGWSIZ
#ifdef OS2
    if (tt_cols[VTERM] < 0 || tt_rows[VTERM] < 0)
      ttgwsiz();
#else /* OS2 */
    if (ttgwsiz() > 0) {
	if (tt_rows > 0 && tt_cols > 0) {
	    cmd_rows = tt_rows;
	    cmd_cols = tt_cols;
	}	    
    }
#endif /* OS2 */
#endif /* CK_TTGWSIZ */

    debug(F101,"dostat xferstat","",xferstat);
    if (xferstat < 0) {
	printf(" No file transfers yet.\n");
	return(1);
    }
    if (brief) printf("\n");
    n = 1;
    printf(" status                 : %s\n",
	   xferstat ? "SUCCESS" : "FAILURE"
	   );
    n++;
    if (xferstat > 0) {
	if (docrc)
	  printf(" crc-16                 : %ld\n", crc16);
	else
	  printf(" crc-16                 : (disabled)\n");
	n++;
    }
    if (!xferstat && *epktmsg) {
	printf(" reason                 : %s\n", epktmsg);
	n++;
    }
    if (!brief) {
	if (whoareu[0]) {
	    printf(" remote system type     : %s\n",
		   getsysid((char *)whoareu));
	    n++;
	}
	printf(" files transferred      : %ld\n",filcnt - filrej);
	printf(" files not transferred  : %ld\n",filrej);
	printf(" characters last file   : %ld\n",ffc);
	printf(" total file characters  : %ld\n",tfc);
	printf(" communication line in  : %ld\n",tlci);
	printf(" communication line out : %ld\n",tlco);
	printf(" packets sent           : %d\n", spackets);
	printf(" packets received       : %d\n", rpackets);
	n += 8;
    }
    printf(" damaged packets rec'd  : %d\n", crunched);
    printf(" timeouts               : %d\n", timeouts);
    printf(" retransmissions        : %d\n", retrans);
    n += 3;

    if (!brief) {
	if (filcnt > 0) {
	    printf(" parity                 : %s",parnam((char)parity));
	    n++;
	    if (autopar) { printf(" (detected automatically)"); n++; }
	    printf(
		 "\n control characters     : %ld prefixed, %ld unprefixed\n",
		   ccp, ccu);
	    n++;
	    printf(" 8th bit prefixing      : ");
	    n++;
	    if (ebqflg) printf("yes [%c]\n",ebq); else printf("no\n");
	    n++;
	    printf(" locking shifts         : %s\n", lscapu ? "yes" : "no");
	    n++;
	}
    }
    printf(" window slots used      : %d of %d\n", wmax, wslotr);
    if (++n > cmd_rows - 3) { if (!askmore()) return(1); else n = 0; }
#ifdef STREAMING
    {
	extern int streamed;
	printf(" streaming              : %s\n", streamed ? "yes" : "no");
	if (++n > cmd_rows - 3) { if (!askmore()) return(1); else n = 0; }
    }
#endif /* STREAMING */
    if (!brief) {
	printf(" packet length          : %d (send), %d (receive)\n",
	       lastspmax, urpsiz);
	if (++n > cmd_rows - 3) { if (!askmore()) return(1); else n = 0; }
	printf(" compression            : ");
	if (rptflg)
	  printf("yes [%c] (%ld)\n",(char) rptq,rptn);
	else
	  printf("no\n");
	if (++n > cmd_rows - 3) { if (!askmore()) return(1); else n = 0; }
	if (bctu == 4)
	  printf(" block check type used  : blank-free-2\n");
	else
	  printf(" block check type used  : %d\n",bctu);
	if (++n > cmd_rows - 3) { if (!askmore()) return(1); else n = 0; }
    }
#ifdef GFTIMER
    printf(" elapsed time           : %0.3f sec, %s\n",fptsecs,hhmmss(tsecs));
#else
    printf(" elapsed time           : %d sec, %s\n",tsecs,hhmmss(tsecs));
#endif /* GFTIMER */
    if (++n > cmd_rows - 3) { if (!askmore()) return(1); else n = 0; }
    if (local && !network && !brief) {
	if (speed <= 0L) speed = ttgspd();
	if (speed > 0L) {
	    if (speed == 8880)
	      printf(" transmission rate      : 75/1200 bps\n");
	    else
	      printf(" transmission rate      : %ld bps\n",speed);
	    if (++n > cmd_rows - 3) { if (!askmore()) return(1); else n = 0; }
	}
    }
    if (local && !network &&	/* Only makes sense for */
	mdmtyp == 0 &&		/* direct serial connections */
	speed > 99L &&		/* when we really know the speed */
	speed != 8880L
	) {
	int eff;
	eff = (((tfcps * 100L) / (speed / 100L)) + 5L) / 10L;
	printf(" effective data rate    : %ld cps (%d%%)\n",tfcps,eff);
    } else
      printf(" effective data rate    : %ld cps\n", tfcps);
    if (peakcps > 0L && peakcps > tfcps)
      printf(" peak data rate         : %ld cps\n", peakcps);
    if (brief)
      printf("\nUse STATISTICS /VERBOSE for greater detail.\n\n");
    return(1);
}

#ifndef NOSPL

/* The INPUT command */

/*
  NOTE: An INPUT timeout of 0 means to perform a nonblocking read of the
  material that has already arrived and is waiting to be read, and perform
  matches against it, without doing any further reads.  It should succeed
  or fail instantaneously.
*/

/* Output buffering for "doinput" */

#ifdef pdp11
#define MAXBURST 16		/* Maximum size of input burst */
#else
#define	MAXBURST 1024
#endif /* pdp11 */
#ifdef OSK
static CHAR *conbuf;		/* Buffer to hold output for console */
#else
static CHAR conbuf[MAXBURST];	/* Buffer to hold output for console */
#endif /* OSK */
static int concnt = 0;		/* Number of characters buffered */
#ifdef OSK
static CHAR *sesbuf;		/* Buffer to hold output for session log */
#else
static CHAR sesbuf[MAXBURST];	/* Buffer to hold output for session log */
#endif /* OSK */
static int sescnt = 0;		/* Number of characters buffered */

static VOID				/* Flush INPUT echoing */
myflsh() {				/* and session log output. */
    if (concnt > 0) {
	conxo(concnt, (char *) conbuf);
	concnt = 0;
    }
    if (sescnt > 0) {
	if (zsoutx(ZSFILE, (char *) sesbuf, sescnt) < 0)
	  seslog = 0;
	sescnt = 0;
    }
}

/* Execute the INPUT and MINPUT commands */

int instatus = -1;
long inetime = -1L;

int
doinput(timo,ms) int timo; char *ms[]; {
    extern int inintr;
#ifdef CK_AUTODL
    extern int inautodl;
#endif /* CK_AUTODL */
    int x, y, i, t, rt, icn, anychar, mi[MINPMAX];
#ifdef GFTIMER
    CKFLOAT fpt = 0.0;
#endif /* GFTIMER */
    int lastchar = 0;
    int waiting = 0;
    char *xp, *s;
    CHAR c;
#ifdef OS2
    extern int term_io;
    int term_io_save;
#endif /* OS2 */
#ifdef TNCODE 
    static int cr = 0;
#endif /* TNCODE */

#define CK_BURST
/*
  This enables the INPUT speedup code, which depends on ttchk() returning
  accurate information.  If INPUT fails with this code enabled, change the
  above "#define" to "#undef".
*/
#ifdef CK_BURST
    int burst = 0;			/* Chars remaining in input burst */
#endif /* CK_BURST */

    instatus = INP_IE;			/* 3 = internal error */

#ifdef OSK
    if (conbuf == NULL) {
	if ((conbuf = (CHAR *)malloc(MAXBURST*2)) == NULL) {
	    return(0);
	}
	sesbuf = conbuf + MAXBURST;
    }
#endif /* OSK */

#ifndef NOLOCAL
    if (local) {			/* In local mode... */
	if ((waiting = ttchk()) < 0) {	/* check that connection is open */
	    printf("?Connection %s %s is not open.\n",
		   network ? "to" : "on",
		   ttname
		   );
            instatus = INP_IO;
	    return(0);
	}
	debug(F101,"doinput waiting","",waiting);
	y = ttvt(speed,flow);		/* Put line in "ttvt" mode */
	if (y < 0) {
	    printf("?INPUT initialization error\n");
            instatus = INP_IO;
	    return(0);			/* Watch out for failure. */
	}
    }
#endif /* NOLOCAL */

    if (!ms[0]) {			/* If we were passed a NULL pointer */
	anychar = 1;			/*  ... */
    } else {
        y = (int)strlen(ms[0]);		/* Or if search string is empty */
        anychar = (y < 1);		/* any input character will do. */
    }
    if (!anychar && waiting == 0 && timo == 0)
      return(0);

#ifndef NODEBUG
    if (deblog) {
	char xbuf[24];
	debug(F101,"doinput anychar","",anychar);
	debug(F101,"doinput timo","",timo);
	debug(F101,"doinput echo","",inecho);
	debug(F101,"doinput burst","",burst);
	y = -1;
	while (ms[++y]) {
	    sprintf(xbuf,"doinput string %2d",y);
	    debug(F111,xbuf,ms[y],strlen(ms[y]));
	}
    }
#endif /* NODEBUG */

#ifdef IKS_OPTION
    if (network && ttnproto == NP_TELNET && me_iks
#ifdef CK_AUTODL
	&& inautodl
#endif /* CK_AUTODL */
	) {
        tn_siks(0);                     /* Send Kermit-Server Start */
    }
#endif /* IKS_OPTION */
    x = 0;				/* Return code, assume failure */
    instatus = INP_TO;			/* Status, assume timeout */

    for (y = 0; y < MINPMAX; y++)
      mi[y] = 0;			/* String pattern match position */

    if (!inpcas[cmdlvl]) {		/* INPUT CASE = IGNORE?  */
	y = -1;

	while(xp = ms[++y]) {
	    while (*xp) {               /* Convert to lowercase */
		if (isupper(*xp)) *xp = (char) tolower(*xp);
		xp++;
	    }
        }
    }
#ifdef COMMENT
    inpbps = inpbp;			/* Save current pointer. */
#endif /* COMMENT */
    rtimer();				/* Reset timer. */
#ifdef GFTIMER
    rftimer();				/* Floating-point timer too. */
#endif /* GFTIMER */
    inetime = -1L;			/* Initialize elapsed time. */
    t = 0;				/* Time now is 0. */
    m_found = 0;			/* Default to timed-out */
    incount = 0;			/* Character counter */
    rt = (timo == 0) ? 0 : 1;		/* Character-read timeout interval */

#ifdef OS2
    term_io_save = term_io;		/* Disable I/O by emulator */
    term_io = 0;
#endif /* OS2 */

    while (1) {				/* Character-getting loop */
#ifdef CK_APC
	/* Check to see if there is an Autodown or other APC command */
	if (apcactive == APC_LOCAL ||
            (apcactive == APC_REMOTE && apcstatus != APC_OFF)) {
            if (mlook(mactab,"_apc_commands",nmac) == -1) {
                debug(F110,"doinput about to execute APC",apcbuf,0);
                domac("_apc_commands",apcbuf,cmdstk[cmdlvl].ccflgs|CF_APC);
                delmac("_apc_commands");
                apcactive = APC_INACTIVE;
            } else {
                debug(F100,"doinput APC in progress","",0);
            }
	}
#endif /* CK_APC */

	if (timo == 0 && waiting < 1) {	/* Special exit criterion */
	    instatus = INP_TO;		/* for timeout == 0 */
	    break;
	}
	if (local) {			/* One case for local */
	    y = ttinc(rt);		/* Get character from comm device */
	    debug(F101,"input ttinc(rt) returns","",y);
	    if (y < -1) {		/* Connection failed. */
		instatus = INP_IO;	/* Status = i/o error */
#ifdef OS2
		term_io = term_io_save;
#endif /* OS2 */
                switch (y) {
		  case -2:		/* Connection lost */
		    if (local && !network && carrier != CAR_OFF) {
			printf("Connection closed.\n");
			ttclos(1);
		    }
                    break;
		  case -3:
                    printf("Session Limit exceeded - closing connection.\n");
                    ttclos(1);
		  default:
                    break;
                }
#ifdef IKS_OPTION
                if (network && ttnproto == NP_TELNET && me_iks
#ifdef CK_AUTODL
		    && inautodl
#endif /* CK_AUTODL */
		    ) {
                    tn_siks(1);         /* Send Kermit-Server Stop */
                }
#endif /* IKS_OPTION */
		return(0);
	    }		
	    if (inintr) {
		if (icn = conchk()) {	/* Interrupted from keyboard? */
		    debug(F101,"input interrupted from keyboard","",icn);
		    while (icn--) coninc(0); /* Yes, absorb what was typed. */
		    instatus = INP_UI;	/* Fail and remember why. */
		    break;
		}
	    }
	} else {			/* Another for remote */
	    y = coninc(rt);
	    debug(F101,"input coninc(rt) returns","",y);
	}
	if (y > -1) {			/* A character arrived */
	    if (timo == 0)
	      waiting--;
#ifndef OS2
#ifdef TNCODE
	    /* Check for telnet protocol negotiation */
	    if (network && (ttnproto == NP_TELNET)) {
                switch (y & 0xff) {
		  case IAC:
                    cr = 0;
                    myflsh();	/* Break from input burst for tn_doop() */
#ifdef CK_BURST
                    burst = 0;
#endif /* CK_BURST */
		    waiting -= 2;	/* (not necessarily...) */
                    switch (tn_doop((CHAR)(y & 0xff),duplex,ttinc)) {
		      case 2: duplex = 0; continue;
		      case 1: duplex = 1;
		      default: continue;
                    }
		  case CR:
                    cr = 1;
                    break;
		  case NUL:
                    cr = 0;
                    if (!u_binary && cr) 
		      continue;
                    break;
		  default:
                    cr = 0;
                }
	    }
#endif /* TNCODE */
#ifdef CK_AUTODL
	    /* Check for file transfer packets */
	    if (inautodl) autodown(y);
#endif /* CK_AUTODL */
#else  /* OS2 */
#ifdef TNCODE
	    /* Check for telnet protocol negotiation */
	    if (network && (ttnproto == NP_TELNET)) {
                switch (y & 0xff) {
		  case IAC:
                    myflsh();	/* Break from input burst for tn_doop() */
#ifdef CK_BURST
                    burst = 0;
#endif /* CK_BURST */
                    scriptwrtbuf((USHORT)y); /* Handles Telnet negotiations */
		    waiting -= 2;	/* (not necessarily...) */
                    cr = 0;
                    continue;		/* and autodownload check */
		  case CR:
                    cr = 1;
                    scriptwrtbuf((USHORT)y);
                    break;
		  case NUL:
                    cr = 0;
                    if (!u_binary && cr) 
		      continue;
                    scriptwrtbuf((USHORT)y);
                    break;
		  default:
                    cr = 0;
                    scriptwrtbuf((USHORT)y);
                }
	    } else 
#endif /* TNCODE */
	      scriptwrtbuf((USHORT)y);	/* Handles Telnet negotiations */
#endif /* OS2 */

	    /* Real input character to be checked */

#ifdef CK_BURST
	    burst--;			/* One less character waiting */
	    debug(F101,"doinput burst","",burst);
#endif /* CK_BURST */
	    c = (CHAR) (cmask & (CHAR) y); /* Mask off parity */

	    inchar[0] = c;		/* Remember character for \v(inchar) */
#ifdef CK_BURST
	    /* Update "lastchar" time only once during input burst */
	    if (burst <= 0)
#endif /* CK_BURST */
	      lastchar = gtimer();	/* Remember when it came */

	    if (c == '\0') {		/* NUL, we can't use it */
		if (anychar) {		/* Except if any character will do? */
		    x = 1;		/* Yes, done. */
		    incount = 1;	/* This must be the first and only. */
		    break;
		} else continue;	/* Otherwise continue INPUTting */
	    }
	    *inpbp++ = c;		/* Store char in circular buffer */
	    incount++;			/* Count it for \v(incount) */

	    if (inpbp >= inpbuf + inbufsize) { /* Time to wrap around? */
		*inpbp = NUL ;		/* Make it null-terminated */
		inpbp = inpbuf;		/* Yes. */
	    }
#ifdef MAC
	    {
		extern char *ttermw;	/* fake pointer cast */
		if (inecho) {
		    outchar(ttermw, c);	/* echo to terminal window */
		    /* this might be too much overhead to do here ? */
		    updatecommand(ttermw);
		}
	    }
#else /* Not MAC */
	    if (inecho) conbuf[concnt++] = c; /* Buffer console output */
#endif /* MAC */
#ifndef OS2
        if (seslog) {
#ifdef UNIX
		if (sessft != 0 || c != '\r')
#else
#ifdef OSK
		if (sessft != 0 || c != '\012')
#endif /* OSK */
#endif /* UNIX */
		  sesbuf[sescnt++] = c;	/* Buffer session log output */
	    }
#endif /* OS2 */
	    if (anychar) {		/* Any character will do? */
		x = 1;
		break;
	    }
	    if (!inpcas[cmdlvl]) {	/* Ignore alphabetic case? */
		if (isupper(c))		/* Yes, convert input char to lower */
		  c = (CHAR) tolower(c);
	    }
	    debug(F000,"doinput char","",c);
	    y = -1;			/* Loop thru search strings */
	    while (s = ms[++y]) {	/* ...as many as we have. */
		i = mi[y];		/* Match-position in this one. */
		debug(F000,"compare char","",(CHAR)s[i]);
		if (c == (CHAR) s[i]) { /* Check for match */
		    i++;		/* Got one, go to next character */
		} else {		/* Don't have a match */
		    int j;
		    for (j = i; i > 0; ) { /* Back up in search string */
			i--; /* (Do this here to prevent compiler foulup) */
			/* j is the length of the substring that matched */
			if (c == (CHAR) s[i]) {
			    if (!strncmp(s,&s[j-i],i)) {
				i++;          /* c actually matches -- cfk */
				break;
			    }
			}
		    }
		}
		if ((CHAR) s[i] == (CHAR) '\0') { /* Matched to end? */
		    x = 1;		/* Yes, */
		    break;		/* done. */
		}
		mi[y] = i;		/* No, remember match-position */
            }
	    if (x == 1) {		/* Set \v(minput) result */
		m_found = y + 1;
		break;
	    }
        }
#ifdef CK_BURST
	else if (y <= -1 && burst > 0) {
	    debug(F111,"doinput (y<=-1&&burst>0)","burst",burst);
	                                /* a timo occurred so there can't   */
	    burst = 0;			/* be data waiting; must check timo */
	}
	if (burst <= 0) {
	    myflsh();			/* Flush buffered output */
	    if (local) {		/* Get size of next input burst */
		burst = ttchk();
		if (burst < 0) {	/* ttchk() says connection is closed */
		    instatus = INP_IO;	/* Status = i/o error */
#ifdef OS2
		    term_io = term_io_save;
#endif /* OS2 */
		    printf("Fatal error - disconnected.\n");
		    ttclos(1);
		    break;
		}
		if (inintr) {
		    if (icn = conchk()) { /* Interrupted from keyboard? */
			debug(F101,"input interrupted from keyboard","",icn);
			while (icn--) coninc(0); /* Yes, absorb chars. */
			break;		/* And fail. */
		    }
		}
	    } else {
		burst = conchk();
	    }
	    debug(F101,"doinput burst","",burst);
	    /* Prevent overflow of "conbuf" and "sesbuf" */
	    if (burst > MAXBURST)
	      burst = MAXBURST;

	    /* Did not match, timer exceeded? */
	    t = gtimer();
	    debug(F111,"doinput gtimer","burst",t);
	    debug(F101,"doinput timo","",timo);
	    if ((t >= timo) && (timo > 0))
	      break;
	    else if (insilence > 0 && (t - lastchar) > insilence)
	      break;
	} else {
	    debug(F111,"doinput (burst > 0)","burst",burst);
	}
#else
	myflsh();			/* Flush buffered output */
	/* Did not match, timer exceeded? */
	t = gtimer();
	debug(F111,"doinput gtimer","no burst",t);
	debug(F101,"doinput timo","",timo);
	if ((t >= timo) && (timo > -1))
	  break;
	else if (insilence > 0 && (t - lastchar) > insilence)
	  break;
#endif /* CK_BURST */
    }					/* Still have time left, continue. */
    myflsh();				/* Flush buffered output. */
    if (x > 0)
      instatus = 0;
#ifdef OS2
    term_io = term_io_save;
#endif /* OS2 */
#ifdef IKS_OPTION
    if (network && ttnproto == NP_TELNET && me_iks
#ifdef CK_AUTODL
	&& inautodl
#endif /* CK_AUTODL */
	) {
        tn_siks(1);                     /* Send Kermit-Server Stop */
    }
#endif /* IKS_OPTION */

#ifdef GFTIMER
    fpt = gftimer();			/* Get elapsed time */

/* If a long is 32 bits, it would take about 50 days for this to overflow. */

    inetime = (fpt * (CKFLOAT)1000.0);
#else
    inetime = gtimer() * 1000;
#endif /* GFTIMER */
    return(x);				/* Return the return code. */
}
#endif /* NOSPL */

#ifndef NOSPL
/* REINPUT Command */

/*
  Note, the timeout parameter is required, but ignored.  Syntax is compatible
  with MS-DOS Kermit except timeout can't be omitted.  This function only
  looks at the characters already received and does not read any new
  characters from the connection.
*/
int
doreinp(timo,s) int timo; char *s; {
    int x, y, i;
    char *xx, *xp, *xq = (char *)0;
    CHAR c;

    y = (int)strlen(s);
    debug(F111,"doreinput",s,y);

    if (y > inbufsize)			/* If search string longer than */
      return(0);			/* input buffer, fail. */

    x = 0;				/* Return code, assume failure */
    i = 0;				/* String pattern match position */

    if (!inpcas[cmdlvl]) {		/* INPUT CASE = IGNORE?  */
	xp = malloc(y+2);		/* Make a separate copy of the */
	if (!xp) {			/* search string. */
	    printf("?malloc error 6\n");
	    return(x);
	} else xq = xp;			/* Keep pointer to beginning. */
	while (*s) {			/* Yes, convert to lowercase */
	    *xp = *s;
	    if (isupper(*xp)) *xp = (char) tolower(*xp);
	    xp++; s++;
	}
	*xp = NUL;			/* Terminate it! */
	s = xq;				/* Move search pointer to it. */
    }
    xx = inpbp;				/* Current INPUT buffer pointer */
    do {
	c = *xx++;			/* Get next character */
	if (xx >= inpbuf + inbufsize)	/* Wrap around if necessary */
	  xx = inpbuf;
	if (!inpcas[cmdlvl]) {		/* Ignore alphabetic case? */
	    if (isupper(c)) c = (CHAR) tolower(c); /* Yes */
	}
	debug(F000,"doreinp char","",c);
	debug(F000,"compare char","",(CHAR) s[i]);
	if (((char) c) == ((char) s[i])) { /* Check for match */
	    i++;			/* Got one, go to next character */
	} else {			/* Don't have a match */
   	    int j;
   	    for (j = i; i > 0; ) {	/* [jrs] search backwards for it  */
		i--;
   		if (((char) c) == ((char) s[i])) {
		    if (!strncmp(s,&s[j-i],i)) {
			i++;
			break;
		    }
		}
   	    }
   	}				/* [jrs] or return to zero from -1 */
	if (s[i] == '\0') {		/* Matched all the way to end? */
	    x = 1;			/* Yes, */
	    break;			/* done. */
	}
    } while (xx != inpbp);		/* Until back where we started. */

    if (!inpcas[cmdlvl]) if (xq) free(xq); /* Free this if it was malloc'd. */
    return(x);				/* Return search result. */
}
#ifndef NOSPL

#endif /* NOSPL */
/*  X X S T R I N G  --  Interpret strings containing backslash escapes  */
/*  Z Z S T R I N G  --  (new name...)  */
/*
 Copies result to new string.
  strips enclosing braces or doublequotes.
  interprets backslash escapes.
  returns 0 on success, nonzero on failure.
  tries to be compatible with MS-DOS Kermit.

 Syntax of input string:
  string = chars | "chars" | {chars}
  chars = (c*e*)*
  where c = any printable character, ascii 32-126
  and e = a backslash escape
  and * means 0 or more repetitions of preceding quantity
  backslash escape = \operand
  operand = {number} | number | fname(operand) | v(name) | $(name) | m(name)
  number = [r]n[n[n]]], i.e. an optional radix code followed by 1-3 digits
  radix code is oO (octal), xX (hex), dD or none (decimal) (see xxesc()).
*/

#ifndef NOFRILLS
int
yystring(s,s2) char *s; char **s2; {	/* Reverse a string */
    int x;
    static char *new;
    new = *s2;
    if (!s || !new) return(-1);		/* Watch out for null pointers. */
    if ((x = (int)strlen(s)) == 0) {	/* Recursion done. */
	*new = '\0';
	return(0);
    }
    x--;				/* Otherwise, call self */
    *new++ = s[x];			/* to reverse rest of string. */
    s[x] = 0;
    return(yystring(s,&new));
}
#endif /* NOFRILLS */

static char ipabuf[16] = { NUL };	/* IP address buffer */

static char *
getip(s) char *s; {
    char c=NUL;				/* Workers... */
    int i=0, p=0, d=0;
    int state = 0;			/* State of 2-state FSA */

    while (c = *s++) {
	switch(state) {
	  case 0:			/* Find first digit */
	    i = 0;			/* Output buffer index */
	    ipabuf[i] = NUL;		/* Initialize output buffer */
	    p = 0;			/* Period counter */
	    d = 0;			/* Digit counter */
	    if (isdigit(c)) {		/* Have first digit */
		d = 1;			/* Count it */
		ipabuf[i++] = c;	/* Copy it */
		state = 1;		/* Change state */
	    }
	    break;

	  case 1:			/* In numeric field */
	    if (isdigit(c)) {		/* Have digit */
		if (++d > 3)		/* Too many */
		  state = 0;		/* Start over */
		else			/* Not too many */
		  ipabuf[i++] = c;	/* Keep it */
	    } else if (c == '.' && p < 3) { /* Have a period */
		p++;			/* Count it */
		if (d == 0)		/* Not preceded by a digit */
		  state = 0;		/* Start over */
		else			/* OK */
		  ipabuf[i++] = c;	/* Keep it */
		d = 0;			/* Reset digit counter */
	    } else if (p == 3 && d > 0) { /* Not part of address */
		ipabuf[i] = NUL;	/* If we have full IP address */
		return((char *)ipabuf);	/* Return it */
	    } else {			/* Otherwise */
		state = 0;		/* Start over */
		ipabuf[0] = NUL;	/* (in case no more chars left) */
	    }
	}
    }					/* Fall thru at end of string */
    ipabuf[i] = NUL;			/* Maybe we have one */
    return((p == 3 && d > 0) ? (char *)ipabuf : "");
}

static char ** flist = (char **) NULL;	/* File list for \fnextfile() */
static int flistn = 0;			/* Number of items in file list */

/*
  The function return-value buffer must be global, since fneval() returns a
  pointer to it.  fneval() is called only by zzstring(), which always copies
  the result out of this buffer to somewhere else, so it's OK to have only
  one buffer for this in most cases.  However, since function calls can be
  nested -- e.g. functions whose arguments are functions, or recursive
  functions, at some point we should convert this to an array of buffers,
  indexed by function depth (which might or might not be the same as the
  "depth" variable).  Also, since function results are potentially quite big,
  we'd need to allocate and deallocate dynamically as we descend and ascend
  function depth.  Left for a future release...
*/
char fnval[FNVALL+2];			/* Function return value  */
static int fndepth = 0;			/* (we don't actually use this yet) */
int fnsuccess = 1;
extern int fnerror;

static char *				/* Evaluate builtin functions */
fneval(fn,argp,argn,xp) char *fn, *argp[]; int argn; char * xp; {
    int i, j, k, len1, len2, len3, n, t, x, y;
    int failed = 0;			/* Return code, 0 = ok */
    char *bp[FNARGS + 1];		/* Pointers to malloc'd strings */
    char c;
    char *p, *s;
    char *val1, *val2;			/* Pointers to numeric string values */

#ifdef RECURSIVE
    int rsave = recursive;
#endif /* RECURSIVE */
    int fsave = fileonly, dsave = dironly;
#ifdef OS2
    int zsave = zxpn;
#endif /* OS2 */

    for (i = 0; i < FNARGS; i++)	/* Initialize argument pointers */
      bp[i] = NULL;
/*
  IMPORTANT: Note that argn is not an accurate count of the number of
  arguments.  We can't really tell if an argument is null until after we
  execute the code below.  So argn is really the maximum number of arguments
  we might have.  In particular note that argn is always at least 1, even
  if the function is called with empty parentheses (but don't count on it).
*/
    if (!fn) fn = "";			/* Protect against null pointers */
    debug(F111,"fneval",fn,argn);
    debug(F110,"fneval",argp[0],0);
    if (argn > FNARGS)			/* Discard excess arguments */
      argn = FNARGS;

    fndepth++;
    debug(F101,"fneval fndepth","",fndepth);
    p = fnval;
    fnval[0] = NUL;
    y = lookup(fnctab,fn,nfuncs,&x);	/* Look up the function name */
    if (y < 0) {			/* Not found */
	failed = 1;
	if (fndiags) {			/* FUNCTION DIAGNOSTIC ON */
	    int x;
	    x = strlen(fn);
	    switch (y) {
	      case -1: 
		if (x + 32 < FNVALL)
		  sprintf(fnval,"<ERROR:NO_SUCH_FUNCTION:\\f%s()>",fn);
		else
		  sprintf(fnval,"<ERROR:NO_SUCH_FUNCTION>");
		break;
	      case -2:
		if (x + 26 < FNVALL)
		  sprintf(fnval,"<ERROR:NAME_AMBIGUOUS:\\f%s()>",fn);
		else
		  sprintf(fnval,"<ERROR:NAME_AMBIGUOUS>");
		break;
	      case -3:
		sprintf(fnval,"<ERROR:FUNCTION_NAME_MISSING:\\f()>");
		break;
	      default:
		if (x + 26 < FNVALL)
		  sprintf(fnval,"<ERROR:LOOKUP_FAILURE:\\f%s()>",fn);
		else
		  sprintf(fnval,"<ERROR:LOOKUP_FAILURE>");
		break;
	    }
	}	
	goto fnend;			/* Always leave via common exit */
    }
#ifdef DEBUG
    if (deblog) {
	int j;
	for (j = 0; j < argn; j++)
	  debug(F111,"fneval arg",argp[j],j);
    }
#endif /* DEBUG */
    for (j = argn-1; j >= 0; j--) {	/* Uncount empty trailing args */
	if (!argp[j])
	  argn--;
	else if (!*(argp[j]))
	  argn--;
	else break;
    }
    debug(F101,"fneval argn","",argn);
/*
  \fliteral() and \fcontents() are special functions that do not evaluate
  their arguments, and are treated specially here.  After these come the
  functions whose arguments are evaluated in the normal way.
*/
    if (y == FN_LIT) {			/* literal(arg1) */
	debug(F110,"flit",xp,0);
	p = xp ? xp : "";		/* Return a pointer to arg itself */
	goto fnend;
    }
    if (y == FN_CON) {			/* Contents of variable, unexpanded. */
	char c;
	if (!(p = argp[0]) || !*p) {
	    failed = 1;
	    p = fnval;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:MISSING_ARG:\\fcontents()>");
	    goto fnend;
	}
	p = brstrip(p);
	if (*p == CMDQ) p++;
	if ((c = *p) == '%') {		/* Scalar variable. */
	    c = *++p;			/* Get ID character. */
	    p = "";			/* Assume definition is empty */
	    if (!c) {			/* Double paranoia */
		failed = 1;
		p = fnval;
		if (fndiags)
		  sprintf(fnval,"<ERROR:ARG_BAD_VARIABLE:\\fcontents()>");
		goto fnend;
	    }
	    if (c >= '0' && c <= '9') { /* Digit for macro arg */
		if (maclvl < 0)		/* Digit variables are global */
		  p = g_var[c];		/* if no macro is active */
		else			/* otherwise */
		  p = m_arg[maclvl][c - '0']; /* they're on the stack */
	    } else if (c == '*' && maclvl >= 0) {
		p = m_line[maclvl];
		if (!p) p = "";
	    } else {
		if (isupper(c)) c -= ('a'-'A');
		p = g_var[c];		/* Letter for global variable */
	    }
	    if (!p) p = "";
	    goto fnend;
	} else if (c == '&') {			/* Array reference. */
	    int vbi, d;
	    if (arraynam(p,&vbi,&d) < 0) { /* Get name and subscript */
		failed = 1;
		p = fnval;
		if (fndiags)
		  sprintf(fnval,"<ERROR:ARG_BAD_ARRAY:\\fcontents()>");
		goto fnend;
	    }
	    if (chkarray(vbi,d) > 0) {	/* Array is declared? */
		vbi -= ARRAYBASE;	/* Convert name to index */
		if (a_dim[vbi] >= d) {	/* If subscript in range */
		    char **ap;
		    ap = a_ptr[vbi];	/* get data pointer */
		    if (ap) {		/* and if there is one */
			p = ap[d];
			goto fnend;
		    }
		}
	    } else {
		failed = 1;
		p = fnval;
		if (fndiags)
		  sprintf(fnval,"<ERROR:ARG_NOT_ARRAY:\\fcontents()>");
		goto fnend;
	    }
	} else {
	    failed = 1;
	    p = fnval;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_VARIABLE:\\fcontents()>");
	    goto fnend;
	}
    }
    p = fnval;				/* Default result pointer */
    fnval[0] = NUL;			/* Default result = empty string */

    for (i = 0; i < argn; i++) {	/* Loop to expand each argument */
	n = MAXARGLEN;			/* Allow plenty of space */
	bp[i] = s = malloc(n+1);	/* Allocate space for this argument */
	if (bp[i] == NULL) {		/* Handle failure to get space */
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:MALLOC_FAILURE:\\f%s()>",fn);
	    goto fnend;
	}
	p = argp[i] ? argp[i] : "";	/* Point to this argument */

/*
  Trim leading and trailing spaces from the original argument, before
  evaluation.  This code new to edit 184.
*/
	{
	    int x, j;
	    x = strlen(p);
	    if (*p == '{' && *(p+x-1) == '}') {
		p[x-1] = NUL;
		p++;
		x -= 2;
	    } else {
		j = x - 1;		/* Trim trailing whitespace */
		while (j > 0 && (*(p + j) == SP || *(p + j) == HT))
		  *(p + j--) = NUL;
		while (*p == SP || *p == HT) /* Strip leading whitespace */
		  p++;
	    }
	}

/* Now evaluate the argument */

	debug(F111,"fneval calling zzstring",p,n);
	t = zzstring(p,&s,&n);		/* Expand arg into new space */
	debug(F101,"fneval zzstring","",t);
	debug(F101,"fneval zzstring","",n);
	if (t < 0) {			
	    debug(F101,"fneval zzstring fails, arg","",i);
	    failed = 1;
	    if (fndiags) {
		if (n == 0)
		  sprintf(fnval,"<ERROR:ARG_TOO_LONG:\\f%s()>",fn);
		else
		  sprintf(fnval,"<ERROR:ARG_EVAL_FAILURE:\\f%s()>",fn);
	    }
	    goto fnend;
	}
	debug(F111,"fneval arg",bp[i],i);
    }

#ifdef DEBUG
    if (deblog) {
	int j;
	for (j = 0; j < argn; j++) {
	    debug(F111,"fneval arg post eval",argp[j],j);
	    debug(F111,"fneval evaluated arg",bp[j],j);
	}
    }
#endif /* DEBUG */
/*
  From this point on, bp[0..argn-1] are not NULL and all must be freed
  before returning.
*/
    if (argn < 1) {			/* Catch required args missing */
	switch (y) {
	  case FN_DEF:
	  case FN_EVA:
	  case FN_EXE:
	  case FN_CHR:
	  case FN_COD:
	  case FN_MAX:
	  case FN_MIN:
	  case FN_MOD:
	  case FN_FD:
	  case FN_FS:
	  case FN_TOD:
	  case FN_FFN:
	  case FN_BSN:
	  case FN_RAW:
	  case FN_CMD:
	  case FN_2HEX:
	  case FN_2OCT:
	  case FN_DNAM:
#ifdef FN_ERRMSG
	  case FN_ERRMSG:
#endif /* FN_ERRMSG */
#ifdef CK_KERBEROS
	  case FN_KRB_TK:
	  case FN_KRB_NX:
	  case FN_KRB_IV:
	  case FN_KRB_TT:
#endif /* CK_KERBEROS */
	    failed = 1;
	    p = fnval;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:MISSING_ARG:\\f%s()>",fn);
	    goto fnend;
	}
    }
    p = fnval;				/* Reset these again. */
    fnval[0] = NUL;

    switch (y) {			/* Do function on expanded args. */

      case FN_DEF:			/* \fdefinition(arg1) */
	k = mlook(mactab,bp[0],nmac);
	p = (k > -1) ? mactab[k].mval : "";
	break;

      case FN_EVA:			/* \fevaluate(arg1) */
	p = *(bp[0]) ? evala(bp[0]) : "";
	if (!*p && fndiags) {
	    failed = 1;
	    p = fnval;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	}
	break;

      case FN_EXE:			/* \fexecute(arg1) */
	j = (int)strlen(s = bp[0]);	/* Length of macro invocation */
	p = "";				/* Initialize return value to null */
	if (j) {			/* If there is a macro to execute */
	    while (*s == SP) s++,j--;	/* strip leading spaces */
	    p = s;			/* remember beginning of macro name */
	    for (i = 0; i < j; i++) {	/* find end of macro name */
		if (*s == SP)
		  break;
		s++;
	    }
	    if (*s == SP) 	{	/* if there was a space after */
		*s++ = NUL;		/* terminate the macro name */
		while (*s == SP) s++;	/* skip past any extra spaces */
	    } else s = "";		/* maybe there are no arguments */
	    if (p && *p)
	      k = mlook(mactab,p,nmac);	/* Look up the macro name */
	    else
	      k = -1;
	    if (k < 0) {
		failed = 1;
		p = fnval;
		if (fndiags)
		  sprintf(fnval,"<ERROR:NO_SUCH_MACRO:\\f%s()>",fn);
		break;
	    }
/*
  This is just a WEE bit dangerous because we are copying up to 9 arguments
  into the space reserved for one.  It won't overrun the buffer, but if there
  are lots of long arguments we might lose some.  The other problem is that if
  the macro has more than 3 arguments, the 4th through last are all
  concatenated onto the third.  (The workaround is to use spaces rather than
  commas to separate them.)  Leaving it like this to avoid having to allocate
  tons more buffers.
*/
	    if (argn > 1) {		/* Commas used instead of spaces */
		int i;
		char *p = bp[0];	/* Reuse this space */
		*p = NUL;		/* Make into dodo() arg list */
		for (i = 1; i < argn; i++) {
		    strncat(p,bp[i],MAXARGLEN);
		    strncat(p," ",MAXARGLEN);
		}		    
		s = bp[0];		/* Point to new list */
	    }
	    p = "";			/* Initialize return value */
	    if (k >= 0) {		/* If macro found in table */
		/* Go set it up (like DO cmd) */
		if ((j = dodo(k,s,cmdstk[cmdlvl].ccflgs)) > 0) {
		    if (cmpush() > -1) { /* Push command parser state */
			extern int ifc;
			int ifcsav = ifc; /* Push IF condition on stack */
			k = parser(1);	/* Call parser to execute the macro */
			cmpop();	/* Pop command parser */
			ifc = ifcsav;	/* Restore IF condition */
			if (k == 0) {	/* No errors, ignore action cmds. */
			    p = mrval[maclvl+1]; /* If OK, set return value. */
			    if (p == NULL) p = "";
			}
		    } else {		/* Can't push any more */
			debug(F100,"fexec pushed too deep","",0);
                        printf("\n?\\fexec() too deeply nested\n");
			while (cmpop() > -1) ;
			p = "";
		    }
		}
	    }
	}
	break;

#ifdef RECURSIVE
      case FN_RDIR:			/* \frdir..() - Recursive dir count */
      case FN_RFIL:			/* \frfiles() - Recursive file count */
	recursive = 2;			/* fall thru... */
#endif /* RECURSIVE */
      case FN_FC:			/* \ffiles() - File count. */
      case FN_DIR:			/* \ffdir.() - Directory count. */
	if (argn < 1) {
	    p = "0";
	    goto fnend;
	}
	if (y == FN_DIR || y == FN_RDIR) { /* Only list directories */
	    dironly = 1;
	    fileonly = 0;
#ifdef OS2
            zxpn = 1;                   /* Use the alternate list */
#endif /* OS2 */
	} else {			/* List only files */
	    fileonly = 1;
	    dironly = 0;
#ifdef OS2
            zxpn = 1;                   /* Use the alternate list */
#endif /* OS2 */
	}
	if (*(bp[0])) {
	    k = zxpand(bp[0]);
	    if (k < 0) k = 0;
	    sprintf(fnval,"%d",k);
	    p = fnval;
	} else p = "0";
#ifndef OS2	
	{				/* Make a copy of the list */
	    int i; char tmp[16];
	    if (flist)			/* Free old file list, if any */
	      free(flist);
	    strncpy(tmp,p,15);		/* Save return value */
	    flist = (char **) malloc((k+2) * sizeof(char *)); /* New array */
	    if (flist) {
		for (i = 0; i <= k; i++) { /* Fill it */
		    znext(fnval);	/* Next filename */
		    if (!*fnval) {	/* No more, done */
			flist[i] = NULL;
			break;
		    }
		    if (flist[i] = (char *) malloc((int)strlen(fnval)+1))
		      strcpy(flist[i],fnval);
		}
	    }
	    strcpy(fnval,tmp);		/* Restore return value */
	    flistn = 0;			/* Reset global list pointer */
	}
#endif /* OS2 */
#ifdef RECURSIVE
	recursive = rsave;
#endif /* RECURSIVE */
	fileonly = fsave;
	dironly = dsave;
#ifdef OS2
        zxpn = zsave;                  
#endif /* OS2 */
	break;

      case FN_FIL:			/* \fnextfile() - Next file in list. */
	p = fnval;			/* (no args) */
	*p = NUL;
#ifdef OS2
        zxpn = 1;                       /* OS/2 - use the alternate list */
	znext(p);			/* Call system-dependent function */
        zxpn = zsave;                   /* Restore original list */
#else
	if (flist)			/* Others, use our own list. */
	  if (flist[flistn])
	    p = flist[flistn++];
#endif /* OS2 */
	break;

      case FN_IND:			/* \findex(arg1,arg2,arg3) */
      case FN_RIX:			/* \frindex(arg1,arg2,arg3) */
	p = "0";
	if (argn > 1) {			/* Only works if we have 2 or 3 args */
	    int start;
	    len1 = (int)strlen(bp[0]);	/* length of string to look for */
	    len2 = (int)strlen(s = bp[1]); /* length of string to look in */
	    if (len1 < 1 || len2 < 1)	/* Watch out for empty strings */
	      break;
	    j = len2 - len1;		/* length difference */
	    start = (y == FN_IND) ? 0 : j; /* Starting position */
	    if (argn > 2) {
		val1 = *(bp[2]) ? evala(bp[2]) : "1";
		if (chknum(val1)) {
		    int t;
		    t = atoi(val1) - 1;
		    if (t < 0) t = 0;
		    start = (y == FN_IND) ? t : start - t - 1;
		    if (start < 0) start = 0;
		} else {
		    failed = 1;
		    if (fndiags)
		      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		    break;
		}
	    }
	    start = ckindex(bp[0],bp[1],start,(y==FN_IND)?0:1,inpcas[cmdlvl]);
	    sprintf(fnval,"%d",start);
	    p = fnval;
	}
	break;

      case FN_RPL:			/* \freplace(s1,s2,s3) */
      /*
	s = bp[0] = source string
	    bp[1] = match string
	    bp[2] = replacement string
	p = fnval = destination (result) string
      */
	if (argn < 1)			/* Nothing */
	  break;
	if (argn < 2) {			/* Only works if we have 2 or 3 args */
	    strcpy(p,bp[0]);
	} else {			
	    len1 = (int)strlen(bp[0]);	/* length of string to look in */
	    len2 = (int)strlen(bp[1]);	/* length of string to look for */
	    len3 = (argn < 3) ? 0 : (int)strlen(bp[2]); /* Len of replacemnt */
	    j = len1 - len2 + 1;
	    if (j < 1 || len1 == 0 || len2 == 0) { /* Args out of whack */
		strcpy(p,bp[0]);	/* so just return original string */
	    } else {
		s = bp[0];		/* Point to beginning of string */
		while (j--) {		/* For each character */
		    if (inpcas[cmdlvl] ?
			!strncmp(bp[1],s,len2) :
			!xxstrcmp(bp[1],s,len2) ) { /* To be replaced? */
			if (len3) {		    /* Yes, */
			    strncpy(p,bp[2],len3);  /* replace it */
			    p += len3;
			}
			s += len2;	            /* and skip past it. */
		    } else {		/* No, */
			*p++ = *s++;	/* just copy this character */
		    }
		}
		*p = NUL;
		while (*p++ = *s++);
	    }
	}
	p = fnval;
	break;

      case FN_CHR:			/* \fcharacter(arg1) */
	val1 = *(bp[0]) ? evala(bp[0]) : "";
	if (chknum(val1)) {		/* Must be numeric */
	    i = atoi(val1);
	    if (i >= 0 && i < 256) {	/* Must be an 8-bit value */
		p = fnval;
		*p++ = (char) i;
		*p = NUL;
		p = fnval;
	    } else {
		failed = 1;
		if (fndiags)
		  sprintf(fnval,"<ERROR:ARG_OUT_OF_RANGE:\\f%s()>",fn);
	    }
	} else {
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	}
	break;

      case FN_COD:			/* \fcode(char) */
	if ((int)strlen(bp[0]) > 0) {
	    p = fnval;
	    i = *bp[0];
	    sprintf(p,"%d",(i & 0xff));
	} else p = "";			/* Can't happen */
	break;

      case FN_LEN:			/* \flength(arg1) */
	if (argn > 0) {
	    p = fnval;
	    sprintf(p,"%d",(int)strlen(bp[0]));
	} else p = "0";
	break;

      case FN_LOW:			/* \flower(arg1) */
	s = bp[0] ? bp[0] : "";
	p = fnval;
	while (*s) {
	    if (isupper(*s))
	      *p = (char) tolower(*s);
	    else
	      *p = *s;
	    p++; s++;
	}
	*p = NUL;
	p = fnval;
	break;

      case FN_MAX:			/* \fmax(arg1,arg2) */
      case FN_MIN:			/* \fmin(arg1,arg2) */
      case FN_MOD:			/* \fmod(arg1,arg2) */
	val1 = *(bp[0]) ? evala(bp[0]) : "";
	free(bp[0]);			/* Copy this because evala() returns */
        bp[0] = NULL;                   /* Set it to NULL in case argn == 1 */
	if (argn > 1) {			/* pointer to same */
	    bp[0] = malloc((int)strlen(val1)+1); /* buffer next time. */
	    strcpy(bp[0],val1);
	    val1 = bp[0];
	    val2 = *(bp[1]) ? evala(bp[1]) : "";
	    if (chknum(val1) && chknum(val2)) {
		i = atoi(val1);
		j = atoi(val2);
		switch (y) {
		  case FN_MAX:
		    if (j < i) j = i;
		    break;
		  case FN_MIN:
		    if (j > i) j = i;
		    break;
		  case FN_MOD:
		    if (j == 0) {
			failed = 1;
			if (fndiags)
			  sprintf(fnval,"<ERROR:DIVIDE_BY_ZERO:\\f%s()>",fn);
			else
			  fnval[0] = NUL;
			goto fnend;
		    } else
		      j = i % j;
		    break;
		}
		p = fnval;
		sprintf(p,"%d",j);
	    } else {
		failed = 1;
		if (fndiags)
		  sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	    }
	} else p = val1;
	break;

      case FN_SUB:			/* \fsubstr(arg1,arg2,arg3) */
      case FN_RIG:			/* \fright(arg1,arg2) */
	if (argn < 1)
	  break;
	val1 = "";
	if (argn > 1)
	  if (*(bp[1]))
	    val1 =  evala(bp[1]);
	if (bp[1]) free(bp[1]);		/* Have to copy this */
	bp[1] = malloc((int)strlen(val1)+1);
	strcpy(bp[1],val1);
	val1 = bp[1];
	val2 = "";
	if (argn > 2)
	  if (*(bp[2]))
	    val2 = evala(bp[2]);
	if (
	    ((argn > 1) && (int)strlen(val1) && !rdigits(val1)) ||
	    ((y == FN_SUB) &&
	      ((argn > 2) && (int)strlen(val2) && !rdigits(val2)))
	    ) {
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	} else {
	    int lx;
	    p = fnval;			/* pointer to result */
	    lx = strlen(bp[0]);		/* length of arg1 */
	    if (y == FN_SUB) {		/* substring */
		k = (argn > 2) ? atoi(val2) : MAXARGLEN; /* length */
		j = (argn > 1) ? atoi(val1) : 1; /* start pos for substr */
	    } else {				 /* right */
		k = (argn > 1) ? atoi(val1) : lx; /* length */
		j = lx - k + 1;			 /* start pos for right */
		if (j < 1) j = 1;
	    }
	    if (k > 0 && j <= lx) { 		 /* if start pos in range */
		s = bp[0]+j-1;    		 /* point to source string */
		for (i = 0; (i < k) && (*p++ = *s++); i++) ;  /* copy */
	    }
	    *p = NUL;			/* terminate the result */
	    p = fnval;			/* and point to it. */
	}
	break;

      case FN_UPP:			/* \fupper(arg1) */
	s = bp[0] ? bp[0] : "";
	p = fnval;
	while (*s) {
	    if (islower(*s))
	      *p = (char) toupper(*s);
	    else
	      *p = *s;
	    p++; s++;
	}
	*p = NUL;
	p = fnval;
	break;

      case FN_REP:			/* \frepeat(text,number) */
	if (argn < 1)
	  break;
	val1 = "1";
	if (argn > 1)
	  if (*(bp[1]))
	    val1 = evala(bp[1]);
	if (chknum(val1)) {		/* Repeat count */
	    n = atoi(val1);
	    debug(F111,"SUNDAY frepeat n",val1,n);
	    if (n > 0) {		/* Make n copies */
		p = fnval;
		*p = '\0';
		k = (int)strlen(bp[0]);	/* Make sure string has some length */
		debug(F111,"SUNDAY frepeat k","",k);
		debug(F111,"SUNDAY frepeat FNVALL","",FNVALL);
		if (k * n >= FNVALL) {	/* But not too much... */
		    failed = 1;
		    if (fndiags)
		      sprintf(fnval,"<ERROR:RESULT_TOO_LONG:\\f%s()>",fn); 
		    else
		      fnval[0] = NUL;
		    p = fnval;
		    break;
		}
		if (k > 0) {		/* If there is something to copy */
		    for (i = 0; i < n; i++) { /* Copy loop */
			s = bp[0];
			for (j = 0; j < k; j++) {
			    if ((p - fnval) >= FNVALL)
			      break;	/* shouldn't happen... */
			    else
			      *p++ = *s++;
			}
		    }
		    *p = NUL;
		}
	    }
	} else {
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	}
	p = fnval;
	break;

#ifndef NOFRILLS
      case FN_REV:			/* \freverse() */
	if (argn < 1)
	  break;
	yystring(bp[0],&p);
	break;
#endif /* NOFRILLS */

      case FN_RPA:			/* \frpad() and \flpad() */
      case FN_LPA:
	if (argn < 1)
	  break;
	val1 = "";
	if (argn > 1)
	  if (*(bp[1]))
	    val1 = evala(bp[1]);
	if (argn == 1 || !*val1) {	/* If a number wasn't given */
	    p = fnval;			/* just return the original string */
	    strncpy(p,bp[0],FNVALL);
	} else if (chknum(val1)) {	/* Repeat count */
	    char pc;
	    n = atoi(val1);
	    if (n >= 0) {
		p = fnval;
		k = (int)strlen(bp[0]);	/* Length of string to be padded */
		if (k >= n) {		/* It's already long enough */
		    strncpy(p,bp[0],FNVALL);
		} else {
		    if (n + k <= FNVALL) {
			pc = (char) ((argn < 3) ? SP : *bp[2]);
			if (!pc) pc = SP;
			if (y == FN_RPA) { /* RPAD */
			    strncpy(p,bp[0],k);
			    p += k;
			    for (i = k; i < n; i++)
			      *p++ = pc;
			} else {	/* LPAD */
			    n -= k;
			    for (i = 0; i < n; i++)
			      *p++ = pc;
			    strncpy(p,bp[0],k);
			    p += k;
			}
		    }
		    *p = NUL;
		}
	    }
	} else {
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	}
	p = fnval;
	break;

#ifdef ZFCDAT
      case FN_FD:			/* \fdate(filename) */
	sprintf(fnval,"%s",*(bp[0]) ? zfcdat(bp[0]) : "");
	break;
#endif /* ZFCDAT */

      case FN_FS:			/* \fsize(filename) */
	sprintf(fnval,"%ld",*(bp[0]) ? zchki(bp[0]) : 0L);
	break;

      case FN_VER:			/* \fverify() */
	p = "0";
	if (argn > 1) {			/* Only works if we have 2 or 3 args */
	    int start;
	    char *s2, ch1, ch2;
	    start = 0;
	    if (argn > 2) {		/* Starting position specified */
		val1 = *(bp[2]) ? evala(bp[2]) : "0";
		if (chknum(val1)) {
		    start = atoi(val1) /* - 1 */;
		    if (start < 0) start = 0;
		    if (start > (int)strlen(bp[1]))
		      goto verfin;
		} else {
		    failed = 1;
		    if (fndiags)
		      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		    break;
		}
	    }
	    i = start;
	    p = "0";
	    for (s = bp[1] + start; *s; s++,i++) {
		ch1 = *s;
		if (!inpcas[cmdlvl]) if (islower(ch1)) ch1 = toupper(ch1);
		j = 0;
		for (s2 = bp[0]; *s2; s2++) {
		    ch2 = *s2;
		    if (!inpcas[cmdlvl]) if (islower(ch2)) ch2 = toupper(ch2);
		    if (ch1 == ch2) {
			j = 1;
			break;
		    }
		}
		if (j == 0) {
		    sprintf(fnval,"%d",i+1);
		    p = fnval;
		    break;
		}
	    }
	}
      verfin:
	break;

      case FN_IPA:			/* Find and return IP address */
	if (argn > 0) {			/* in argument string. */
	    int start;
	    char *s2;
	    start = 0;
	    if (argn > 1) {		/* Starting position specified */
		if (chknum(bp[1])) {
		    start = atoi(bp[1]) - 1;
		    if (start < 0) start = 0;
		} else {
		    failed = 1;
		    if (fndiags)
		      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		    break;
		}
	    }
	    p = getip(bp[0]+start);
	} else p = "";
	break;

#ifdef OS2
      case FN_CRY:
	p = "";
	if (argn > 0) {
	    p = fnval;
	    strcpy(p,bp[0]);
            ck_encrypt(p);
	}
	break;

      case FN_OOX:
	p = "";
	if (argn > 0)
	  p = (char *) ck_oox(bp[0], (argn > 1) ? bp[1] : "");
	break;
#endif /* OS2 */

      case FN_HEX:			/* \fhexify(arg1) */
	if (argn < 1)
	  break;
	if ((int)strlen(bp[0]) < (FNVALL / 2)) {
	    s = bp[0];
	    p = fnval;
	    while (*s) {
		x = (*s >> 4) & 0x0f;
		*p++ = hexdigits[x];
		x = *s++ & 0x0f;
		*p++ = hexdigits[x];	    
	    }
	    *p = NUL;
	    p = fnval;
	}
	break;

      case FN_UNH: {			/* \funhex(arg1) */
	  int c[2], i;
	  if (argn < 1)
	    break;
	  if ((int)strlen(bp[0]) < (FNVALL * 2)) {
	      s = bp[0];
	      p = fnval;
	      while (*s) {
		  for (i = 0; i < 2; i++) {
		      c[i] = *s++;
		      if (!c[i]) { p = ""; goto unhexfin; }
		      if (islower(c[i])) c[i] = toupper(c[i]);
		      if (c[i] >= '0' && c[i] <= '9')
			c[i] -= 0x30;
		      else if (c[i] >= 'A' && c[i] <= 'F')
			c[i] -= 0x37;
		      else { p = ""; goto unhexfin; }
		  }
		  *p++ = ((c[0] << 4) & 0xf0) | (c[1] & 0x0f);
	      }
	      *p = NUL;
	      p = fnval;
	  }
	unhexfin:
	  break;
      }

      case FN_BRK: {			/* \fbreak() */
	  char * c;			/* Characters to break on */
	  char c2, s2;
	  int start = 0;
	  int done = 0;
	  if (argn < 1)
	    break;
	  if (argn > 2) {
	      s = bp[2] ? bp[2] : "0";
	      if (chknum(s)) {
		  start = atoi(s);
		  if (start < 0) start = 0;
		  if (start > (int)strlen(bp[0]))
		    goto brkfin;
	      } else {
		  failed = 1;
		  if (fndiags)
		    sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		  break;
	      }
	  }
	  s = bp[0] + start;		/* Source pointer */

	  while (*s && !done) {
	      s2 = *s;
	      if (!inpcas[cmdlvl] && islower(s2)) s2 = toupper(s2);
	      c = bp[1] ? bp[1] : "";	/* Character to break on */
	      while (*c) {
		  c2 = *c;
		  if (!inpcas[cmdlvl] && islower(c2)) c2 = toupper(c2);
		  if (c2 == s2) {
		      done = 1;
		      break;
		  }
		  c++;
	      }
	      if (done) break;
	      *p++ = *s++;
	  }
	  *p = NUL;			/* terminate the result */
	  p = fnval;			/* and point to it. */
	brkfin:
	  break;
      }

      case FN_SPN: {			/* \fspan() */
	  char *q;
	  char c1, c2;
	  int start = 0;
	  if (argn < 1)
	    break;
	  if (argn > 2) {		/* Starting position */
	      s = bp[2] ? bp[2] : "0";
	      if (chknum(s)) {
		  start = atoi(s);
		  if (start < 0) start = 0;
	      } else {
		  failed = 1;
		  if (fndiags)
		    sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		  break;
	      }
	  }
	  s = bp[0] + start;		/* Source pointer */
	  if (argn > 1 &&
	      (int)strlen(bp[1]) > 0 &&
	      start <= (int)strlen(bp[0])) {
	      while (*s) {		/* Loop thru source string */
		  q = bp[1];		/* Span string */
		  c1 = *s;
		  if (!inpcas[cmdlvl])
		    if (islower(c1)) c1 = toupper(c1);
		  x = 0;
		  while (c2 = *q++) {
		      if (!inpcas[cmdlvl])
			if (islower(c2)) c2 = toupper(c2);
		      if (c1 == c2) { x = 1; break; }
		  }
		  if (!x) break;
		  *p++ = *s++;
	      }
	      *p = NUL;			/* Terminate and return the result */
	      p = fnval;
	  }
	  break;
      }

      case FN_TRM:			/* \ftrim(s1[,s2]) */
      case FN_LTR:			/* \fltrim(s1[,s2]) */
	if (argn < 1)
	  break;
	if ((len1 = (int)strlen(bp[0])) > 0) {
	    if (len1 > FNVALL)
	      len1 = FNVALL;
	    s = " \t";
	    if (argn > 1)		/* Trim list given */
	      s = bp[1];
	    len2 = (int)strlen(s);
	    if (len2 < 1) {		/* or not... */
		s = " \t";		/* Default is to trim whitespace */
		len2 = 2;
	    }
	    if (y == FN_TRM) {		/* Trim from right */
		char * q, p2, q2;
		strncpy(fnval,bp[0],FNVALL); /* Copy string to output */
		p = fnval + len1 - 1;	/* Point to last character */

		while (p >= (char *)fnval) { /* Go backwards */
		    q = s;		/* Point to trim list */
		    p2 = *p;
		    if (!inpcas[cmdlvl])
		      if (islower(p2)) p2 = toupper(p2);
		    while (*q) {	/* Is this char in trim list? */
			q2 = *q;
			if (!inpcas[cmdlvl])
			  if (islower(q2)) q2 = toupper(q2);
			if (p2 == q2) {	/* Yes, null it out */
			    *p = NUL;
			    break;
			}
			q++;
		    }
		    if (!*q)		/* Trim list exhausted */
		      break;		/* So we're done. */
		    p--;		/* Else keep trimming */
		}
	    } else {			/* Trim from left */
		char * q, p2, q2;
		p = bp[0];		/* Source */
		while (*p) {
		    p2 = *p;
		    if (!inpcas[cmdlvl])
		      if (islower(p2)) p2 = toupper(p2);
		    q = s;
		    while (*q) {	/* Is this char in trim list? */
			q2 = *q;
			if (!inpcas[cmdlvl])
			  if (islower(q2)) q2 = toupper(q2);
			if (p2 == q2) {	/* Yes, point past it */
			    p++;	/* and try next source character */
			    break;
			}
			q++;		/* No, try next trim character */
		    }
		    if (!*q)		/* Trim list exhausted */
		      break;		/* So we're done. */
		}
		strncpy(fnval,p,FNVALL);
	    }
	    p = fnval;
	} else p = "";
	break;

      case FN_CAP:			/* \fcapitalize(arg1) */
	if (argn < 1) 
	  break;
	s = bp[0];
	p = fnval;
	x = 0;
	while (c = *s++) {
	    if (isalpha(c)) {
		if (x == 0) {
		    x = 1;
		    if (islower(c))
		      c = toupper(c);
		} else if (isupper(c))
		  c = tolower(c);
	    }
	    *p++ = c;
	}
	*p = NUL;
	p = fnval;
	break;

      case FN_TOD:			/* Time of day to secs since midnite */
	sprintf(fnval,"%ld",tod2sec(bp[0]));
	break;

      case FN_FFN:			/* Full pathname of file */
#ifdef ZFNQFP
	zfnqfp(bp[0],FNVALL,p);
#else
	strcpy(p,bp[0]);
#endif /* ZFNQFP */
	if (!p) p = "";
	break;

      case FN_CHK: {			/* \fchecksum() */
	  long chk = 0;
	  p = (argn > 0) ? bp[0] : "";
	  while (*p) chk += *p++;
	  sprintf(fnval,"%lu",chk);
	  p = fnval;
	  break;
      }

      case FN_CRC:			/* \fcrc16() */
	if (argn > 0)
	  sprintf(fnval,"%u",chk3((CHAR *)bp[0],(int)strlen(bp[0])));
	else
	  p = "0";
	break;

      case FN_BSN:			/* \fbasename() */
	zstrip(bp[0],&p);
	break;

#ifdef OS2
      case FN_SCRN_CX:			/* \fscrncurx() */
	if (argn > 0) {
	    p = fnval;
	    sprintf(p,"%d",(int)VscrnGetCurPos(VTERM)->x);
	} else p = "0";
	break;

      case FN_SCRN_CY:			/* \fscrncury() */
	if (argn > 0) {
	    p = fnval;
	    sprintf(p,"%d",(int)VscrnGetCurPos(VTERM)->y);
	} else p = "0";
	break;

      case FN_SCRN_STR: {		/* \fscrnstr() */
	  videoline * line = NULL;
	  viocell * cells = NULL;
	  int row = 0, col = 0, len = 0;
	  /* NOTE: On Unicode systems, the screen contents are stored in */
	  /* in Unicode.  Therefore, we should really be performing a    */
	  /* conversion to the local character set.                      */

	  if (bp[0] == NULL || bp[0][0] == '\0') {
	      row = 0;
	  } else {
	      if (chknum(bp[0])) {
		  row = atoi(bp[0]);
		  if (row < 0)
		    row = 0;
	      } else {
		  failed = 1;
		  if (fndiags)
		    sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		  break;
	      }
	  }
	  line = VscrnGetLineFromTop( VTERM, (USHORT) row );
	  if (line != NULL) {
	      if (bp[1] == NULL || bp[1][0] == '\0')
		col = 0;
	      else {
		  if (chknum(bp[0])) {
		      col = atoi(bp[1]);
		      if (col < 0 || col >= line->width)
			col = 0;
		  } else {
		      failed = 1;
		      if (fndiags)
			sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		      break;
		  }
	      }
	      if (bp[2] == NULL || bp[2][0] == '\0') {
		  len = line->width - (col+1);
	      } else {
		  if (!chknum(bp[2])) {
		      failed = 1;
		      if (fndiags)
			sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		      break;
		  }
		  len = atoi(bp[2]);
		  if (len < 0 || len > line->width)
		    len = line->width;
	      }
	      cells = line->cells;
	      for (i = 0; i < len; i++) {
		  int pos = i + col;
		  if (pos < line->width) {
		      fnval[i] = (CHAR) (cells[pos].c & 0xFF);
		      if (fnval[i] == 0)
			fnval[i] = SP;
		  } else
		    fnval[i] = SP;
	      }
	      fnval[i] = '\0';
	  } else {
	      fnval[0] = '\0';
	  }
	  p = fnval;
	  break;
      }
#endif /* OS2 */

#ifndef NOPUSH
      case FN_RAW:			/* \frawcommand() */
      case FN_CMD: {			/* \fcommand() */
	  int x, c, n = FNVALL;
	  x = 0;			/* Completion flag */
/*
  ZIFILE can be safely used because we can't possibly be transferring a file
  while executing this function.
*/
	  if (!nopush && zxcmd(ZIFILE,bp[0]) > 0) { /* Open the command */
	      while (n-- > -1) {	/* Read from it */
		  if ((c = zminchar()) < 0) {
		      x = 1;	 	 /* EOF - set completion flag */
		      if (y == FN_CMD) { /* If not "rawcommand" */
			  p--;		 /* remove trailing newlines */
			  while (*p == CR || *p == LF)
			    p--;
			  p++;
		      }
		      *p = NUL;		/* Terminate the string */
		      break;
		  } else		/* Command still running */
		    *p++ = c;		/* Copy the bytes */
	      }
	      zclose(ZIFILE);		/* Close the command */
	  }
	  /* Return null string if command's output was too long. */
	  p = fnval;
	  if (!x) {
	      failed = 1;
	      if (fndiags)
		sprintf(fnval,"<ERROR:RESULT_TOO_LONG:\\f%s()>",fn); 
	  }
	  break;
      }
#endif /* NOPUSH */

      case FN_STX: 			/* \fstripx(string,c) */
	if (!(s = bp[0]))		/* Make sure there is a string */
	  break;
	c = '.';			/* Character to strip from */
	if (argn > 1) if (*bp[1]) c = *bp[1];
	strncpy(fnval,bp[0],FNVALL);
	n = strlen(fnval);
	while (--n >= 0) {
	    if (fnval[n] == c) {
		fnval[n] = NUL;
		break;
	    }
	}
	p = fnval;
	break;

      case FN_STL: 			/* \flop(string,c) */
	if (!(s = bp[0]))		/* Make sure there is a string */
	  break;
	c = '.';			/* Character to strip to */
	if (argn > 1) if (*bp[1]) c = *bp[1];
	x = 0;
	while (*s++) {
	    if (*(s-1) == c) {
		x = 1;
		break;
	    }
	}	      
	if (!x) s = bp[0];
	strncpy(fnval,s,FNVALL);
	p = fnval;
	break;

      case FN_STN:			/* \fstripn(string,n) */
	if (argn < 1)			/* Remove n chars from right */
	  break;
	val1 = "0";
	if (argn > 1)
	  if (*(bp[1]))
	    val1 = evala(bp[1]);
	if (!chknum(val1)) {
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	    break;
	}
	n = atoi(val1);
	if (n < 0) n = 0;
	k = (int)strlen(s = bp[0]) - n;
	if (k < 0) k = 0;
	p = fnval;
	while (k-- > 0)
	  *p++ = *s++;
	*p = NUL;
	p = fnval;
	break;

      case FN_2HEX:			/* Number to hex */
      case FN_2OCT:			/* Number to octal */
	if (!rdigits(bp[0])) {
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	    break;
	}
	sprintf(fnval, y == FN_2HEX ? "%lx" : "%lo", atol(bp[0]));
	if (y == FN_2HEX && (int)(strlen(fnval)&1))
	  sprintf(fnval,"0%lx",atol(bp[0]));
	p = fnval;
	break;

      case FN_DNAM: {			/* Directory part of file name */
	  char *s;
#ifdef ZFNQFP
	  zfnqfp(bp[0],FNVALL,p);	/* Get full name */
#else
	  strcpy(p,bp[0]);
#endif /* ZFNQFP */
	  if (!isdir(p)) {		/* Is it already a directory? */
	      zstrip(p,&s);		/* No get basename */
	      if (*s) {
		  x = ckindex(s,p,0,0,0); /* Pos of latter in former */
		  if (x > 0) p[x-1] = NUL;
	      }
	  } 
	  if (!p) p = "";
	  break;
      }
	
#ifndef NORANDOM
      case FN_RAND:			/* Random number */
	k = rand();
	x = 0;
	if (argn > 0) {
	    if (!chknum(bp[0])) {
		failed = 1;
		if (fndiags)
		  sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		break;
	    }
	    x = atoi(bp[0]);
	}
	sprintf(fnval,"%d", x > 0 ? k % x : (x == 0 ? 0 : (0 - (k % (-x)))));
	p = fnval;
	break;
#endif /* NORANDOM */

      case FN_SPLIT:			/* \fsplit(s1,a,s2,s3) */
      case FN_WORD: {			/* \fword(s1,n,s2,s3) */
	  int inword = 0;
	  int wordnum = 0;
	  int splitting = 0;
	  int x, max = 0;
	  char c;
	  char * sep = "";
	  char * notsep = "";
	  char abuf[16];
	  fnval[0] = NUL;		/* Initial return value */
	  x = (splitting = (y == FN_SPLIT)) ? 2 : 1;
	  if (argn < x)	{		/* Check for minimum number of args */
	      failed = 1;
	      if (fndiags)
		sprintf(fnval,"<ERROR:MISSING_ARG:\\f%s()>",fn);
	      break;
	  }
	  if (!splitting) {		/* \fword(): n = word number */
	      val1 = "1";		/* Default is first word */
	      if (argn > 1)		/* Word number supplied */
		if (*(bp[1]))
		  val1 = evala(bp[1]);
	      if (!chknum(val1)) {
		  failed = 1;
		  if (fndiags)
		    sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
		  break;
	      }
	      n = atoi(val1);
	  } else {			/* \fsplit(): n = word count */
	      strncpy(abuf,bp[1],15);	/* Get array reference */
	      failed = 1;		/* Assume it's bad */
	      p = fnval;		/* Point to result */
	      if (fndiags)		/* Default is this error message */
		sprintf(fnval,"<ERROR:ARG_BAD_ARRAY:\\f%s()>",fn);
	      if (abuf[0] != '&')	/* "Address" of array */
		break;			/* It's bad */
	      if (abuf[2])
		if (abuf[2] != '[' || abuf[3] != ']')
		  break;		/* Bad */
	      if (abuf[1] > 64 && abuf[1] < 91)	/* Convert upper to lower */
		abuf[1] += 32;
	      if (abuf[1] < 97 || abuf[1] > 122) /* Check for a-z */
		break;
	      if ((max = chkarray(abuf[1],1)) < 1) { /* Array is declared? */
		  if (fndiags)		/* Change message */
		    sprintf(fnval,"<ERROR:ARG_NOT_ARRAY:\\f%s()>",fn);
		  break;
	      }
	      fnval[0] = NUL;		/* No error, erase message */
	      failed = 0;		/* Unset failure flag */
	      n = 0;			/* Initialize the counter */
	      c = abuf[1];		/* Remember array letter */
	  }
	  if (argn > 2)			/* Have break set? */
	    sep = bp[2];
	  if (argn > 3)			/* Have include set? */
	    notsep = bp[3];
	  if (splitting || n >= 0) {	/* Something to do? */
	      s = bp[0];		/* String to get word(s) from */
	      p = "";			/* Pointer to word */
	      while (*s) {		/* Loop through string */
		  if (*s < SP)		/* Current char */
		    x = 0;		/* x == 0 means "is separator" */
		  else if (*sep)	/* Break set given */
		    x = (ckstrchr(sep,*s) ? 0 : 1);
		  else			/* Default break set */
		    x = (*s >= '0' && *s <= '9' ||
			 *s >= 'A' && *s <= 'Z' ||
			 *s >= 'a' && *s <= 'z');
		  if (x == 0 && *notsep) /* Exception set */
		    x = (ckstrchr(notsep,*s) ? 1 : 0);
		  if (x) {
		      if (!inword) {	/* Character is not a separator */
			  wordnum++;
			  inword = 1;
			  p = s;
		      }
		  } else {		/* Character is a separator */
		      if (inword) {
			  inword = 0;
			  if (splitting) { /* \fsplit() */
			      if (*s)
				*s++ = NUL;
			      sprintf(abuf,"\\&%c[%d]",c,wordnum);
			      addmac(abuf,p);
			      if (wordnum == max)
				break;
			      continue;
			  } else if (wordnum == n) { /* \fword() */
			      *s = NUL;
			      strncpy(fnval,p,FNVALL);
			      fnval[FNVALL-1] = NUL;
			      break;
			  } else
			    p = "";
		      }
		  }
		  if (!*s)
		    break;
		  else
		    s++;
	      }
	  }
	  if (splitting)
	    sprintf(fnval,"%d",wordnum);
	  p = fnval;
	  break;
      }

#ifdef CK_KERBEROS
      case FN_KRB_TK:			/* Kerberos tickets */
      case FN_KRB_NX: 			/* Kerberos next ticket */
      case FN_KRB_IV:			/* Kerberos ticket is valid */
      case FN_KRB_TT: {			/* Kerberos ticket time */
	  int kv = 0;			/* Kerberos version */
          int n = 0;
          char * s = NULL;
	  if (rdigits(bp[0])) {
	      kv = atoi(bp[0]);
	  } else {
	      failed = 1;
	      if (fndiags)
		sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	      break;
	  }
	  if (kv != 4 && kv != 5) {
	      failed = 1;
	      if (fndiags)
		sprintf(fnval,"<ERROR:ARG_OUT_OF_RANGE:\\f%s()>",fn);
	      break;
	  }
	  if ((y == FN_KRB_IV || y == FN_KRB_TT) && argn < 2) {
	      failed = 1;
	      if (fndiags)
		sprintf(fnval,"<ERROR:MISSING_ARG:\\f%s()>",fn);
	      break;
	  }
	  switch (y) {
	    case FN_KRB_TK:		/* Number of Kerberos tickets */
#ifdef CK_AUTHENTICATION
              switch (kv) {
		case 4:
                  n = ck_krb4_get_tkts();
                  sprintf(fnval, "%d", (n >= 0) ? n : 0);
                  break;
		case 5: {
		    extern char * krb5_d_cc;
		    n = ck_krb5_get_tkts(krb5_d_cc);
		    sprintf(fnval, "%d", (n >= 0) ? n : 0);
		    break;
		}
              }
#else
	      sprintf(fnval,"%d",0);	/* Some number, 0 or greater */
#endif /* CK_AUTHENTICATION */
	      break;
	      
	    case FN_KRB_NX:		/* Kerberos next ticket */
#ifdef CK_AUTHENTICATION
	      switch (kv) {
                case 4:
		  s = ck_krb4_get_next_tkt();
		  sprintf(fnval, "%s", s ? s : "");
		  break;
                case 5:
		  s = ck_krb5_get_next_tkt();
		  sprintf(fnval, "%s" , s ? s : "");
		  break;
	      }
#else
	      sprintf(fnval,"k%d next-ticket-string",kv); /* Some string */
#endif /* CK_AUTHENTICATION */
	      break;

	    case FN_KRB_IV:		/* Kerberos ticket is valid */
#ifdef CK_AUTHENTICATION
	      /* Return 1 if valid, 0 if not */
	      switch (kv) {
                case 4:
		  n = ck_krb4_tkt_isvalid(bp[1]);
		  sprintf(fnval, "%d", n > 0 ? 1 : 0);
		  break;
                case 5: {
                    extern char * krb5_d_cc;
                    n = ck_krb5_tkt_isvalid(krb5_d_cc,bp[1]);
                    sprintf(fnval,"%d", n > 0 ? 1 : 0);
                    break;
                }
	      }
#else
	      sprintf(fnval,"%d",0);	/* Return 1 if valid, 0 if not */
#endif /* CK_AUTHENTICATION */
	      break;

	    case FN_KRB_TT:		/* Kerberos ticket time */
#ifdef CK_AUTHENTICATION
	      switch (kv) {
                case 4:
		  n = ck_krb4_tkt_time(bp[1]);
		  sprintf(fnval,"%d", n >= 0 ? n : 0);
		  break;
                case 5: {
                    extern char * krb5_d_cc;
                    n = ck_krb5_tkt_time(krb5_d_cc,bp[1]);
                    sprintf(fnval,"%d", n >= 0 ? n : 0);
                    break;
                }
	      }
#else
	      sprintf(fnval,"%s","600");	/* Some time */
#endif /* CK_AUTHENTICATION */
	      break;
	  }
	  p = fnval;
	  break;
      }
#endif /* CK_KERBEROS */

#ifdef FN_ERRMSG
      case FN_ERRMSG:
	if (rdigits(bp[0])) {
	    k = atoi(bp[0]);
	} else {
	    failed = 1;
	    if (fndiags)
	      sprintf(fnval,"<ERROR:ARG_NOT_NUMERIC:\\f%s()>",fn);
	    break;
	}
#ifdef VMS
	strncpy(fnval,ckvmserrstr(k),FNVALL);
#else
	x = errno;
	errno = k;
	strncpy(fnval,ck_errstr(),FNVALL);
	errno = x;
#endif /* VMS */
	p = fnval;
	break;
#endif /* FN_ERRMSG */

      case FN_DIM: {
	  int x, max;
	  char abuf[16];
	  fnval[0] = NUL;		/* Initial return value */
	  if (argn < 1)	{		/* Check for minimum number of args */
	      failed = 1;
	      if (fndiags)
		sprintf(fnval,"<ERROR:MISSING_ARG:\\f%s()>",fn);
	      break;
	  }
	  strncpy(abuf,bp[0],15);	/* Get array reference */
	  failed = 1;			/* Assume it's bad */
	  p = fnval;			/* Point to result */
	  if (fndiags)			/* Default is this error message */
	    sprintf(fnval,"<ERROR:ARG_BAD_ARRAY:\\f%s()>",fn);
	  if (abuf[0] != '&')		/* "Address" of array */
	    break;			/* It's bad */
	  if (abuf[2])
	    if (abuf[2] != '[' || abuf[3] != ']')
	      break;			/* Bad */
	  if (abuf[1] >= 64 && abuf[1] < 91) /* Convert upper to lower */
	    abuf[1] += 32;
	  if (abuf[1] < 95 || abuf[1] > 122) /* Check for a-z */
	    break;
	  if ((max = chkarray(abuf[1],1)) < 1)
	    max = 0;
	  failed = 0;			/* Unset failure flag */
	  sprintf(fnval,"%d",max);
	  break;
      }

/* Note: when adding new functions remember to update dohfunc in ckuus2.c. */

      default:
	failed = 1;
	if (fndiags)
	  sprintf(fnval,"<ERROR:UNKNOWN_FUNCTION:\\f%s()>",fn);
	break;
    } /* End of switch() */

  fnend:
    /* Free temporary storage for aguments */
    for (k = 0; k < argn; k++) if (bp[k]) free(bp[k]);
    fndepth--;
    if (failed) {			/* Handle failure */
	k = strlen(p);
	if (k > 0) {
	    /* In case this wasn't caught above... */
	    if (p[0] != '<' && p[k-1] != '>') {
		sprintf(fnval,"<ERROR:ARG_TOO_LONG:\\f%s()>",fn);
		p = fnval;
		k = strlen(p);
	    }
	}
	if (fnerror) {			/* SET FUNCTION ERROR ON */
	    debug(F100,"fneval failed","",0);
	    fnsuccess = 0;		/* Make command fail (see ckuus5.c) */
	    if (fndiags) {		/* SET FUNCTION DIAGNOSTICS ON */
		if (k > 0) {		/* Strip <>'s */
		    if (p[0] == '<' && p[k-1] == '>') {
			p[k-1] = NUL;
			p++;
		    }
		}
		printf("?%s\n",p);	/* Print error message now. */
	    }
	    return("");			/* Return nothing. */
	}
    }
    return(p);
}
#endif /* NOSPL */

static char ndatbuf[10];

char *
zzndate() {
    char * p;
    int x;

    ztime(&p);				/* Get "asctime" string */
    if (p == NULL || *p == NUL) return("");
    for (x = 20; x < 24; x++)		/* yyyy */
      ndatbuf[x - 20] = p[x];
    ndatbuf[6] = (char) ((p[8] == ' ') ? '0' : p[8]);
    ndatbuf[7] = p[9];			/* dd */
    for (x = 0; x < 12; x++)		/* mm */
      if (!strncmp(p+4,months[x],3)) break;
    if (x == 12) {
	ndatbuf[4] = ndatbuf[5] = '?';
    } else {
	x++;
	ndatbuf[4] = (char) ((x < 10) ? '0' : '1');
	ndatbuf[5] = (char) ((x % 10) + 48);
    }
    ndatbuf[8] = NUL;
    return((char *)ndatbuf);
}

/* For VN_PID */

#ifdef OS2
#define getpid _getpid
#else
#ifdef VMS
_PROTOTYP( long zgpid, (void) );
#endif /* VMS */
#endif /* OS2 */

#ifndef NOSPL
#define EMBUFLEN 128			/* Error message buffer length */

static char embuf[EMBUFLEN+1];

char *					/* Evaluate builtin variable */
nvlook(s) char *s; {
    int x, y;
    long z;
    char *p;
#ifndef NODIAL
    MDMINF * m;
#endif /* NODIAL */
#ifndef NOKVERBS			/* Keyboard macro material */
    extern int keymac, keymacx;
#endif /* NOKVERBS */
    if (!s) s = "";
    x = strlen(s);
    if (fndiags) {			/* FUNCTION DIAGNOSTIC ON */
	if (x + 32 < EMBUFLEN)
	  sprintf(embuf,"<ERROR:NO_SUCH_VARIABLE:\\v(%s)>",s);
	else
	  sprintf(embuf,"<ERROR:NO_SUCH_VARIABLE>");
    } else				/* FUNCTION DIAGNOSTIC OFF */
      embuf[0] = NUL;
    x = VVBUFL;
    p = vvbuf;
    if (zzstring(s,&p,&x) < 0) {	/* e.g. for \v(\%a) */
	y = -1;
    } else {
	s = vvbuf;
	y = lookup(vartab,s,nvars,&x);
    }
#ifndef NODIAL
    m = (mdmtyp > 0) ? modemp[mdmtyp] : NULL; /* For \v(m_xxx) variables */
#endif /* NODIAL */

    debug(F101,"nvlook y","",y);

    switch (y) {
      case VN_ARGC:			/* ARGC */
	sprintf(vvbuf,"%d",macargc[maclvl]);
	return(vvbuf);

      case VN_ARGS:			/* ARGS */
	sprintf(vvbuf,"%d",xargs);
	return(vvbuf);

      case VN_COUN:			/* COUNT */
	sprintf(vvbuf,"%d",count[cmdlvl]);
	return(vvbuf);

      case VN_DATE:			/* DATE */
	ztime(&p);			/* Get "asctime" string */
	if (p == NULL || *p == NUL) return(NULL);
	vvbuf[0] = p[8];		/* dd */
	vvbuf[1] = p[9];
	vvbuf[2] = SP;
	vvbuf[3] = p[4];		/* mmm */
	vvbuf[4] = p[5];
	vvbuf[5] = p[6];
	vvbuf[6] = SP;
	for (x = 20; x < 24; x++)	/* yyyy */
	  vvbuf[x - 13] = p[x];
	vvbuf[11] = NUL;
	return(vvbuf);

      case VN_NDAT:			/* Numeric date */
	strcpy(vvbuf,zzndate());
        return(vvbuf);

      case VN_DIRE:			/* DIRECTORY */
	s = zgtdir();			/* Get current directory */
	if (!s)
#ifdef UNIXOROSK
	  s = "./";
#else
#ifdef VMS
	  s = "[]";
#else
	  s = "";
#endif /* VMS */
#endif /* UNIXOROSK */
	strncpy(vvbuf,s,VVBUFL);
	s = vvbuf;
#ifdef UNIXOROSK
	x = strlen(s);
	if (x < VVBUFL - 1) {
	    if (s[x-1] != '/') {
		s[x] = '/';
		s[x+1] = NUL;
	    }
	}
#endif /* UNIXOROSK */
	return(s);

      case VN_FILE:			/* filespec */
	return(fspec);

      case VN_HOST:			/* host name */
	if (*myhost) {			/* If known */
	    return(myhost);		/* return it. */
	} else {			/* Otherwise */
	    strcpy(vvbuf,"unknown");	/* just say "unknown" */
	    return(vvbuf);
	}

      case VN_SYST:			/* System type */
#ifdef UNIX
	strcpy(vvbuf,"UNIX");
#else
#ifdef VMS
	strcpy(vvbuf,"VMS");
#else
#ifdef OSK
	strcpy(vvbuf,"OS9/68K");
#else
#ifdef AMIGA
	strcpy(vvbuf,"Amiga");
#else
#ifdef MAC
	strcpy(vvbuf,"Macintosh");
#else
#ifdef OS2
#ifdef NT
	strcpy(vvbuf,"WIN32") ;
#else /* NT */
	strcpy(vvbuf,"OS/2");
#endif /* NT */
#else
#ifdef datageneral
	strcpy(vvbuf,"AOS/VS");
#else
#ifdef GEMDOS
	strcpy(vvbuf,"Atari_ST");
#else
#ifdef STRATUS
	strcpy(vvbuf,"Stratus_VOS");
#else
	strcpy(vvbuf,"unknown");
#endif /* STRATUS */
#endif /* GEMDOS */
#endif /* datageneral */
#endif /* OS2 */
#endif /* MAC */
#endif /* AMIGA */
#endif /* OSK */
#endif /* VMS */
#endif /* UNIX */
	return(vvbuf);

      case VN_SYSV:			/* System herald */
	for (x = y = 0; x < VVBUFL; x++) {
	    if (ckxsys[x] == SP && y == 0) continue;
	    vvbuf[y++] = (char) ((ckxsys[x] == SP) ? '_' : ckxsys[x]);
	}
	vvbuf[y] = NUL;
	return(vvbuf);

      case VN_TIME:			/* TIME. Assumes that ztime returns */
	ztime(&p);			/* "Thu Feb  8 12:00:00 1990" */
	if (p == NULL || *p == NUL)	/* like asctime()! */
	  return(NULL);
	for (x = 11; x < 19; x++)	/* copy hh:mm:ss */
	  vvbuf[x - 11] = p[x];		/* to vvbuf */
	vvbuf[8] = NUL;			/* terminate */
	return(vvbuf);			/* and return it */

      case VN_NTIM:			/* Numeric time */
	ztime(&p);			/* "Thu Feb  8 12:00:00 1990" */
	if (p == NULL || *p == NUL)	/* like asctime()! */
	  return(NULL);
	z = atol(p+11) * 3600L + atol(p+14) * 60L + atol(p+17);
	sprintf(vvbuf,"%ld",z);
	return(vvbuf);

#ifdef CK_TTYFD
      case VN_TTYF:			/* TTY file descriptor */
	sprintf(vvbuf,"%d",
#ifdef VMS
		vmsttyfd()
#else
		ttyfd
#endif /* VMS */
		);
	return(vvbuf);
#endif /* CK_TTYFD */

      case VN_VERS:			/* Numeric Kermit version number */
	sprintf(vvbuf,"%ld",vernum);
	return(vvbuf);

      case VN_XVNUM:			/* Product-specific version number */
	sprintf(vvbuf,"%ld",xvernum);
	return(vvbuf);

      case VN_HOME:			/* Home directory */
#ifdef UNIXOROSK
        sprintf(vvbuf,"%s",zhome());
	x = strlen(vvbuf);
	if (x <= 0) {
	    vvbuf[0] = '/';
	    vvbuf[1] = NUL;
	} else if (x < VVBUFL - 2 && vvbuf[x-1] != '/') {
	    vvbuf[x] = '/';
	    vvbuf[x+1] = NUL;
	}
	return(vvbuf);
#else
#ifdef STRATUS
	sprintf(vvbuf,"%s>",zhome());
	return(vvbuf);
#else
	return(zhome());
#endif /* STRATUS */
#endif /* UNIXOROSK */

      case VN_IBUF:			/* INPUT buffer */
	return((char *)inpbuf);

      case VN_ICHR:			/* INPUT character */
	inchar[1] = NUL;
	return((char *)inchar);

      case VN_ICNT:			/* INPUT character count */
        sprintf(vvbuf,"%d",incount);
	return(vvbuf);

      case VN_SPEE: {			/* Transmission SPEED */
	  long t;
	  t = ttgspd();
	  if (t < 0L)
	    sprintf(vvbuf,"unknown");
	  else
	    sprintf(vvbuf,"%ld",t);
	  return(vvbuf);
      }
      case VN_SUCC:			/* SUCCESS flag */
	sprintf(vvbuf,"%d",(success == 0) ? 1 : 0);
	return(vvbuf);

      case VN_LINE: {			/* LINE */
#ifdef CK_TAPI
          if (tttapi) {
              int i;
              for (i = 0; i < ntapiline; i++) {
                  if (!strcmp(ttname,tapilinetab[i].kwd)) {
                      p = _tapilinetab[i].kwd;
                      return(p);
                  }
              }
          }
#endif /* CK_TAPI */
          p = (char *) ttname;
          return(p);
      }

      case VN_PROG:			/* Program name */
	return("C-Kermit");

      case VN_RET:			/* Value of most recent RETURN */
	p = mrval[maclvl+1];
	if (p == NULL) p = "";
	return(p);

      case VN_FFC:			/* Size of most recent file */
	sprintf(vvbuf, "%ld", ffc);
	return(vvbuf);

      case VN_TFC:			/* Size of most recent file group */
	sprintf(vvbuf, "%ld", tfc);
	return(vvbuf);

    case VN_CPU:			/* CPU type */
#ifdef OS2
         {
            char * getcpu(void) ;
            return getcpu();
         }
#else /* OS2 */
#ifdef CKCPU
	return(CKCPU);
#else
#ifdef CK_UTSNAME
	{
	    extern char unm_mch[];
	    return((char *)unm_mch);
	}
#else
	return("unknown");
#endif /* CK_UTSNAME */
#endif /* CKCPU */
#endif /* OS2 */

      case VN_CMDL:			/* Command level */
	sprintf(vvbuf, "%d", cmdlvl);
	return(vvbuf);

      case VN_DAY:			/* Day of week */
      case VN_NDAY:
/*
  Depends on ztime() returning ENGLISH asctime()-format string!
  asctime() format is: "Thu Feb  8 12:00:00 1990".
  Needs updating to accommodate non-English asctime() strings.
*/
	ztime(&p);
	if (p != NULL && *p != NUL) {	/* ztime() succeeded. */
	    if (y == VN_DAY) {		/* String day. */
		strncpy(vvbuf,p,3);
	    } else {			/* Numeric day. */
		for (x = 0; x < 7; x++)	  /* Look up day string in table */
		  if (!strncmp(p,wkdays[x],3))
		    break;
		if (x > 6) x = -1;	/* Not found */
		sprintf(vvbuf,"%d",x);	/* Return the number */
	    }
	} else vvbuf[0] = NUL;		/* ztime() failed. */
	return(vvbuf);			/* Return what we got. */

      case VN_LCL:			/* Local (vs remote) mode */
	strcpy(vvbuf, local ? "1" : "0");
	return(vvbuf);

      case VN_CMDS:			/* Command source */
	if (cmdstk[cmdlvl].src == CMD_KB)
	  strcpy(vvbuf,"prompt");
	else if (cmdstk[cmdlvl].src == CMD_MD)
	  strcpy(vvbuf,"macro");
	else if (cmdstk[cmdlvl].src == CMD_TF)
	  strcpy(vvbuf,"file");
	else strcpy(vvbuf,"unknown");
	return(vvbuf);

      case VN_CMDF:			/* Current command file name */
#ifdef COMMENT				/* (see comments above) */
	if (tfnam[tlevel]) {		/* (near dblbs declaration) */
	    dblbs(tfnam[tlevel],vvbuf,VVBUFL);
	    return(vvbuf);
	} else return("");
#else
	if (tlevel < 0)
	  return("");
	else
	  return(tfnam[tlevel] ? tfnam[tlevel] : "");
#endif /* COMMENT */

      case VN_MAC:			/* Current macro name */
	return((maclvl > -1) ? m_arg[maclvl][0] : "");

      case VN_EXIT:
	sprintf(vvbuf,"%d",xitsta);
	return(vvbuf);

      case VN_PRTY: {			/* Parity */
	  char *s;
	  switch (parity) {
	    case 0:   s = "none";  break;
	    case 'e': s = "even";  break;
	    case 'm': s = "mark";  break;
	    case 'o': s = "odd";   break;
	    case 's': s = "space"; break;
	    default:  s = "unknown"; break;
	  }
	  strcpy(vvbuf,s);
	  return(vvbuf);
      }

      case VN_DIAL:
	sprintf(vvbuf,"%d",
#ifndef NODIAL
		dialsta
#else
		-1
#endif /* NODIAL */
		);
	return(vvbuf);

#ifdef OS2
      case VN_KEYB:
	strncpy(vvbuf,conkbg(),VVBUFL);
	return(vvbuf);

      case VN_SELCT: {
          extern char * selection ;
          return( selection ? selection : "" ) ;
      }
#endif /* OS2 */

      case VN_CPS: {
	  extern long tfcps;
	  sprintf(vvbuf,"%ld",tfcps);
        }
	return(vvbuf);

      case VN_MODE:			/* File transfer mode */
	switch (binary) {
	  case XYFT_T: strcpy(vvbuf,"text"); break;
	  case XYFT_B:
	  case XYFT_U: strcpy(vvbuf,"binary"); break;
	  case XYFT_I: strcpy(vvbuf,"image"); break;
	  case XYFT_L: strcpy(vvbuf,"labeled"); break;
	  case XYFT_M: strcpy(vvbuf,"macbinary"); break;
	  default:     strcpy(vvbuf,"unknown");
	}
	return(vvbuf);

#ifdef CK_REXX
      case VN_REXX:
	return(rexxbuf);
#endif /* CK_REXX */

      case VN_NEWL:			/* System newline char or sequence */
#ifdef UNIX
	strcpy(vvbuf,"\n");
#else
#ifdef datageneral
	strcpy(vvbuf,"\n");
#else
#ifdef OSK
	strcpy(vvbuf,"\15");		/* Remember, these are octal... */
#else
#ifdef MAC
	strcpy(vvbuf,"\15");
#else
#ifdef OS2
	strcpy(vvbuf,"\15\12");
#else
#ifdef STRATUS
	strcpy(vvbuf,"\n");
#else
#ifdef VMS
	strcpy(vvbuf,"\15\12");
#else
#ifdef AMIGA
	strcpy(vvbuf,"\n");
#else
#ifdef GEMDOS
	strcpy(vvbuf,"\n");
#else
	strcpy(vvbuf,"\n");
#endif /* GEMDOS */
#endif /* AMIGA */
#endif /* VMS */
#endif /* STRATUS */
#endif /* OS2 */
#endif /* MAC */
#endif /* OSK */
#endif /* datageneral */
#endif /* UNIX */
	return(vvbuf);

      case VN_ROWS:			/* ROWS */
      case VN_COLS:			/* COLS */
        strcpy(vvbuf,(y == VN_ROWS) ? "24" : "80"); /* Default */
#ifdef CK_TTGWSIZ
#ifdef OS2 
        if (tt_cols[VTERM] < 0 || tt_rows[VTERM] < 0)
	  ttgwsiz();
        sprintf(vvbuf,"%d",(y == VN_ROWS) ? tt_rows[VTERM] : tt_cols[VTERM]);
#else /* OS2 */
        if (ttgwsiz() > 0)		/* Get window size */
	  if (tt_cols > 0 && tt_rows > 0) /* sets tt_rows, tt_cols */
	    sprintf(vvbuf,"%d",(y == VN_ROWS) ? tt_rows : tt_cols);
#endif /* OS2 */
#endif /* CK_TTGWSIZ */
	return(vvbuf);

      case VN_TTYP:
#ifdef OS2
	sprintf(vvbuf, "%s",
		(tt_type >= 0 && tt_type <= max_tt) ?
		tt_info[tt_type].x_name :
		"unknown"
		);
#else
#ifdef MAC
	strcpy(vvbuf,"vt320");
#else
	p = getenv("TERM");
	sprintf(vvbuf,"%s", p ? p : "unknown");
#endif /* MAC */
#endif /* OS2 */
	return(vvbuf);

      case VN_MINP:			/* MINPUT */
	sprintf(vvbuf, "%d", m_found);
	return(vvbuf);

      case VN_CONN:			/* CONNECTION */
	if (!local) {
	  strcpy(vvbuf,"remote");
	} else {
	    if (!network)
	      strcpy(vvbuf,"serial");
#ifdef TCPSOCKET
	    else if (nettype == NET_TCPB || nettype == NET_TCPA) {
		if (ttnproto == NP_TELNET)
		  strcpy(vvbuf,"tcp/ip_telnet");
		else
		  strcpy(vvbuf,"tcp/ip");
	    }
#endif /* TCPSOCKET */
#ifdef ANYX25
	    else if (nettype == NET_SX25 ||
		     nettype == NET_VX25 ||
		     nettype == NET_IX25
		     )
	      strcpy(vvbuf,"x.25");
#endif /* ANYX25 */
#ifdef DECNET
	    else if (nettype == NET_DEC) {
		if ( ttnproto == NP_LAT ) strcpy(vvbuf,"decnet_lat");
		else if ( ttnproto == NP_CTERM ) sprintf(vvbuf,"decnet_cterm");
		else strcpy(vvbuf,"decnet");
	    }
#endif /* DECNET */
#ifdef SUPERLAT
        else if ( nettype == NET_SLAT ) 
           strcpy(vvbuf,"superlat");
#endif /* SUPERLAT */
#ifdef NETFILE
        else if ( nettype == NET_FILE )
           strcpy(vvbuf,"local file");
#endif /* NETFILE */
#ifdef NETCMD
        else if ( nettype == NET_CMD )
           strcpy(vvbuf,"sub-process");
#endif /* NETCMD */

#ifdef NETDLL
        else if ( nettype == NET_DLL )
           strcpy(vvbuf,"dynamic link library");
#endif /* NETDLL */
#ifdef SSH
        else if ( nettype == NET_SSH )
           strcpy(vvbuf,"secure shell");
#endif /* SSH */

#ifdef NPIPE
	    else if (nettype == NET_PIPE)
	      strcpy(vvbuf,"named_pipe");
#endif /* NPIPE */
#ifdef CK_NETBIOS
	    else if (nettype == NET_BIOS)
	      strcpy(vvbuf,"netbios");
#endif /* CK_NETBIOS */
	    else
	      strcpy(vvbuf,"unknown");
	}
	return(vvbuf);

      case VN_SYSI:			/* System ID, Kermit code */
	return((char *)cksysid);

#ifdef OS2
      case VN_SPA:
	sprintf(vvbuf,"%ld",zdskspace(0));
	return(vvbuf);
#endif /* OS2 */

      case VN_QUE: {
	  extern char querybuf[];
	  return(querybuf);
      }
#ifndef NOCSETS
      case VN_CSET:
#ifdef OS2
	sprintf(vvbuf,"cp%d",os2getcp());
#else
	sprintf(vvbuf,"%s",fcsinfo[fcharset].keyword);
#endif /* OS2 */
	return(vvbuf);
#endif /* NOCSETS */

#ifdef OS2
      case VN_STAR:
	return(startupdir);

      case VN_EXEDIR:
	return(exedir);    
#else
#ifdef VMSORUNIX
      case VN_STAR:
	return(startupdir);
#endif /* VMSORUNIX */
#endif /* OS2 */

      case VN_INI:
	return(inidir);

      case VN_MDM:
	return(gmdmtyp());

      case VN_EVAL:
	return(evalbuf);

#ifndef NODIAL
      case VN_D_CC:			/* DIAL COUNTRY-CODE */
	return(diallcc ? diallcc : "");
	
      case VN_D_AC:			/* DIAL AREA-CODE */
	return(diallac ? diallac : "");

      case VN_D_IP:			/* DIAL INTERNATIONAL-PREFIX */
	return(dialixp ? dialixp : "");

      case VN_D_LP:			/* DIAL LD-PREFIX */
	return(dialldp ? dialldp : "");

      case VN_D_LCP:			/* DIAL LOCAL-PREFIX */
	return(diallcp ? diallcp : "");
#else
      case VN_D_CC:			/* DIAL COUNTRY-CODE */
      case VN_D_AC:			/* DIAL AREA-CODE */
      case VN_D_IP:			/* DIAL INTERNATIONAL-PREFIX */
      case VN_D_LP:			/* DIAL LD-PREFIX */
      case VN_D_LCP:			/* DIAL LOCAL-PREFIX */
	return("");
#endif /* NODIAL */
      case VN_UID:
	return((char *)uidbuf);

      case VN_PWD:
#ifdef OS2
	if (activecmd == XXOUT) {
	    strncpy(vvbuf,pwbuf,VVBUFL);
	    ck_encrypt((char *)vvbuf);
	    return((char *)vvbuf);
	} else
#endif /* OS2 */
	  return((char *)pwbuf);

      case VN_PRM:
	return((char *)prmbuf);

      case VN_PROTO:
#ifdef CK_XYZ
	return(ptab[protocol].p_name);
#else
	return("kermit");
#endif /* CK_XYZ */

#ifdef CK_TMPDIR
      case VN_DLDIR:
	return(dldir ? dldir : "");
#endif /* CK_TMPDIR */

#ifndef NODIAL
      case VN_M_INI:			/* Modem init string */
	return(dialini ? dialini : (m ? m->wake_str : ""));

      case VN_M_DCM:			/* Modem dial command */
	return(dialcmd ? dialcmd : (m ? m->dial_str : ""));

      case VN_M_DCO:			/* Modem data compression on */
	return(dialdcon ? dialdcon : (m ? m->dc_on_str : ""));

      case VN_M_DCX:			/* Modem data compression off */
	return(dialdcoff ? dialdcoff : (m ? m->dc_off_str : ""));

      case VN_M_ECO:			/* Modem error correction on */
	return(dialecon ? dialecon : (m ? m->ec_on_str : ""));

      case VN_M_ECX:			/* Modem error correction off */
	return(dialecoff ? dialecoff : (m ? m->ec_off_str : ""));

      case VN_M_AAO:			/* Modem autoanswer on */
	return(dialaaon ? dialaaon : (m ? m->aa_on_str : ""));

      case VN_M_AAX:			/* Modem autoanswer off */
	return(dialaaoff ? dialaaoff : (m ? m->aa_off_str : ""));

      case VN_M_HUP:			/* Modem hangup command */
	return(dialhcmd ? dialhcmd : (m ? m->hup_str : ""));

      case VN_M_HWF:			/* Modem hardware flow command */
	return(dialhwfc ? dialhwfc : (m ? m->hwfc_str : ""));

      case VN_M_SWF:			/* Modem software flow command */
	return(dialswfc ? dialswfc : (m ? m->swfc_str : ""));

      case VN_M_NFC:			/* Modem no flow-control command */
	return(dialnofc ? dialnofc : (m ? m->nofc_str : ""));

      case VN_M_PDM:			/* Modem pulse dialing mode */
	return(dialpulse ? dialpulse : (m ? m->pulse : ""));

      case VN_M_TDM:			/* Modem tone dialing mode */
	return(dialtone ? dialtone : (m ? m->tone : ""));
#else
      case VN_M_INI:			/* Modem init string */
      case VN_M_DCM:			/* Modem dial command */
      case VN_M_DCO:			/* Modem data compression on */
      case VN_M_DCX:			/* Modem data compression off */
      case VN_M_ECO:			/* Modem error correction on */
      case VN_M_ECX:			/* Modem error correction off */
      case VN_M_AAO:			/* Modem autoanswer on */
      case VN_M_AAX:			/* Modem autoanswer off */
      case VN_M_HUP:			/* Modem hangup command */
      case VN_M_HWF:			/* Modem hardware flow command */
      case VN_M_SWF:			/* Modem software flow command */
      case VN_M_NFC:			/* Modem no flow-control command */
      case VN_M_PDM:			/* Modem pulse dialing mode */
      case VN_M_TDM:			/* Modem tone dialing mode */
	return("");
#endif /* NODIAL */

      case VN_ISTAT:			/* INPUT status */
	sprintf(vvbuf, "%d", instatus);
	return(vvbuf);

      case VN_TEMP:			/* Temporary directory */
	if (tempdir) {
	    p = tempdir;
	} else {
#ifdef OS2
#ifdef NT
	    p = getenv("K95TMP");
#else
	    p = getenv("K2TMP");
#endif /* NT */
	    if ( !p )
		p = getenv("CK_TMP");
	    if (!p)
#endif /* OS2 */
	    p = getenv("TEMP");
	    if (!p) p = getenv("TMP");
	    if (!p)
#ifdef UNIX				/* Systems that have a standard */
	      p = "/tmp/";		/* temporary directory... */
#else
#ifdef datageneral
	      p = ":TMP:";
#else
	      p = "";
#endif /* datageneral */
#endif /* UNIX */
	}
	strncpy(vvbuf,p,VVBUFL - 1);
	p = vvbuf;

/* This needs generalizing for VOS, AOS/VS, etc... */

	while (*p) {
#ifdef OS2
	    if (*p == '\\') *p = '/';
#endif /* OS2 */
	    p++;
	}
	if (p > vvbuf) {
	    char c =			/* Directory termination character */
#ifdef MAC
	      ':'
#else
#ifdef datageneral
	      ':'
#else
#ifdef STRATUS
	      '>'
#else
	      '/'
#endif /* STRATUS */
#endif /* datageneral */
#endif /* MAC */
		;

	    if (*(p-1) != c) {
		*p++ = c;
		*p = NUL;
	    }
	}
	return(vvbuf);

      case VN_ERRNO:			/* Error number */
#ifdef VMS
	{
	    extern int vms_lasterr;
            sprintf(vvbuf, "%d", vms_lasterr);
	}
#else
	sprintf(vvbuf, "%d", errno);
#endif /* VMS */
	return(vvbuf);

      case VN_ERSTR:			/* Error string */
	strncpy(vvbuf,ck_errstr(),VVBUFL - 1);
	return(vvbuf);

      case VN_RPSIZ:			/* RECEIVE packet-length */
	sprintf(vvbuf,"%d",urpsiz);
	return(vvbuf);

      case VN_WINDO:			/* WINDOW slots */
	sprintf(vvbuf,"%d",wslotr);
	return(vvbuf);

      case VN_TFLN:			/* TAKE-file line number */
	if (tlevel > -1) {
	    sprintf(vvbuf, "%d", tfline[tlevel]);
	    return(vvbuf);
	} else
	  return("0");

      case VN_MDMSG:			/* DIALRESULT */
#ifndef NODIAL
	return((char *)modemmsg);
#else
	return("");
#endif /* NODIAL */

      case VN_DNUM:			/* DIALNUMBER */
#ifndef NODIAL
	return(dialnum ? (char *) dialnum : "");
#else
	return("");
#endif /* NODIAL */

      case VN_APC:
	sprintf(vvbuf, "%d",
#ifdef CK_APC
		apcactive
#else
		0
#endif /* CK_APC */
		);
	return((char *)vvbuf);

      case VN_TRMK:
	  sprintf(vvbuf, "%d",
#ifdef OS2
		keymac
#else
		0
#endif /* OS2 */
		);
	return((char *)vvbuf);

      case VN_IPADDR:
#ifdef TCPSOCKET
        if (!myipaddr[0])
	  getlocalipaddr();
#endif /* TCPSOCKET */
	sprintf(vvbuf, "%s",
#ifdef TCPSOCKET
		(char *) myipaddr
#else
		""
#endif /* TCPSOCKET */
		);
	return((char *)vvbuf);

      case VN_CRC16:			/* CRC-16 of most recent transfer */
	sprintf(vvbuf,"%ld",crc16);
	return(vvbuf);

#ifdef CK_PID
      case VN_PID: {
	  long zz;
	  zz =
#ifdef VMS
	    zgpid() /* Maybe getpid() would work here too? */
#else
	    getpid()
#endif /* VMS */
	      ;
	  sprintf(vvbuf,"%ld",zz);
	  return(vvbuf);
      }
#endif /* CK_PID */

      case VN_FNAM: {
	  extern char filnam[], ofn1[];
	  extern int what;
	  return(what == W_SEND ? (char *)filnam : (char *)ofn1);
      }
      case VN_FNUM: {
	  extern long filcnt;
	  sprintf(vvbuf,"%ld",filcnt);
	  return((char *)vvbuf);
      }
#ifdef PEXITSTAT
      case VN_PEXIT: {
	  extern int pexitstat;
	  sprintf(vvbuf,"%d",pexitstat);
	  return((char *)vvbuf);
      }
#endif /* PEXITSTAT */

      case VN_P_8BIT:
	vvbuf[0] = parity ? ebq : NUL;
	vvbuf[1] = NUL;
	return((char *)vvbuf);

      case VN_P_CTL: {
	  extern CHAR myctlq;
	  vvbuf[0] = myctlq;
	  vvbuf[1] = NUL;
	  return((char *)vvbuf);
      }
      case VN_P_RPT: {
	  extern int rptena;
	  vvbuf[0] = rptena ? rptq : NUL;
	  vvbuf[1] = NUL;
	  return((char *)vvbuf);
      }
#ifdef OS2
      case VN_REGN:
	return(get_reg_name());
      case VN_REGO:
	return(get_reg_corp());
      case VN_REGS:
	return(get_reg_sn());
#endif /* OS2 */

      case VN_XPROG:
#ifdef OS2
#ifdef NT
	return("K-95");
#else
	return("K/2");
#endif /* NT */
#else
	return("C-Kermit");
#endif /* OS2 */

      case VN_EDITOR:
#ifdef NOFRILLS	
	return("");
#else
#ifdef NOPUSH
	return("");
#else
	{
	    extern char editor[];
	    char *s;
	    if (!editor[0]) {
		s = getenv("EDITOR");
		if (s) strncpy(editor,s,CKMAXPATH);
	    }
	    return((char *)editor);
	}
#endif /* NOPUSH */
#endif /* NOFRILLS */

      case VN_EDOPT:
#ifdef NOFRILLS	
	return("");
#else
#ifdef NOPUSH
	return("");
#else
	{
	    extern char editopts[];
	    return(editopts[0] ? (char *)editopts : "");
	}
#endif /* NOPUSH */
#endif /* NOFRILLS */

      case VN_EDFILE:
#ifdef NOFRILLS	
	return("");
#else
#ifdef NOPUSH
	return("");
#else
	{
	    extern char editfile[];
	    return(editfile[0] ? (char *)editfile : "");
	}
#endif /* NOPUSH */
#endif /* NOFRILLS */

#ifdef BROWSER
      case VN_BROWSR: {
	  extern char browser[];
	  if (!browser[0]) {
	      s = getenv("BROWSER");
	      if (s) strncpy(browser,s,CKMAXPATH);
	  }
          return(browser[0] ? (char *)browser : "");
      }
      case VN_BROPT: {
	  extern char browsopts[];
	  return(browsopts[0] ? (char *)browsopts : "");
      }
      case VN_URL: {
	  extern char browsurl[];
	  return(browsurl[0] ? (char *)browsurl : "");
      }
#endif /* BROWSER */
      case VN_HERALD:
	return((char *)versio);

      case VN_TEST: {			/* test */
	  extern char * ck_s_test, * ck_s_tver;
	  if (!ck_s_test) ck_s_test = "";
	  if (!ck_s_tver) ck_s_tver = "";
	  if (*ck_s_test) {
	      strcpy(vvbuf,ck_s_test);
	      if (*ck_s_tver) {
		  strcat(vvbuf,".");
		  strcat(vvbuf,ck_s_tver);
	      }
	  } else
	    strcpy(vvbuf,"0");
	  return((char *)vvbuf);
      }
      case VN_XFSTAT:			/* xferstatus */
	x = xferstat;			/* Like success */
	if (x > -1) x = (x == 0) ? 1 : 0; /* External value is reversed */
	sprintf(vvbuf,"%d",x);
	return((char *)vvbuf);

      case VN_XFMSG:			/* xfermsg */
	return((char *)epktmsg);

#ifndef NOMSEND
      case VN_SNDL: {			/* sendlist */
	  extern int filesinlist;
	  sprintf(vvbuf,"%d",filesinlist);
	  return((char *)vvbuf);
      }
#endif /* NOMSEND */

#ifdef CK_TRIGGER
      case VN_TRIG: {
	  extern char * triggerval;
	  return(triggerval ? triggerval : "");
      }
#endif /* CK_TRIGGER */

#ifdef OS2
      case VN_MOU_X: {
	  extern int MouseCurX;
	  sprintf(vvbuf,"%d",MouseCurX);
	  return((char *)vvbuf);
      }
      case VN_MOU_Y: {
	  extern int MouseCurY;
	  sprintf(vvbuf,"%d",MouseCurY);
	  return((char *)vvbuf);
      }
#endif /* OS2 */
      case VN_PRINT: {
	  extern int printpipe;
	  extern char * printername;
#ifdef PRINTSWI
	  extern int noprinter;
	  if (noprinter) return("");
#endif /* PRINTSWI */
	  sprintf(vvbuf,"%s%s",
		  printpipe ? "|" : "",
		  printername ? printername :
#ifdef OS2
		  "PRN"
#else
		  "(default)"
#endif /* OS2 */
		  );
	  return((char *)vvbuf);
      }
      case VN_ESC: {			/* Escape character */
	  extern int escape;
	  sprintf(vvbuf,"%d",escape);
	  return((char *)vvbuf);
      }
      case VN_INTIME:
	sprintf(vvbuf,"%ld",inetime);
	return((char *)vvbuf);

#ifdef CK_KERBEROS
      case VN_K4PRN: {
	  extern char * krb4_d_principal;
	  if (krb4_d_principal)
	    sprintf(vvbuf,"%s",krb4_d_principal);
	  else
	    *vvbuf = NUL;
	  return((char *)vvbuf);
      }
      case VN_K5PRN: {
	  extern char * krb5_d_principal;
	  if (krb5_d_principal)
	    sprintf(vvbuf,"%s",krb5_d_principal);
	  else
	    *vvbuf = NUL;
	  return((char *)vvbuf);
      }
      case VN_K4RLM: {
	  extern char * krb4_d_realm;
	  if (krb4_d_realm) {
	      sprintf(vvbuf,"%s",krb4_d_realm);
	  } else {
              char * s = ck_krb4_getrealm();
              sprintf(vvbuf,"%s", s ? s : "");
          }
	  return((char *)vvbuf);
      }
      case VN_K4SRV: {
	  extern char * krb4_d_srv;
	  if (krb4_d_srv)
	    sprintf(vvbuf,"%s",krb4_d_srv);
	  else
	    strcpy(vvbuf,"rcmd");
	  return((char *)vvbuf);
      }
      case VN_K5RLM: {
	  extern char * krb5_d_realm;
	  extern char * krb5_d_cc;
	  if (krb5_d_realm) {
	      sprintf(vvbuf,"%s",krb5_d_realm);
	  } else {
              char * s = ck_krb5_getrealm(krb5_d_cc);
              sprintf(vvbuf,"%s", s ? s : "");
          }
	  return((char *)vvbuf);
      }
      case VN_K5CC: {
	  extern char * krb5_d_cc;
	  if (krb5_d_cc)
	    sprintf(vvbuf,"%s",krb5_d_cc);
	  else
	    *vvbuf = NUL;
	  return((char *)vvbuf);
      }
      case VN_K5SRV: {
	  extern char * krb5_d_srv;
	  if (krb5_d_srv)
	    sprintf(vvbuf,"%s",krb5_d_srv);
	  else
	    strcpy(vvbuf,"host");
	  return((char *)vvbuf);
      }
#endif /* CK_KERBEROS */

      case VN_OSNAM:
#ifdef CK_UTSNAME
	{
	    extern char unm_nam[];
	    return((char *)unm_nam);
	}
#else
	for (x = y = 0; x < VVBUFL; x++) {
	    if (ckxsys[x] == SP && y == 0) continue;
	    vvbuf[y++] = (char) ((ckxsys[x] == SP) ? '_' : ckxsys[x]);
	}
	vvbuf[y] = NUL;
	return(vvbuf);
#endif /* CK_UTSNAME */

      case VN_OSVER: {
#ifdef CK_UTSNAME
	  extern char unm_ver[];
	  return((char *)unm_ver);
#else
	  return("");
#endif /* CK_UTSNAME */
      }

      case VN_OSREL: {
#ifdef CK_UTSNAME
	  extern char unm_rel[];
	  return((char *)unm_rel);
#else
	  return("");
#endif /* CK_UTSNAME */
      }

      case VN_NAME: {
	  extern char * myname;
	  return(myname);
      }

      case VN_MODL: {
#ifdef CK_UTSNAME
	  extern char unm_mod[], unm_mch[];
	  int y = VVBUFL - 1;
	  char * s = unm_mod;
#endif /* CK_UTSNAME */ 

#ifdef HPUX
	  if (!unm_mod[0])
	    zzstring("\\fcommand(model)",&s,&y);
/*
   Another possibility would be:
     "\\fcommand(ksh -c 'whence model 1>&- && model || uname -m')"
   But that would depend on having ksh.
*/
#else
#ifdef OSF32				/* Digital UNIX 3.2 and higher... */
/* Note: Ultrix has /etc/sizer, but it is not publicly executable. */
/* sizer -c outputs 'cpu:<tab><tab>"DECxxxx"' */
	  if (!unm_mod[0]) {
	      char * p;
	      int flag = 0;
	      zzstring("\\fcommand(/usr/sbin/sizer -c)",&s,&y);
	      debug(F110,"DU model",unm_mod,0);
	      s = unm_mod;
	      p = unm_mod;
	      while (*p) {		/* Extract the part in quotes */
		  if (*p == '"') {
		      if (flag)
			break;
		      flag = 1;
		      p++;
		      continue;
		  }		    
		  if (flag)
		    *s++ = *p;
		  p++;
	      }
	      *s = NUL;
	  }
#endif /* OSF32 */
#endif /* HPUX */

#ifdef CK_UTSNAME
	  if (unm_mod[0])
	    return((char *)unm_mod);
	  else
	    return((char *)unm_mch);	    
#else
	  return("");
#endif /* CK_UTSNAME */
      }

#ifdef IBMX25
      /* X.25 variables (local and remote address) */
      case VN_X25LA:
	if (!local_nua[0] && !x25local_nua(local_nua))
	  *vvbuf = NULL;
	else
	  sprintf(vvbuf,"%s",local_nua);
	return((char *)vvbuf);

      case VN_X25RA:
	if (!remote_nua[0])
	  *vvbuf = NULL;
	else
	  sprintf(vvbuf,"%s",remote_nua);
	return((char *)vvbuf);
#endif /* IBMX25 */

      default:
	fnsuccess = 0;
	if (fnerror) {
	    int k;
	    char * p;
	    p = embuf;
	    k = strlen(p);
	    if (k > 0) {
		p[k-1] = NUL;
		p++;
	    }
	    printf("?%s",p);
	    return("");
	} else
	  return(fndiags ? embuf : NULL);
    }
}
#endif /* NOSPL */


/*
  X X S T R I N G  --  Expand variables and backslash codes.

    int xxtstring(s,&s2,&n);

  Expands \ escapes via recursive descent.
  Argument s is a pointer to string to expand (source).
  Argument s2 is the address of where to put result (destination).
  Argument n is the length of the destination string (to prevent overruns).
  Returns -1 on failure, 0 on success,
    with destination string null-terminated and s2 pointing to the
    terminating null, so that subsequent characters can be added.
*/

#define XXDEPLIM 100			/* Recursion depth limit */

int
zzstring(s,s2,n) char *s; char **s2; int *n; {
    int x,				/* Current character */
        y,				/* Worker */
        pp,				/* Paren level */
	kp,				/* Brace level */
        argn,				/* Function argument counter */
        n2,				/* Local copy of n */
        d,				/* Array dimension */
        vbi,				/* Variable id (integer form) */
        argl;				/* String argument length */

    char vb,				/* Variable id (char form) */
        *vp,				/* Pointer to variable definition */
        *new,				/* Local pointer to target string */
        *p,				/* Worker */
        *q;				/* Worker */
    char *r  = (char *)0;		/* For holding function args */
    char *r2 = (char *)0;
    char *r3p;

#ifndef NOSPL
    char vnambuf[VNAML];		/* Buffer for variable/function name */
    char *argp[FNARGS];			/* Pointers to function args */
#endif /* NOSPL */

    static int depth = 0;		/* Call depth, avoid overflow */

    n2 = *n;				/* Make local copies of args */
    new = *s2;				/* for one less level of indirection */

    depth++;				/* Sink to a new depth */
    if (depth > XXDEPLIM) {		/* Too deep? */
	printf("?definition is circular or too deep\n");
	depth = 0;
	*new = NUL;
	debug(F101,"zzstring fail","",1);
	return(-1);
    }
    if (!s || !new) {			/* Watch out for null pointers */
	depth = 0;
	*new = NUL;
	debug(F101,"zzstring fail","",2);
	return(-1);
    }
    argl = (int)strlen(s);		/* Get length of source string */
    debug(F111,"xxstring",s,argl);
    if (argl < 0) {			/* Watch out for garbage */
	depth = 0;
	*new = NUL;
	debug(F101,"zzstring fail","",3);
	return(-1);
    }
    while (x = *s) {			/* Loop for all characters */
        if (x != CMDQ) {		/* Is it the command-quote char? */
	    *new++ = *s++;		/* No, normal char, just copy */
	    if (--n2 < 0) {		/* and count it, careful of overflow */
		debug(F101,"zzstring fail","",4);
		return(-1);
	    }
	    continue;
	}

/* We have the command-quote character. */

	x = *(s+1);			/* Get the following character. */

	switch (x) {			/* Act according to variable type */
#ifndef NOSPL
	  case 0:			/* It's a lone backslash */
	    *new++ = *s++;
	    if (--n2 < 0) {
		debug(F101,"zzstring fail","",5);
		return(-1);
	    }
	    break;
	  case '%':			/* Variable */
	    s += 2;			/* Get the letter or digit */
	    vb = *s++;			/* and move source pointer past it */
	    vp = NULL;			/* Assume definition is empty */
	    if (vb >= '0' && vb <= '9') { /* Digit for macro arg */
		if (maclvl < 0) 	/* Digit variables are global */
		  vp = g_var[vb];	/* if no macro is active */
		else			/* otherwise */
		  vp = m_arg[maclvl][vb - '0']; /* they're on the stack */
	    } else if (vb == '*' && maclvl >= 0) {
		vp = m_line[maclvl];
		if (!vp) vp = "";
	    } else {
		if (isupper(vb)) vb += ('a'-'A');
		vp = g_var[vb];		/* Letter for global variable */
	    }
	    if (vp) {			/* If definition not empty */
		if (zzstring(vp,&new,&n2) < 0) { /* call self to evaluate it */
		    debug(F101,"zzstring fail","",6);
		    return(-1);		/* Pass along failure */
		}
	    }
	    break;
	  case '&':			/* An array reference */
	    if (arraynam(s,&vbi,&d) < 0) { /* Get name and subscript */
		debug(F101,"zzstring fail","",7);
		return(-1);
	    }
	    pp = 0;			/* Bracket counter */
	    while (*s) {		/* Advance source pointer... */
		if (*s == '[') pp++;
		if (*s == ']' && --pp == 0) break;
		s++;
	    }
	    if (*s == ']') s++;		/* ...past the closing bracket. */
	    if (chkarray(vbi,d) > 0) {	/* Array is declared? */
		vbi -= ARRAYBASE;	/* Convert name to index */
		if (a_dim[vbi] >= d) {	/* If subscript in range */
		    char **ap;
		    ap = a_ptr[vbi];	/* get data pointer */
		    if (ap) {		/* and if there is one */
			if (ap[d]) {	/* If definition not empty */
			    if (zzstring(ap[d],&new,&n2) < 0) { /* evaluate */
				debug(F101,"zzstring fail","",8);
				return(-1); /* Pass along failure */
			    }
			}
		    }
		}
	    }
	    break;

	  case 'F':			/* A builtin function */
	  case 'f':
	    q = vnambuf;		/* Copy the name */
	    y = 0;			/* into a separate buffer */
	    s += 2;			/* point past 'F' */
	    while (y++ < VNAML) {
		if (*s == '(') { s++; break; } /* Look for open paren */
		if ((*q = *s) == NUL) break;   /* or end of string */
		s++; q++;
	    }
	    *q = NUL;			/* Terminate function name */
	    if (y >= VNAML) {		/* Handle pathological case */
		while (*s && (*s != '(')) /* of very long string entered */
		  s++;			  /* as function name. */
		if (*s == ')') s++;	  /* Skip past it. */
	    }
	    r = r2 = malloc(argl+2);	/* And make a place to copy args */
	    debug(F101,"xxstring r2","",r2);
	    if (!r2) {			/* Watch out for malloc failure */
		depth = 0;
		*new = NUL;
		debug(F101,"zzstring fail","",9);
		return(-1);
	    }
	    if (r3) free(r3); /* And another to copy literal arg string */
	    r3 = malloc(argl+2);
	    debug(F101,"xxstring r3","",r3);
	    if (!r3) {
		depth = 0;
		*new = NUL;
		debug(F101,"zzstring fail","",10);
		if (r2) free(r2);
		return(-1);
	    } else
	      r3p = r3;
	    argn = 0;			/* Argument counter */
	    argp[argn++] = r;		/* Point to first argument */
	    y = 0;			/* Completion flag */
	    pp = 1;			/* Paren level (already have one). */
	    kp = 0;
	    while (1) {			/* Copy each argument, char by char. */
		*r3p++ = *s;		/* This is a literal copy for \flit */
		if (!*s) break;

		if (*s == '{') {	/* Left brace */
#ifdef COMMENT
		    if (kp++ == 0) {	/* Skip it if it's the outer one */
			s++;
			*r3p++ = *s;
		    }
#else
		    kp++;
#endif /* COMMENT */
		}
		if (*s == '}') {	/* Right brace */
#ifdef COMMENT
		    if (--kp == 0) {	/* Skip it if it's the outer one */
			s++;
			*r3p++ = *s;
		    }
#else
		    kp--;
#endif /* COMMENT */
		}
		if (*s == '(' && kp <= 0) { /* Open paren not in brace */
		    pp++;		/* Count it */
		}
		*r = *s;		/* Now copy resulting byte */
		if (!*r)		/* If NUL, done. */
		  break;
		if (*r == ')' && kp <= 0) { /* Closing paren, count it. */
		    if (--pp == 0) {	/* Final one? */
			*r = NUL;	/* Make it a terminating null */
			*(r3p - 1) = NUL;
			s++;		/* Point past it in source string */
			y = 1;		/* Flag we've got all the args */
			break;		/* Done with while loop */
		    }
		}
		if (*r == ',' && kp <= 0) { /* Comma */
		    if (pp == 1) {	    /* If not within ()'s, */
			if (argn >= FNARGS) { /* Too many args */
			    s++; r++;	/* Keep collecting flit() string */
			    continue;
			}
			*r = NUL;	    /* New arg, skip past comma */
			argp[argn++] = r+1; /* In range, point to new arg */
		    }			/* Otherwise just skip past  */
		}
		s++; r++;		/* Advance pointers */
	    }
	    debug(F111,"xxstring function name",vnambuf,y);
	    debug(F110,"xxstring function r3",r3,0);
	    if (!y) {			/* If we didn't find closing paren */
		debug(F101,"zzstring fail","",11);
		if (r2) { free(r2); r2 = NULL; }
		if (r3) { free(r3); r3 = NULL; } /* Remember this is global */
		return(-1);		/* Return failure */
	    }
#ifdef DEBUG
	    if (deblog)
	      for (y = 0; y < argn; y++)
		debug(F111,"xxstring function arg",argp[y],y);
#endif /* DEBUG */
	    vp = fneval(vnambuf,argp,argn,r3); /* Evaluate the function. */
	    if (vp) {			/* If definition not empty */
		while (*new++ = *vp++)	/* copy it to output string */
		  if (--n2 < 0) {	/* watch out for overflow */
		      debug(F101,"zzstring fail","",12);
		      if (r2) { free(r2); r2 = NULL; }
		      if (r3) { free(r3); r3 = NULL; }
		      return(-1);
		  }
		new--;			/* Back up over terminating null */
		n2++;			/* to allow for further deposits. */
	    }
	    if (r2) { free(r2); r2 = NULL; }
	    if (r3) { free(r3); r3 = NULL; }
	    break;
	  case '$':			/* An environment variable */
	  case 'V':			/* Or a named builtin variable. */
	  case 'v':
	  case 'M':			/* Or a macro = long variable */
	  case 'm':
	    p = s+2;			/* $/V/M must be followed by (name) */
	    if (*p != '(') {		/* as in \$(HOME) or \V(count) */
		*new++ = *s++;		/* If not, just copy it */
		if (--n2 < 0) {
		    debug(F101,"zzstring fail","",13);
		    return(-1);
		}
		break;
	    }
	    p++;			/* Point to 1st char of name */
	    q = vnambuf;		/* Copy the name */
	    y = 0;			/* into a separate buffer */
	    while (y++ < VNAML) {	/* Watch out for name too long */
		if (*p == ')') {	/* Name properly terminated with ')' */
		    p++;		/* Move source pointer past ')' */
		    break;
		}
		if ((*q = *p) == NUL)	/* String ends before ')' */
		  break;
 		p++; q++;		/* Advance pointers */
	    }
	    *q = NUL;			/* Terminate the variable name */
	    if (y >= VNAML) {		/* Handle pathological case */
		while (*p && (*p != ')')) /* of very long string entered */
		  p++;			  /* as variable name. */
		if (*p == ')') p++;	  /* Skip ahead to the end of it. */
	    }
	    s = p;			/* Adjust global source pointer */
	    p = malloc((int)strlen(vnambuf) + 1); /* Make temporary space */
	    if (p) {			/* If we got the space */
		vp = vnambuf;		/* Point to original */
		strcpy(p,vp);		/* Make a copy of it */
		y = VNAML;		/* Length of name buffer */
		zzstring(p,&vp,&y);	/* Evaluate the copy */
		free(p);		/* Free the temporary space */
		p = NULL;
	    }
	    debug(F110,"xxstring vname",vnambuf,0);
	    q = NULL;
	    if (x == '$') {		/* Look up its value */
		vp = getenv(vnambuf);	/* This way for environment variable */
	    } else if (x == 'm' || x == 'M') { /* or this way for macro */
		y = mlook(mactab,vnambuf,nmac);	/* get definition */
		if (y > -1) {		/* Got definition */
		    vp = mactab[y].mval;
#ifdef COMMENT
/*
  This works, but it breaks too many things, like CKERMIT.INI!
  We need a new \_() function for this, which fully evaluates the name
  of the macro before retrieving its definition.
*/
		    q = p = malloc(ARGBUFSIZ+1); /* Now evaluate it */
		    if (p) {
			y = ARGBUFSIZ;
			zzstring(vp,&p,&y);
		    }
		    vp = q;		/* Point to evaluated definition */
#endif /* COMMENT */
		} else vp = NULL;
	    } else { 			/*  or */
	        vp = nvlook(vnambuf);	/* this way for builtin variable */
	    }
	    if (vp) {			/* If definition not empty */
		while (*new++ = *vp++)	/* copy it to output string. */
		  if (--n2 < 0) {
		      if (q) free(q);
		      debug(F101,"zzstring fail","",14);
		      return(-1);
		  }
		new--;			/* Back up over terminating null */
		n2++;			/* to allow for further deposits. */
	    }
	    if (q) {
		free(q);
		q = NULL;
	    }
	    break;
#endif /* NOSPL	*/			/* Handle \nnn even if NOSPL. */

#ifndef NOKVERBS
	case 'K':
	case 'k': {
	    extern struct keytab kverbs[];
	    extern int nkverbs;
#define K_BUFLEN 30
	    char kbuf[K_BUFLEN + 1];	/* Key verb name buffer */
	    int x, y, z, brace = 0;
	    s += 2;
/*
  We assume that the verb name is {braced}, or it extends to the end of the
  string, s, or it ends with a space, control character, or backslash.
*/
	    p = kbuf;			/* Copy verb name into local buffer */
	    x = 0;
	    if (*s == '{')  {
		s++;
		brace++;
	    }
	    while ((x++ < K_BUFLEN) && (*s > SP) && (*s != CMDQ)) {
		if (brace && *s == '}') {
		    s++;
		    break;
		}	
		*p++ = *s++;
	    }
	    brace = 0;
	    *p = NUL;			/* Terminate. */
	    p = kbuf;			/* Point back to beginning */
	    debug(F110,"zzstring kverb",p,0);
	    y = xlookup(kverbs,p,nkverbs,&x); /* Look it up */
	    debug(F101,"zzstring lookup",0,y);
	    if (y > -1) {
		dokverb(VCMD,y);
#ifndef NOSPL
	    } else {			/* Is it a macro? */
		y = mxlook(mactab,p,nmac);
		if (y > -1) {
		    debug(F111,"zzstring mxlook",s,y);
		    if ((z = dodo(y,NULL,cmdstk[cmdlvl].ccflgs)) > 0) {
			if (cmpush() > -1) {  /* Push command parser state */
			    extern int ifc;
			    int ifcsav = ifc; /* Push IF condition on stack */
			    y = parser(1);    /* New parser to execute macro */
			    cmpop();	      /* Pop command parser */
			    ifc = ifcsav;     /* Restore IF condition */
			    if (y == 0) {     /* No errors, ignore actions */
				p = mrval[maclvl+1]; /* If OK set return val */
				if (p == NULL) p = "";
			    }
			} else {		/* Can't push any more */
			    debug(F100,"zzstring pushed too deep","",0);
			    printf(
			       "\n?Internal error: zzstring stack overflow\n"
				   );
			    while (cmpop() > -1);
			    p = "";
			}
		    }
		}
#endif /* NOSPL */
	    }
	    break;
	}
#endif /* NOKVERBS */

	default:			/* Maybe it's a backslash code */
	  y = xxesc(&s);		/* Go interpret it */
	  if (y < 0) {			/* Upon failure */
	      *new++ = (char) x;	/* Just quote the next character */
	      s += 2;			/* Move past the pair */
	      n2 -= 2;
	      if (n2 < 0) {
		  debug(F101,"zzstring fail","",15);
		  return(-1);
	      }
	      continue;			/* and go back for more */
	  } else {
	      *new++ = (char) y;	/* else deposit interpreted value */
	      if (--n2 < 0) {
		  debug(F101,"zzstring fail","",16);
		  return(-1);
	      }
	  }
	}
    }
    *new = NUL;				/* Terminate the new string */
    depth--;				/* Adjust stack depth gauge */
    *s2 = new;				/* Copy results back into */
    *n = n2;				/* the argument addresses */
    return(0);				/* and return. */
}
#endif /* NOICP */
