/* dlink.h
 * (c) Alexandre Frey 1996
 */

#ifndef __DLINK_H__
#define __DLINK_H__

#include <bfd.h>
#include <bfdlink.h>
#include "alloc.h"

struct dlink_info 
{
  struct bfd_link_info link_info;
  bfd *output_bfd;
  dlink_memory *memory;
};

void 
dlink_init (void* (*ainternal_alloc) (size_t),
	    void  (*ainternal_free)  (void*),
	    void* (*asection_alloc) (size_t),
	    void  (*asection_free)  (void*),
	    void  (*notice_error) (char* desc, char* hints),
	    void  (*notice_warning) (char* desc, char* hints),
	    char* static_map_filename);

extern struct dlink_info* static_dlink_info;

void
dlink_info_init (struct dlink_info *info);

struct dlink_info *
dlink_info_create (void);

boolean 
dlink_add_file (struct dlink_info* info, 
		char* filename,
		boolean use_static);

boolean 
dlink_info_closed_p (struct dlink_info* info);


boolean 
dlink_info_link (struct dlink_info* info);

boolean 
dlink_info_symbol_defined_p (struct dlink_info* info, char* c_name);

bfd_vma
dlink_get_symbol_value (struct dlink_info* info, char* c_name);

void dlink_info_free (struct dlink_info *info);
void dlink_info_release (struct dlink_info *info);

void 
dlink_info_walk_on_undefined (struct dlink_info *info,
			      void (*proc)(const char*) );

#endif
