/* dloadmap.c
 * (c) Alexandre Frey 1996
 *
 * . take an executable in stdin and write a map of global symbols to stdout 
 * . or get a file name in command line and write the map to the file 
 *   with extension .map
 */

#include <stdio.h>
#include <ansidecl.h>
#include <libiberty.h>
#include <bfd.h>
#include <unistd.h>
#include <stdlib.h>

void fatal (char* message) {
  bfd_perror (message);
  exit (-1);
}

int main (int argc, char* argv[]) {
  bfd * object;
  asymbol** symbol;
  long symbol_storage;
  int i;
  FILE* output_file;

  bfd_init();
  
  if (argc <= 1)
    {
      object = bfd_fdopenr("<stdin>", NULL, STDIN_FILENO);
      output_file = stdout;
    }
  else
    {
      char* output_file_name = (char*) malloc (strlen (argv[1])+5);
      object = bfd_openr (argv[1], NULL);
      sprintf (output_file_name, "%s.map", argv[1]);
      output_file = fopen (output_file_name, "w");
      if (!output_file)
	fatal ("Can't open output file");
    }

  if (object == NULL)
    fatal ("Can't open input file");

  if (! bfd_check_format (object, bfd_object))
    fatal ("Not an objet file");

  symbol_storage = bfd_get_symtab_upper_bound (object);

  if (symbol_storage < 0)
    fatal ("Unable to read the symbols");

  symbol = malloc (symbol_storage);
  bfd_canonicalize_symtab (object, symbol);

  for (i=0; i< object->symcount; i++) 
    if (symbol[i]->flags & BSF_EXPORT) {
      fprintf_vma (output_file, symbol[i]->value + symbol[i]->section->vma);
      fprintf (output_file, " %s\n", symbol[i]->name);
    }

  bfd_close (object);
  fclose (output_file);

  return 0;
  
}
  
      
